/* ************************************************************ io-png.c *** *
 * PNG⥸塼
 *
 * Copyright (C) 2002-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/28 01:27:59 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include "teoeyes_loader.h"
#include "format_png.icon"

/* ************************************************************************* */
static gchar *mime_types[] = {
  "image/png",
  NULL
};

/* ************************************************************************* */
static gchar *extensions[] = {
  "png",
  NULL
};

/* ************************************************************************* */
gboolean
check_png (GnomeVFSHandle	*handle) {
  GnomeVFSResult	result;
  guchar		buf[8];
  GnomeVFSFileSize	bytes_read;

  result = gnome_vfs_read(handle, buf, 8, &bytes_read);
  result = gnome_vfs_seek(handle, GNOME_VFS_SEEK_START, 0);

  if (!(buf[0] == 0x89 && buf[1] == 'P' && buf[2] == 'N' && buf[3] == 'G')) {
    return FALSE;
  }
  if (buf[4] != 0x0d || buf[5] != 0x0a || buf[6] != 0x1a || buf[7] != 0x0a) {
    return FALSE;
  }
  return TRUE;
}

/* ************************************************************************* */
GdkPixbuf*
load_png (const gchar	*filename,
	  gpointer	data) {
  return gnome_gdk_pixbuf_new_from_uri (filename);
}

/* ************************************************************************* */
gboolean
save_png (const gchar	*filename,
	  gpointer	data) {
  gchar		*localname;

  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  gdk_pixbuf_save ((GdkPixbuf *) data, localname, "png", NULL, NULL);
  g_free(localname);
  
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = g_new (ImageFormat, 1);
  module->info->name		= "PNG";
  module->info->description	= _("The PNG image format");
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= IMAGE_FORMAT_WRITABLE;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_png, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  N_("PNG Image Loader"),
  "1.0",
  N_("Yasuyuki Sugaya"),
  NULL,
  NULL,
  check_png,
  load_png,
  save_png,
  load_info
};

/* ***************************************************** End of io-png.c *** */
