/* ************************************************************ io-teo.c *** *
 * TEO⥸塼
 *
 * Copyright (C) 2002-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/28 01:18:42 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>
#include <teo.h>
#include "teoeyes_loader.h"
#include "teo2gdk-pixbuf.h"
#include "teimage_structure.h"
#include "format_teo.icon"


/* ************************************************************************* */
GtkWidget*	teo_dialog_new	(TEImage	*ti,
				 gchar		*filename);

/* ************************************************************************* */
static gchar *mime_types[] = {
  "image/teo",
  NULL
};

/* ************************************************************************* */
static gchar *extensions[] = {
  "teo",
  NULL
};

/* ************************************************************************* */
gboolean
check_teo (GnomeVFSHandle	*handle) {
  GnomeVFSResult	result;
  guchar		buf[3];
  GnomeVFSFileSize	bytes_read;

  result = gnome_vfs_read(handle, buf, 3, &bytes_read);
  result = gnome_vfs_seek(handle, GNOME_VFS_SEEK_START, 0);

  if (!(buf[0] == 'T' && buf[1] == 'E' && buf[2] == 'O')) {
    return FALSE;
  }
  return TRUE;
}

/* ************************************************************************* */
static GdkPixbuf*
load_teo_simple (const gchar	*filename) {
  TEOFILE	*teofp;
  TEOIMAGE	*teoimg;
  GdkPixbuf	*pixbuf;

  teofp = TeoOpenFile ((char *) filename);
  if (!teofp) {
    fprintf (stderr, "TEO-IO : Can not open %s.\n", filename);
    return NULL;
  }
  teoimg = TeoAllocSimilarImage (teofp);
  TeoReadFrame (teofp, teoimg);
  pixbuf = Teo2GdkPixbuf_new_from_teoimage (teoimg, TRUE);

  TeoFreeImage (teoimg);
  TeoCloseFile (teofp);

  return pixbuf;
}

/* ************************************************************************* */
GdkPixbuf*
load_teo (const gchar	*filename,
	  gpointer	data) {
  TEOFILE	*teofp;
  TEOIMAGE	*teoimg;
  GdkPixbuf	*pixbuf;
  gboolean	load_all;
  gboolean	normalize;
  int		n;
  gchar		*localname;

  if (strrchr(filename, ':')) {
    localname = gnome_vfs_get_local_path_from_uri(filename);
  } else {
    localname = g_strdup (filename);
  }
  if (!localname) {
    fprintf (stderr, "TEO-IO : Can not open %s.\n", localname);
    return NULL;
  }
  if (!data) {
    pixbuf = load_teo_simple(localname);
    g_free(localname);
    return pixbuf;
  } else {
    /* TEOեΥץ */
    if (!((TEImage *) data)->fp) {
      ((TEImage *) data)->fp = TeoOpenFile ((char *) localname);
    }
    if (!((TEImage *) data)->fp) {
      fprintf (stderr, "TEO-IO : Can not open %s.\n", localname);
      return NULL;
    }
    g_free(localname);
    teofp    = (TEOFILE *) ((TEImage *) data)->fp;
    load_all = (gboolean)  ((TEImage *) data)->user_data[1];
    normalize= (gboolean)  ((TEImage *) data)->user_data[0];
    
    /* ե졼ֹ */
    if (((TEImage *) data)->frame == -1) {
      ((TEImage *) data)->frame = TeoFrame (teofp) - 1;
    } else {
      ((TEImage *) data)->frame =
	(((TEImage *) data)->frame >= 0 &&
	 ((TEImage *) data)->frame < 
	 TeoFrame (teofp)) ? ((TEImage *) data)->frame : 0;
    }
    /* ե졼 */
    ((TEImage *) data)->nframes = TeoFrame (teofp);

    /* ͥ */
    ((TEImage *) data)->nchannels = TeoPlane (teofp);

    /* ǡ */
    switch (TeoType (teofp)) {
    case TEO_UNSIGNED:
      ((TEImage *) data)->type = TI_PIXEL_UNSIGNED;
      break;
    case TEO_SIGNED:
      ((TEImage *) data)->type = TI_PIXEL_SIGNED;
      break;
    case TEO_FLOAT:
      ((TEImage *) data)->type = TI_PIXEL_FLOAT;
      break;
    }
    /* ǡΥӥåȿ */
    ((TEImage *) data)->bit = TeoBit (teofp);

    /* եåȤ */
    ((TEImage *) data)->xoffset = TeoXoffset (teofp);
    ((TEImage *) data)->yoffset = TeoYoffset (teofp);

    TeoSetAbsFrame(teofp, 0);
  
    if (load_all) {
      for (n = 0; n < TeoFrame (teofp); n++) {
	/* TEOIMAGEΰ */
	teoimg = TeoAllocSimilarImage (teofp);

	/* ǡɤ߹ */
	TeoReadFrame (teofp, teoimg);
    
	/* ꥹȤɲ */
	((TEImage *) data)->original_list
	  = g_list_append (((TEImage *) data)->original_list, teoimg);

	/* GdkPixbufǡ */
	pixbuf = Teo2GdkPixbuf_new_from_teoimage (teoimg, normalize);

	((TEImage *) data)->pixbuf_list 
	  = g_list_append (((TEImage *) data)->pixbuf_list, pixbuf);
      }
      return (GdkPixbuf *) g_list_nth_data (((TEImage *) data)->pixbuf_list, 
					    ((TEImage *) data)->frame);
    } else {
      /* TEOIMAGEΰ */
      teoimg = TeoAllocSimilarImage (teofp);

      /* ꤵ줿ե졼ǡΥå */
      TeoSetAbsFrame ((TEOFILE *) ((TEImage *) data)->fp,
		      ((TEImage *) data)->frame);

      /* ǡɤ߹ */
      TeoReadFrame (teofp, teoimg);

      /* ꥹȤɲ */
      ((TEImage *) data)->original_list 
	= g_list_append (((TEImage *) data)->original_list, teoimg);

      /* GdkPixbufǡ */
      pixbuf = Teo2GdkPixbuf_new_from_teoimage (teoimg, normalize);

      ((TEImage *) data)->pixbuf_list 
	= g_list_append (((TEImage *) data)->pixbuf_list, pixbuf);

      return (GdkPixbuf *) g_list_nth_data(((TEImage *) data)->pixbuf_list, 0);
    }
  }
}

/* ************************************************************************* */
gboolean
save_teo (const gchar	*filename,
	  gpointer	data) {
  GtkWidget	*dialog;

  dialog = teo_dialog_new ((TEImage *) data, (gchar *) filename);
  gtk_widget_show_all (dialog);
  
  return TRUE;
}

/* ************************************************************************* */
void
load_info (TeoeyesImageModule	*module) {
  module->info = g_new (ImageFormat, 1);
  module->info->name		= "TEO";
  module->info->description	= _("The TEO image format");
  module->info->mime_types	= mime_types;
  module->info->extensions	= extensions;
  module->info->flags		= IMAGE_FORMAT_WRITABLE;
  module->icon = gdk_pixbuf_new_from_inline (-1, format_teo, FALSE, NULL);
};

/* ************************************************************************* */
TeoeyesImageModule module = {
  N_("TEO Image Loader"),
  "0.9",
  N_("Yasuyuki Sugaya"),
  NULL,
  NULL,
  check_teo,
  load_teo,  
  save_teo,
  load_info
};

/* ***************************************************** End of io-teo.c *** */
