/* *********************************************************** median.c *** *
 * Teoeyes Plugin Collection ($B%a%G%#%"%s%U%#%k%?(B)
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/01 09:02:48 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "teoeyes_plugin.h"

#define	MIN_VAL			1
#define	MAX_VAL			32
#define	STEP_SIZE		1
#define	PAGE_SIZE		5
/* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
#define	USE_PROGRESS_BAR	1

/* ************************************************************************* *
   $BCf4VCM$r5a$a$k(B
 * ************************************************************************* */
guchar
median (guchar	*val,
	int	num) {
  int		n, m, tmp;
  guchar	min;

  for (n = 0; n < num / 2 + 1; n++) {
    min = val[n];
    tmp = n;
    for (m = n+1; m < num; m++) {
      if (val[m] < min) {
	min = val[m];
	tmp = m;
      }
    }
    val[tmp] = val[n];
    val[n]   = min;
  }
  return val[num/2];
}

/* ************************************************************************* *
   $B%W%i%0%$%s4X?tK\BN(B
 * ************************************************************************* */
void
exec_median (GdkPixbuf	*src,
	     GdkPixbuf	*dst,
	     double	param1,
	     double	param2,
	     double	param3) {
  int		scope = (int) param1;
  int		row, col;
  int		n, m, p, num;
  int		w, ww;
  guchar	**vals = NULL;

  w  = scope * 2 + 1;  
  ww = w * w;

  vals = (guchar **) malloc (sizeof (guchar *) * 3);
  for (p = 0; p < 3; p++) vals[p] = (guchar *) malloc (sizeof (guchar) * ww);

  for (row = scope; row < gdk_pixbuf_get_height (src) - scope; row++) {
    for (col = scope; col <= gdk_pixbuf_get_width (src) - scope; col++) {
      for (p = 0; p < 3; p++) {
	num = 0;	
	for (n = 0; n < ww; n++) vals[p][n] = 0;
	for (n = -scope; n <= scope; n++) {
	  for (m = -scope; m <= scope; m++) {
	    vals[p][num++] = gdk_pixbuf_get_pixel (src, col+m, row+n, p);
	  }
	}
	gdk_pixbuf_put_pixel (dst, col, row, p, median (vals[p], ww));
      }
      if (gdk_pixbuf_get_has_alpha (src) && gdk_pixbuf_get_has_alpha (dst)) {
	gdk_pixbuf_put_pixel (dst, col, row, 4,
			      gdk_pixbuf_get_pixel (src, col, row, 4));
      }
    }
#if USE_PROGRESS_BAR /* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
    teoeyes_plugin_progressbar_update ((double) (row - scope) /
				       (double) (gdk_pixbuf_get_height (src) 
						 - scope + 1));
#endif
  } 
#if USE_PROGRESS_BAR /* $B%W%m%0%l%9%P!<$r;HMQ$9$k>l9g$O(B1$B$KJQ99$7$F$$2<$5$$(B */
  teoeyes_plugin_progressbar_update (0.0);
#endif
  for (p = 0; p < 3; p++) free (vals[p]);
  free (vals);
}

/* ************************************************************************* *
   $B%W%i%0%$%s<B9TMQ4X?t(B
 * ************************************************************************* */
void
plugin_median (GdkPixbuf	*src,
	       GdkPixbuf	*dst,
	       gpointer		data) {
  /* $B%W%i%0%$%s%@%$%"%m%0$NI=<((B */
  teoeyes_plugin_dialog_new (_("Median Filter"),/* $B%@%$%"%m%0%?%$%H%k(B */
			     exec_median,	/* $B%W%i%0%$%s4X?tK\BN(B */
			     src,		/* $BF~NO2hA|%G!<%?(B */
			     dst,		/* $B=PNO2hA|%G!<%?(B */
			     _("Scope"),	/* $B%Q%i%a!<%?%i%Y%k(B */
			     MIN_VAL,		/* $B%Q%i%a!<%?:G>.CM(B */
			     MAX_VAL,		/* $B%Q%i%a!<%?:GBgCM(B */
			     STEP_SIZE,		/* $B%Q%i%a!<%?A}2CNL(B1 */	
			     PAGE_SIZE,		/* $B%Q%i%a!<%?A}2CNL(B2 */	
			     TRUE,
			     TRUE);
  gtk_main ();
}

/* ************************************************************************* *
   $B%W%i%0%$%s>pJs(B
 * ************************************************************************* */
TeoeyesPluginInfo plugin_info = {  
  {
    GNOME_APP_UI_ITEM, N_("Median Filter"),
    NULL,
    NULL, NULL, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  }, 
  N_("Median Filter Plugin"),
  N_("Yasuyuki Sugaya"),
  "2.2",
  N_("This plugin applies\n the median filter to the image."),
  plugin_median
};

/* ***************************************************** End of median.c *** */
