/* ********************************************************** cripping.c *** *
 * Υåԥ
 *
 * Copyright (C) 2001-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/07/18 04:45:35 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include "cripping.h"
#include "list_window.h"

/* åԥΰ ************************************************** */
void
crip_draw_area (void) {
  GtkWidget	*canvas;
  GtkWidget	*widget_x;
  GtkWidget	*widget_y;
  GtkWidget	*widget_w;
  GtkWidget	*widget_h;
  GdkWindow	*window;
  GdkGC		*gc;
  GdkColor	c1, c2;
  GdkColormap	*cmap;
  gint		x, y, w, h;
  
  /* åȤγ */
  canvas = G_GET_WIDGET (image_window, "canvas");
  window = canvas->window;

  /* åԥ󥰺ɸγ */
  x = (gint) G_GET_PARAMETER (image_window, "crip_x");
  y = (gint) G_GET_PARAMETER (image_window, "crip_y");
  w = (gint) G_GET_PARAMETER (image_window, "crip_w");
  h = (gint) G_GET_PARAMETER (image_window, "crip_h");

  /* ǥåȥɥؤȿ */
  if (edit_window) {
    widget_x = G_GET_WIDGET (edit_window, "spin_crip_x");
    widget_y = G_GET_WIDGET (edit_window, "spin_crip_y");
    widget_w = G_GET_WIDGET (edit_window, "spin_crip_width");
    widget_h = G_GET_WIDGET (edit_window, "spin_crip_height");
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_x), (gfloat) x);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_y), (gfloat) y);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_w), (gfloat) w);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_h), (gfloat) h);
  }
  /* åԥΰΥꥢ */
  if (w > 0 && h > 0) gdk_window_clear_area (window, x, y, w, h);

  /* 顼ޥåפγ */
  cmap = gdk_colormap_get_system ();
  
  /* ǣ1 */
  gc = gdk_gc_new (window);
  c1.pixel = 0;
  c1.red   = 160 << 8;
  c1.green = 200 << 8;
  c1.blue  = 220 << 8;
  gdk_color_alloc (cmap, &c1);
  
  /* ǣ2 */
  c2.pixel = 0;  
  c2.red   = 0;
  c2.green = 0;
  c2.blue  = 0;
  gdk_color_alloc (cmap, &c2);
  
  /* ǣäΥå */
  gdk_gc_set_foreground (gc, &c1);

  /* åԥΰ */
  if (w >= 10 && h >= 10) {
    gdk_gc_set_foreground (gc, &c2);
    gdk_draw_rectangle (window, gc, FALSE, 
			x - 1 + (w >> 1) - 4, y - 1 + (h >> 1) - 4, 7, 7);
    gdk_gc_set_foreground (gc, &c1);
    gdk_draw_rectangle (window, gc, TRUE, 
			x - 1 + (w >> 1) - 3, y - 1 + (h >> 1) - 3, 6, 6);
  }
  gdk_gc_set_foreground (gc, &c2);
  gdk_draw_rectangle (window, gc, FALSE, x - 7 - 1, y - 7 - 1, 7, 7);
  gdk_gc_set_foreground (gc, &c1);
  gdk_draw_rectangle (window, gc, TRUE, x - 6 - 1, y - 6 - 1, 6, 6);
  gdk_gc_set_foreground (gc, &c2);
  gdk_draw_rectangle (window, gc, FALSE, x + w - 1 + 0 + 1, y - 7 - 1, 7, 7);
  gdk_gc_set_foreground (gc, &c1);
  gdk_draw_rectangle (window, gc, TRUE, x + w - 1 + 1 + 1, y - 6 - 1, 6, 6);
  gdk_gc_set_foreground (gc, &c2);
  gdk_draw_rectangle (window, gc, FALSE,
		      x + w - 1 + 0 + 1, y + h + 1 - 1 + 0, 7, 7);
  gdk_gc_set_foreground (gc, &c1);
  gdk_draw_rectangle (window, gc, TRUE,
		      x + w - 1 + 1 + 1, y + h + 1 - 1 + 1, 6, 6);
  gdk_gc_set_foreground (gc, &c2);
  gdk_draw_rectangle (window, gc, FALSE, x - 7 - 1, y + h + 1 - 1 + 0, 7, 7);
  gdk_gc_set_foreground (gc, &c1);
  gdk_draw_rectangle (window, gc, TRUE,
		      x - 6 - 1, y + h + 1 + 1 - 1 + 1 - 1, 6, 6);
  gdk_gc_set_foreground (gc, &c2);
  gdk_draw_rectangle (window, gc, FALSE, 
		     x - 2 - 1, y - 2 - 1, w + 2 - 1 + 4, h + 2 - 1 + 4);
  gdk_draw_rectangle (window, gc, FALSE, x - 1, y - 1, w + 2 - 1, h + 2 - 1);
  gdk_gc_set_foreground (gc, &c1);
  gdk_draw_rectangle (window, gc, FALSE,
		      x - 1 - 1, y - 1 - 1, w + 2 - 1 + 2, h + 2 - 1 + 2);
  gdk_flush ();
  gdk_gc_destroy (gc);
}

/* åԥΰΥꥢ ************************************************ */
void
crip_clear_area (void) {
  GtkWidget	*canvas;  
  GdkWindow	*window;
  gint		x, y, w, h;

  /* åȤγ */
  canvas = G_GET_WIDGET (image_window, "canvas");
  window = canvas->window;

  /* åΰγ */
  x = (gint) G_GET_PARAMETER (image_window, "crip_x");
  y = (gint) G_GET_PARAMETER (image_window, "crip_y");
  w = (gint) G_GET_PARAMETER (image_window, "crip_w");
  h = (gint) G_GET_PARAMETER (image_window, "crip_h");

  /* ΰΥꥢ */
  if (w >= 10 && h >= 10)
    gdk_window_clear_area (window,
			   x - 1 + (w >> 1) - 4, y - 1 + (h >> 1) - 4, 8, 8);
  gdk_window_clear_area (window, x - 8, y - 8, 8,      h + 16);
  gdk_window_clear_area (window, x - 8, y - 8, w + 16, 8);
  gdk_window_clear_area (window, x + w, y - 8, 8,      h + 16);
  gdk_window_clear_area (window, x - 8, y + h, w + 16, 8);
}

/* åԥ󥰥⡼ɤβ ************************************************ */
static void
remove_crip (void) {
  GtkWidget	*widget_x;
  GtkWidget	*widget_y;
  GtkWidget	*widget_w;
  GtkWidget	*widget_h;

  G_SET_PARAMETER (image_window, "crip_x", 0);
  G_SET_PARAMETER (image_window, "crip_y", 0);
  G_SET_PARAMETER (image_window, "crip_w", 0);
  G_SET_PARAMETER (image_window, "crip_h", 0);

  /* ǥåȥɥؤȿ */
  if (edit_window) {
    widget_x = G_GET_WIDGET (edit_window, "spin_crip_x");
    widget_y = G_GET_WIDGET (edit_window, "spin_crip_y");
    widget_w = G_GET_WIDGET (edit_window, "spin_crip_width");
    widget_h = G_GET_WIDGET (edit_window, "spin_crip_height");
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_x), (gfloat) 0);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_y), (gfloat) 0);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_w), (gfloat) 0);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_h), (gfloat) 0);
  }
}

/* åԥ󥰤μ¹ ****************************************************** */
void
crip_do_crip (void) {
  GtkWidget	*canvas;
  TEImage	*image;
  GdkPixbuf	*pixbuf, *tmp;
  gint		x, y, w, h, ow, oh;

  /* åȤγ */
  canvas = G_GET_WIDGET (image_window, "canvas");

  /* ǡγ */
  pixbuf = ti_get_pixbuf (image_list);

  /* åΰγ */
  x  = (gint) G_GET_PARAMETER (image_window, "crip_x");
  y  = (gint) G_GET_PARAMETER (image_window, "crip_y");
  w  = (gint) G_GET_PARAMETER (image_window, "crip_w");
  h  = (gint) G_GET_PARAMETER (image_window, "crip_h");
  ow = ti_get_width  (image_list);
  oh = ti_get_height (image_list);

  /* åԥ󥰤μ¹ */
  if (pixbuf) {
    if (w > 0 && h > 0) {
      /* åԥ */
      tmp = gdk_pixbuf_new (GDK_COLORSPACE_RGB,
			    gdk_pixbuf_get_has_alpha (pixbuf), 8, w, h);
      gdk_pixbuf_copy_area (pixbuf, x, y, w, h, tmp, 0, 0);
      image = teoeyes_image_new("cripped-image", GNOME_VFS_FILE_MEMORY);

      /* åԥ󥰤ꥹȤɲ */
      teoeyes_image_set_memory(image, tmp);
      image_list = g_list_append(image_list, image);
      image_list = g_list_last(image_list);

      /* 礭 */
      w = (gint) G_GET_PARAMETER (image_window, "crip_w");
      h = (gint) G_GET_PARAMETER (image_window, "crip_h");

      gtk_window_set_title(GTK_WINDOW(image_window), "cripped_image");
      image_window_set_size(image_window,
			    ti_get_width(image_list),
			    ti_get_height(image_list));
      remove_crip ();

      /* ꥹȥɥƤϥͥ򹹿 */
      if (list_window && GTK_WIDGET_VISIBLE (list_window)) {
	list_window_refresh_list (list_window);
      }
    }
  }
}

/* ޥܥ󤬲줿ν ****************************************** */
void
crip_mouse_press (gint	x,
		  gint	y) {
  gint		cx, cy, cw, ch;

  cx = (gint) G_GET_PARAMETER (image_window, "crip_x");
  cy = (gint) G_GET_PARAMETER (image_window, "crip_y");
  cw = (gint) G_GET_PARAMETER (image_window, "crip_w");
  ch = (gint) G_GET_PARAMETER (image_window, "crip_h");

  if (x >= cx && x < (cx + cw) && y >= cy && y < (cy + ch)) {
    G_SET_PARAMETER (image_window, "crip_do", 3);
    G_SET_PARAMETER (image_window, "prev_x",  x);
    G_SET_PARAMETER (image_window, "prev_y",  y);    
  } else if (x <= (cx + (cw / 2)) && y <= (cy + (ch / 2)) &&
	     x >= (cx - 8) && y >= (cy - 8)) {
    G_SET_PARAMETER (image_window, "crip_do",    2);
    G_SET_PARAMETER (image_window, "crip_dir_x", 1);
    G_SET_PARAMETER (image_window, "crip_dir_y", 1);    
  } else if (x <= (cx + (cw / 2)) && y >= (cy + (ch / 2)) &&
	     x >= (cx - 8) && y <= (cy + ch + 8)) {
    G_SET_PARAMETER (image_window, "crip_do",    2);
    G_SET_PARAMETER (image_window, "crip_dir_x", 1);
    G_SET_PARAMETER (image_window, "crip_dir_y", 2);    
  } else if (x >= (cx + (cw / 2)) && y <= (cy + (ch / 2)) &&
	     x <= (cx + cw + 8) && y >= (cy - 8)) {
    G_SET_PARAMETER (image_window, "crip_do",    2);
    G_SET_PARAMETER (image_window, "crip_dir_x", 2);
    G_SET_PARAMETER (image_window, "crip_dir_y", 1);    
  } else if (x >= (cx + (cw / 2)) && y >= (cy + (ch / 2)) &&
	     x <= (cx + cw + 8) && y <= (cy + ch + 8)) {
    G_SET_PARAMETER (image_window, "crip_do",    2);
    G_SET_PARAMETER (image_window, "crip_dir_x", 2);
    G_SET_PARAMETER (image_window, "crip_dir_y", 2);    
  } else {
    crip_clear_area ();
    G_SET_PARAMETER (image_window, "crip_do",    1);
    G_SET_PARAMETER (image_window, "crip_x",     x);
    G_SET_PARAMETER (image_window, "crip_y",     y);
    G_SET_PARAMETER (image_window, "crip_w",     0);
    G_SET_PARAMETER (image_window, "crip_h",     0);
    G_SET_PARAMETER (image_window, "crip_dir_x", 0);
    G_SET_PARAMETER (image_window, "crip_dir_y", 0);
  }
}

/* ޥɥå줿ν ****************************************** */
void
crip_mouse_move (gint	x,
		 gint	y) {
  GtkWidget	*canvas;
  gint		w, h;
  gint          px, py, pw, ph, cx, cy, cw, ch, dirx, diry;
  gint          cripping;

  /* åȤγ */
  canvas = G_GET_WIDGET (image_window, "canvas");
  cripping = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_do");

  w = canvas->allocation.width;
  h = canvas->allocation.height;
  
  if (cripping == 1) { /* åԥΰ */
    crip_clear_area ();
    cx   = (gint) G_GET_PARAMETER (image_window, "crip_x");
    cy   = (gint) G_GET_PARAMETER (image_window, "crip_y");
    pw   = (gint) G_GET_PARAMETER (image_window, "crip_w");
    cw   = (gint) G_GET_PARAMETER (image_window, "crip_w");
    ph   = (gint) G_GET_PARAMETER (image_window, "crip_h");
    ch   = (gint) G_GET_PARAMETER (image_window, "crip_h");
    dirx = (gint) G_GET_PARAMETER (image_window, "crip_dir_x");
    diry = (gint) G_GET_PARAMETER (image_window, "crip_dir_y");
    if (!dirx) {
      if (x < cx) {
	dirx = 1;
      } else if (x > cx) {
	dirx = 2;
      }
      if (dirx) G_SET_PARAMETER (image_window, "crip_dir_x", dirx);
    }
    if (!diry) {
      if (y < cy) {
	diry = 1;
      } else if (y > cy) {
	diry = 2;
      }
      if (diry) G_SET_PARAMETER (image_window, "crip_dir_y", diry);
    }
    if (x < 0) x = 0;
    if (x > w) x = w;
    if (dirx == 1) {
      cw = cw + cx - x;
    } else if (dirx == 2) {
      cw = x - cx;
      x = cx;
    }
    if (cw < 1) {
      cw = 1;
      if (x > (cx + pw - 1))	x = cx + pw - 1;
      if (pw == cw)		x = cx;
    } else if (pw == cw) {
      x = cx;
    }
    if ((x + cw) > w) cw = w - x;
    G_SET_PARAMETER (image_window, "crip_x", x);
    G_SET_PARAMETER (image_window, "crip_w", cw);
    if (y < 0) y = 0;
    if (y > h) y = h;
    if (diry == 1) {
      ch = ch + cy - y;
    } else if (diry == 2) {
      ch = y - cy;
      y = cy;
    }
    if (ch < 1) {
      ch = 1;
      if (y > (cy + ph - 1))	y = cy + ph - 1;
      if (ph == ch)		y = cy;
    } else if (ph == ch) {
      y = cy;
    }
    if ((y + ch) > h) ch = h - y;
    G_SET_PARAMETER (image_window, "crip_y", y);
    G_SET_PARAMETER (image_window, "crip_h", ch);
    crip_draw_area ();
  } else if (cripping == 2) { /* åԥΰΰư */
    crip_clear_area ();
    cx   = (gint) G_GET_PARAMETER (image_window, "crip_x");
    cy   = (gint) G_GET_PARAMETER (image_window, "crip_y");
    pw   = (gint) G_GET_PARAMETER (image_window, "crip_w");
    cw   = (gint) G_GET_PARAMETER (image_window, "crip_w");
    ph   = (gint) G_GET_PARAMETER (image_window, "crip_h");
    ch   = (gint) G_GET_PARAMETER (image_window, "crip_h");
    dirx = (gint) G_GET_PARAMETER (image_window, "crip_dir_x");
    diry = (gint) G_GET_PARAMETER (image_window, "crip_dir_y");
    if (x < 0) x = 0;
    if (x > w) x = w;
    if (dirx == 1) {
      cw = cw + cx - x;
    } else if (dirx == 2) {
      cw = x - cx;
      x  = cx;
    }
    if (cw < 1) {
      cw = 1;
      if (x > (cx + pw - 1)) x = cx + pw - 1;
      if (pw == cw)	     x = cx;
    } else if (pw == cw) {
      x = cx;
    }
    if ((x + cw) > w) cw = w - x;
    G_SET_PARAMETER (image_window, "crip_x", x);
    G_SET_PARAMETER (image_window, "crip_w", cw);
    if (y < 0) y = 0;
    if (y > h) y = h;
    if (diry == 1) {
      ch = ch + cy - y;
    } else if (diry == 2) {
      ch = y - cy;
      y  = cy;
    }
    if (ch < 1) {
      ch = 1;
      if (y > (cy + ph - 1))	y = cy + ph - 1;
      if (ph == ch)		y = cy;
    } else if (ph == ch) {
      y = cy;
    }
    if ((y + ch) > h) ch = h - y;
    G_SET_PARAMETER (image_window, "crip_y", y);
    G_SET_PARAMETER (image_window, "crip_h", ch);
    crip_draw_area ();
  } else if (cripping == 3) {
    crip_clear_area ();
    cx = (gint) G_GET_PARAMETER (image_window, "crip_x");
    cy = (gint) G_GET_PARAMETER (image_window, "crip_y");
    px = (gint) G_GET_PARAMETER (image_window, "prev_x");
    py = (gint) G_GET_PARAMETER (image_window, "prev_y");
    cw = (gint) G_GET_PARAMETER (image_window, "crip_w");
    ch = (gint) G_GET_PARAMETER (image_window, "crip_h");
    cx += x - px;
    cy += y - py;
    if (cx < 0) cx = 0;
    if (cy < 0) cy = 0;
    if ((cx + cw) > w) cx = w - cw;
    if ((cy + ch) > h) cy = h - ch;
    G_SET_PARAMETER (image_window, "prev_x", x);
    G_SET_PARAMETER (image_window, "prev_y", y);
    G_SET_PARAMETER (image_window, "crip_x", cx);
    G_SET_PARAMETER (image_window, "crip_y", cy);
    crip_draw_area ();
  }
}

/* ޥ ܥΥ줿ν ***************************************** */
void
crip_mouse_release (void) {
  gint	dirx, diry;

  G_SET_PARAMETER (image_window, "crip_do", 0);
  dirx = (gint) G_GET_PARAMETER (image_window, "crip_dir_x");
  diry = (gint) G_GET_PARAMETER (image_window, "crip_dir_y");
  if (!dirx || !diry) {
    crip_clear_area ();
    G_SET_PARAMETER (image_window, "crip_x", 	 0);
    G_SET_PARAMETER (image_window, "crip_y", 	 0);
    G_SET_PARAMETER (image_window, "crip_w", 	 0);
    G_SET_PARAMETER (image_window, "crip_h", 	 0);
    G_SET_PARAMETER (image_window, "crip_dir_x", 0);
    G_SET_PARAMETER (image_window, "crip_dir_y", 0);
  }
}

/* *************************************************** End of cripping.c *** */
