/* ******************************************* glib-fileutil-extension.h *** *
 * ǥ쥯ȥꡦեؿ إåե
 *
 * Copyright (C) 2002-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/04/02 02:42:00 sugaya>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 * ************************************************************************* */
#ifndef	__GLIB_FILEUTIL_EXTENSION_H__
#define	__GLIB_FILEUTIL_EXTENSION_H__

#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define	G_STRING_TERMINATOR	'\0'
#define	G_DIR_CURRENT_S		"."
#define	G_DIR_PARENT_S		".."

/* ************************************************************************* */
void		g_separate_path			(const gchar	*fullname,
						 gchar		**path,
						 gchar		**file);
gchar* 		g_get_absolute_path 		(const gchar	*path);

/* ************************************************************************* */
const gchar*	g_get_username			(gint		uid);
const gchar*	g_get_usershell 		(gint		uid);

/* ************************************************************************* */
gboolean	g_dir_cd 			(const gchar	*dir);
gboolean	g_dir_mkdir 			(const gchar	*dir);
gboolean	g_dir_mkdirs	 		(const gchar	*dir);
gboolean	g_dir_remove			(const gchar	*dir);
gboolean	g_dir_is_current_dir		(const gchar	*dir);
gboolean	g_dir_is_parent_dir		(const gchar	*dir);
gboolean	g_dir_is			(const gchar	*dir);
gint		g_dir_exist_subdir		(const gchar	*dir);
gchar*		g_dir_get_current_dir 		(void);
gchar*		g_dir_get_parent_dir 		(const gchar	*dir);
  
/* ************************************************************************* */
gboolean	g_file_exist	 		(const gchar	*filename);
gboolean	g_file_is 			(const gchar	*filename);
gboolean	g_file_is_link 			(const gchar	*filename);
gboolean	g_file_remove	 		(const gchar	*filename);
gboolean	g_file_rename	 		(const gchar	*old, 
						 const gchar	*new);
gboolean	g_file_copy 			(const gchar	*from,
						 const gchar	*to);
guint64		g_file_get_moddate		(const gchar	*filename);
gchar*		g_file_get_moddate_string	(const gchar	*filename);
gint		g_file_get_size 		(const gchar	*filename);
gchar*		g_file_get_size_string 		(const gchar	*filename);
gboolean	g_file_get_permissions 		(const gchar	*filename);
gboolean	g_file_get_owner		(const gchar	*filename);
gboolean	g_file_get_group		(const gchar	*filename);
gboolean	g_file_can_read			(const gchar	*filename);
gboolean	g_file_can_write 		(const gchar	*filename);
gboolean	g_file_can_exec			(const gchar	*filename);

/* ************************************************************************* */
gint		g_strcmp 			(const gchar	*pattern,
						 const gchar	*text);

#ifdef __cplusplus
}
#endif /* __cplusplus */
  
#endif	/* __GLIB_FILEUTIL_EXTENSION_H__ */

/* ************************************ End of glib-fileutil-extension.h *** */
