/* ********************************************** gnome-custom-filesel.c *** *
 * $B%+%9%?%`%U%!%$%kA*Br%@%$%"%m%0(B
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/07/20 11:37:50 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <gtk/gtk.h>
#include <gnome.h>
#include <unistd.h>
#include "gnome-custom-filesel.h"
#include "gnome-file-list.h"
#include "gtkiconbutton.h"
#include "gtkdirtreeview.h"
#include "glib-fileutil-extension.h"

/* $B%^%/%mDj5A(B ************************************************************** */
#define	FOLDER_BUTTON_W		32
#define	FOLDER_BUTTON_H		28
#define	TREE_WINDOW_W		200
#define	TREE_WINDOW_H		400
#define	LIST_WINDOW_W		520
#ifndef	COMBO_LIST_LIMIT
#define	COMBO_LIST_LIMIT	20
#endif

#define	FOLDER_ICON_DIR		"folder"
#define	MIME_ICON_DIR		"mimetype"
#define STOCK_ICON_DIR		"stock"

/* $B%"%$%3%s%G!<%?(B ********************************************************** */
static const guint8 folder_up_icon[] = 
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (1370) */
  "\0\0\5r"
  /* pixdata_type (0x2010002) */
  "\2\1\0\2"
  /* rowstride (88) */
  "\0\0\0X"
  /* width (22) */
  "\0\0\0\26"
  /* height (22) */
  "\0\0\0\26"
  /* pixel_data: */
  "\216\0\0\0\0\6\0*\257\30,S\306\237\25)k\202\0\0\0\0\0\30\207\24\0\0\0"
  "\1\216\0\0\0\0\10\0,\252\24\40K\302qk\217\345\336\204\264\377\3775^\303"
  "\3504L\234\2516R\273\334\0\0\12*\214\0\0\0\0\12\0""0\240\7\33G\260em"
  "\223\350\332\217\273\377\377^\235\377\377H\201\366\377h\212\361\3779"
  "N\305\325\2\33\255\306\0\0\37R\206\0\0\0\0\2\36w\377\37\7""5\201-\203"
  "\0\0\0\0\13\21L\305L\377\377\377\377G\1\1\377s\257\377\377M\213\373\377"
  "i\225\366\377`\213\377\3770b\377\377\0\17\275\276\0\20\267\270\0\1""7"
  "q\204\0\0\0\0\22\20V\267\17@\214\376~\223\302\377\355\214\271\377\367"
  "\22""9}s\15>\2354D{\347\247\235\302\377\377\377\377\377\377G\1\1\377"
  "`\224\367\377\177\250\376\377K\204\377\377\34[\377\377\40\\\377\377\13"
  "/\327\350\0\17\264\316\0\2L\214\203\0\0\0\0\10\31T\252C\210\270\371\321"
  "\350\371\377\377\356\373\377\377\325\357\377\377\233\313\377\377\214"
  "\272\377\373\261\331\377\377\202\377\377\377\377\24\335\360\377\377G"
  "\1\1\3773}\377\377%i\377\377#_\377\377\40]\377\377\40K\364\377\0\20\264"
  "\344\0\2e\246\0\0\0\3\0\0\0\0\0\0\0\14\221\272\365\344\377\377\377\377"
  "\356\373\377\377\330\356\377\377\307\345\377\377\271\340\377\377\252"
  "\327\377\377x\265\377\377\202\377\377\377\377\23\335\360\377\377G\1\1"
  "\377/x\377\377+k\377\377$_\377\377\36Y\377\377\33K\366\377\3\31\277\360"
  "\0\2\202\305\0\0\0\24\0\0\0\0\0\0\0\5\223\267\350\336\377\377\377\377"
  "\352\370\377\377\331\357\377\377\307\345\377\377\264\333\377\377\240"
  "\317\377\377\202\377\377\377\377\203\335\360\377\377\21G\1\1\377+i\377"
  "\377$_\377\377\33R\377\377\21>\355\377\14(\325\374\0\3\233\340\0\0\13"
  "4\0\0\0\0\16@\2078\246\311\370\350\377\377\377\377\352\371\377\377\331"
  "\357\377\377\307\345\377\377\272\336\377\377\217\302\377\377\202\377"
  "\377\377\377\203\335\360\377\377\20G\1\1\377+i\377\377#[\377\377\27G"
  "\357\377\15""8\352\377\16""0\344\377\0\6\264\365\0\0""0e\0\0\0\0)Y\236"
  "\214\374\377\377\377\377\377\377\377\352\370\377\377\333\360\377\377"
  "\313\347\377\377\235\314\377\377\203\377\377\377\377\204\335\360\377"
  "\377\21G\1\1\377\40Q\365\377\25C\356\377\6""2\352\377\3+\346\377@R\323"
  "\377\20\34a\242\0\0\0\0\0\10\"3\276\333\377\371\377\377\377\377\355\372"
  "\377\377\320\352\377\377\230\310\377\377\234\311\377\377\244\321\377"
  "\377G\1\1\377\202\377\377\377\377\1\335\360\377\377\202G\1\1\377\21&"
  "[\370\377\32K\364\377\12""8\356\377\"G\346\377{\211\332\377\307\306\326"
  "\377Ua\244\346\0\0\0\26\0\0\0\1X~\270\270\377\377\377\377\327\356\377"
  "\377\224\306\377\377\301\344\377\377\265\340\377\377\211\303\377\377"
  "n\260\377\377\202\377\377\377\377\24\335\360\377\377G\1\1\377-h\373\377"
  "\36S\370\377\32J\362\377e}\346\377\274\276\332\377\315\313\325\377\314"
  "\310\323\377\206\217\310\377\0\0-a\0\0\0\0\6\40JX\336\362\377\377\306"
  "\345\377\377\252\326\377\377\327\367\377\377\245\326\377\377\210\301"
  "\377\377m\257\377\377\202\377\377\377\377\25\335\360\377\377G\1\1\377"
  "\40]\374\377Ak\366\377\246\263\352\377\333\330\340\377\323\322\335\377"
  "\315\314\331\377\212\221\304\377\36+v\341\0\0\14I\0\0\0\0\0\0\0\20\213"
  "\252\343\343\341\366\377\377\225\310\377\377\317\361\377\377\245\326"
  "\377\377\207\277\377\377j\255\377\377T\234\377\377\203G\1\1\377\10i\217"
  "\370\377\323\327\355\377\347\345\347\377\336\335\346\377\314\315\341"
  "\377px\272\377\0\12T\302\0\0\0""8\203\0\0\0\0\22%Cx\207\347\373\377\377"
  "\235\311\377\377\303\347\377\377\242\323\377\377\204\275\377\377f\252"
  "\377\377O\231\377\3776\204\377\377Q\217\377\377\265\311\372\377\361\357"
  "\364\377\357\355\361\377\352\350\357\377\250\256\330\377.;\210\351\0"
  "\0#\203\0\0\0\24\204\0\0\0\0\20\0\0\16#\237\273\356\360\277\341\377\377"
  "\263\333\377\377\240\322\377\377~\272\377\377\\\243\377\377K\224\377"
  "\377\216\272\377\377\355\362\377\377\377\376\373\377\373\372\372\377"
  "\344\344\365\377r}\275\377\0\13H\257\0\0\0""4\207\0\0\0\0\7%Ax\217\314"
  "\345\377\377\244\315\377\377\243\323\377\377s\263\377\377\201\270\377"
  "\377\321\347\377\377\203\377\377\377\377\4\275\305\354\3773A\212\343"
  "\0\0\25m\0\0\0\11\210\0\0\0\0\5\0\0\5\36e\210\325\347\262\325\377\377"
  "\234\316\377\377\277\340\377\377\204\377\377\377\377\3u\207\314\377\0"
  "\12I\264\0\0\0""1\213\0\0\0\0\3\10\33Gf\201\253\377\377\335\360\377\377"
  "\203\377\377\377\377\4\343\355\377\377L`\245\350\0\0\33u\0\0\0\21\214"
  "\0\0\0\0\3\0\0\0\5\33B\230\273\272\325\377\377\202\377\377\377\377\3"
  "\242\263\350\377\21$`\266\0\0\0""7\217\0\0\0\0\6\0\0\20""1Kw\334\365"
  "\315\336\377\377C\\\237\336\0\0\40r\0\0\0\14\221\0\0\0\0\3\0\13""6e\1"
  "\26H\225\0\0\0'\215\0\0\0\0"};

static const guint8 folder_new_icon[] = 
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (1403) */
  "\0\0\5\223"
  /* pixdata_type (0x2010002) */
  "\2\1\0\2"
  /* rowstride (88) */
  "\0\0\0X"
  /* width (22) */
  "\0\0\0\26"
  /* height (22) */
  "\0\0\0\26"
  /* pixel_data: */
  "\216\0\0\0\0\6\0*\257\30,S\306\237\25)k\202\0\0\0\0\0\30\207\24\0\0\0"
  "\1\216\0\0\0\0\10\0,\252\24\40K\302qk\217\345\336\204\264\377\3775^\303"
  "\3504L\234\2516R\273\334\0\0\12*\214\0\0\0\0\12\0""0\240\7\33G\260em"
  "\223\350\332\217\273\377\377^\235\377\377H\201\366\377h\212\361\3779"
  "N\305\325\2\33\255\306\0\0\37R\206\0\0\0\0\2\36w\377\37\7""5\201-\203"
  "\0\0\0\0\13\21L\305Lc\214\342\306\232\302\377\377\377\377\377\377M\213"
  "\373\377i\225\366\377\364\371J\3770b\377\377\0\17\275\276\364\371J\377"
  "\0\1""7q\204\0\0\0\0\22\20V\267\17@\214\376~\223\302\377\355\214\271"
  "\377\367\22""9}s\15>\2354D{\347\247\235\302\377\377\235\316\377\377a"
  "\242\377\377`\224\367\377\377\377\377\377K\204\377\377\364\371J\377\40"
  "\\\377\377\364\371J\377\0\17\264\316\0\2L\214\203\0\0\0\0\16\31T\252"
  "C\210\270\371\321\350\371\377\377\356\373\377\377\325\357\377\377\233"
  "\313\377\377\214\272\377\373\261\331\377\377\201\274\377\377i\244\377"
  "\377z\251\377\377`\235\377\3773}\377\377\377\377\377\377\202\364\371"
  "J\377\21\40K\364\377\0\20\264\344\0\2e\246\0\0\0\3\0\0\0\0\0\0\0\14\221"
  "\272\365\344\377\377\377\377\356\373\377\377\330\356\377\377\307\345"
  "\377\377\271\340\377\377\252\327\377\377x\265\377\377\200\262\377\377"
  "}\262\377\377G\221\377\377\204\377\377\377\377\203\364\371J\377\21\0"
  "\2\202\305\0\0\0\24\0\0\0\0\0\0\0\5\223\267\350\336\377\377\377\377\352"
  "\370\377\377\331\357\377\377\307\345\377\377\264\333\377\377\240\317"
  "\377\377v\256\377\377\235\307\377\377D\223\377\377:\211\377\3775\202"
  "\377\3770w\377\377\202\377\377\377\377\177\364\371J\377\21>\355\377\14"
  "(\325\374\0\3\233\340\0\0\13""4\0\0\0\0\16@\2078\246\311\370\350\377"
  "\377\377\377\352\371\377\377\331\357\377\377\307\345\377\377\272\336"
  "\377\377\217\302\377\377\234\304\377\377\213\277\377\377E\222\377\377"
  "=\211\377\3776\201\377\377\377\377\377\377+i\377\377\377\377\377\377"
  "\27G\357\377\364\371J\377\16""0\344\377\0\6\264\365\0\0""0e\0\0\0\0)"
  "Y\236\214\374\377\377\377\377\377\377\377\352\370\377\377\333\360\377"
  "\377\313\347\377\377\235\314\377\377\206\270\377\377\250\317\377\377"
  "g\252\377\377H\223\377\377;\211\377\377\377\377\377\3770u\377\377*c\377"
  "\377\377\377\377\377\25C\356\377\6""2\352\377\364\371J\377@R\323\377"
  "\20\34a\242\0\0\0\0\0\10\"3\276\333\377\371\377\377\377\377\355\372\377"
  "\377\320\352\377\377\230\310\377\377\234\311\377\377\244\321\377\377"
  "s\264\377\377Y\242\377\377H\223\377\377;\211\377\3775}\377\377/m\377"
  "\377&[\370\377\377\377\377\377\12""8\356\377\"G\346\377{\211\332\377"
  "\307\306\326\377Ua\244\346\0\0\0\26\0\0\0\1X~\270\270\377\377\377\377"
  "\327\356\377\377\224\306\377\377\301\344\377\377\265\340\377\377\211"
  "\303\377\377n\260\377\377Y\242\377\377G\222\377\377;\206\377\3774w\377"
  "\377-h\373\377\36S\370\377\32J\362\377e}\346\377\274\276\332\377\315"
  "\313\325\377\314\310\323\377\206\217\310\377\0\0-a\0\0\0\0\6\40JX\336"
  "\362\377\377\306\345\377\377\252\326\377\377\327\367\377\377\245\326"
  "\377\377\210\301\377\377m\257\377\377V\237\377\377D\217\377\377:\202"
  "\377\3772s\377\377\40]\374\377Ak\366\377\246\263\352\377\333\330\340"
  "\377\323\322\335\377\315\314\331\377\212\221\304\377\36+v\341\0\0\14"
  "I\0\0\0\0\0\0\0\20\213\252\343\343\341\366\377\377\225\310\377\377\317"
  "\361\377\377\245\326\377\377\207\277\377\377j\255\377\377T\234\377\377"
  "C\214\377\377\12""3|\377\377-n\377\377i\217\370\377\323\327\355\377\347"
  "\345\347\377\336\335\346\377\314\315\341\377px\272\377\0\12T\302\0\0"
  "\0""8\203\0\0\0\0\22%Cx\207\347\373\377\377\235\311\377\377\303\347\377"
  "\377\242\323\377\377\204\275\377\377f\252\377\377O\231\377\3776\204\377"
  "\377Q\217\377\377\265\311\372\377\361\357\364\377\357\355\361\377\352"
  "\350\357\377\250\256\330\377.;\210\351\0\0#\203\0\0\0\24\204\0\0\0\0"
  "\20\0\0\16#\237\273\356\360\277\341\377\377\263\333\377\377\240\322\377"
  "\377~\272\377\377\\\243\377\377K\224\377\377\216\272\377\377\355\362"
  "\377\377\377\376\373\377\373\372\372\377\344\344\365\377r}\275\377\0"
  "\13H\257\0\0\0""4\207\0\0\0\0\7%Ax\217\314\345\377\377\244\315\377\377"
  "\243\323\377\377s\263\377\377\201\270\377\377\321\347\377\377\203\377"
  "\377\377\377\4\275\305\354\3773A\212\343\0\0\25m\0\0\0\11\210\0\0\0\0"
  "\5\0\0\5\36e\210\325\347\262\325\377\377\234\316\377\377\277\340\377"
  "\377\204\377\377\377\377\3u\207\314\377\0\12I\264\0\0\0""1\213\0\0\0"
  "\0\3\10\33Gf\201\253\377\377\335\360\377\377\203\377\377\377\377\4\343"
  "\355\377\377L`\245\350\0\0\33u\0\0\0\21\214\0\0\0\0\3\0\0\0\5\33B\230"
  "\273\272\325\377\377\202\377\377\377\377\3\242\263\350\377\21$`\266\0"
  "\0\0""7\217\0\0\0\0\6\0\0\20""1Kw\334\365\315\336\377\377C\\\237\336"
  "\0\0\40r\0\0\0\14\221\0\0\0\0\3\0\13""6e\1\26H\225\0\0\0'\215\0\0\0\0"};

static const guint8 folder_home_icon[] = 
{ ""
  /* Pixbuf magic (0x47646b50) */
  "GdkP"
  /* length: header (24) + pixel_data (1573) */
  "\0\0\6="
  /* pixdata_type (0x2010002) */
  "\2\1\0\2"
  /* rowstride (88) */
  "\0\0\0X"
  /* width (22) */
  "\0\0\0\26"
  /* height (22) */
  "\0\0\0\26"
  /* pixel_data: */
  "\211\0\0\0\0\5:::\14:::\305'''\377\24\24\24\305\24\24\24\14\214\0\0\0"
  "\0\13(((\30###:\5\5\5:\0\0\0\30```\22___CYYY\322FFF\377333\322555C66"
  "6\22\213\0\0\0\0\13(((d###\363\5\5\5\363\0\0\0d```Mddd\364\246\246\246"
  "\374\247\247\247\377\200\200\200\374;;;\364666M\213\0\0\0\0\14(((h##"
  "#\377\5\5\5\377***\317ttt\310\242\242\242\377\261\261\261\377\245\245"
  "\245\377\213\213\213\377kkk\377AAA\310&&&g\212\0\0\0\0\16,((h*'&\377"
  "\37\36\36\377XXX\377\216\216\216\377\250\250\250\377\224\224\224\377"
  "\205\205\205\377zzz\377sss\377XXX\377CCC\301$$$Z$$$\16\210\0\0\0\0\17"
  "6/.h:44\377RQQ\377\217\217\217\377\246\246\246\377\203\203\203\377mm"
  "m\377eee\377bbb\377```\377rrr\377\\\\\\\377000\341)))A!!!\16\207\0\0"
  "\0\0\17ONNh\\[[\377\242\242\242\377\221\221\221\377www\377mmm\377\223"
  "\223\223\377\232\232\232\377\211\211\211\377fff\377\\\\\\\377ccc\377"
  "jjj\372...\341!!!Z\206\0\0\0\0\21UUUgwww\301\224\224\224\377\222\222"
  "\222\377|||\377{{{\377\234\234\234\377\303\303\303\377\314\314\314\377"
  "\275\275\275\377\227\227\227\377ppp\377aaa\377bbb\377[[[\377\77\77\77"
  "\301\40\40\40g\203\0\0\0\0""5```\22```Mttt\310\213\213\213\377\237\237"
  "\237\377uuu\377{{{\377\233\233\233\377\317\317\317\377\346\346\346\377"
  "\355\355\355\377\344\344\344\377\306\306\306\377\226\226\226\377nnn\377"
  "YYY\377mmm\377SSS\377;;;\310!!!M!!!\22JJJ\14aaaCddd\364\240\240\240\377"
  "\236\236\236\377ppp\377hhh\377\233\233\233\377\317\317\317\377\361\361"
  "\361\377\367\367\367\377\371\371\371\377\365\365\365\377\350\350\350"
  "\377\305\305\305\377\225\225\225\377ddd\377QQQ\377jjj\377bbb\377%%%\364"
  "$$$CJJJ\305eee\322\247\247\247\374\215\215\215\377uuu\377ooo\377\234"
  "\234\234\377\312\312\312\377\352\352\352\377\366\366\366\377\202\370"
  "\370\370\377L\367\367\367\377\363\363\363\377\347\347\347\377\307\307"
  "\307\377\227\227\227\377fff\377XXX\377]]]\377hhh\374111\322JJJ\177ZZ"
  "Z\234sss\371WWW\377```\377\212\212\212\377\300\300\300\377\343\343\343"
  "\377\357\354\352\377\343\330\322\377\315\273\252\377\273\240\217\377"
  "\274\240\223\377\341\326\321\377\357\354\352\377\342\342\342\377\274"
  "\274\274\377\201\201\201\377WTT\377K\77>\377^CA\3715*)\234\0\0\0\0(("
  "(-(((\274'''\355XXX\377\247\247\247\377\325\325\325\377\356\356\356\377"
  "\350\337\332\377\301\247\226\377\257\215p\377\226gG\377\220ZA\377\266"
  "\225\207\377\345\332\326\377\355\355\355\377\322\322\322\377\230\230"
  "\230\377ZVV\3779%#\355\77\6\2\274\77\6\2-\0\0\0\0(((\3(((\13*))\262["
  "ZZ\377\252\252\252\377\327\327\327\377\356\356\356\377\332\315\301\377"
  "\233sN\377\330\301\256\377\343\307\262\377\301\225z\377s3\26\377\315"
  "\270\257\377\357\357\357\377\327\327\327\377\241\241\241\377ZZZ\3771"
  "//\262\77\6\2\13\77\6\2\3\203\0\0\0\0\21""555\256ccc\377\257\257\257"
  "\377\331\331\331\377\357\357\357\377\331\314\277\377\230oH\377\324\267"
  "\237\377\337\246v\377\277j(\377o)\5\377\314\265\253\377\360\357\357\377"
  "\332\330\330\377\252\251\251\377[[[\377+++\256\205\0\0\0\0\21:::\256"
  "ggg\377\261\261\261\377\331\331\331\377\357\357\357\377\327\311\274\377"
  "\222g=\377\317\244\201\377\326\212K\377\265P\0\377o'\1\377\314\265\252"
  "\377\360\357\357\377\333\331\331\377\257\256\256\377\\\\\\\377)))\256"
  "\205\0\0\0\0\21:::\256ggg\377\261\261\261\377\331\331\331\377\357\357"
  "\357\377\324\305\266\377\212Z+\377\312\221_\377\317{8\377\254J\0\377"
  "o&\1\377\314\265\252\377\360\357\357\377\333\331\331\377\260\260\260"
  "\377]]]\377)))\256\205\0\0\0\0\21:::\256ggg\377\261\261\261\377\331\331"
  "\331\377\357\357\357\377\322\301\261\377\202M\31\377\310\204L\377\316"
  "u.\377\254J\0\377o&\1\377\314\265\252\377\360\357\357\377\333\331\331"
  "\377\261\261\261\377]]]\377)))\256\205\0\0\0\0\21:::\256ggg\377\261\261"
  "\261\377\331\331\331\377\357\357\357\377\321\300\257\377\177H\23\377"
  "\303u4\377\307h\37\377\244D\0\377n&\1\377\314\265\252\377\360\357\357"
  "\377\333\331\331\377\260\260\260\377]]]\377)))\256\205\0\0\0\0\21:::"
  "\256fff\377\255\255\255\377\325\325\325\377\347\347\347\377\306\265\246"
  "\377u=\14\377\265^\32\377\271W\17\377\231>\1\377e#\4\377\302\255\244"
  "\377\350\347\347\377\327\325\325\377\255\255\255\377\\\\\\\377)))\256"
  "\205\0\0\0\0\21:::\246ccc\370\241\241\241\377\305\305\305\377\316\316"
  "\316\377\254\233\216\377b*\2\377\230>\2\377\241A\2\377\2077\4\377P\37"
  "\14\377\246\227\221\377\317\316\316\377\307\305\305\377\241\240\240\377"
  "WWW\377)))\256\205\0\0\0\0\21:::(KKK\213RRR\377XXX\377YXX\377NIF\377"
  "7)\40\377C.\40\377F/\40\377\77,\40\3772'\"\377MGE\377ZXW\377VVV\377G"
  "GG\377444\377(((\256\202\0\0\0\0"};

/* $B%U%!%$%kA*Br%@%$%"%m%0=i4|2=4X?t(B **************************************** */
static void
gnome_custom_file_selection_class_init	(GnomeCustomFileSelClass *klass);
static void
gnome_custom_file_selection_init	(GnomeCustomFileSel	*filesel);

/* $B%@%$%"%m%0$N%3!<%k%P%C%/4X?t(B ******************************************** */
static void	cb_folder_up	 	(GtkWidget		*widget,
					 GnomeCustomFileSel	*filesel);
static void	cb_folder_new 		(GtkWidget		*widget,
					 GnomeCustomFileSel	*filesel);
static void	cb_folder_home		(GtkWidget		*widget,
					 GnomeCustomFileSel	*filesel);
static gboolean	cb_folder_tree_release	(GtkWidget		*widget,
					 GdkEventButton		*ev,
					 GnomeCustomFileSel	*filesel);
static void	cb_folder_changed 	(GtkWidget		*widget,
					 GnomeCustomFileSel	*filesel);
static gboolean	cb_folder_entry_press	(GtkWidget		*widget,
					 GdkEventKey		*key,
					 GnomeCustomFileSel	*filesel);
static void	cb_filter_changed 	(GtkWidget		*widget,
					 GnomeCustomFileSel	*filesel);
static gboolean	cb_filter_entry_press	(GtkWidget		*widget,
					 GdkEventKey		*key,
					 GnomeCustomFileSel	*filesel);
static gboolean cb_button_released	(GnomeFileList		*filelist,
					 GdkEventButton		*ev,
					 gpointer		data);
static gboolean	cb_button_pressed	(GnomeFileList		*filelist,
					 GdkEventButton		*ev,
					 gpointer		data);

/* $BJd=u4X?t(B **************************************************************** */
static void	folder_combo_prepend	(GnomeCustomFileSel	*filesel,
					 const gchar		*folder);

static GtkWidget *mkfolder_dialog_new	(GnomeCustomFileSel	*filesel);
static void	cb_mkfolder_dialog_ok 	(GtkWidget		*widget,
					 GtkWidget		*dialog);
static void	cb_mkfolder_dialog_cancel(GtkWidget		*widget,
					  GtkWidget		*dialog);
static void	cb_mkfolder_dialog_close(GtkWidget		*widget,
					 gpointer		data);

/* $B%0%m!<%P%kJQ?t(B ********************************************************** */
static GtkWindowClass	*parent_class	    = NULL;
#if 0
static gboolean		combo_callback_flag = TRUE;
#endif
/* ************************************************************************* *
 * $B%U%!%$%kA*Br%@%$%"%m%0=i4|2=4X?t(B
 *
 * gnome_custom_file_selection_get_type
 * gnome_custom_file_selection_class_init
 * gnome_custom_file_selection_init
 * ************************************************************************* */

/* $B%?%$%W<hF@4X?t(B ********************************************************** */
GType
gnome_custom_file_selection_get_type (void) {
  static GType	filesel_type = 0;

  if (!filesel_type) {
    static const GTypeInfo filesel_info = {
      sizeof (GnomeCustomFileSelClass),
      NULL,
      NULL,
      (GClassInitFunc) gnome_custom_file_selection_class_init,
      NULL,
      NULL,
      sizeof (GnomeCustomFileSel),
      0,
      (GInstanceInitFunc) gnome_custom_file_selection_init,
      NULL
    };
    filesel_type
      = g_type_register_static (GTK_TYPE_WINDOW,
				"GnomeCustomFileSel", &filesel_info, 0);
  }
  return filesel_type;
}

/* $B%/%i%9=i4|2=4X?t(B ******************************************************** */
static void
gnome_custom_file_selection_class_init (GnomeCustomFileSelClass	*klass) {
  parent_class = gtk_type_class (gnome_custom_file_selection_get_type());
}

/* $B%&%#%8%'%C%H=i4|2=4X?t(B ************************************************** */
static void
gnome_custom_file_selection_init (GnomeCustomFileSel	*filesel) {

}

/* ************************************************************************* *
 * $B%U%!%$%kA*Br%@%$%"%m%0$N:n@.(B
 * ************************************************************************* */
GtkWidget*
gnome_custom_file_selection_new (const gchar	*title,
				 const gchar	*icon_folder) {
  GnomeCustomFileSel	*filesel;
  GtkWidget		*dialog;
  GtkWidget		*dialog_vbox;
  GtkWidget		*hbox;
  GtkWidget		*label;
  GtkWidget		*hpaned;
  GtkWidget		*frame;
  GtkWidget		*separator;
  GtkWidget		*table;
  GtkTooltips		*tooltips;
  gchar			current[1024];
  gchar			*folder[5], *iconname;
  gchar			*mime_file_folder;
  gint			n;
  
  /* $B%@%$%"%m%0$N:n@.(B */
  dialog = gtk_widget_new (gnome_custom_file_selection_get_type(), NULL);
  gtk_window_set_title (GTK_WINDOW (dialog), title);

  filesel = GNOME_CUSTOM_FILESEL(dialog);
  
  dialog_vbox = gtk_vbox_new(FALSE, 5);
  gtk_widget_show(dialog_vbox);
  gtk_container_add(GTK_CONTAINER(filesel), dialog_vbox);
  gtk_container_set_border_width(GTK_CONTAINER(dialog_vbox), 5);
  {
    hbox = gtk_hbox_new (FALSE, 2);
    gtk_widget_show (hbox);
    gtk_box_pack_start (GTK_BOX (dialog_vbox), hbox, FALSE, FALSE, 0);
    {
      /* $B%U%)%k%@%i%Y%k(B */
      label = gtk_label_new(_("Current Folder:"));
      gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);
      gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

      /* $B%U%)%k%@%3%s%\%\%C%/%9(B */
      filesel->folder_combo = gtk_combo_box_entry_new_text();
      filesel->folder_entry = GTK_BIN(filesel->folder_combo)->child;
      g_signal_connect(G_OBJECT(filesel->folder_combo), "changed",
		       G_CALLBACK(cb_folder_changed), filesel);
      g_signal_connect(G_OBJECT(filesel->folder_entry), "key_press_event",
		       G_CALLBACK(cb_folder_entry_press), filesel);
      gtk_box_pack_start(GTK_BOX(hbox), filesel->folder_combo, TRUE, TRUE, 0);

      /* $B%D!<%k%A%C%W(B */
      tooltips = gtk_tooltips_new();

      /* [$B?F%U%)%k%@$X(B]$B%\%?%s(B */
      iconname = g_build_filename(icon_folder, STOCK_ICON_DIR,
				  "folder_up.png", NULL);
      if (g_file_test(iconname, G_FILE_TEST_EXISTS)) {
	filesel->folder_button_up = gtk_icon_button_new (iconname);
	g_free(iconname);
      } else {
	filesel->folder_button_up
	  = gtk_icon_button_new_from_inline(folder_up_icon);
      }
      gtk_widget_set_size_request(filesel->folder_button_up,
				  FOLDER_BUTTON_W, FOLDER_BUTTON_H);
      g_signal_connect(G_OBJECT(filesel->folder_button_up), "clicked",
		       G_CALLBACK(cb_folder_up), filesel);
      gtk_box_pack_start(GTK_BOX(hbox),
			 filesel->folder_button_up, FALSE, FALSE, 0);
      gtk_tooltips_set_tip(tooltips, filesel->folder_button_up,
			   _("Go to parent folder"), NULL);

      /* [$B%U%)%k%@:n@.(B]$B%\%?%s(B */
      iconname = g_build_filename(icon_folder, STOCK_ICON_DIR,
				  "folder_new.png", NULL);
      if (g_file_test(iconname, G_FILE_TEST_EXISTS)) {
	filesel->folder_button_new = gtk_icon_button_new (iconname);
	g_free(iconname);
      } else {
	filesel->folder_button_new
	  = gtk_icon_button_new_from_inline(folder_new_icon);
      }
      gtk_widget_set_size_request(filesel->folder_button_new,
				  FOLDER_BUTTON_W, FOLDER_BUTTON_H);
      g_signal_connect(G_OBJECT(filesel->folder_button_new), "clicked",
		       G_CALLBACK(cb_folder_new),
		       GNOME_CUSTOM_FILESEL(filesel));
      gtk_box_pack_start(GTK_BOX(hbox),
			 filesel->folder_button_new, FALSE, FALSE, 0);
      gtk_tooltips_set_tip(tooltips, filesel->folder_button_new,
			   _("Create new folder"), NULL);

      /* [$B%[!<%`$X(B]$B%\%?%s(B */
      iconname = g_build_filename(icon_folder, STOCK_ICON_DIR,
				  "home.png", NULL);
      if (g_file_test(iconname, G_FILE_TEST_EXISTS)) {
	filesel->folder_button_home = gtk_icon_button_new (iconname);
	g_free(iconname);
      } else {
	filesel->folder_button_home
	  = gtk_icon_button_new_from_inline(folder_home_icon);
      }
      gtk_widget_set_size_request(filesel->folder_button_home,
				  FOLDER_BUTTON_W, FOLDER_BUTTON_H);
      g_signal_connect(G_OBJECT(filesel->folder_button_home), "clicked",
		       G_CALLBACK(cb_folder_home),
		       GNOME_CUSTOM_FILESEL(filesel));
      gtk_box_pack_start(GTK_BOX(hbox),
			 filesel->folder_button_home, FALSE, FALSE, 0);
      gtk_tooltips_set_tip(tooltips, filesel->folder_button_home,
			   _("Go to home folder"), NULL);
    }
    hpaned = gtk_hpaned_new();
    gtk_box_pack_start(GTK_BOX(dialog_vbox), hpaned, TRUE, TRUE, 0);
    {
      frame = gtk_frame_new(NULL);
      gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
      gtk_paned_pack1(GTK_PANED(hpaned), frame, FALSE, TRUE);
      
      /* $B%U%)%k%@%D%j!<(B */
      filesel->tree_window = gtk_scrolled_window_new(NULL, NULL);
      gtk_widget_set_size_request(filesel->tree_window,
				  TREE_WINDOW_W, TREE_WINDOW_H);
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(filesel->tree_window),
				     GTK_POLICY_AUTOMATIC,
				     GTK_POLICY_AUTOMATIC);
      gtk_container_add(GTK_CONTAINER(frame), filesel->tree_window);
      {
	if (!icon_folder) {
	  filesel->folder_tree
	    = gtk_dir_tree_view_new(G_DIR_SEPARATOR_S, FALSE);
	} else {
	  folder[0] = g_build_filename(icon_folder, FOLDER_ICON_DIR,
				       "folder.png", NULL);
	  folder[1] = g_build_filename(icon_folder, FOLDER_ICON_DIR,
				       "folder_open.png", NULL);
	  folder[2] = g_build_filename(icon_folder, FOLDER_ICON_DIR,
				       "folder_link.png", NULL);
	  folder[3] = g_build_filename(icon_folder, FOLDER_ICON_DIR,
				       "folder_link_open.png", NULL);
	  folder[4] = g_build_filename(icon_folder, FOLDER_ICON_DIR,
				       "folder_dennied.png", NULL);
	  filesel->folder_tree
	    = gtk_dir_tree_view_new_from_file(G_DIR_SEPARATOR_S, FALSE,
					      folder[0], folder[1], folder[2],
					      folder[3], folder[4]);
	  for (n = 0; n < 5; n++) g_free(folder[n]);
	}
	g_signal_connect(G_OBJECT(filesel->folder_tree), "button_release_event",
			 G_CALLBACK(cb_folder_tree_release),
			 GNOME_CUSTOM_FILESEL(filesel));
	gtk_container_add(GTK_CONTAINER(filesel->tree_window),
			  filesel->folder_tree);
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(filesel->folder_tree),
					  FALSE);
      }
      frame = gtk_frame_new(NULL);
      gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
      gtk_paned_pack2(GTK_PANED(hpaned), frame, TRUE, TRUE);
      
      /* $B%U%!%$%k%j%9%H(B */
      filesel->list_window = gtk_scrolled_window_new(NULL, NULL);
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(filesel->list_window),
				     GTK_POLICY_AUTOMATIC,
				     GTK_POLICY_AUTOMATIC);
      gtk_widget_set_size_request(filesel->list_window, LIST_WINDOW_W, -1);
      
      gtk_container_add(GTK_CONTAINER(frame), filesel->list_window);
      {
	mime_file_folder = g_build_filename(icon_folder, MIME_ICON_DIR, NULL);
	filesel->file_list
	  = gnome_file_list_new_from_file(NULL,
					  mime_file_folder, 80, NULL,
					  GNOME_FILE_LIST_SORT_TYPE, 0);
	g_free(mime_file_folder);
	gtk_container_add(GTK_CONTAINER(filesel->list_window),
			  filesel->file_list);
#if 0
	g_signal_connect(G_OBJECT(filesel->file_list), "select_icon",
			 G_CALLBACK(select_icon), NULL);
#endif
	g_signal_connect(G_OBJECT(filesel->file_list), "button_press_event",
			 G_CALLBACK(cb_button_pressed),  filesel);
	g_signal_connect(G_OBJECT(filesel->file_list), "button_release_event",
			 G_CALLBACK(cb_button_released), filesel);
      }
    }
    separator = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(dialog_vbox), separator, FALSE, FALSE, 3);

    filesel->custom_box = gtk_hbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(dialog_vbox),
		       filesel->custom_box, FALSE, FALSE, 0);

    table = gtk_table_new(2, 4, FALSE);
    gtk_table_set_row_spacings(GTK_TABLE(table), 3);
    gtk_table_set_col_spacings(GTK_TABLE(table), 5);    
    gtk_box_pack_start(GTK_BOX(dialog_vbox), table, FALSE, FALSE, 0);
    {
      /* $B%i%Y%k(B */
      label = gtk_label_new("");
      gtk_widget_set_size_request(label, 80, -1);
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, 0, 1,
		       (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);

      label = gtk_label_new("");
      gtk_widget_set_size_request(label, 80, -1);
      gtk_table_attach(GTK_TABLE(table), label, 0, 1, 1, 2,
		       (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
      
      label = gtk_label_new(_("File:"));
      gtk_table_attach(GTK_TABLE(table), label, 1, 2, 0, 1,
		       (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
      gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);

      label = gtk_label_new(_("File type:"));
      gtk_table_attach(GTK_TABLE(table), label, 1, 2, 1, 2,
		       (GtkAttachOptions) (0), (GtkAttachOptions) (0), 0, 0);
      gtk_misc_set_alignment(GTK_MISC(label), 1.0, 0.5);

      /* $B%U%!%$%kL>%(%s%H%j(B */
      filesel->file_entry = gtk_entry_new();
      gtk_table_attach(GTK_TABLE(table), filesel->file_entry, 2, 3, 0, 1,
		       (GtkAttachOptions) (GTK_EXPAND) | (GTK_FILL),
		       (GtkAttachOptions) (0), 0, 0);
 
      /* $B%U%!%$%k$N<oN`%3%s%\(B */
      filesel->filter_combo = gtk_combo_box_entry_new_text();
      filesel->filter_entry = GTK_BIN(filesel->filter_combo)->child;      
      g_signal_connect(G_OBJECT(filesel->filter_combo), "changed",
		       G_CALLBACK(cb_filter_changed), filesel);
      g_signal_connect(G_OBJECT(filesel->filter_entry), "key_press_event",
		       G_CALLBACK(cb_filter_entry_press), filesel);
      gtk_table_attach(GTK_TABLE(table), filesel->filter_combo, 2, 3, 1, 2,
		       (GtkAttachOptions) (GTK_EXPAND) | (GTK_FILL),
		       (GtkAttachOptions) (0), 0, 0);
      /* OK$B%\%?%s(B */
      filesel->ok_button = gtk_button_new_from_stock("gtk-ok");
      gtk_table_attach(GTK_TABLE(table), filesel->ok_button, 3, 4, 0, 1,
		       (GtkAttachOptions) (GTK_FILL),
		       (GtkAttachOptions) (0), 0, 0);
      GTK_WIDGET_SET_FLAGS(filesel->ok_button, GTK_CAN_DEFAULT);
      gtk_widget_grab_default(filesel->ok_button);      
      
      /* $B%-%c%s%;%k%\%?%s(B */
      filesel->cancel_button = gtk_button_new_from_stock("gtk-cancel");
      gtk_table_attach(GTK_TABLE(table), filesel->cancel_button, 3, 4, 1, 2,
		       (GtkAttachOptions) (GTK_FILL),
		       (GtkAttachOptions) (0), 0, 0);
    }
  }
  filesel->folder_combo_list = NULL;
  getcwd(current, sizeof(current));
  gnome_custom_file_selection_set_folder(filesel, current);
  
  gtk_widget_show_all(dialog);
  
  return dialog;
}

/* ************************************************************************* *
 * $B%U%!%$%kA*Br%@%$%"%m%0$N%3!<%k%P%C%/4X?t(B
 *
 * cb_folder_up
 * cb_folder_new
 * cb_folder_home
 * cb_folder_tree_release
 * cb_folder_changed
 * cb_folder_entry_press
 * cb_filter_changed
 * cb_filter_entry_press
 * cb_file_selected
 * 
 * ************************************************************************* */

/* [$B?F%U%)%k%@$X0\F0(B]$B%\%?%s$N%3!<%k%P%C%/4X?t(B ******************************* */
static void
cb_folder_up (GtkWidget			*widget,
	      GnomeCustomFileSel	*filesel) {
  gchar	*folder = NULL;
  gchar	*parent;
  
  folder = gtk_dir_tree_view_get_selected_path(GTK_DIR_TREE_VIEW
					       (filesel->folder_tree));
  if (!folder) return;
  if (strcmp(folder, G_DIR_SEPARATOR_S) == 0) {
    g_free(folder);
    return;
  }
  parent = g_dir_get_parent_dir(folder);
  gnome_custom_file_selection_set_folder(filesel, parent);

  g_free(parent);
}

/* [$B%U%)%k%@:n@.(B]$B%\%?%s$N%3!<%k%P%C%/4X?t(B *********************************** */
static void
cb_folder_new (GtkWidget		*widget,
	       GnomeCustomFileSel	*filesel) {
  GtkWidget	*dialog;

  dialog = mkfolder_dialog_new(filesel);
  gtk_widget_show_all(dialog);
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(filesel));
}

/* [$B%[!<%`$X0\F0(B]$B%\%?%s$N%3!<%k%P%C%/4X?t(B *********************************** */
static void
cb_folder_home (GtkWidget		*widget,
		GnomeCustomFileSel	*filesel) {
  gchar	*home;

  home = g_locale_to_utf8(g_get_home_dir(), -1, NULL, NULL, NULL);
  gnome_custom_file_selection_set_folder(filesel, home);
  
  g_free(home);
}

/* $B%U%)%k%@%D%j!<$N%3!<%k%P%C%/4X?t(B ***************************************** */
static gboolean
cb_folder_tree_release (GtkWidget		*widget,
			GdkEventButton		*ev,
			GnomeCustomFileSel	*filesel) {
  GtkComboBox			*combo;
  gchar				*path, *utf8_path = NULL;
  
  /* $BA*Br$7$?%U%)%k%@%Q%9$N<hF@(B */
  path = gtk_dir_tree_view_get_selected_path(GTK_DIR_TREE_VIEW(widget));
  if (path) utf8_path = g_locale_to_utf8(path, -1, NULL, NULL, NULL);

  if (utf8_path) {
    /* $B%3%s%\%\%C%/%9$N%3!<%k%P%C%/$r%V%m%C%/(B */
#if 0
    combo_callback_flag = FALSE;
#endif
    combo = GTK_COMBO_BOX(filesel->folder_combo);
    gtk_entry_set_text(GTK_ENTRY(filesel->folder_entry), utf8_path);
  
    folder_combo_prepend(filesel, utf8_path);
    gnome_file_list_create_list(GNOME_FILE_LIST(filesel->file_list),
				utf8_path, FALSE);

    /* $B%3%s%\%\%C%/%9$N%3!<%k%P%C%/$r%V%m%C%/$r2r=|(B */
#if 0
    combo_callback_flag = TRUE;
#endif
    g_free(utf8_path);
  }  
  return FALSE;
}

/* ************************************************************************* */
static void
cb_folder_changed (GtkWidget		*widget,
		   GnomeCustomFileSel	*filesel) {
  gchar	*folder;

  folder =
    g_filename_from_utf8(gtk_entry_get_text(GTK_ENTRY(filesel->folder_entry)),
			 -1, NULL, NULL, NULL);
  if (folder && strcmp (folder, "") != 0) {
    gtk_dir_tree_view_set_dir(GTK_DIR_TREE_VIEW(filesel->folder_tree), folder);
    gnome_file_list_create_list(GNOME_FILE_LIST(filesel->file_list),
				folder, FALSE);
    g_free(folder);
  }			    
}

/* $B%U%)%k%@%3%s%\%(%s%H%j$N%3!<%k%P%C%/4X?t(B ********************************* */
static gboolean
cb_folder_entry_press (GtkWidget		*widget,
		       GdkEventKey		*key,
		       GnomeCustomFileSel	*filesel) {
  gchar	*folder;
  
  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return FALSE;

  folder = g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
  if (!g_dir_is(folder)) {
    g_free(folder);
    return FALSE;
  }
  folder_combo_prepend(filesel, folder);
  gtk_dir_tree_view_set_dir(GTK_DIR_TREE_VIEW(filesel->folder_tree), folder);
  gnome_file_list_create_list(GNOME_FILE_LIST(filesel->file_list),
			      folder, FALSE);
  
  g_free(folder);

  return FALSE;
}

/* ************************************************************************* */
static void
cb_filter_changed (GtkWidget		*widget,
		   GnomeCustomFileSel	*filesel) {
  gchar	*filter;

  filter =
    g_filename_from_utf8(gtk_entry_get_text(GTK_ENTRY(filesel->filter_entry)),
			 -1, NULL, NULL, NULL);
  if (filter && strcmp (filter, "") != 0) {
    gnome_file_list_set_filter(GNOME_FILE_LIST(filesel->file_list), filter);
    g_free(filter);
  }			    
}

/* $B%U%)%k%@%3%s%\%(%s%H%j$N%3!<%k%P%C%/4X?t(B ********************************* */
static gboolean
cb_filter_entry_press (GtkWidget		*widget,
		       GdkEventKey		*key,
		       GnomeCustomFileSel	*filesel) {
  gchar	*filter;
  
  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return FALSE;

  filter = g_strdup(gtk_entry_get_text(GTK_ENTRY(widget)));
  if (filter) {
    gnome_file_list_set_filter(GNOME_FILE_LIST(filesel->file_list), filter);
    g_free(filter);
  }			    
  return FALSE;
}

/* ************************************************************************* */
static gboolean
cb_button_released (GnomeFileList	*filelist,
		    GdkEventButton	*ev,
		    gpointer		data) {
  GnomeCustomFileSel	*filesel  = GNOME_CUSTOM_FILESEL(data);
  GnomeIconList		*iconlist = GNOME_ICON_LIST(filelist);
  GnomeFileListItem	*item;
  GList			*selection;
  gint			num;

  selection = gnome_icon_list_get_selection(iconlist);
  if (selection) {
    num = (gint) selection->data;
    item = (GnomeFileListItem *) gnome_icon_list_get_icon_data(iconlist, num);

    if (item->type != GNOME_FILE_LIST_FOLDER) {
      gtk_entry_set_text(GTK_ENTRY(filesel->file_entry), item->filename);
    }
  }
  return FALSE;
}

/* ************************************************************************* */
static gboolean
cb_button_pressed (GnomeFileList	*filelist,
		   GdkEventButton	*ev,
		   gpointer		data) {
  GnomeCustomFileSel	*filesel  = GNOME_CUSTOM_FILESEL(data);
  GnomeIconList		*iconlist = GNOME_ICON_LIST(filelist);
  GnomeFileListItem	*item;
  GList			*selection;
  gchar			*path, *tmp, *utf8_path, *locale_path;
  gint			num;

  if (ev->type == GDK_2BUTTON_PRESS) {  

    selection = gnome_icon_list_get_selection(iconlist);
    if (selection) {
      num = (gint) selection->data;
      item = (GnomeFileListItem *) gnome_icon_list_get_icon_data(iconlist,num);

      if (item->type == GNOME_FILE_LIST_FOLDER) {      
	if (strcmp(item->filename, ".") == 0) return FALSE;
	path = gnome_file_list_get_path(filelist);
	tmp  = g_build_filename(path, item->filename, NULL);
	utf8_path = g_get_absolute_path(tmp);
	locale_path = g_locale_from_utf8(utf8_path, -1, NULL, NULL, NULL);
	gtk_dir_tree_view_set_dir(GTK_DIR_TREE_VIEW(filesel->folder_tree),
				  locale_path);
	folder_combo_prepend(filesel, utf8_path);
	gtk_entry_set_text(GTK_ENTRY(filesel->folder_entry), utf8_path);
	gnome_file_list_create_list(filelist, locale_path, FALSE);
	g_free(tmp);
	g_free(utf8_path);
	g_free(locale_path);    
      }
    }
  }
  return FALSE;
}
  
/* ************************************************************************* *
 * $BJd=u4X?t(B
 * ************************************************************************* */

/* ************************************************************************* *
 * $B%U%)%k%@%3%s%\$NJd=u4X?t(B
 *
 * folder_combo_prepend
 *
 * ************************************************************************* */

/* ************************************************************************* */
static void
folder_combo_prepend (GnomeCustomFileSel	*filesel,
		      const gchar		*folder) {
  GList		*list;
  gboolean	exist_flag = FALSE;

  for (list = filesel->folder_combo_list; list; list = g_list_next(list)) {
    if (strcmp(folder, (gchar *) list->data) == 0) {
      exist_flag = TRUE;
      break;
    }
  }
  if (!exist_flag) {
    filesel->folder_combo_list = g_list_prepend(filesel->folder_combo_list,
						g_strdup(folder));
    gtk_combo_box_prepend_text(GTK_COMBO_BOX(filesel->folder_combo),
			       g_strdup(folder));
    if (g_list_length(filesel->folder_combo_list) > COMBO_LIST_LIMIT) {
      filesel->folder_combo_list
	= g_list_remove(filesel->folder_combo_list,
			g_list_last(filesel->folder_combo_list)->data);
      gtk_combo_box_remove_text(GTK_COMBO_BOX(filesel->folder_combo),
				COMBO_LIST_LIMIT);
    }
  }
}

/* ************************************************************************* */
static void
cb_mkfolder_dialog_close (GtkWidget	*widget,
			  gpointer	data) {
  gtk_widget_destroy(widget);
}

/* ************************************************************************* */
static void
cb_mkfolder_dialog_cancel (GtkWidget	*widget,
			   GtkWidget	*dialog) {
  gtk_widget_destroy(dialog);
}

/* ************************************************************************* */
static void
cb_mkfolder_dialog_ok (GtkWidget	*widget,
		       GtkWidget	*dialog) {
  GnomeCustomFileSel	*filesel;
  GtkEntry		*entry;
  gchar			*path, *text, *filename, *localename;
  gchar			*message;
  GError		*error = NULL;

  filesel = GNOME_CUSTOM_FILESEL(g_object_get_data(G_OBJECT(dialog), "parent"));
  
  entry = GTK_ENTRY(g_object_get_data(G_OBJECT(dialog), "entry"));
  text  = (gchar *) gtk_entry_get_text(entry);
  path  = gnome_file_list_get_path(GNOME_FILE_LIST(filesel->file_list));

  filename   = g_build_filename(path, text, NULL);
  localename = g_filename_from_utf8(filename, -1, NULL, NULL, &error);
  if (error) {
    if (g_error_matches(error,
			G_CONVERT_ERROR, G_CONVERT_ERROR_ILLEGAL_SEQUENCE)) {
      message = g_strdup_printf(_("The folder name '%s' contains symbols that are not allowed in filenames."), text);
    } else {
      message = g_strdup_printf(_("Error creating folder '%s' : %s\n%s\n"),
				text, error->message,
				_("You probably used symbols not allowed in filenames."));
    }
    g_printerr("%s", message);
    g_free(message);
    g_error_free(error);
  } else {
    g_dir_mkdir(localename);
    gtk_dir_tree_view_refresh_tree(GTK_DIR_TREE_VIEW(filesel->folder_tree));
    gnome_file_list_create_list(GNOME_FILE_LIST(filesel->file_list),
				path, TRUE);
  }
  gtk_widget_destroy(dialog);
  g_free(filename);
  g_free(localename);
}

/* $B?75,%U%)%k%@:n@.%@%$%"%m%0:n@.4X?t(B ************************************** */
static GtkWidget*
mkfolder_dialog_new (GnomeCustomFileSel	*filesel) {
  GtkWidget	*dialog;
  GtkWidget	*dialog_vbox;
  GtkWidget	*hbox;
  GtkWidget	*dialog_action_area;
  GtkWidget	*label;
  GtkWidget	*entry;
  GtkWidget	*button;
  
  /* $B%@%$%"%m%0$N:n@.(B */
  dialog = gtk_dialog_new();
  gtk_window_set_title(GTK_WINDOW(dialog), _("New Folder"));
  gtk_window_set_resizable(GTK_WINDOW (dialog), FALSE);
  g_signal_connect(G_OBJECT(dialog),
		   "destroy", G_CALLBACK(cb_mkfolder_dialog_close), NULL);

  dialog_vbox = GTK_DIALOG(dialog)->vbox;

  /* $B?75,%U%)%k%@L>F~NO%(%s%H%j(B */
  hbox = gtk_hbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(hbox), 3);
  gtk_box_pack_start(GTK_BOX(dialog_vbox), hbox, FALSE, FALSE, 0);
  {
    label = gtk_label_new(_("New Folder:"));
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    entry = gtk_entry_new();
    g_object_set_data(G_OBJECT(dialog), "entry", entry);
    gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 0);    
  }
  /* $B%\%?%s$N:n@.(B */
  dialog_action_area = GTK_DIALOG(dialog)->action_area;
  gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog_action_area),
			    GTK_BUTTONBOX_END);
  {
    /* $B%-%c%s%;%k%\%?%s(B */
    button = gtk_button_new_from_stock("gtk-cancel");
    gtk_dialog_add_action_widget(GTK_DIALOG(dialog),
				 button, GTK_RESPONSE_CANCEL);
    g_signal_connect(G_OBJECT(button), "clicked",
		     G_CALLBACK(cb_mkfolder_dialog_cancel), dialog);
    GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

    /* OK$B%\%?%s(B */        
    button = gtk_button_new_from_stock("gtk-ok");
    gtk_dialog_add_action_widget(GTK_DIALOG(dialog), button, GTK_RESPONSE_OK);
    g_signal_connect(G_OBJECT(button), "clicked",
		     G_CALLBACK(cb_mkfolder_dialog_ok), dialog);

    GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(button);
  }
  g_object_set_data(G_OBJECT(dialog), "parent", filesel);

  return dialog;
}

/* ************************************************************************* *
 * $B%U%!%$%kA*Br%@%$%"%m%0$N%0%m!<%P%k4X?t(B
 * ************************************************************************* */
void
gnome_custom_file_selection_set_folder (GnomeCustomFileSel	*filesel,
					const gchar		*folder) {
  gchar	*realpath  = NULL;
  gchar	*utf8_path = NULL;
  
  if (!folder) return;

  realpath = g_get_absolute_path(folder);
  utf8_path = g_filename_to_utf8(realpath, -1, NULL, NULL, NULL);
  if (utf8_path) {
    gtk_dir_tree_view_set_dir(GTK_DIR_TREE_VIEW(filesel->folder_tree),
			      utf8_path);
    gtk_entry_set_text(GTK_ENTRY(filesel->folder_entry), utf8_path);
    folder_combo_prepend(filesel, utf8_path);
    gnome_file_list_create_list(GNOME_FILE_LIST(filesel->file_list),
				utf8_path, FALSE);
  }
  g_free(realpath);
  g_free(utf8_path);
}

/* ************************************************************************* */
gchar*
gnome_custom_file_selection_get_filename (GnomeCustomFileSel	*filesel) {
  gchar		*path, *fullpath;
  
  path = gnome_file_list_get_path(GNOME_FILE_LIST(filesel->file_list));
#if 0
  fullpath = g_build_filename(path, filesel->selected_file, NULL);
#else
  fullpath = g_build_filename(path,
			      gtk_entry_get_text
			      (GTK_ENTRY(filesel->file_entry)), NULL);
#endif
  return g_locale_from_utf8(fullpath, -1, NULL, NULL, NULL);
}

/* *************************************** End of gnome-custom-filesel.c *** */
