/* *************************************************** gnome-file-list.c *** *
 * եꥹȥå
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/04/02 02:47:43 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <gtk/gtk.h>
#include <gnome.h>
#include "gnome-vfs-extension.h"
#include "gnome-file-list.h"
#include "gnome-file-icons.h"
#include "glib-fileutil-extension.h"
#include "gnome-file-list-default-icons.h"

/* եؿ **************************************** */
static void	gnome_file_list_class_init (GnomeFileListClass	*klass);
static void	gnome_file_list_init	   (GnomeFileList 	*filelist);
static gint	sort_list 		   (gpointer		a,
					    gpointer		b);
static gint	gnome_file_list_add_type   (GnomeFileList	*filelist);

/* Хѿ ********************************************************** */
static GnomeIconListClass	*parent_class	= NULL;
static const GdkPixbuf		*slink		= NULL;

static GnomeFileListType	default_types[] = {
  {"*.cpp",	GNOME_FILE_LIST_C},
  {"*.c",	GNOME_FILE_LIST_C},
  {"*.o",	GNOME_FILE_LIST_O},  
  {"*.h",	GNOME_FILE_LIST_H},
  {"*.java",	GNOME_FILE_LIST_JAVA},
  {"*.mp3",	GNOME_FILE_LIST_MP3},
  {"*.wav",	GNOME_FILE_LIST_WAV},
  {"*.ogg",	GNOME_FILE_LIST_OGG},  
  {"*.ps",	GNOME_FILE_LIST_PS},
  {"*.pdf",	GNOME_FILE_LIST_PDF},
  {"*.doc",	GNOME_FILE_LIST_FILE},
  {"Makefile",	GNOME_FILE_LIST_MAKE},  
  {"*.xpm",	GNOME_FILE_LIST_XPM},
  {"*.jpg",	GNOME_FILE_LIST_JPEG},
  {"*.jpeg",	GNOME_FILE_LIST_JPEG},
  {"*.gif",	GNOME_FILE_LIST_GIF},
  {"*.teo",	GNOME_FILE_LIST_TEO},
  {"*.tif",	GNOME_FILE_LIST_TIFF},
  {"*.tiff",	GNOME_FILE_LIST_TIFF},
  {"*.png",	GNOME_FILE_LIST_PNG},
  {"*.gz",	GNOME_FILE_LIST_GZ},  
  {"*.bz2",	GNOME_FILE_LIST_BZ2},
  {"*.tar",	GNOME_FILE_LIST_TAR},
  {"*.tar.bz2",	GNOME_FILE_LIST_TAR},
  {"*.tar.gz",	GNOME_FILE_LIST_TAR},
  {"*.tgz",	GNOME_FILE_LIST_TAR},
  {"*.rpm",	GNOME_FILE_LIST_RPM},
  {"*.htm",	GNOME_FILE_LIST_HTML},
  {"*.html",	GNOME_FILE_LIST_HTML},
  {"*.php",	GNOME_FILE_LIST_PHP},  
  {"*.mpeg",	GNOME_FILE_LIST_MPEG},
  {"*.mpeg1",	GNOME_FILE_LIST_MPEG},
  {"*.mpeg2",	GNOME_FILE_LIST_MPEG},
  {"*.mpg",	GNOME_FILE_LIST_MPEG},
  {"*.mpg1",	GNOME_FILE_LIST_MPEG},
  {"*.mpg2",	GNOME_FILE_LIST_MPEG},
  {"*.avi",	GNOME_FILE_LIST_AVI},
  {"*.wmv",	GNOME_FILE_LIST_WMV},
  {NULL, 	0},
};

static const gchar	*mime_filename[] = {
  "mime-folder",
  "mime-text",
  "mime-application-ps",
  "mime-application-pdf",
  "mime-application-tex",
  "mime-application-html",
  "mime-application-php",  
  "mime-text-c",
  "mime-text-o",
  "mime-text-h",
  "mime-text-makefile",
  "mime-text-java",
  "mime-application-binary",
  "mime-image-bmp",
  "mime-image-gif",
  "mime-image-jpeg",
  "mime-image-png",
  "mime-image-pnm",
  "mime-image-svg",
  "mime-image-teo",
  "mime-image-tiff",
  "mime-image-xpm",  
  "mime-application-bz2",
  "mime-application-gz",
  "mime-application-rpm",
  "mime-application-tar",    
  "mime-audio-mp3",
  "mime-audio-ogg",
  "mime-audio-wav",
  "mime-video-avi",
  "mime-video-mpeg",
  "mime-video-wmv"
};

#ifdef HAVE_FNMATCH_H
#include <fnmatch.h>
#else
/* ************************************************************************* */
static int
fnmatch (const char	*pattern,
	 const char	*s,
	 int		m) {
  int slen = strlen (s);
  int plen = strlen (pattern);

  if (strstr (pattern, "*.*")) {
    return 0;
  } else if (*pattern == '*') {
    return ((strstr (s, pattern+1) == s + slen - (plen - 1)) ? 0 : 1);
  } else if ('*' == pattern[plen]) {
    return ((0 == strncmp (s, pattern, plen - 1)) ? 0 : 1);
  } else if (NULL == strstr (pattern, "*") && NULL == strstr (pattern, "?")) {
    return ((0 == strcmp (s, pattern)) ? 0 : 1);
  } else {
    g_print ("fnmatch(%s,%s,%d) ???\n", pattern, s, m);
    return 0;
  }
}
#endif

/* ׼ؿ ********************************************************** */
GType
gnome_file_list_get_type (void) {
  static GType	filelist_type = 0;

  if (!filelist_type) {
    static const GTypeInfo filelist_info = {
      sizeof (GnomeFileListClass),
      NULL,
      NULL,
      (GClassInitFunc) gnome_file_list_class_init,
      NULL,
      NULL,
      sizeof (GnomeFileList),
      0,
      (GInstanceInitFunc) gnome_file_list_init,
      NULL
    };
    filelist_type
      = g_type_register_static (GNOME_TYPE_ICON_LIST,
				"GnomeFileList", &filelist_info, 0);
  }
  return filelist_type;
}

/* 饹ؿ ******************************************************** */
static void
gnome_file_list_class_init (GnomeFileListClass	*klass) {
  GtkWidgetClass	*widget_class;

  widget_class = (GtkWidgetClass *) klass;
  parent_class = gtk_type_class(GNOME_TYPE_FILE_LIST);
}

/* åȽؿ ************************************************** */
static void
gnome_file_list_init (GnomeFileList	*filelist) {
  GnomeFileListType	*types;

  filelist->path	 = NULL;
  filelist->filter	 = NULL;  
  filelist->show_folder  = TRUE;
  filelist->show_hidden  = FALSE;
  filelist->ntypes = 0;

  types = default_types;
  while (types->extension) {
    gnome_file_list_add_type_filter(filelist, types->type, types->extension);
    types++;
  }
}

/* ȴؿ ************************************************************** */
static gint
sort_list (gpointer	a,
	   gpointer	b) {
  GnomeFileListItem 	*filea;
  GnomeFileListItem 	*fileb;
  gint 			compare_value;

  filea = (GnomeFileListItem *) a;
  fileb = (GnomeFileListItem *) b;

  compare_value = filea->type - fileb->type;
  if (compare_value == 0) {
    compare_value = strcmp (filea->filename, fileb->filename);
  }
  return compare_value;
}

/* ե륿βϴؿ ****************************************************** */
static void
parse_filter(GnomeFileList	*filelist,
	     const gchar	*filter_string) {
  GList	*list;
  gchar	*ptr;
  gchar	*dst_ptr;
  gchar	buff[256];

  /* Ťե륿κ */
  if (filelist->filter) {
    for (list = filelist->filter; list; list = g_list_next(list)) {
      g_free (list->data);
    }
    g_list_free(filelist->filter);
    filelist->filter = NULL;
  }
  /* ڤʸ,򥹥åפ */
  ptr = (gchar *) filter_string;
  while ((*ptr == '|' || *ptr == ' ') && *ptr != '\0') ptr++;

  if (strcmp(ptr, "") == 0) return;

  /* ե륿Ф */
  dst_ptr = buff;
  while (*ptr != '\0') {
    if (*ptr == '|' && *(ptr+1) != '\0') {
      while ((*ptr == '|' || *ptr == ' ') && *ptr != '\0') ptr++;
      if (*ptr != '\0') {
	*dst_ptr = '\0';
	filelist->filter = g_list_append(filelist->filter, g_strdup (buff));
	dst_ptr = buff;
      }
    } else {
      *dst_ptr++ = *ptr++;
    }
  }
  *dst_ptr = '\0';
  filelist->filter = g_list_append(filelist->filter, g_strdup (buff));
}

/* ************************************************************************* *
 * եꥹȤκ
 * ************************************************************************* */
GtkWidget*
gnome_file_list_new (const gchar	*path,
		     guint		icon_width,
		     GtkAdjustment	*adj,
		     GtkSelectionMode	mode,
		     int		flags) {
  GnomeFileList		*filelist;
  GtkWidget		*widget;
    
  /* եꥹ */
  widget = gtk_widget_new (gnome_file_list_get_type(), NULL);
  filelist = GNOME_FILE_LIST(widget);

  gnome_file_list_add_type(filelist);
  
  gnome_icon_list_construct(GNOME_ICON_LIST(filelist),
			    icon_width, adj, flags);
  if (path) {
    filelist->path = g_strdup(path);
  } else {
    filelist->path = g_strdup("/");
  }
  filelist->sort_mode = mode;
  
  return widget;
}

/* ************************************************************************* *
 * եꥹȤκ
 * ************************************************************************* */
GtkWidget*
gnome_file_list_new_from_file (const gchar	*path,
			       const gchar	*icon_folder,	
			       guint		icon_width,
			       GtkAdjustment	*adj,
			       GtkSelectionMode	mode,
			       int		flags) {
  GnomeFileList		*filelist;
  GtkWidget		*widget;
    
  /* եꥹ */
  widget = gtk_widget_new (gnome_file_list_get_type(), NULL);
  filelist = GNOME_FILE_LIST(widget);

  gnome_file_list_add_type_from_file(filelist, icon_folder);
  
  gnome_icon_list_construct(GNOME_ICON_LIST(filelist),
			    icon_width, adj, flags);
  if (path) {
    filelist->path = g_strdup(path);
  } else {
    filelist->path = g_strdup("/");
  }
  filelist->sort_mode = mode;
  
  return widget;
}

/* κ ********************************************************** */
static gint
gnome_file_list_add_type (GnomeFileList	*filelist) {
  GdkPixbuf	*pixbuf;
  int		n;

  for (n = 0; n < sizeof(mime_filename) / sizeof(mime_filename[0]); n++) {
    pixbuf = gdk_pixbuf_new_from_inline(-1, mime_filename[n], FALSE, NULL);
    filelist->pixmaps = g_list_append(filelist->pixmaps, pixbuf);
    filelist->ntypes++;
  }
  return filelist->ntypes - 1;
}

/* κ ********************************************************** */
gint
gnome_file_list_add_type_from_file (GnomeFileList	*filelist,
				    const gchar	*mime_icon_folder) {
  GdkPixbuf	*pixbuf;
  gchar		*filename;
  int		n;

  for (n = 0; n < sizeof(mime_filename) / sizeof(mime_filename[0]); n++) {
    filename = g_strconcat(mime_icon_folder, G_DIR_SEPARATOR_S,
				mime_filename[n], ".png", NULL);
    pixbuf = gdk_pixbuf_new_from_file(filename, NULL);
    filelist->pixmaps = g_list_append(filelist->pixmaps, pixbuf);
    filelist->ntypes++;
    g_free(filename);
  }
  return filelist->ntypes - 1;
}

/* ե륿פ **************************************************** */
void
gnome_file_list_add_type_filter (GnomeFileList	*filelist,
				 gint 		type,
				 const gchar 	*filter) {
  GnomeFileListType	*type_item;

  type_item = g_new0(GnomeFileListType, 1);
  type_item->type = type;
  type_item->extension = g_strdup(filter);

  filelist->types = g_list_append(filelist->types, type_item);
}

/* եꥹȤκ **************************************************** */
gboolean
gnome_file_list_create_list (GnomeFileList	*filelist,
			     const gchar 	*path,
			     gboolean		reload_flag) {
  GnomeIconList 	*iconlist;
  GnomeFileListItem 	*file_item;
  GnomeFileListType 	*file_type;
  GList			*dir_list = NULL, *files = NULL;
  GList			*types, *list, *filter_list;
  GdkPixbuf		*pixbuf;
  gchar			*realpath, *filename, *file, *locale_name;
  gint			nicons;
  gboolean 		show_file;
  gboolean 		stat_subdirs = TRUE;
  struct stat		fileinfo, linkinfo;
  gint			type, n;

  /* ꥹȥåȤμ */
  iconlist = GNOME_ICON_LIST (filelist);

  /* 󥯥κ */
  if (!slink) slink = gdk_pixbuf_new_from_inline(-1, slink_pixbuf, FALSE, NULL);

  /* Хѥμ */
  realpath = g_get_absolute_path(path);

  /* ߤΥѥʤ鲿⤷ʤ */
  if (strcmp(realpath, filelist->path) == 0 && !reload_flag) return FALSE;

  /* եꥹȤμ */
  dir_list = gnome_vfs_ext_ls_dir(realpath);  

  /* ߤΥѥι */
  if (filelist->path) g_free(filelist->path);
  filelist->path = g_strdup(realpath);

  /* ꥹȤι */
  gnome_icon_list_freeze(iconlist);
  
  nicons = gnome_icon_list_get_num_icons(iconlist);
  for (n = 0; n < nicons; n++) {
    file_item = (GnomeFileListItem *)
      gnome_icon_list_get_icon_data(iconlist, n);
    g_free(file_item->filename);
  }
  gnome_icon_list_clear (iconlist);

  gdk_threads_enter();

  for (files = NULL, list = dir_list; list; list = g_list_next(list)) {
    file = ((GnomeVFSFileInfo *) list->data)->name;
    filename = g_build_filename(realpath, file, NULL);
    show_file = TRUE;
    if (stat_subdirs) {
      if (stat(filename, &fileinfo) == 0) {
	if (S_ISDIR (fileinfo.st_mode)) {
	  type = GNOME_FILE_LIST_FOLDER;
	} else {
	  type = GNOME_FILE_LIST_FILE;
	  if (fileinfo.st_mode & 0111) type = GNOME_FILE_LIST_EXEC;
	}
      } else {
	continue;
      }
    } else {
      type = GNOME_FILE_LIST_FOLDER;
    }
    if (filelist->show_folder && type == GNOME_FILE_LIST_FOLDER) {
      show_file = TRUE;
    }
    if (file[0] == '.') {
      show_file = (filelist->show_hidden == TRUE) ? TRUE : FALSE;
      if (filelist->show_folder &&
	  (strcmp(file, ".") == 0 || strcmp(file, "..") == 0)) {
	show_file = TRUE;
      }
    }
    if (strcmp(filename, "/.") == 0 || strcmp(filename, "/..") == 0) {
      show_file = FALSE;
    }
    if (!filelist->show_folder && type == GNOME_FILE_LIST_FOLDER) {
      show_file = FALSE;
    }
    if (g_list_length(filelist->filter) != 0) {
      show_file = FALSE;
      for (filter_list = filelist->filter; filter_list;
	   filter_list = g_list_next(filter_list)) {
	if (filter_list->data &&
	    fnmatch ((gchar *) filter_list->data, file, (1 << 4)) == 0) {
	  show_file = TRUE;
	  break;
	}
      }
    }
    if (show_file) {
      file_item = (GnomeFileListItem *) g_new0(GnomeFileListItem, 1);
      file_item->filename = g_strdup(file);
      file_item->type      = type;
      file_item->is_link   = FALSE;
      if (stat_subdirs) {
	if (lstat(filename, &linkinfo) != 0) {
	  g_warning("Can not resolve link: %s", filename);
	}
	if (S_ISLNK(linkinfo.st_mode)) file_item->is_link = TRUE;
      }
      files = g_list_append(files, file_item);
    }
    g_free (filename);
  }
  /* Υ */
  for (list = files; list; list = g_list_next(list)) {
    file_item = (GnomeFileListItem *) list->data;
    type      = file_item->type;
    types     = filelist->types;
    while (types) {
      file_type = (GnomeFileListType *) types->data;
      if (fnmatch ((gchar *) file_type->extension, file_item->filename,
		   (1 << 4)) == 0) {
	type = file_type->type; 
	break;
      }
      types = types->next;
    }
    file_item->type = type;
  }
  files = g_list_sort(files, (GCompareFunc) sort_list);

  for (list = files; list; list = g_list_next(list)) {
    file_item = (GnomeFileListItem *) list->data;
    locale_name = g_strdup(file_item->filename);
    g_free(file_item->filename);
    file_item->filename = g_filename_to_utf8(locale_name, 
					      -1, NULL, NULL, NULL);
    pixbuf
      = gdk_pixbuf_copy(g_list_nth_data(filelist->pixmaps, file_item->type));

    if (file_item->is_link) {
      gdk_pixbuf_copy_area(slink,
			   0, 0,
			   gdk_pixbuf_get_width (slink),
			   gdk_pixbuf_get_height(slink),
			   pixbuf,
			   gdk_pixbuf_get_width (pixbuf)-7,
			   gdk_pixbuf_get_height(pixbuf)-7);
    }
    n = gnome_icon_list_append_pixbuf (iconlist, pixbuf, locale_name,
				       file_item->filename);
    gnome_icon_list_set_icon_data(iconlist, n, file_item);
    g_free(locale_name);
  }
  gdk_threads_leave();

  gnome_icon_list_thaw(iconlist);
  gnome_vfs_file_info_list_free(dir_list);  
  g_list_free(files);

  return TRUE;
}

/* ߤΥե֤ؿ ************************************************ */
gchar*
gnome_file_list_get_path (GnomeFileList	*filelist) {
  return filelist->path;
}

/* 򤵤ƤեΥե̾Ĵ٤ؿ ************************** */
gchar*
gnome_file_list_get_filename (GnomeFileList	*filelist) {
  GnomeFileListItem	*item;
  GList			*list;
  
  list = gnome_icon_list_get_selection(GNOME_ICON_LIST(filelist));
  if (list) {
    item = (GnomeFileListItem *)
      gnome_icon_list_get_icon_data(GNOME_ICON_LIST(filelist),
				    (gint) list->data);
    if (item) return item->filename;
  }
  return NULL;
}

/* 򤵤ƤեμĴ٤ؿ ******************************** */
gint
gnome_file_list_get_filetype (GnomeFileList	*filelist) {
  GnomeFileListItem	*item;
  GList			*list;
  
  list = gnome_icon_list_get_selection(GNOME_ICON_LIST(filelist));
  if (list) {
    item = (GnomeFileListItem *)
      gnome_icon_list_get_icon_data(GNOME_ICON_LIST(filelist),
				    (gint) list->data);
    if (item) return item->type;
  }
  return -1;
}

/* ե륿ؿ ****************************************************** */
void
gnome_file_list_set_filter (GnomeFileList	*filelist,
			    const gchar		*filter_string) {
  parse_filter(filelist, filter_string);
  gnome_file_list_create_list(filelist, filelist->path, TRUE);
}

/* եɽ/ɽꤹؿ ***************************** */
void
gnome_file_list_set_show_folder (GnomeFileList	*filelist,
				 gboolean	show_folder) {
  filelist->show_folder = show_folder;
}

/* եɽ/ɽꤹؿ ********************************* */
void
gnome_file_list_set_show_hidden (GnomeFileList	*filelist,
				 gboolean	show_hidden) {
  filelist->show_hidden = show_hidden;
}

/* եɽ/ɽ֤ؿ *************************** */
gboolean
gnome_file_list_get_show_folder (GnomeFileList	*filelist) {
  return filelist->show_folder;
}

/* եɽ/ɽ֤ؿ ******************************* */
gboolean
gnome_file_list_get_show_hidden (GnomeFileList	*filelist) {
  return filelist->show_hidden;
}

/* ******************************************** End of gnome-file-list.c *** */
