/* ******************************************************** image_info.c *** *
 * $B2hA|>pJs$rI=<($9$k%@%$%"%m%0(B
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/27 18:10:14 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include <teo.h>
#include "memory_icon.icon"

/* $B2hA|>pJs%@%$%"%m%0$N%/%m!<%:(B ******************************************** */
static void
info_dialog_close (GtkWidget	*widget,
		   gpointer	*data) {
  gtk_widget_hide(widget);
}

/* $B2hA|>pJs%@%$%"%m%0$N%/%m!<%:(B ******************************************** */
static void
cb_close (GtkWidget	*widget,
	  gpointer	*data) {
  gtk_widget_hide(GTK_WIDGET(data));
}

/* $B2hA|>pJs%@%$%"%m%0$N@8@.(B ************************************************ */
GtkWidget*
info_dialog_new (void) {
  GtkWidget	*dialog;
  GtkWidget	*dialog_action_area;
  GtkWidget	*vbox, *vbox1;
  GtkWidget	*hbox;
  GtkWidget	*frame;
  GtkWidget	*label[8];
  GtkWidget	*widget;
  GtkWidget	*icon;
  gint		n = 0;
  
  /* $B%&%#%s%I%&$N@8@.(B */
  dialog = gtk_dialog_new ();
  gtk_window_set_title    (GTK_WINDOW (dialog), _("Image Info Dialog"));
  gtk_window_set_resizable(GTK_WINDOW (dialog), FALSE);
  gtk_widget_realize(dialog);
  gtk_window_set_icon(GTK_WINDOW(dialog), teoeyes_icon);
  gdk_window_set_icon_name(dialog->window, _("Image Info Dialog"));
  g_signal_connect(G_OBJECT(dialog),
		   "destroy", G_CALLBACK(info_dialog_close), NULL);

  /* $B%Q%C%-%s%0%\%C%/%9$N@8@.(B */
  vbox = GTK_DIALOG (dialog)->vbox;
  {
    /* $B%U%l!<%`$N@8@.(B */
    frame = gtk_frame_new(NULL);
    gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
    {
      vbox1 = gtk_vbox_new(FALSE, 5);
      gtk_container_border_width(GTK_CONTAINER(vbox1), 10);
      gtk_container_add(GTK_CONTAINER(frame), vbox1);
      {
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 3);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	{
	  /* $B%"%$%3%s$N@8@.(B */
	  icon = gtk_image_new_from_pixbuf(teoeyes_icon);
	  gtk_box_pack_start(GTK_BOX (hbox), icon, TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(icon), 0.0, 0.5);

	  /* $B%i%Y%k(B ($B%U%!%$%kL>(B) */
	  label[n] = gtk_label_new("");
	  gtk_box_pack_start(GTK_BOX (hbox), label[n], TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(label[n]), 0.0, 0.5);
	  n++;
	}
	widget = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox1), widget, FALSE, TRUE, 0);

	hbox = gtk_hbox_new(TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 3);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	{
	  /* $B%i%Y%k(B ($B%U%!%$%k%5%$%:(B) */
	  widget = gtk_label_new(_("File Size"));
	  gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(widget), 0.0, 0.5);

	  label[n] = gtk_label_new("");
	  gtk_box_pack_start(GTK_BOX(hbox), label[n], TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(label[n]), 0.0, 0.5);
	  n++;
	}
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 3);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	{
	  /* $B%i%Y%k(B ($B99?7F|(B) */
	  widget = gtk_label_new(_("Update"));
	  gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(widget), 0.0, 0.5);

	  label[n] = gtk_label_new("");
	  gtk_box_pack_start(GTK_BOX(hbox), label[n], TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(label[n]), 0.0, 0.5);
	  n++;
	}
	widget = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox1), widget, FALSE, TRUE, 0);

	hbox = gtk_hbox_new(TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 3);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	{
	  /* $B%i%Y%k(B ($B%U%)!<%^%C%H(B) */
	  widget = gtk_label_new(_("Format"));
	  gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(widget), 0.0, 0.5);

	  label[n] = gtk_label_new("");
	  gtk_box_pack_start(GTK_BOX(hbox), label[n], TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(label[n]), 0.0, 0.5);
	  n++;
	}
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 3);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	{
	  /* $B%i%Y%k(B ($B2hA|$NBg$-$5(B) */
	  widget = gtk_label_new(_("Image Size"));
	  gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(widget), 0.0, 0.5);

	  label[n] = gtk_label_new("");
	  gtk_box_pack_start(GTK_BOX(hbox), label[n], TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(label[n]), 0.0, 0.5);
	  n++;
	}
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 3);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	{
	  /* $B%i%Y%k(B ($B2hAGCM$N%l%s%8(B) */
	  widget = gtk_label_new(_("Pixel Range"));
	  gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(widget), 0.0, 0.5);

	  label[n] = gtk_label_new("");
	  gtk_box_pack_start(GTK_BOX(hbox), label[n], TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(label[n]), 0.0, 0.5);
	  n++;
	}
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 3);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	{
	  /* $B%i%Y%k(B ($B%U%l!<%`?t(B) */
	  widget = gtk_label_new(_("Frame"));
	  gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(widget), 0.0, 0.5);

	  label[n] = gtk_label_new("");
	  gtk_box_pack_start(GTK_BOX(hbox), label[n], TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(label[n]), 0.0, 0.5);
	  n++;
	}
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_container_border_width(GTK_CONTAINER(hbox), 3);
	gtk_box_pack_start(GTK_BOX(vbox1), hbox, FALSE, FALSE, 0);
	{
	  /* $B%i%Y%k(B ($B%W%l!<%s?t(B) */
	  widget = gtk_label_new(_("Channel"));
	  gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(widget), 0.0, 0.5);

	  label[n] = gtk_label_new("");
	  gtk_box_pack_start(GTK_BOX(hbox), label[n], TRUE, TRUE, 0);
	  gtk_misc_set_alignment(GTK_MISC(label[n]), 0.0, 0.5);
	}
      }
    }
    dialog_action_area = GTK_DIALOG(dialog)->action_area;
    gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog_action_area),
			      GTK_BUTTONBOX_END);
    {
      widget = gtk_button_new_from_stock(GTK_STOCK_CLOSE);
      g_signal_connect(G_OBJECT(widget),
		       "clicked", G_CALLBACK(cb_close), dialog);
      gtk_dialog_add_action_widget(GTK_DIALOG(dialog),
				   widget, GTK_RESPONSE_CLOSE);
      GTK_WIDGET_SET_FLAGS(widget, GTK_CAN_DEFAULT);
      gtk_widget_grab_default(widget);      
    }
  }
  /* $B%&%#%8%'%C%H$NEPO?(B */
  G_SET_OBJECT(dialog, "icon",   icon);
  G_SET_OBJECT(dialog, "label0", label[0]);
  G_SET_OBJECT(dialog, "label1", label[1]);
  G_SET_OBJECT(dialog, "label2", label[2]);
  G_SET_OBJECT(dialog, "label3", label[3]);
  G_SET_OBJECT(dialog, "label4", label[4]);
  G_SET_OBJECT(dialog, "label5", label[5]);
  G_SET_OBJECT(dialog, "label6", label[6]);
  G_SET_OBJECT(dialog, "label7", label[7]);
  
  return dialog;
}

/* $B2hA|>pJs$N%;%C%H(B ******************************************************** */
void
info_dialog_set_info (GtkWidget	*dialog,
		      GList	*list) {
  static GdkPixbuf	*pixbuf = NULL;
  TeoeyesImageModule	*loader;
  GnomeVFSFileInfo	*info;
  GtkWidget		*label[10];
  GtkWidget		*icon;
  gchar			buf[1024], *time_str;
  gint			n = 0;
  gint			nchannels;
  gint			channel;
  gdouble		min, max;

  /* $B%m!<%@$N<hF@(B */
  loader = ti_get_loader(list);
  
  /* $B%"%$%3%s$N%;%C%H(B */
  icon = G_GET_WIDGET(dialog, "icon");
  if (ti_get_location(list) != GNOME_VFS_FILE_MEMORY) {  
    gtk_image_set_from_pixbuf (GTK_IMAGE (icon), loader->icon);
  } else {
    if (!pixbuf) {
      pixbuf = gdk_pixbuf_new_from_inline(-1, memory_icon, FALSE, NULL);
    }
    gtk_image_set_from_pixbuf (GTK_IMAGE(icon), pixbuf);
  }
  /* $B%i%Y%k%&%#%8%'%C%H$N<hF@(B */
  label[0] = G_GET_WIDGET (dialog, "label0");
  label[1] = G_GET_WIDGET (dialog, "label1");
  label[2] = G_GET_WIDGET (dialog, "label2");
  label[3] = G_GET_WIDGET (dialog, "label3");
  label[4] = G_GET_WIDGET (dialog, "label4");
  label[5] = G_GET_WIDGET (dialog, "label5");
  label[6] = G_GET_WIDGET (dialog, "label6");
  label[7] = G_GET_WIDGET (dialog, "label7");

  /* $B%U%!%$%k>pJs$N<hF@(B */
  info = gnome_vfs_file_info_new();
  gnome_vfs_get_file_info(ti_get_uri(list),
			  info, GNOME_VFS_FILE_INFO_GET_MIME_TYPE);
  
  /* $B%U%!%$%kL>$N%;%C%H(B */
  gtk_label_set(GTK_LABEL(label[n++]), info->name);

  /* $B%U%!%$%k%5%$%:$N%;%C%H(B */
  if (ti_get_location(list) != GNOME_VFS_FILE_MEMORY) {
    sprintf(buf, "%u %s", (unsigned int) info->size, _("Bytes"));
  } else {
    sprintf(buf, "%s", _("Unknown"));
  }
  gtk_label_set (GTK_LABEL(label[n++]), buf);

  /* $B%U%!%$%k$N99?7F|$N%;%C%H(B */
  if (ti_get_location (list) != GNOME_VFS_FILE_MEMORY) {
    time_str = ctime(&(info->ctime));
    time_str[strlen(time_str)-1] = '\0';
    gtk_label_set (GTK_LABEL(label[n++]), g_strdup(time_str));
  } else {
    gtk_label_set (GTK_LABEL(label[n++]), _("Unknown"));
  }
  /* $B%U%!%$%k%U%)!<%^%C%H$N%;%C%H(B */
  if (ti_get_location(list) != GNOME_VFS_FILE_MEMORY) {
    if (strcmp(loader->module_name, "TEO") != 0) {
      sprintf(buf, "%s", loader->module_name);
    } else {
      switch (ti_get_type(list)) {
      case TI_PIXEL_UNSIGNED:
	sprintf(buf, "%s (%s%d)", loader->module_name, "U", ti_get_bit(list));
	break;
      case TI_PIXEL_SIGNED:
	sprintf(buf, "%s (%s%d)", loader->module_name, "S", ti_get_bit(list));
	break;
      case TI_PIXEL_FLOAT:
	sprintf(buf, "%s (%s%d)", loader->module_name, "F", ti_get_bit(list));
	break;
      }
    }
  } else {
    sprintf(buf, "%s", _("Unknown"));    
  }
  gtk_label_set(GTK_LABEL (label[n++]), buf);

  /* $B2hA|%5%$%:$N%;%C%H(B */
  sprintf(buf, "%dx%d (%d:%d, %d:%d)", 
	  ti_get_width  (list),
	  ti_get_height (list),
	  ti_get_xoffset(list),
	  ti_get_xoffset(list) + ti_get_width(list) - 1,
	  ti_get_yoffset(list),
	  ti_get_yoffset(list) + ti_get_height(list) - 1);
  gtk_label_set(GTK_LABEL(label[n++]), buf);

  /* $B2hAGCM$N%l%s%8$N%;%C%H(B */
  if (ti_get_min(list) == -1 && ti_get_max(list) == -1) {
    ti_get_pixel_range (list, &min, &max);
    ti_set_min(list, min);
    ti_set_max(list, max);
  }
  if (!ti_get_original_list(list) || 
      (ti_get_original_list(list) && ti_get_type(list) != TI_PIXEL_FLOAT)) {
    sprintf (buf, "[%ld: %ld]",
	     (long) ti_get_min(list), (long) ti_get_max(list));
  } else {
    sprintf (buf, "[%.8e: %.8e]", ti_get_min(list), ti_get_max(list));
  }
  gtk_label_set(GTK_LABEL(label[n++]), buf);
  
  /* $B%U%l!<%`?t$N%;%C%H(B */
  sprintf(buf, "%d / %d",
	  ti_get_frame (list) + 1,
	   (!ti_get_fp (list)) ? 1 : ti_get_nframes (list));
  gtk_label_set (GTK_LABEL (label[n++]), buf);

  /* $B%W%l!<%s?t$N%;%C%H(B */
  nchannels = ti_get_nchannels(list);
  channel   = ti_get_channel(list);
  if (channel == -1) {
    sprintf(buf, "%d", nchannels);
  } else {
    sprintf(buf, "%d / %d", channel + 1, nchannels);
  }
  gtk_label_set(GTK_LABEL(label[n++]), buf);
}

/* ************************************************* End of image_info.c *** */
