/* ******************************************************* list_window.c *** *
 * ꥹȥӥ塼
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/07/12 13:45:37 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include <teo.h>
#include "list_window.h"
#include "menu_callbacks.h"

#define	ICON_WIDTH	160
#define	ICON_HEIGHT	120
#define	STOCK_ICON_DIR	"stock"

/* ץȥ ******************************************************** */
static void	cb_destroy		(GtkWidget	*widget,
					 gpointer	data);
static void	cb_mouse_press 		(GtkWidget	*widget,
					 GdkEventButton	*event,
					 gpointer	data);
static void	cb_remove_image 	(GtkWidget	*widget,
					 gpointer	data);

static void	lv_remove_image 	(void);


/* ************************************************************************* *
 * Хåؿ
 * ************************************************************************* */

/* ************************************************************************* */
static void
cb_destroy (GtkWidget	*widget,
	    gpointer	data) {
  gtk_widget_destroy (list_window);
  list_window = NULL;
}

/* ޥåΥ٥ ********************************************** */
static void
cb_mouse_press (GtkWidget	*widget,
		GdkEventButton	*event,
		gpointer	data) {
  GtkWidget	*ebox = NULL;
  GtkWidget	*icon_box;
  gchar		*label;  
  
  /* 򤵤Ƥ̾ */
  label = (gchar *) G_GET_PARAMETER (list_window, "selected_filename");

  /*  */
  if (label) {
    ebox = GTK_WIDGET(G_GET_OBJECT(list_window, label));
    if (ebox) {
      icon_box = GTK_WIDGET(G_GET_OBJECT(ebox, "icon_box"));
      if (icon_box) {
	gtk_frame_set_shadow_type(GTK_FRAME(icon_box), GTK_SHADOW_NONE);
      }
      G_SET_PARAMETER(list_window, "selected_filename", NULL);
    }
  }
  /*  */
  if (widget != ebox) {
    icon_box = GTK_WIDGET(G_GET_OBJECT(widget, "icon_box"));
    if (icon_box) {
      gtk_frame_set_shadow_type(GTK_FRAME(icon_box), GTK_SHADOW_ETCHED_OUT);
    }
    /* 򤵤줿̾Ͽ */
    label = (gchar *) G_GET_PARAMETER (widget, "uri");
    G_SET_PARAMETER(list_window, "selected_filename", label);
  }
  /* ֥륯åΥ٥ */
  if (event->type == GDK_2BUTTON_PRESS) {
    label = (gchar *) G_GET_PARAMETER(widget, "uri");
    if (label) {
      image_list = ti_get_list_from_uri(image_list, label);
      teoeyes_image_load(ti_get_image(image_list), image_loader, 0,
			 option->create_pixmap);
      gtk_window_set_title(GTK_WINDOW(image_window),
			   ti_get_filename(image_list));
      image_window_set_size(image_window,
			    ti_get_width(image_list),
			    ti_get_height(image_list));
    }
  }
}

/* ************************************************************************* */
static void
cb_remove_image (GtkWidget	*widget,
		 gpointer	data) {
  lv_remove_image ();
}

/* ************************************************************************* *
 * ꥹȥӥ塼ؿ
 *
 * lv_add_image
 * lv_remove_image
 * lv_component_toolbar_new
 * list_window_new 
 * ************************************************************************* */

/* ************************************************************************* */
static GtkWidget*
lv_icon_new (GList	*list) {
  GtkWidget	*icon;
  GdkPixbuf	*pixbuf = NULL, *thumbnail;
  gint		ow, oh, tw, th;

  /* ǡμ */
  if (!ti_get_pixbuf(list)) {
    pixbuf = teoeyes_image_load_pixbuf_simple(image_loader, ti_get_uri(list));
  } else {
    pixbuf = ti_get_pixbuf(list);
  }
  /* ꥸʥǡ礭 */
  ow = gdk_pixbuf_get_width (pixbuf);
  oh = gdk_pixbuf_get_height(pixbuf);

  /* ͥǡ礭 */  
  if (ow <= ICON_WIDTH && oh <= ICON_HEIGHT) {
    tw = ow;
    th = oh;
  } else if (ow > ICON_WIDTH && oh > ICON_HEIGHT) {
    if (ow > oh) {
      tw = ICON_WIDTH;
      th = tw * oh / ow;
    } else {
      th = ICON_HEIGHT;
      tw = th * ow / oh;
    }
  } else if (ow > ICON_WIDTH) {
    tw = ICON_WIDTH;
    th = tw * oh / ow;
  } else if (oh > ICON_HEIGHT) {
    th = ICON_HEIGHT;
    tw = th * ow / oh;    
  }
  /* ͥǡ */    
  thumbnail = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, tw, th);
  gdk_pixbuf_composite_color (pixbuf, thumbnail, 0, 0, tw, th, 0, 0,
			      (double) tw / ow, (double) th / oh,
			      GDK_INTERP_TILES,
			      255, 0, 0, 16, 0xaaaaaa, 0x555555);
  icon = gtk_image_new_from_pixbuf (thumbnail);

  if (!ti_get_pixbuf(list)) gdk_pixbuf_unref(pixbuf);
  gdk_pixbuf_unref(thumbnail);

  return icon;
}
		 
/* ************************************************************************* */
static void
lv_remove_image (void) {
  GList		*this = NULL;
  GList		*prev = NULL;
  GList		*next = NULL;
  gchar		*uri;

  /* 򤵤Ƥ̾ */
  uri = (gchar *) G_GET_PARAMETER(list_window, "selected_filename");
  if (!uri) return;

  /* ꥹȤγ */
  this = ti_get_list_from_uri(image_list, uri);
  if (!this) return;
  prev = g_list_previous (this);
  next = g_list_next     (this);

  /* ˲ʤϺʤ */
  if (!prev && !next) return;

  /* ߤΥꥹȤκ */
  if (prev) prev->next = next;
  if (next) next->prev = prev;

  /* ǡβ */
  teoeyes_image_free(this->data);

  /* ɽ */
  if (this == image_list) {
    image_list = (next) ? next : prev;
    if (!ti_get_pixbuf(image_list)) {
      teoeyes_image_load(ti_get_image(image_list), image_loader, 0,
			 option->create_pixmap);
    }
    /* ɥѹ */
    image_window_set_size(image_window,
			  ti_get_width(image_list), ti_get_height(image_list));
  }
  /* ͥι */
  list_window_refresh_list(list_window);

  /*  */
  G_SET_PARAMETER(GTK_OBJECT(list_window), "selected_filename", NULL);
}

/* ************************************************************************* */
static void
lv_add_image (GtkWidget	*window,
	      GtkWidget	*box) {
  GList		*list;
  GtkWidget	*icon_box = NULL;
  GtkWidget	*ebox;
  GtkWidget	*icon;
  
  for (list = g_list_first(image_list); list; list = g_list_next(list)) {
    icon_box = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(icon_box), GTK_SHADOW_NONE);
    gtk_container_set_border_width(GTK_CONTAINER(icon_box), 2);
    gtk_widget_show(icon_box);
    {
      ebox = gtk_event_box_new();
      gtk_widget_set_events(ebox, GDK_BUTTON_PRESS_MASK);
      g_signal_connect(G_OBJECT(ebox), "button_press_event",
		       G_CALLBACK(cb_mouse_press), NULL);
      gtk_container_add (GTK_CONTAINER(icon_box), ebox);
      gtk_widget_show(ebox);
      
      G_SET_OBJECT(window, g_strdup(ti_get_uri(list)), ebox);
      G_SET_OBJECT(icon_box, "ebox", ebox);
      G_SET_OBJECT(ebox, "icon_box", icon_box);
      G_SET_PARAMETER(ebox, "uri", g_strdup(ti_get_uri(list)));
      {
	icon = lv_icon_new(list);
	gtk_container_add(GTK_CONTAINER(ebox), icon);
	gtk_widget_show(icon);
      }
    }
    gtk_box_pack_start(GTK_BOX(box), icon_box, FALSE, FALSE, 5);
  }
}

/* ġСݡͥȤ ****************************************** */
static GtkWidget*
lv_component_toolbar_new (void) {
  GtkWidget	*handlebox;
  GtkWidget	*toolbar;
  GtkWidget	*icon;
  GdkPixbuf	*pixbuf;
  char		*name;
  
  /* ϥɥܥå */
  handlebox = gtk_handle_box_new ();

  /* ġС */
  toolbar = gtk_toolbar_new ();
  gtk_container_add (GTK_CONTAINER (handlebox), toolbar);
  {
    /* Ĥץܥ */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, close_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "close.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Close"), 
				_("Close Image List Viewer"),
				_("Close Image List Viewer"),
				icon,
				G_CALLBACK (cb_destroy),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* ֤Ȣץܥ */
#if 0	
    pixbuf = gdk_pixbuf_new_from_inline (-1, trash_icon, FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "trash.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Trash"), 
				_("Delete a selected image from the list"),
				_("Delete a selected image from the list"),
				icon,
				G_CALLBACK (cb_remove_image),
				NULL);    
    gdk_pixbuf_unref (pixbuf);

    /* Ƭץܥ */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, leftarrow2_blue_icon,
					 FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "2leftarrow_blue.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("First Image"), 
				_("Show the first image in the list"),
				_("Show the first image in the list"),
				icon,
				G_CALLBACK (cb_image_top),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* ץܥ */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, leftarrow1_blue_icon,
					 FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "1leftarrow_blue.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Previous Image"), 
				_("Show the previous image in the list"),
				_("Show the previous image in the list"),
				icon,
				G_CALLBACK (cb_image_prev),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* ּץܥ */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, rightarrow1_blue_icon,
					 FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "1rightarrow_blue.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Next Image"), 
				_("Show the next image in the list"),
				_("Show the next image in the list"),
				icon,
				G_CALLBACK (cb_image_next),
				NULL);
    gdk_pixbuf_unref (pixbuf);

    /* ץܥ */
#if 0
    pixbuf = gdk_pixbuf_new_from_inline (-1, rightarrow2_blue_icon,
					 FALSE, NULL);
#else
    name = g_build_filename(tc->icon_folder,
			    STOCK_ICON_DIR, "2rightarrow_blue.png", NULL);
    pixbuf = gdk_pixbuf_new_from_file (name, NULL);
    g_free(name);
#endif
    icon = gtk_image_new_from_pixbuf (pixbuf);
    gtk_toolbar_append_element (GTK_TOOLBAR (toolbar),
				GTK_TOOLBAR_CHILD_BUTTON,
				NULL,				  
				_("Last Image"), 
				_("Show the last image in the list"),
				_("Show the last image in the list"),
				icon,
				G_CALLBACK (cb_image_bottom),
				NULL);
    gdk_pixbuf_unref (pixbuf);
  }
  return handlebox;
}

/* ꥹȥӥ塼 ************************************************ */
GtkWidget*
list_window_new (void) {
  GtkWidget	*window;
  GtkWidget	*box;
  GtkWidget	*handlebox;
  GtkWidget	*separator;
  GtkWidget	*scrolled_window;

  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), _("Teoeyes Image List Viewer"));
  gtk_window_set_resizable (GTK_WINDOW (window), TRUE);
  gtk_window_set_icon (GTK_WINDOW (window), teoeyes_icon);
  g_signal_connect (G_OBJECT (window),
		    "destroy", G_CALLBACK (cb_destroy), NULL);
  g_signal_connect (G_OBJECT (window),
		    "delete_event", G_CALLBACK (cb_destroy), NULL);

  /* ľܥå */
  box = gtk_vbox_new (FALSE, 0);
  gtk_container_add (GTK_CONTAINER (window), box);
  gtk_widget_show (box);
  {
    /* ġСݡͥȤ */
    handlebox = lv_component_toolbar_new ();
    gtk_box_pack_start (GTK_BOX (box), handlebox, FALSE, FALSE, 0);
    gtk_widget_show_all (handlebox);
    
    /* ѥ졼 */
    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box), separator, FALSE, FALSE, 3);
    gtk_widget_show (separator);
  
    /* 륦ɥ */
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_ALWAYS, GTK_POLICY_NEVER);
    gtk_box_pack_start (GTK_BOX (box), scrolled_window, TRUE, TRUE, 0);
    gtk_widget_show (scrolled_window);
    G_SET_OBJECT(window, "scrolled_window", scrolled_window);    
    {
      /* ʿܥå */
      box = gtk_hbox_new (FALSE, 0);
      G_SET_OBJECT(window, "box", box);
      gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
					     (scrolled_window), box);
      gtk_widget_show (box);
      
      /* ͥɲ */
      lv_add_image (window, box);

      /* 򤵤줿Ͽ (Ϥ̤) */
      G_SET_PARAMETER (window, "selected_image", NULL);
    }	
  }
  return window;
}

/* ͥι ******************************************************** */
void
list_window_refresh_list (GtkWidget	*window) {
  GtkWidget	*box;
  GtkWidget	*scrolled_window;

  box = GTK_WIDGET(G_GET_OBJECT(window, "box"));
  scrolled_window = GTK_WIDGET(G_GET_OBJECT(window, "scrolled_window"));
  gtk_widget_hide (box);
  gtk_widget_destroy (box);
  
  box = gtk_hbox_new (FALSE, 0);
  G_SET_OBJECT(window, "box", box);

  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window),
					box);
  gtk_widget_show_all(box);

  lv_add_image(window, box);					  
}

/* ************************************************ End of list_window.c *** */
