/* ************************************************************** open.c *** *
 * $B2hA|$N%*!<%W%s(B
 *
 * Copyright (C) 2002-2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/06/30 23:57:02 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"
#include "glib-fileutil-extension.h"
#include "gnome-custom-filesel.h"
#include "gnome-file-list.h"
#include "list_window.h"
#include "open.h"

/* $B2hA|$r8=:_$N%&%#%s%I%&$G3+$/(B ******************************************** */
gboolean
teoeyes_open_image_on_same_window (const gchar	*filename) {
  TEImage	*image;
  GList		*list, *previous;
  gchar		*uri;
  
  /* $B4{$K%j%9%H$K4^$^$l$F$$$k>l9g$O$=$N%G!<%?$rI=<((B */
  uri = gnome_vfs_ext_get_uri(filename);
  
  for (list = g_list_first(image_list); list; list = g_list_next(list)) {
    if (strcmp(ti_get_uri(list), uri) == 0) {
      /* $B2hA|$rI=<((B */
      image_list = ti_get_list_from_uri(image_list, uri);
      if (!ti_get_pixbuf(image_list)) {
	teoeyes_image_load(ti_get_image(image_list), image_loader,
			   0, option->create_pixmap);
      }
      image_window_set_size(image_window,
			    ti_get_width(image_list),
			    ti_get_height(image_list));
      return TRUE;
    }
  }
  /* $B?7$7$$2hA|$r%j%9%H$KDI2C(B */
  image = teoeyes_image_new(uri, gnome_vfs_ext_get_location(uri));
  if (image) {
    /* $B2hA|$rI=<($9$k(B */
    previous = image_list;
    image_list = g_list_append(image_list, image);    
    image_list = g_list_last(image_list);
    if (teoeyes_image_load(ti_get_image(image_list), image_loader,
			   0, option->create_pixmap)) {
      image_window_set_size(image_window,
			    ti_get_width(image_list),
			    ti_get_height(image_list));
      if (list_window) list_window_refresh_list(list_window);
    } else {
      image = image_list->data;
      teoeyes_image_free(image);
      g_list_delete_link(image_list, g_list_last(image_list));
      image_list = previous;
    }
  }
  g_free(uri);
  
  return TRUE;
}

/* $B?7$7$$2hA|$rJL$N%&%#%s%I%&$G3+$/(B **************************************** */
gboolean
teoeyes_open_image_on_new_window (const gchar	*filename) {
  int	pid;

  if (filename) {
    if ((pid = fork ()) == 0) {
      if (execlp (PACKAGE, PACKAGE, filename, (char *) 0) == -1) {
	perror (PACKAGE);
	return FALSE;
      }
    }
  } else {
    if ((pid = fork ()) == 0) {
      if (execlp (PACKAGE, PACKAGE, (char *) 0) == -1) {
	perror (PACKAGE);
	return FALSE;
      }
    }
  }
  return TRUE;
}

/* OK$B%\%?%s$,2!$5$l$?;~$N=hM}(B ********************************************** */
static void
cb_dialog_ok (GtkWidget			*widget,
	      GnomeCustomFileSel	*dialog) {
  gchar		*filename, *localename;
  gboolean	flag;
  
  /* $B?7$7$$%&%#%s%I%&$r3+$/$+$I$&$+D4$Y$k(B */
  flag =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON 
				  (gtk_object_get_data (GTK_OBJECT (dialog),
							"checkbutton")));
  /* $B%U%!%$%kL>$r3MF@$9$k(B */
  filename = (gchar *) 
    gnome_custom_file_selection_get_filename (GNOME_CUSTOM_FILESEL(dialog));
  localename = g_filename_from_utf8 (filename, -1, NULL, NULL, NULL);
  if (!localename || strcmp (localename, "") == 0 ||
      !g_file_test(localename, G_FILE_TEST_EXISTS) || g_dir_is(localename)) {
    g_free(localename);
    return;  
  }
  /* $B2hA|$r3+$/(B */
  if (flag) {
    teoeyes_open_image_on_new_window(localename);
  } else {
    teoeyes_open_image_on_same_window(localename);
  }
  g_free(localename);
}

/* Cancel$B%\%?%s$,2!$5$l$?;~$N=hM}(B ****************************************** */
static void 
cb_dialog_cancel (GtkWidget	*widget,
		  GtkWidget	*dialog) {
  gtk_widget_destroy(dialog);
}

/* $B%"%$%3%s$r%@%V%k%/%j%C%/$7$?$H$-$N=hM}(B ********************************** */
static gboolean
cb_select_item (GnomeFileList		*flist,
		GdkEventButton		*ev,
		gpointer		data) {
  if (ev->type == GDK_2BUTTON_PRESS) {
    cb_dialog_ok (NULL, GNOME_CUSTOM_FILESEL(data));
  }
  return FALSE;
}

/* $B%@%$%"%m%0$N%/%m!<%:(B **************************************************** */
static void
open_dialog_destroy (GtkWidget	*widget,
		     gpointer	data) {
  gtk_widget_destroy(widget);
}

/* $B2hA|%*!<%W%s%@%$%"%m%0$N@8@.(B ******************************************** */
GtkWidget*
open_dialog_new (const gchar	*title) {
  GtkWidget	*dialog;
  GtkWidget	*widget;

  /* $B%@%$%"%m%0$N@8@.(B */
  dialog = gnome_custom_file_selection_new (title, tc->icon_folder);
  gtk_window_set_icon (GTK_WINDOW (dialog), teoeyes_icon);
  g_signal_connect (G_OBJECT (dialog),
		    "destroy", G_CALLBACK (open_dialog_destroy), NULL);
  g_signal_connect (G_OBJECT (dialog),
		    "delete_event", G_CALLBACK (open_dialog_destroy), NULL);
  
  /* $B%A%'%C%/%\%?%s$NDI2C(B */
  widget = gtk_check_button_new_with_label (_("Open on a new window"));
  G_SET_OBJECT(dialog, "checkbutton", widget);
  gtk_box_pack_start (GTK_BOX (GNOME_CUSTOM_FILESEL (dialog)->custom_box),
		      widget, FALSE, FALSE, 0);
  /* $B%$%Y%s%H$N@_Dj(B */
  g_signal_connect (G_OBJECT (GNOME_CUSTOM_FILESEL(dialog)->ok_button),
		    "clicked", G_CALLBACK (cb_dialog_ok), dialog);
  g_signal_connect (G_OBJECT (GNOME_CUSTOM_FILESEL (dialog)->cancel_button),
		    "clicked", G_CALLBACK (cb_dialog_cancel), dialog);
  g_signal_connect (G_OBJECT (GNOME_CUSTOM_FILESEL (dialog)->file_list),
		    "button_press_event", G_CALLBACK (cb_select_item), dialog);

  return dialog;
}

/* ******************************************************* End of open.c *** */
