/* ********************************************************* operation.c *** *
 * ˴ؤؿ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <05/04/26 06:31:27 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "teoeyes.h"

/* ǡΥХåå ************************************************ */
void
do_backup (GList	*list) {
  TEImage	*ti;
  
  ti = ti_get_image(list);
  if (ti->backup) gdk_pixbuf_unref(ti->backup);
  ti->backup = gdk_pixbuf_copy(ti->pixbuf);
}

/* ХååץǡΥꥹȥ ******************************************** */
void
restore_backup (GList	*list) {
  TEImage	*ti;
  GdkPixbuf	*work;
  GList		*this;
  
  ti = ti_get_image(list);
  if (ti->backup) {
    work = gdk_pixbuf_copy(ti->pixbuf);

    if (g_list_length(ti_get_pixbuf_list(list)) == 1) {
      this = ti_get_pixbuf_list(list);
    } else {
      this = g_list_nth(ti_get_pixbuf_list(list), ti_get_frame(list));
    }
    gdk_pixbuf_unref(this->data);
    this->data = gdk_pixbuf_copy(ti->backup);
    ti->pixbuf = this->data;    
    ti->width  = gdk_pixbuf_get_width(ti->pixbuf);
    ti->height = gdk_pixbuf_get_height(ti->pixbuf);
    
    gdk_pixbuf_unref (ti->backup);
    ti->backup = gdk_pixbuf_copy (work);
    gdk_pixbuf_unref (work);
  }
}

/* ꥸʥ᤹ **************************************************** */
void
original_image (GList	*list) {
  int frame = ti_get_frame(list);

  teoeyes_image_load(ti_get_image(list), image_loader, frame,
		     option->create_pixmap);
}


/* 쥤 ********************************************************** */
void
grayscale_image (GList	*list) {
  guchar	r, g, b, y;
  gint		has_alpha, row, col;
  
  has_alpha = gdk_pixbuf_get_has_alpha (ti_get_pixbuf (list));
  for (row = 0; row < ti_get_height (list); row++) {
    for (col = 0; col < ti_get_width (list); col++) {
      r = ti_get_pixel (list, col, row, 0);
      g = ti_get_pixel (list, col, row, 1);
      b = ti_get_pixel (list, col, row, 2);
      y = (guchar) (0.299 * r + 0.587 * g + 0.114 * b);
      ti_put_pixel (list, col, row, 0, y);
      ti_put_pixel (list, col, row, 1, y);
      ti_put_pixel (list, col, row, 2, y);
      if (has_alpha) ti_put_pixel (list, col, row, 3, 
				   ti_get_pixel (list, col, row, 3));
    }
  }
}

/* ͤȿž ************************************************************ */
void
reverse_image (GList	*list) {
  gint		has_alpha, row, col;
  
  has_alpha = gdk_pixbuf_get_has_alpha (ti_get_pixbuf (list));
  for (row = 0; row < ti_get_height (list); row++) {
    for (col = 0; col < ti_get_width (list); col++) {
      ti_put_pixel (list,  col, row, 0, 
		    255 - ti_get_pixel (list, col, row, 0));
      ti_put_pixel (list,  col, row, 1, 
		    255 - ti_get_pixel (list, col, row, 1));
      ti_put_pixel (list,  col, row, 2, 
		    255 - ti_get_pixel (list, col, row, 2));
      if (has_alpha) ti_put_pixel (list, col, row, 3, 
				   ti_get_pixel (list, col, row, 3));
    }
  }
}

/* ͤ ********************************************************** */
void
normalize_image (GList		*list,
		 gdouble	min,
		 gdouble	max) {
  gdouble	param, nval;
  gint		has_alpha, row, col, p;

  /* ͤϰϤå */
  if (min == -1 && max == -1) ti_get_pixel_range (list, &min, &max);
  if (min == max) return;

  /* ѿν */
  has_alpha = gdk_pixbuf_get_has_alpha (ti_get_pixbuf (list));
  param	    = max - min;
  if (param == 0) return;

  /*  */
  for (row = 0; row < ti_get_height (list); row++) {
    for (col = 0; col < ti_get_width (list); col++) {
      for (p = 0; p < 3; p++) {
	nval = (ti_get_pixel (list, col, row, p) - min) * 255 / param;
	if (nval < 0)   nval = 0;
	if (nval > 255) nval = 255;
	ti_put_pixel (list,  col, row, p, (guchar) nval);
      }
      if (has_alpha) ti_put_pixel (list, col, row, 3, 
				   ti_get_pixel (list, col, row, 3));
    }
  }
}

/* ************************************************************************* *
 * ʿȿžؿ
 *	
 * 
 *	list : ϲ
 * 
 *	ʤ
 * ************************************************************************* */
void
flip_horizontal (GList	*list) {
  guchar	val1, val2;
  gint		x1, x2, y, p, channel;

  channel = 3 + gdk_pixbuf_get_has_alpha (ti_get_pixbuf (list));

  for (y = 0; y < ti_get_height (list); y++) {
    for (x1 = 0, x2 = ti_get_width (list) - 1;
	 x1 < ti_get_width (list) >> 1; x1++, x2--) {
      for (p = 0; p < channel; p++) {
	val1 = ti_get_pixel (list, x1, y, p);
	val2 = ti_get_pixel (list, x2, y, p);
	ti_put_pixel (list, x1, y, p, val2);
	ti_put_pixel (list, x2, y, p, val1);
      }
    }
  }
}

/* ************************************************************************* *
 * ľȿžؿ
 *	
 * 
 *	list : ϲ
 * 
 *	ʤ
 * ************************************************************************* */
void
flip_vertical (GList	*list) {
  guchar	*ptr1, *ptr2, r, rr;
  gint		x, y, yy, rowstride, channel;

  rowstride = gdk_pixbuf_get_rowstride (ti_get_pixbuf (list));
  channel   = 3 + gdk_pixbuf_get_has_alpha (ti_get_pixbuf (list));

  for (yy = ti_get_height (list) - 1, y = 0;
       y < ti_get_height (list) >> 1; y++, yy--) {
    ptr1 = gdk_pixbuf_get_pixels (ti_get_pixbuf (list)) + (y  * rowstride);
    ptr2 = gdk_pixbuf_get_pixels (ti_get_pixbuf (list)) + (yy * rowstride);
    for (x = 0; x < ti_get_width (list); x++) {
      r  = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;

      r  = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;

      r  = *ptr1;
      rr = *ptr2;
      *ptr2++ = r;
      *ptr1++ = rr;

      if (channel == 4) {
	r  = *ptr1;
	rr = *ptr2;
	*ptr2++ = r;
	*ptr1++ = rr;
      }
    }
  }
}

/* ΨꤷƲѹ ************************************ */
void
scaling_by_scale (GList		*list,
		  gdouble	xscale,
		  gdouble	yscale) {
  GdkPixbuf	*dest;
  gint		w, h;

  w = xscale * ti_get_width  (list);
  h = xscale * ti_get_height (list);

  dest = gdk_pixbuf_scale_simple (ti_get_pixbuf (list),
				  w, h, GDK_INTERP_BILINEAR);
  modify_pixbuf(list, dest);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
}

/* ΨꤷƲѹ ************************************ */
void
scaling_by_size (GList	*list,
		 gint	width,
		 gint	height) {
  GdkPixbuf	*dest;
  
  dest = gdk_pixbuf_scale_simple (ti_get_pixbuf (list), width, height,
				  GDK_INTERP_BILINEAR);
  modify_pixbuf(list, dest);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
}

/* ************************************************************************* *
 * 90ٲžؿ
 * (gthumb-2.6.0/libgthumb/pixbuf-utils.c)
 *
 * 
 *	list              : ϲ
 *	counter_clockwise : ž, 0 - ײ, 1 - ȿײ
 *
 * 
 *	ʤ
 * ************************************************************************* */
void
rotate_90 (GList	*list,
	   gboolean	counter_clockwise) {
  GdkPixbuf	*dest;
  
  dest = gdk_pixbuf_copy_rotate_90 (ti_get_pixbuf (list), counter_clockwise);
  modify_pixbuf(list, dest);
  if (ti_get_pixmap_list(image_list)) modify_pixmap(image_list);
}

/* ********************************************************* operation.c *** */
