/* *************************************************** property_dialog.c **** *
 * $B@_Dj%@%$%"%m%0$K4X$9$k4X?t(B
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/07/11 20:08:14 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <X11/keysym.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <dlfcn.h>
#include "teoeyes.h"
#include "gnome-custom-filesel.h"
#include "property_dialog.h"
#include "gtkiconbutton.h"
#include "teoeyes_menu.h"
#include "reference_dialog.h"
#include "teoeyes_plugin.h"

#include "config_option.icon"
#include "config_browser.icon"
#include "config_loader.icon"
#include "config_plugin.icon"
#include "config_shortcut.icon"
#include "config_assistant.icon"
#include "config_misc.icon"

/* ************************************************************************* */
#define	DIALOG_WIDTH	560
#define	DIALOG_HEIGHT	520

/* GUI$B:n@.$NJd=u4X?t(B ******************************************************* */
static void		check_button_new	(GtkWidget	*parent,
						 GtkWidget	*box,
						 const gchar	*label,
						 const gchar	*name,
						 gboolean	flag);
static GtkWidget*	ref_entry_box_new	(GtkWidget	*parent,
						 const gchar	*title,
						 const gchar	*name,
						 const gchar	*value);
static GtkWidget*	list_box_new		(GtkWidget	*parent,
						 const gchar	*title,
						 const gchar	*list_title,
						 const gchar	*list_name,
						 const gchar	*entry_name,
						 GSList		*value_list,
						 gboolean      header_visible);
static GtkWidget*	plugin_list_box_new	(GtkWidget	*parent,
						 const gchar	*title,
						 const gchar	*list_title,
						 const gchar	*list_name,
						 const gchar	*entry_name,
						 GSList		*value_list,
						 gboolean      header_visible);

/* $B;2>H%@%$%"%m%0$K4X$9$kJd=u4X?t(B ****************************************** */
static void		cb_reference_entry_dialog(GtkWidget	*widget,
						  GtkEntry	*entry);
static void		cb_reference_list_dialog(GtkWidget	*widget,
						 GtkTreeView	*treeview);

/* $B@_Dj%\%C%/%9$N:n@.4X?t(B ************************************************** */
static GtkWidget*	config_box_option 	(GtkWidget	*parent,
						 TEConfig	*config);
static GtkWidget*	config_box_browser	(GtkWidget	*parent,
						 TEConfig	*config);
static GtkWidget*	config_box_loader	(GtkWidget	*parent,
						 TEConfig	*config);
static GtkWidget*	config_box_plugin	(GtkWidget	*parent,
						 TEConfig	*config);
static GtkWidget*	config_box_shortcut	(GtkWidget	*parent,
						 TEConfig	*config);
static GtkWidget*	config_box_assistant	(GtkWidget	*parent,
						 TEConfig	*config);
static GtkWidget*	config_box_misc		(GtkWidget	*parent,
						 TEConfig	*config);

/* $B%7%g!<%H%+%C%H@_Dj$NJd=u4X?t(B ******************************************** */
static gchar*		grab_shortcut_key 	(guint		*keycode,
						 guint		*state);
static void		modify_shortcut_key 	(GtkTreeView	*treeview,
						 const gchar	*key,
						 const guint	keycode,
						 const guint	state);
static gboolean		cb_shortcut_button_press(GtkWidget	*widget,
						 GdkEventButton	*event,
						 gpointer	data);

/* $B%j%9%H%\%C%/%9$NJd=u4X?t(B ************************************************ */
static void		cb_add_list 		(GtkWidget	*widget,
						 gpointer	data);
static void		cb_delete_list 		(GtkWidget	*widget,
						 gpointer	data);
static GSList*		get_list 		(GtkTreeView	*treeview,
						 gint		column);
static GSList*		get_shortcut_list 	(GtkTreeView	*treeview);

/* $B3HBgN($N@_DjJd=u4X?t(B **************************************************** */
static void		loope_scale_change 	(GtkWidget	*widget,
						 gpointer	data);
static gint		scale_to_index 		(gint		scale);

/* $B%@%$%"%m%0%\%C%/%9$N%3!<%k%P%C%/4X?t(B ************************************ */
static void		cb_ok 			(GtkWidget	*widget,
						 gpointer	data);
static void		cb_apply		(GtkWidget	*widget,
						 gpointer	data);
static void		cb_cancel		(GtkWidget	*widget,
						 gpointer	data);
static void		cb_change_box 		(GtkWidget	*widget,
						 gpointer	data);

/* ************************************************************************* */
static gchar	*prop_default_assistant_skin = "%s/assistant/penguin/skindata";
static gchar	*prop_default_title_image	= "%s/pixmaps/teoeyes.jpg";
static gchar	*prop_default_player_skin	= "%s/player/default/skindata";
static gchar	*prop_default_icon_folder	= "%s/icons/default";
static gint	loope_size = 0;

/* $B%G%U%)%k%H%7%g!<%H%+%C%H@_Dj(B ******************************************** */
static gchar *shortcut_action[] =  {
  N_("New"),  
  N_("Open"),
  N_("Save"),
  N_("Save as"),
  N_("Print"),
  N_("Top Image"),
  N_("Previous Image"),
  N_("Next Image"),
  N_("Bottom Image"),
  N_("Top Frame"),
  N_("Previous Frame"),
  N_("Next Frame"),
  N_("Bottom Frame"),
  N_("Show Plane"),
  N_("Top Plane"),  
  N_("Previous Plane"),
  N_("Next Plane"),
  N_("Bottom Plane"),  
  N_("Double Size"),
  N_("Half Size"),
  N_("Scale Up 10\\%"),
  N_("Scale Down 10\\%"),
  N_("Show Menubar"),
  N_("Undo"),
  N_("Original"),
  N_("Grayscale"),
  N_("Reverse"),
  N_("Normalize"),
  N_("Flip Horizontal"),
  N_("Flip Vertical"),
  N_("Rotate 90"),
  N_("Rotate 270"),  
  N_("Image List Viewer"),
  N_("Image Editor"),
  N_("Image Explorer"),
  N_("Image Player"),
  N_("Assistant"),  
  N_("Image Information"),
  N_("Property"),
  N_("About Teoeyes"),
  N_("Help"),
  N_("Quit")
};

/* $BAu>~;RJ8;zNs(B ************************************************************ */
static char *mod_str[] = {
  "", 
  "<Shift>",		"", "", 
  "<Control>",
  "<Shift><Control>",	"", "",
  "<Alt>", 
  "<Shift><Alt>",	"", "",
  "<Control><Alt>", 
  "<Shift><Control><Alt>"
};

/* $B%k!<%Z$N3HBgN(%a%K%e!<(B ************************************************** */
static GnomeUIInfo loope_uiinfo[] = {
  {
    GNOME_APP_UI_ITEM, N_("x   2"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 2, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x   4"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 4, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x   8"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 8, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x  16"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 16, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x  32"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 32, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x  64"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 64, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  {
    GNOME_APP_UI_ITEM, N_("x 128"),
    NULL,
    (gpointer) loope_scale_change, (gpointer) 128, NULL,
    GNOME_APP_PIXMAP_NONE, NULL,
    0, (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

static GnomeUIInfo loope_menu_uiinfo[] = {
  {
    GNOME_APP_UI_RADIOITEMS, NULL, NULL, loope_uiinfo,
    NULL, NULL, GNOME_APP_PIXMAP_NONE, NULL, 0,
    (GdkModifierType) 0, NULL
  },
  GNOMEUIINFO_END
};

/* ************************************************************************* *
 * GUI$B:n@.$NJd=u4X?t(B
 *
 * check_button_new
 * ref_entry_box_new
 * list_box_new
 * ************************************************************************* */

/* $B%A%'%C%/%\%?%s$N@8@.(B **************************************************** */
static void
check_button_new (GtkWidget	*parent,
		  GtkWidget	*box,
		  const gchar	*label,
		  const gchar	*name,
		  gboolean	flag) {
  GtkWidget	*button;
  
  button = gtk_check_button_new_with_label(label);
  gtk_box_pack_start(GTK_BOX(box), button, FALSE, FALSE, 0);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button), flag);
  G_SET_OBJECT(parent, name, button);
}

/* $B;2>H%\%?%sIU$-$N%(%s%H%j%\%C%/%9$N@8@.(B ********************************** */
static GtkWidget*
ref_entry_box_new (GtkWidget	*parent,
		   const gchar	*title,
		   const gchar	*name,
		   const gchar	*value) {
  GtkWidget	*frame;
  GtkWidget	*hbox;  
  GtkWidget	*entry;
  GtkWidget	*widget;

  /* $B%U%l!<%`$N@8@.(B */
  frame = gtk_frame_new(title);
  {
    hbox = gtk_hbox_new(FALSE, 0);
    gtk_container_border_width(GTK_CONTAINER(hbox), 8);
    gtk_container_add(GTK_CONTAINER(frame), hbox);
    {
      /* $B%(%s%H%j%\%C%/%9$N@8@.(B */
      entry = gtk_entry_new();
      if (value) gtk_entry_set_text(GTK_ENTRY(entry), value);
      gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 3);
      G_SET_OBJECT(parent, name, entry);

      /* $B;2>H%\%?%s$N@8@.(B */
      widget = gtk_button_new_with_mnemonic(_("_Browse..."));
      g_signal_connect(GTK_OBJECT(widget), "clicked",
		       G_CALLBACK(cb_reference_entry_dialog), GTK_ENTRY(entry));
      gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 3);
      G_SET_OBJECT(frame, "button", widget);
      G_SET_PARAMETER(widget, "parent", parent);
    }
  }
  return frame;
}

/* $B%j%9%H%\%C%/%9$N@8@.(B **************************************************** */
static GtkWidget*
list_box_new (GtkWidget		*parent,
	      const gchar	*title,
	      const gchar	*list_title,
	      const gchar	*list_name,
	      const gchar	*entry_name,
	      GSList		*value_list,	      
	      gboolean		header_visible) {
  GtkWidget		*hbox;
  GtkWidget		*vbox;  
  GtkWidget		*frame;
  GtkWidget		*entry;
  GtkWidget		*scrolled_window;
  GtkWidget		*widget;
  GtkWidget		*treeview;
  GtkListStore		*store;
  GtkTreeModel		*model;
  GtkCellRenderer	*renderer;
  GtkTreeViewColumn	*column;
  GtkTreeIter		iter;
  GSList		*list;
  
  frame = gtk_frame_new (title);
  {
    vbox = gtk_vbox_new (FALSE, 3);
    gtk_container_border_width (GTK_CONTAINER (vbox), 8);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
      
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_set_shadow_type
      (GTK_SCROLLED_WINDOW (scrolled_window), GTK_SHADOW_ETCHED_OUT);
    gtk_box_pack_start (GTK_BOX (vbox), scrolled_window, TRUE, TRUE, 0);
    {
      store    = gtk_list_store_new (1, G_TYPE_STRING);
      model    = GTK_TREE_MODEL (store);
      treeview = gtk_tree_view_new_with_model (model);

      gtk_object_set_data (GTK_OBJECT (parent), list_name, treeview);
      gtk_container_add (GTK_CONTAINER (scrolled_window), treeview);
      
      renderer = gtk_cell_renderer_text_new ();
      column   = gtk_tree_view_column_new_with_attributes
	(list_title, renderer, "text", 0, NULL);
      gtk_tree_view_set_headers_visible (GTK_TREE_VIEW (treeview),
					 header_visible);
      gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
	
      for (list = value_list; list; list = g_slist_next (list)) {
	gtk_list_store_append (store, &iter);
	gtk_list_store_set (store, &iter, 0, g_strdup (list->data), -1);
      }
    }
    if (entry_name) {
      /* $B%(%s%H%j%\%C%/%9$N@8@.(B */
      entry = gtk_entry_new ();
      gtk_object_set_data (GTK_OBJECT (parent), entry_name, entry);
      gtk_box_pack_start (GTK_BOX (vbox), entry, FALSE, FALSE, 3);
      
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
      {
	/* $B;2>H%\%?%s$N@8@.(B */
	widget = gtk_button_new_with_mnemonic (_("_Browse..."));
	g_signal_connect (GTK_OBJECT (widget), "clicked",
			  G_CALLBACK (cb_reference_entry_dialog),
			  GTK_ENTRY (entry));
	gtk_widget_set_size_request (widget, 80, -1);	
	gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);

	/* $B:o=|%\%?%s$N@8@.(B */
	widget = gtk_button_new_with_mnemonic (_("_Delete"));
	g_signal_connect (GTK_OBJECT (widget), "clicked",
			  G_CALLBACK (cb_delete_list), treeview);
	gtk_widget_set_size_request (widget, 80, -1);	
	gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	
	/* $BDI2C%\%?%s$N@8@.(B */
	widget = gtk_button_new_with_mnemonic (_("_Add"));
	g_signal_connect (GTK_OBJECT (widget), "clicked",
			  G_CALLBACK (cb_add_list), treeview);
	gtk_widget_set_size_request (widget, 80, -1);
	gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	G_SET_PARAMETER(widget, "entry", entry);
      }
    }
  }
  return frame;
}

/* $B%j%9%H%\%C%/%9$N@8@.(B **************************************************** */
static GtkWidget*
loader_list_box_new (GtkWidget		*parent,
		     const gchar	*title,
		     const gchar	*list_title,
		     const gchar	*list_name,
		     const gchar	*entry_name,
		     GSList		*value_list,	      
		     gboolean		header_visible) {
  GtkWidget		*hbox;
  GtkWidget		*vbox;  
  GtkWidget		*frame;
  GtkWidget		*scrolled_window;
  GtkWidget		*widget;
  GtkWidget		*treeview;
  GtkListStore		*store;
  GtkTreeModel		*model;
  GtkCellRenderer	*renderer;
  GtkTreeViewColumn	*column;
  GtkTreeIter		iter;
  GList			*list;
  TeoeyesImageModule	*module;
  gint			n;
  gchar			*utf8_name[3];
  
  frame = gtk_frame_new (title);
  {
    vbox = gtk_vbox_new (FALSE, 3);
    gtk_container_border_width (GTK_CONTAINER (vbox), 8);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
      
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_set_shadow_type
      (GTK_SCROLLED_WINDOW (scrolled_window), GTK_SHADOW_ETCHED_OUT);
    gtk_box_pack_start (GTK_BOX (vbox), scrolled_window, TRUE, TRUE, 0);
    {
      store = gtk_list_store_new (4,
				  G_TYPE_STRING, G_TYPE_STRING,
				  G_TYPE_STRING, G_TYPE_STRING);
      model    = GTK_TREE_MODEL (store);
      treeview = gtk_tree_view_new_with_model (model);

      gtk_object_set_data (GTK_OBJECT (parent), list_name, treeview);
      gtk_container_add (GTK_CONTAINER (scrolled_window), treeview);
	
      renderer = gtk_cell_renderer_text_new ();
      column   = gtk_tree_view_column_new_with_attributes
	(_("Loader Name"), renderer, "text", 0, NULL);
      gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

      renderer = gtk_cell_renderer_text_new ();
      column   = gtk_tree_view_column_new_with_attributes
	(_("Version"), renderer, "text", 1, NULL);
      gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

      renderer = gtk_cell_renderer_text_new ();
      column   = gtk_tree_view_column_new_with_attributes
	(_("Author"), renderer, "text", 2, NULL);
      gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

      renderer = gtk_cell_renderer_text_new ();
      column   = gtk_tree_view_column_new_with_attributes
	(_("Location"), renderer, "text", 3, NULL);
      gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

      for (list = image_loader, n = 0; list; list = g_list_next(list), n++) {
	module = dlsym(list->data, "module");	
	gtk_list_store_append(store, &iter);
	utf8_name[0] = g_locale_to_utf8 (module->module_name,
					 -1, NULL, NULL, NULL);
	utf8_name[1] = g_locale_to_utf8 (module->version,
					 -1, NULL, NULL, NULL);
	utf8_name[2] = g_locale_to_utf8 (module->author,
					 -1, NULL, NULL, NULL);
	
	gtk_list_store_set (store, &iter,
			    0, (utf8_name[0])
			    ? g_strdup (L_(utf8_name[0]))
			    : g_strdup (L_(module->module_name)),
			    1, (utf8_name[1])
			    ? g_strdup (utf8_name[1])
			    : g_strdup (module->version),
			    2, (utf8_name[2])
			    ? g_strdup (L_(utf8_name[2]))
			    : g_strdup (L_(module->author)),
			    3, (gchar *) g_slist_nth_data(value_list, n),
			    -1);
	g_free (utf8_name[0]);
	g_free (utf8_name[1]);
	g_free (utf8_name[2]);	    
      }
    }
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    {
      /* $B:o=|%\%?%s$N@8@.(B */
      widget = gtk_button_new_with_mnemonic (_("_Delete"));
      g_signal_connect (GTK_OBJECT (widget), "clicked",
			G_CALLBACK (cb_delete_list), treeview);
      gtk_widget_set_size_request (widget, 80, -1);	
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	
      /* $BDI2C%\%?%s$N@8@.(B */
      widget = gtk_button_new_with_mnemonic (_("_Add"));
      g_signal_connect (GTK_OBJECT (widget), "clicked",
			G_CALLBACK (cb_reference_list_dialog), treeview);
      gtk_widget_set_size_request (widget, 80, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
    }
  }
  return frame;
}

/* $B%j%9%H%\%C%/%9$N@8@.(B **************************************************** */
static GtkWidget*
plugin_list_box_new (GtkWidget		*parent,
		     const gchar	*title,
		     const gchar	*list_title,
		     const gchar	*list_name,
		     const gchar	*entry_name,
		     GSList		*value_list,	      
		     gboolean		header_visible) {
  GtkWidget		*hbox;
  GtkWidget		*vbox;  
  GtkWidget		*frame;
  GtkWidget		*scrolled_window;
  GtkWidget		*widget;
  GtkWidget		*treeview;
  GtkListStore		*store;
  GtkTreeModel		*model;
  GtkCellRenderer	*renderer;
  GtkTreeViewColumn	*column;
  GtkTreeIter		iter;
  GList			*list;
  TeoeyesPluginInfo	*pinfo;
  gint			n;
  
  frame = gtk_frame_new (title);
  {
    vbox = gtk_vbox_new (FALSE, 3);
    gtk_container_border_width (GTK_CONTAINER (vbox), 8);
    gtk_container_add (GTK_CONTAINER (frame), vbox);
      
    scrolled_window = gtk_scrolled_window_new (NULL, NULL);
    gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
				    GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);
    gtk_scrolled_window_set_shadow_type
      (GTK_SCROLLED_WINDOW (scrolled_window), GTK_SHADOW_ETCHED_OUT);
    gtk_box_pack_start (GTK_BOX (vbox), scrolled_window, TRUE, TRUE, 0);
    {
      store = gtk_list_store_new (4,
				  G_TYPE_STRING, G_TYPE_STRING,
				  G_TYPE_STRING, G_TYPE_STRING);
      model    = GTK_TREE_MODEL (store);
      treeview = gtk_tree_view_new_with_model (model);

      gtk_object_set_data (GTK_OBJECT (parent), list_name, treeview);
      gtk_container_add (GTK_CONTAINER (scrolled_window), treeview);
	
      renderer = gtk_cell_renderer_text_new ();
      column   = gtk_tree_view_column_new_with_attributes
	(_("Plugin Name"), renderer, "text", 0, NULL);
      gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

      renderer = gtk_cell_renderer_text_new ();
      column   = gtk_tree_view_column_new_with_attributes
	(_("Version"), renderer, "text", 1, NULL);
      gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

      renderer = gtk_cell_renderer_text_new ();
      column   = gtk_tree_view_column_new_with_attributes
	(_("Author"), renderer, "text", 2, NULL);
      gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);

      renderer = gtk_cell_renderer_text_new ();
      column   = gtk_tree_view_column_new_with_attributes
	(_("Location"), renderer, "text", 3, NULL);
      gtk_tree_view_append_column (GTK_TREE_VIEW (treeview), column);
      
      for (list = plugin_list, n = 0; list; list = g_list_next(list), n++) {
	pinfo = dlsym(list->data, "plugin_info");
	gtk_list_store_append(store, &iter);
	gtk_list_store_set(store, &iter,
			   0, L_(pinfo->name),
			   1, pinfo->version,
			   2, L_(pinfo->author),
			   3, (gchar *) g_slist_nth_data(value_list, n),
			   -1);
      }
    }
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    {
      /* $B:o=|%\%?%s$N@8@.(B */
      widget = gtk_button_new_with_mnemonic (_("_Delete"));
      g_signal_connect (GTK_OBJECT (widget), "clicked",
			G_CALLBACK (cb_delete_list), treeview);
      gtk_widget_set_size_request (widget, 80, -1);	
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	
      /* $BDI2C%\%?%s$N@8@.(B */
      widget = gtk_button_new_with_mnemonic (_("_Add"));
      g_signal_connect (GTK_OBJECT (widget), "clicked",
			G_CALLBACK (cb_reference_list_dialog), treeview);
      gtk_widget_set_size_request (widget, 80, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
    }
  }
  return frame;
}

/* ************************************************************************* *
 * $B%U%!%$%kA*Br%@%$%"%m%0$K4X$9$k4X?t(B
 *
 * cb_reference_entry_dialog
 * cb_reference_list_dialog
 * ************************************************************************* */

/* $B;2>H%@%$%"%m%0$N@8@.(B **************************************************** */
static void
cb_reference_entry_dialog (GtkWidget	*widget,
			   GtkEntry	*entry) {
  GtkWidget	*dialog;

  dialog = reference_dialog_set_to_entry_new(_("Reference"),
					     tc->icon_folder, entry);
  gtk_widget_show_all(dialog);
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog),
			       GTK_WINDOW(G_GET_PARAMETER(widget, "parent")));
  gtk_window_set_keep_above(GTK_WINDOW(dialog), TRUE);
}

/* $B;2>H%@%$%"%m%0$N@8@.(B **************************************************** */
static void
cb_reference_list_dialog (GtkWidget	*widget,
			  GtkTreeView	*treeview) {
  GtkWidget	*dialog;

  dialog = reference_dialog_set_to_list_new(_("Reference"),
					    tc->icon_folder, treeview);
  gtk_widget_show_all(dialog);
  gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
  gtk_window_set_transient_for(GTK_WINDOW(dialog),
			       GTK_WINDOW(G_GET_PARAMETER(widget, "parent")));
  gtk_window_set_keep_above(GTK_WINDOW(dialog), TRUE);
}

/* ************************************************************************* *
 * $B@_Dj9`L\%\%C%/%9$N:n@.4X?t(B
 *
 * config_box_option
 * config_box_browser
 * config_box_loader
 * config_box_plugin
 * config_box_shortcut
 * config_box_assistant
 * config_box_misc
 * ************************************************************************* */

/* $B%*%W%7%g%s%\%C%/%9$N@_Dj(B ************************************************ */
static GtkWidget*
config_box_option (GtkWidget	*parent,
		   TEConfig	*config) {
  GtkWidget	*box;
  GtkWidget	*button_box;
  GtkWidget	*frame;

  /* BOX$B$N@8@.(B */
  box = gtk_vbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(box), 5); 

  /* $B%G%U%)%k%H%*%W%7%g%s$N@_Dj(B */
  frame = gtk_frame_new(_("Option"));
  gtk_box_pack_start(GTK_BOX(box), frame, FALSE, FALSE, 3);
  G_SET_OBJECT(box, "frame1", frame);

  /* $B%\%?%s%\%C%/%9$N@8@.(B */
  button_box = gtk_vbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER (button_box), 8);
  gtk_container_add(GTK_CONTAINER(frame), button_box);
  G_SET_OBJECT(box, "button_box1", button_box);
  {
    /* -l $B%*%W%7%g%s(B */
    check_button_new(parent, button_box,
		     _("Store all images in memory when start teoeyes."),
		     "option1", config->option_load_all);
    /* -N $B%*%W%7%g%s(B */
    check_button_new(parent, button_box,
		     _("Normalize the image in the optimal pixel range."),
		     "option2", config->option_normalize);
    /* -P $B%*%W%7%g%s(B */
    check_button_new(parent, button_box,
		     _("Create pixmap data for quickly displying the image."),
		     "option3", config->option_create_pixmap);
  }
  /* $B%G%U%)%k%H%*%W%7%g%s$N@_Dj(B */      
  frame = gtk_frame_new(_("Confirm"));
  gtk_box_pack_start(GTK_BOX (box), frame, FALSE, FALSE, 3);
  G_SET_OBJECT(box, "frame2", frame);

  /* $B%\%?%s%\%C%/%9$N@8@.(B */
  button_box = gtk_vbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(button_box), 8);  
  gtk_container_add(GTK_CONTAINER(frame), button_box);
  G_SET_OBJECT(box, "button_box2", button_box);
  {
    /* $B2hA|$rJ]B8$9$k$H$-$N3NG'(B */
    check_button_new(parent, button_box,
		     _("Confirm Are you sure you want to save."),
		     "confirm1", config->confirm_save);
    /* $B2hA|$r>e=q$-$9$k$H$-$N3NG'(B */
    check_button_new(parent, button_box,
		     _("Confirm Are you sure you want to overwrite."),
		     "confirm2", config->confirm_overwrite);
  }
  return box;
}

/* $B%V%i%&%6%\%C%/%9$N@_Dj(B ************************************************** */
static GtkWidget*
config_box_browser (GtkWidget	*parent,
		    TEConfig	*config) {
  GtkWidget	*box;
  GtkWidget	*hbox;  
  GtkWidget	*frame;
  GtkWidget	*widget;
  GtkObject	*adjustment;

  /* BOX$B$N@8@.(B */
  box = gtk_vbox_new(FALSE, 8);
  gtk_container_border_width(GTK_CONTAINER (box), 5);
  {
    /* $B%U%)%k%@2hA|$N%G!<%?CV>l(B */
    frame = ref_entry_box_new(parent, _("Folder Icon Theme"), "icon_folder",
			      config->icon_folder);
    gtk_box_pack_start(GTK_BOX(box), frame, FALSE, FALSE, 0);

    /* $B%5%`%M%$%k2hA|$N>l=j(B */
    frame = ref_entry_box_new(parent, _("Thumbnail Folder"), "thumbnail_folder",
			      config->thumbnail_folder);
    gtk_box_pack_start(GTK_BOX(box), frame, FALSE, FALSE, 0);
    
    /* $B%5%`%M%$%k2hA|$NBg$-$5(B */    
    frame = gtk_frame_new(_("Thumbnail Size"));
    gtk_box_pack_start(GTK_BOX(box), frame, FALSE, FALSE, 0);
    {
      hbox = gtk_hbox_new(FALSE, 0);
      gtk_container_border_width(GTK_CONTAINER (hbox), 8);      
      gtk_container_add(GTK_CONTAINER(frame), hbox);

      /* $B%5%`%M%$%k2hA|$NI}(B */
      widget = gtk_label_new(_("Width :"));
      gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 3);

      adjustment = gtk_adjustment_new(16, 16, 320, 1, 10, 10);
      widget = gtk_spin_button_new(GTK_ADJUSTMENT(adjustment), 1, 0);
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),
				(gfloat) config->thumbnail_width);
      gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 3);
      G_SET_OBJECT(parent, "thumbnail_width", widget);

      /* $B%5%`%M%$%k2hA|$N9b$5(B */      
      widget = gtk_label_new(_("Height :"));
      gtk_box_pack_start(GTK_BOX(hbox), widget, FALSE, FALSE, 3);

      adjustment = gtk_adjustment_new(16, 16, 320, 1, 10, 10);
      widget = gtk_spin_button_new(GTK_ADJUSTMENT(adjustment), 1, 0);
      gtk_spin_button_set_value(GTK_SPIN_BUTTON(widget),
				(gfloat) config->thumbnail_height);
      gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 3);
      G_SET_OBJECT(parent, "thumbnail_height", widget);
    }
  }
  return box;
}

/* $B%V%i%&%6%\%C%/%9$N@_Dj(B ************************************************** */
static GtkWidget*
config_box_loader (GtkWidget	*parent,
		   TEConfig	*config) {
  GtkWidget		*box;
  GtkWidget		*frame;
  
  /* BOX$B$N@8@.(B */
  box = gtk_vbox_new(FALSE, 8);
  gtk_container_border_width(GTK_CONTAINER (box), 5);
  {
    frame = loader_list_box_new (parent, _("Loader List"),
				 _("Loader List"),
				 "loader_list", NULL,
				 config->loader_list, FALSE);
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 3);
  }
  return box;
}

/* $B%W%i%0%$%s%\%C%/%9$N@_Dj(B *********************************************** */
static GtkWidget*
config_box_plugin (GtkWidget	*parent,
		   TEConfig	*config) {
  GtkWidget		*box;
  GtkWidget		*frame;
  
  /* BOX$B$N@8@.(B */
  box = gtk_vbox_new(FALSE, 8);
  gtk_container_border_width(GTK_CONTAINER (box), 5);
  {
    /* $B%W%i%0%$%s$NCV>l(B */
    frame = plugin_list_box_new (parent, _("Plugin List"),
				 _("Plugin List"),
				 "plugin_list", NULL,
				 config->plugin_list, FALSE);
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 3);
  }
  return box;
}

/* $B%7%g!<%H%+%C%H%\%C%/%9$N@8@.(B ******************************************** */
static GtkWidget*
config_box_shortcut (GtkWidget	*parent,
		     TEConfig	*config) {
  GtkWidget		*box;
  GtkWidget		*frame;
  GtkWidget		*scrollwindow;
  GtkWidget		*widget;
  GtkListStore		*store;
  GtkTreeModel		*model;
  GtkCellRenderer	*renderer;
  GtkTreeViewColumn	*column;
  GtkTreeIter		iter;
  GSList		*list;
  gint			n;
  
  /* BOX$B$N@8@.(B */
  box = gtk_vbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER (box), 5);
  {
    /* $B%7%g!<%H%+%C%H%j%9%H(B */
    frame = gtk_frame_new(_("Shortcut"));
    gtk_box_pack_start(GTK_BOX(box), frame, TRUE, TRUE, 3);
    {
      scrollwindow = gtk_scrolled_window_new(NULL, NULL);
      gtk_container_border_width(GTK_CONTAINER(scrollwindow), 8);      
      gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwindow),
				     GTK_POLICY_AUTOMATIC,
				     GTK_POLICY_AUTOMATIC);
      gtk_scrolled_window_set_shadow_type
	(GTK_SCROLLED_WINDOW(scrollwindow), GTK_SHADOW_ETCHED_OUT);
      gtk_container_add(GTK_CONTAINER(frame), scrollwindow);
      {
	store = gtk_list_store_new (3,
				    G_TYPE_STRING,
				    G_TYPE_STRING,
				    G_TYPE_BOOLEAN);
	model  = GTK_TREE_MODEL(store);
	widget = gtk_tree_view_new_with_model(model);
	g_signal_connect(G_OBJECT(widget), "button_press_event",
			 G_CALLBACK (cb_shortcut_button_press), model);
	gtk_container_add(GTK_CONTAINER(scrollwindow), widget);
	G_SET_OBJECT(parent, "shortcut", widget);
	
	renderer = gtk_cell_renderer_text_new();
	column   = gtk_tree_view_column_new_with_attributes
	  (_("Action"), renderer, "text", 0, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW (widget), column);

	renderer = gtk_cell_renderer_text_new();
	column   = gtk_tree_view_column_new_with_attributes
	  (_("Shortcut"), renderer, "text", 1, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW (widget), column);

	for (list = config->shortcut, n = 0;
	     list; list = g_slist_next(list), n++) {
	  gtk_list_store_append(store, &iter);
	  gtk_list_store_set(store, &iter,
			     0, _(shortcut_action[n]),
			     1, (gchar *) list->data,
			     -1);
	}
      }
    }
  }
  return box;
}

/* $B%"%7%9%?%s%H%\%C%/%9$N@_Dj(B ********************************************** */
static GtkWidget*
config_box_assistant (GtkWidget	*parent,
		      TEConfig	*config) {
  GtkWidget		*box;
  GtkWidget		*frame;
  
  /* BOX$B$N@8@.(B */
  box = gtk_vbox_new (FALSE, 8);
  gtk_container_border_width (GTK_CONTAINER (box), 5);
  {
    /* $B%"%7%9%?%s%H%9%-%s%G!<%?(B */
    frame = ref_entry_box_new(parent, _("Assistant Skin Data"),
			      "assistant_skin", config->assistant_skin);
    gtk_box_pack_start (GTK_BOX (box), frame, FALSE, FALSE, 3);

    /* $B%"%7%9%?%s%H%G!<%?$NCV$->l=j(B */
    frame = list_box_new(parent, _("Assistant Document Folder"),
			 _("Assistant Document Folder"),
			 "assistant_doc_folder_list",
			 "assistant_doc_folder_entry",
			 config->assistant_doc_folders, FALSE);
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 3);
  }
  return box;
}

/* $B$=$NB>$N@_Dj(B ************************************************************ */
static GtkWidget*
config_box_misc (GtkWidget	*parent,
		 TEConfig	*config) {
  GtkWidget		*box;
  GtkWidget		*hbox;
  GtkWidget		*frame;
  GtkWidget		*widget;
  GtkWidget		*option_menu;
  
  /* BOX$B$N@8@.(B */
  box = gtk_vbox_new (FALSE, 8);
  gtk_container_border_width (GTK_CONTAINER (box), 5);
  {
    /* $B%k!<%Z$N3HBgN((B */
    frame = gtk_frame_new (_("Loope"));
    gtk_box_pack_start (GTK_BOX (box), frame, FALSE, FALSE, 3);
    {
      hbox = gtk_hbox_new (FALSE, 3);
      gtk_container_border_width (GTK_CONTAINER (hbox), 8);
      gtk_container_add (GTK_CONTAINER (frame), hbox);
      {
	widget = gtk_label_new (_("Default Loope Scale"));
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);

	option_menu = gtk_option_menu_new ();
	gtk_box_pack_end (GTK_BOX (hbox), option_menu, FALSE, FALSE, 0);
	G_SET_PARAMETER (box, "option_menu", option_menu);
	{
	  widget = gtk_menu_new ();
	  gnome_app_fill_menu (GTK_MENU_SHELL (widget), loope_menu_uiinfo,
			       NULL, FALSE, 0);
	  gtk_option_menu_set_menu (GTK_OPTION_MENU (option_menu), widget);
	  G_SET_PARAMETER(box, "loope_menu", widget);
	}
	gtk_option_menu_set_history (GTK_OPTION_MENU (option_menu),
				     scale_to_index (config->loope_size));
	gtk_check_menu_item_set_active
	  (GTK_CHECK_MENU_ITEM
	   (loope_uiinfo[scale_to_index(config->loope_size)].widget), TRUE);
      }
    }
    /* $B%?%$%H%k2hA|(B */
    frame = ref_entry_box_new (parent, _("Title Image"), "title_image",
			       config->title_image);
    gtk_box_pack_start (GTK_BOX (box), frame, FALSE, FALSE, 3);
    
    /* $B2hA|%W%l!<%d$N%9%-%s%G!<%?(B */
    frame = ref_entry_box_new (parent, _("Image Player Skin"), "player_skin",
			       config->player_skin);
    gtk_box_pack_start (GTK_BOX (box), frame, FALSE, FALSE, 3);    
  }
  return box;
}

/* ************************************************************************* *
 * $B%7%g!<%H%+%C%H$N@_Dj$K4X$9$kJd=u4X?t(B
 *
 * grab_shortcut_key
 * modify_shortcut_key
 * ************************************************************************* */

/* $B%7%g!<%H%+%C%H$N@_Dj(B **************************************************** */
static gchar*
grab_shortcut_key (guint	*keycode,
		   guint	*state) {
  GtkWidget	*window;
  GtkWidget	*label;
  GtkWidget	*frame;
  GtkWidget	*align;
  gchar		*key;
  XEvent	ev;
  
  /* $BF~NO%&%#%s%I%&$N@8@.(B */
  window = gtk_window_new(GTK_WINDOW_POPUP);
  gtk_window_set_policy(GTK_WINDOW(window), 0, 0, 1);
  gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
  {
    /* $B%U%l!<%`$N@8@.(B */
    frame = gtk_frame_new(NULL);
    gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
    align = gtk_alignment_new(0.0, 0.0, 0.0, 0.0);
    gtk_container_set_border_width(GTK_CONTAINER(align), 32);
    {
      /* $B%i%Y%k$N@8@.(B */
      label = gtk_label_new(_("Please press the key on the keyboard\n"
			      "you wish to modify this keyboard-shortcut\n"
			      "to use from now on."));
      gtk_container_add(GTK_CONTAINER(window), frame);
      gtk_container_add(GTK_CONTAINER(frame),  align);
      gtk_container_add(GTK_CONTAINER(align),  label);
    }
  }
  gtk_widget_show_all(window);

  /* $B%-!<F~NO(B */
  while (gtk_events_pending()) gtk_main_iteration();
  gdk_flush();
  while (gtk_events_pending()) gtk_main_iteration();
  gdk_window_set_events(window->window, GDK_KEY_PRESS_MASK);
  *keycode = 0;

  while (*keycode == 0) {
    XSetInputFocus(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(window->window),
		   RevertToPointerRoot, CurrentTime);
    gdk_keyboard_grab(window->window, TRUE, GDK_CURRENT_TIME);
    XWindowEvent(GDK_DISPLAY(), GDK_WINDOW_XWINDOW(window->window),
		 KeyReleaseMask, &ev);
    gdk_keyboard_ungrab(GDK_CURRENT_TIME);
    key = XKeysymToString(XKeycodeToKeysym(GDK_DISPLAY(), ev.xkey.keycode, 0));
    *keycode = XKeycodeToKeysym(GDK_DISPLAY(), ev.xkey.keycode, 1);
    if (*keycode >= 65 && *keycode <= 90) {
      key = XKeysymToString(XKeycodeToKeysym(GDK_DISPLAY(),
					     ev.xkey.keycode, 1));
    }
  }
  /* $B8e;OKv(B */
  gtk_widget_destroy(window);
  *state = ev.xkey.state;

  return g_strdup(key);
}

/* $B%7%g!<%H%+%C%H$N%-!<@_Dj(B ************************************************ */
static void
modify_shortcut_key (GtkTreeView	*treeview,
		     const gchar	*key,
		     const guint	keycode,
		     const guint	state) {
  GtkTreeSelection	*selection;
  GtkTreeModel		*model;
  GtkTreeIter		iter;
  gchar			*old_text, *text, *accelerator;
  gboolean		success;

  selection = gtk_tree_view_get_selection(treeview);
  if (!selection) return;
  success = gtk_tree_selection_get_selected(selection, &model, &iter);

  gtk_tree_model_get(model, &iter, 1, &old_text, -1);
  accelerator = g_strconcat(mod_str[state], key, NULL);
  if (accelerator) {
    gtk_list_store_set(GTK_LIST_STORE(model), &iter, 1, accelerator, -1);
  }
  g_free (accelerator);

  success = gtk_tree_model_get_iter_first(model, &iter);
  while (success) {
    gtk_tree_model_get(model, &iter, 1, &text, -1);
    success = gtk_tree_model_iter_next(model, &iter);
    g_free (text);
  }
}

/* $B%7%g!<%H%+%C%H$NJQ993+;O(B ************************************************ */
static gboolean
cb_shortcut_button_press (GtkWidget		*widget,
			  GdkEventButton	*event,
			  gpointer		data) {
  gchar	*key;
  guint	keycode, state;

  if (event->type == GDK_2BUTTON_PRESS) {
    key = grab_shortcut_key (&keycode, &state);
    state = state & 0xf;
    printf ("%d\n", state);
    modify_shortcut_key (GTK_TREE_VIEW (widget), key, keycode, state);
  }
  return FALSE;
}

/* ************************************************************************* *
 * $B%j%9%H%\%C%/%9$N%j%9%HDI2C(B/$B:o=|$K4X$9$k4X?t(B
 *
 * cb_add_list
 * cb_delete_list
 * ************************************************************************* */

/* $B%j%9%H$NDI2C4X?t(B ******************************************************** */
static void
cb_add_list (GtkWidget	*widget,
	     gpointer	data) {
  GtkEntry		*entry;
  GtkTreeView		*treeview = GTK_TREE_VIEW (data);
  GtkTreeModel		*model;
  GtkTreeIter		iter;

  entry = GTK_ENTRY (G_GET_WIDGET (widget, "entry"));
  model = gtk_tree_view_get_model (treeview);
  if (gtk_entry_get_text (entry) &&
      strcmp (gtk_entry_get_text (entry), "") != 0) {
    gtk_list_store_append (GTK_LIST_STORE (model), &iter);
    gtk_list_store_set (GTK_LIST_STORE (model), &iter, 0,
			g_strdup (gtk_entry_get_text (entry)), -1);
  }
}

/* $B%j%9%H$N:o=|4X?t(B ******************************************************** */
static void
cb_delete_list (GtkWidget	*widget,
		gpointer	data) {
  GtkTreeView		*treeview = GTK_TREE_VIEW (data);
  GtkTreeSelection	*selection;
  GtkTreeModel		*model;
  GtkTreeIter		iter;
  gint			success;
  
  selection = gtk_tree_view_get_selection (treeview);
  if (!selection) return;

  success = gtk_tree_selection_get_selected (selection, &model, &iter);
  if (!success) return;

  gtk_list_store_remove (GTK_LIST_STORE (model), &iter);
}

/* $B%j%9%H%\%C%/%9$+$i%j%9%H$r3MF@(B ****************************************** */
static GSList*
get_list (GtkTreeView	*treeview,
	  gint		column) {
  GSList	*list = NULL;
  GtkTreeModel	*model;
  GtkTreeIter	iter;
  gboolean	success;
  gchar		*list_data;
  
  model   = gtk_tree_view_get_model (treeview);
  success = gtk_tree_model_get_iter_first (model, &iter);
  while (success) {
    gtk_tree_model_get (model, &iter, column, &list_data, -1);
    list    = g_slist_append (list, list_data);
    success = gtk_tree_model_iter_next (model, &iter);
  }
  return list;
}

/* $B%7%g!<%H%+%C%H$N%j%9%H%\%C%/%9$+$i%j%9%H$r3MF@(B ************************** */
static GSList*
get_shortcut_list (GtkTreeView	*treeview) {
  GSList	*list = NULL;
  GtkTreeModel	*model;
  GtkTreeIter	iter;
  gchar		*list_data;
  gboolean	success;
  
  model   = gtk_tree_view_get_model (treeview);
  success = gtk_tree_model_get_iter_first (model, &iter);
  while (success) {
    gtk_tree_model_get (model, &iter, 1, &list_data, -1);
    list = g_slist_append (list, g_strdup (list_data));
    g_free (list_data);
    success = gtk_tree_model_iter_next (model, &iter);    
  }
  return list;
}


/* ************************************************************************* *
 * $B3HBgN($N@_DjJd=u4X?t(B
 *
 * loope_scale_change
 * scale_to_index
 * ************************************************************************* */
 
/* $B3HBgN($NJQ99(B ************************************************************ */
static void
loope_scale_change (GtkWidget		*widget,
		    gpointer		data) {
  loope_size = (gint) data;
}

/* $B3HBgN($+$i%a%K%e!<$N%$%s%G%C%/%9$r5a$a$k(B ******************************** */
static gint
scale_to_index (gint	scale) {
  gint	n = 0;

  while (scale != 2) {
    scale = scale >> 1;
    n++;
  }
  return n;
}

/* ************************************************************************* *
 * $B@_Dj%@%$%"%m%0$K4X$9$k4X?t(B ($B%m!<%+%k4X?t(B)
 *
 * get_list
 * get_shortcut_list
 * ************************************************************************* */

/* ************************************************************************* *
 * $B%@%$%"%m%0$N%\%?%s$KBP$9$k%3!<%k%P%C%/4X?t(B
 *
 * cb_ok
 * cb_apply
 * cb_cancel
 * ************************************************************************* */

/* OK$B%\%?%s$N%3!<%k%P%C%/4X?t(B ********************************************** */
static void
cb_ok (GtkWidget	*widget,
       gpointer		data) {
  cb_apply(widget, data);
  gtk_widget_hide(GTK_WIDGET(data));
  config_dialog = NULL;
}

/* $BE,MQ%\%?%s$N%3!<%k%P%C%/4X?t(B ******************************************** */
static void
cb_apply (GtkWidget	*widget,
	  gpointer	data) {
  GtkWidget	*dialog, *child;
  gchar		buf[1024];
  gchar		*app_path;

  dialog = GTK_WIDGET(data);
  
  /* $B%F%*%"%$%:$N%G!<%?%G%#%l%/%H%j$X$N%Q%9$r@8@.(B */
  app_path = g_build_filename (PACKAGE_DATA_DIR, "teoeyes", NULL);
  
  /* $B%*%W%7%g%s$N@_Dj$N99?7(B */
  child = G_GET_WIDGET (dialog, "option1");
  tc->option_load_all =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));
  child = G_GET_WIDGET (dialog, "option2");
  tc->option_normalize =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));
  child = G_GET_WIDGET (dialog, "option3");
  tc->option_create_pixmap =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));
  
  /* $B3NG'@_Dj$N99?7(B */
  child = G_GET_WIDGET (dialog, "confirm1");
  tc->confirm_save =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));

  child = G_GET_WIDGET (dialog, "confirm2");
  tc->confirm_overwrite =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (child));

  /* $B%V%i%&%6@_Dj$N99?7(B */
  child = G_GET_WIDGET (dialog, "icon_folder");
  if (tc->icon_folder) g_free (tc->icon_folder);
  tc->icon_folder = NULL;
  if (gtk_entry_get_text (GTK_ENTRY (child)) &&
      strcmp (gtk_entry_get_text (GTK_ENTRY (child)), "") != 0) {
    tc->icon_folder = g_strdup (gtk_entry_get_text (GTK_ENTRY (child)));
  } else {
    sprintf (buf, prop_default_icon_folder, app_path);
    tc->icon_folder = g_strdup (buf);
  }
  child = G_GET_WIDGET (dialog, "thumbnail_width");  
  tc->thumbnail_width
    = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (child));
  child = gtk_object_get_data (GTK_OBJECT (dialog), "thumbnail_height");  
  tc->thumbnail_height
    = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (child));

  /* $B2hA|%m!<%@$N@_Dj(B */
  child = G_GET_WIDGET (dialog, "loader_list");
  g_slist_foreach (tc->loader_list, (GFunc) g_free, NULL);
  tc->loader_list = get_list (GTK_TREE_VIEW (child), 3);

  /* $B2hA|%m!<%@$NA*BrJ}K!(B */
  
  /* $B%"%7%9%?%s%H@_Dj$N99?7(B */
  child = G_GET_WIDGET (dialog, "assistant_skin");
  if (tc->assistant_skin) g_free (tc->assistant_skin);
  tc->assistant_skin = NULL;
  if (gtk_entry_get_text (GTK_ENTRY (child)) &&
      strcmp (gtk_entry_get_text (GTK_ENTRY (child)), "") != 0) {
    tc->assistant_skin = g_strdup (gtk_entry_get_text (GTK_ENTRY (child)));
  } else {
    sprintf (buf, prop_default_assistant_skin, app_path);
    tc->assistant_skin = g_strdup (buf);
  }
  child = G_GET_WIDGET (dialog, "assistant_doc_folder_list");
  if (tc->assistant_doc_folders) {
    g_slist_foreach (tc->assistant_doc_folders, (GFunc) g_free, NULL);
  }
  tc->assistant_doc_folders = get_list (GTK_TREE_VIEW (child), 0);
  
  /* $B%W%i%0%$%s%j%9%H(B */
  child = G_GET_WIDGET (dialog, "plugin_list");
  g_slist_foreach (tc->plugin_list, (GFunc) g_free, NULL);
  tc->plugin_list = get_list (GTK_TREE_VIEW (child), 3);

  /* $B%7%g!<%H%+%C%H(B */
  child = G_GET_WIDGET (dialog, "shortcut");
  g_slist_foreach (tc->shortcut, (GFunc) g_free, NULL);
  tc->shortcut = get_shortcut_list (GTK_TREE_VIEW (child));

  /* $B%k!<%Z$N3HBgN((B */
  tc->loope_size = loope_size;

  /* $B%?%$%H%k2hA|(B */
  child = G_GET_WIDGET (dialog, "title_image");
  if (tc->title_image) g_free (tc->title_image);
  tc->title_image = NULL;
  if (gtk_entry_get_text (GTK_ENTRY (child)) ||
      strcmp (gtk_entry_get_text (GTK_ENTRY (child)), "") != 0) {
    tc->title_image = g_strdup (gtk_entry_get_text (GTK_ENTRY (child)));
  } else {
    sprintf (buf, prop_default_title_image, app_path);
    tc->title_image = g_strdup (buf);
  }
  /* $B2hA|%W%l!<%d$N%9%-%s(B */
  child = G_GET_WIDGET (dialog, "player_skin");
  if (tc->player_skin) g_free (tc->player_skin);
  tc->player_skin = NULL;
  if (gtk_entry_get_text (GTK_ENTRY (child)) &&
      strcmp (gtk_entry_get_text (GTK_ENTRY (child)), "") != 0) {
    tc->player_skin = g_strdup (gtk_entry_get_text (GTK_ENTRY (child)));
  } else {
    sprintf (buf, prop_default_player_skin, app_path);
    tc->player_skin = g_strdup (buf);
  }
  config_save (gconf_client);
  g_free (app_path);
}

/* $B%-%c%s%;%k%\%?%s$N%3!<%k%P%C%/4X?t(B ************************************** */
static void
cb_cancel (GtkWidget	*widget,
	   gpointer	data) {
  gtk_widget_destroy(GTK_WIDGET(data));
  config_dialog = NULL;  
}

/* $B@_Dj%\%C%/%9$NI=<(@ZBX$((B ************************************************ */
static void
cb_change_box (GtkWidget	*widget,
	       gpointer		data) {
  GtkWidget	*box;
  static gchar	*box_str[]={"box0","box1","box2","box3","box4","box5","box6"};
  gint		n;
  
  for (n = 0; n < sizeof(box_str) / sizeof(box_str[0]); n++) {
    box = G_GET_WIDGET(config_dialog, box_str[n]);
    gtk_widget_hide(box);
  }
  box = G_GET_WIDGET(config_dialog, box_str[(gint) data]);
  gtk_widget_show_all(box);
}

/* ************************************************************************* *
 * $B@_Dj%@%$%"%m%0$N:n@.(B
 * ************************************************************************* */
GtkWidget*
config_dialog_new (TEConfig	*config) {
  GtkWidget	*dialog;
  GtkWidget	*main_vbox;
  GtkWidget	*dialog_vbox;
  GtkWidget	*dialog_action_area;
  GtkWidget	*hbox, *vbox;
  GtkWidget	*scrollwindow;
  GtkWidget	*viewport;
  GtkWidget	*separator;
  GtkWidget	*button;
  GtkWidget	*config_box[7];
  
  /* $B%@%$%"%m%0$N:n@.(B */
  dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(dialog), _("TeoEyes Property Dialog"));
  gtk_widget_set_size_request(dialog, DIALOG_WIDTH, DIALOG_HEIGHT);
  gtk_widget_realize(dialog);
  gtk_window_set_icon(GTK_WINDOW(dialog), teoeyes_icon);
  gdk_window_set_icon_name(dialog->window, _("TeoEyes Property Dialog"));
#if 0
  g_signal_connect(G_OBJECT(dialog),
		   "destroy", G_CALLBACK(dialog_close_real), NULL);
#endif
  main_vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(main_vbox), 5);
  gtk_widget_show(main_vbox);
  gtk_container_add(GTK_CONTAINER(dialog), main_vbox);

  dialog_vbox = gtk_vbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(main_vbox), dialog_vbox, TRUE, TRUE, 0);
  gtk_widget_show(dialog_vbox);
  
  hbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(dialog_vbox), hbox, TRUE, TRUE, 0);
  gtk_widget_show(hbox);
  
  /* $B9`L\A*Br%\%?%s$N:n@.(B */
  scrollwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwindow),
				 GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
  gtk_box_pack_start(GTK_BOX(hbox), scrollwindow, FALSE, FALSE, 0);
  gtk_widget_show(scrollwindow);
  
  viewport = gtk_viewport_new(NULL, NULL);
  gtk_container_add(GTK_CONTAINER(scrollwindow), viewport);
  gtk_widget_show(viewport);
  
  vbox = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(viewport), vbox);
  gtk_widget_show(vbox);  
  {
    /* $B%*%W%7%g%s(B */
    button = gtk_icon_button_new_from_inline_with_label
      (config_option, _("Option"), GTK_ICON_BUTTON_TEXT_BOTTOM, 2);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (button), "clicked",
		      G_CALLBACK (cb_change_box), (gpointer) 0);
    G_SET_OBJECT(dialog, "button1", button);

    /* $B%5%`%M%$%k%S%e!<%o(B */
    button = gtk_icon_button_new_from_inline_with_label
      (config_browser, _("Thumb. Viewer"), GTK_ICON_BUTTON_TEXT_BOTTOM, 2);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (button), "clicked",
		      G_CALLBACK (cb_change_box), (gpointer) 1);
    G_SET_OBJECT(dialog, "button2", button);

    /* $B2hA|%m!<%@(B */
    button = gtk_icon_button_new_from_inline_with_label
      (config_loader, _("Image Loader"), GTK_ICON_BUTTON_TEXT_BOTTOM, 2);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (button), "clicked",
		      G_CALLBACK (cb_change_box), (gpointer) 2);
    G_SET_OBJECT(dialog, "button3", button);

    /* $B%W%i%0%$%s(B */
    button = gtk_icon_button_new_from_inline_with_label
      (config_plugin, _("Plugin"), GTK_ICON_BUTTON_TEXT_BOTTOM, 2);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (button), "clicked",
		      G_CALLBACK (cb_change_box), (gpointer) 3);
    G_SET_OBJECT(dialog, "button4", button);

    /* $B%7%g!<%H%+%C%H(B */
    button = gtk_icon_button_new_from_inline_with_label
      (config_shortcut, _("Shortcut"), GTK_ICON_BUTTON_TEXT_BOTTOM, 2);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (button), "clicked",
		      G_CALLBACK (cb_change_box), (gpointer) 4);
    G_SET_OBJECT(dialog, "button5", button);

    /* $B%"%7%9%?%s%H(B */
    button = gtk_icon_button_new_from_inline_with_label
      (config_assistant, _("Assistant"), GTK_ICON_BUTTON_TEXT_BOTTOM, 2);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (button), "clicked",
		      G_CALLBACK (cb_change_box), (gpointer) 5);
    G_SET_OBJECT(dialog, "button6", button);

    /* $B$=$NB>(B */
    button = gtk_icon_button_new_from_inline_with_label
      (config_misc, _("Misc"), GTK_ICON_BUTTON_TEXT_BOTTOM, 2);
    gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
    g_signal_connect (G_OBJECT (button), "clicked",
		      G_CALLBACK (cb_change_box), (gpointer) 6);
    G_SET_OBJECT(dialog, "button7", button);
  }
  gtk_widget_show_all(vbox);
  
  /* $B$=$l$>$l$N@_Dj%\%C%/%9$N@8@.(B */
  {
    /* $B%*%W%7%g%s(B */
    config_box[0] = config_box_option(dialog, config);
    gtk_box_pack_start(GTK_BOX (hbox), config_box[0], TRUE, TRUE, 0);
    gtk_widget_show_all(config_box[0]);
    G_SET_OBJECT(dialog, "box0", config_box[0]);

    /* $B%5%`%M%$%k%S%e!<%o(B */
    config_box[1] = config_box_browser(dialog, config);
    gtk_box_pack_start(GTK_BOX (hbox), config_box[1], TRUE, TRUE, 0);
    G_SET_OBJECT(dialog, "box1", config_box[1]);
    
    /* $B2hA|%m!<%@(B */
    config_box[2] = config_box_loader(dialog, config);
    gtk_box_pack_start(GTK_BOX (hbox), config_box[2], TRUE, TRUE, 0);
    G_SET_OBJECT(dialog, "box2", config_box[2]);

    /* $B%W%i%0%$%s(B */
    config_box[3] = config_box_plugin(dialog, config);
    gtk_box_pack_start(GTK_BOX (hbox), config_box[3], TRUE, TRUE, 0);
    G_SET_OBJECT(dialog, "box3", config_box[3]);
    
    /* $B%7%g!<%H%+%C%H(B */
    config_box[4] = config_box_shortcut(dialog, config);
    gtk_box_pack_start(GTK_BOX (hbox), config_box[4], TRUE, TRUE, 0);
    G_SET_OBJECT(dialog, "box4", config_box[4]);

    /* $B%"%7%9%?%s%H(B */
    config_box[5] = config_box_assistant(dialog, config);
    gtk_box_pack_start(GTK_BOX (hbox), config_box[5], TRUE, TRUE, 0);
    G_SET_OBJECT(dialog, "box5", config_box[5]);

    /* $B%"%7%9%?%s%H(B */
    config_box[6] = config_box_misc(dialog, config);
    gtk_box_pack_start(GTK_BOX (hbox), config_box[6], TRUE, TRUE, 0);
    G_SET_OBJECT(dialog, "box6", config_box[6]);
  }
  separator = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(main_vbox), separator, FALSE, FALSE, 0);
  gtk_widget_show(separator);
  
  /* $B%\%?%s$N:n@.(B */
  dialog_action_area = gtk_hbutton_box_new();
  gtk_box_pack_start(GTK_BOX(main_vbox), dialog_action_area, FALSE, FALSE, 0);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(dialog_action_area),
			    GTK_BUTTONBOX_END);
  gtk_widget_show(dialog_action_area);  
  {
    /* $B%-%c%s%;%k%\%?%s(B */
    button = gtk_button_new_from_stock("gtk-cancel");
    gtk_box_pack_start(GTK_BOX(dialog_action_area), button, FALSE, FALSE, 0);
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(cb_cancel),dialog);
    gtk_widget_show(button);
    GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

    /* $BE,MQ%\%?%s(B */    
    button = gtk_button_new_from_stock("gtk-apply");
    gtk_box_pack_start(GTK_BOX(dialog_action_area), button, FALSE, FALSE, 0);
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(cb_apply), dialog);
    gtk_widget_show(button);
    GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);

    /* OK$B%\%?%s(B */        
    button = gtk_button_new_from_stock("gtk-ok");
    gtk_box_pack_start(GTK_BOX(dialog_action_area), button, FALSE, FALSE, 0);
    gtk_widget_show(button);
    g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(cb_ok), dialog);

    GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(button);
  }
  return dialog;
}

/* ******************************************** End of property_dialog.c *** */
