/* ************************************************* reference_dialog.c **** *
 * ȥ˴ؤؿ
 *
 * Copyright (C) 2005 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <05/05/18 21:57:11 sugaya>
 * ************************************************************************* */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <dlfcn.h>
#include "teoeyes.h"
#include "gnome-custom-filesel.h"
#include "teoeyes_plugin.h"

/* ȥΡOKץܥΥХåؿ ************************** */
static void
cb_dialog_ok1 (GtkWidget		*widget,
	       GnomeCustomFileSel	*dialog) {
  GtkEntry	*entry;
  
  entry = GTK_ENTRY(g_object_get_data(G_OBJECT(dialog), "entry"));
  gtk_entry_set_text(entry,
		     gnome_custom_file_selection_get_filename(dialog));
  gtk_widget_destroy(GTK_WIDGET(dialog));
}

/* ȥΡOKץܥΥХåؿ ************************** */
static void
cb_dialog_ok2 (GtkWidget		*widget,
	       GnomeCustomFileSel	*dialog) {
  GtkTreeView		*treeview;
  GtkTreeModel		*model;
  GtkTreeIter		iter;
  GSList		*list;  
  gchar			*name = NULL;
  gboolean		flag = TRUE;
  TeoeyesPluginInfo	*pinfo;
  void			*handle;
  
  treeview = GTK_TREE_VIEW(g_object_get_data(G_OBJECT(dialog), "treeview"));
  model = gtk_tree_view_get_model (treeview);
  name = g_strdup (gnome_custom_file_selection_get_filename(dialog));
  if (name) {
    for (list = tc->plugin_list; list; list = g_slist_next(list)) {
      if (strcmp (list->data, name) == 0) {
	flag = FALSE;
	break;
      }
    }
    if (flag) {
      handle = dlopen(name, RTLD_LAZY);
      if (handle) {
	pinfo = dlsym(handle, "plugin_info");
	gtk_list_store_append (GTK_LIST_STORE(model), &iter);	
	gtk_list_store_set(GTK_LIST_STORE(model), &iter,
			   0, pinfo->name,
			   1, pinfo->version,
			   2, pinfo->author,
			   3, name,
			   -1);
      }
    }
    g_free(name);
  }
  gtk_widget_destroy(GTK_WIDGET(dialog));
}

/* ȥΡOKץܥΥХåؿ ************************** */
static void
cb_dialog_cancel (GtkWidget	*widget,
		  GtkWidget	*dialog) {
  gtk_widget_destroy(dialog);
}

/* ȥ **************************************************** */
GtkWidget*
reference_dialog_set_to_entry_new (const gchar	*title,
				   const gchar	*icon_folder,	
				   GtkEntry	*entry) {
  GtkWidget	*dialog = NULL;

  /*  */
  dialog = gnome_custom_file_selection_new(title, icon_folder);
  
  /* Хåؿ */
  g_object_set_data(G_OBJECT(dialog), "entry", entry);
  g_signal_connect(G_OBJECT(GNOME_CUSTOM_FILESEL(dialog)->ok_button),
		   "clicked", G_CALLBACK(cb_dialog_ok1),
		    GNOME_CUSTOM_FILESEL(dialog));
  g_signal_connect (G_OBJECT(GNOME_CUSTOM_FILESEL(dialog)->cancel_button),
		    "clicked", G_CALLBACK (cb_dialog_cancel),
		    dialog);
  return dialog;
}

/* ȥ **************************************************** */
GtkWidget*
reference_dialog_set_to_list_new (const gchar	*title,
				  const gchar	*icon_folder,	
				  GtkTreeView	*treeview) {
  GtkWidget	*dialog = NULL;

  /*  */
  dialog = gnome_custom_file_selection_new(title, icon_folder);
  
  /* Хåؿ */
  g_object_set_data(G_OBJECT(dialog), "treeview", treeview);
  g_signal_connect(G_OBJECT(GNOME_CUSTOM_FILESEL(dialog)->ok_button),
		   "clicked", G_CALLBACK(cb_dialog_ok2),
		   GNOME_CUSTOM_FILESEL(dialog));
  g_signal_connect (G_OBJECT(GNOME_CUSTOM_FILESEL(dialog)->cancel_button),
		    "clicked", G_CALLBACK (cb_dialog_cancel), dialog);
  return dialog;
}

/* ******************************************* End of reference_dialog.c *** */ 
