//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOANYIMAGE_H_
#define _TEOPP_TEOANYIMAGE_H_
#include <teopp/error.h>
/* $B2hA|Am>N%/%i%9(B */
class TeoAnyImage {
public:
  class Error : public TeoErr {
  public:
    Error();
  };

  TeoAnyImage();
  TeoAnyImage(TEOIMAGE *const img);
  TeoAnyImage(const TeoAnyImage &img);
  TeoAnyImage(int width, int height,
	      int xoffset, int yoffset,
	      int type, int bit, int plane);
  TeoAnyImage(const char *file_name, int num_of_frame=0);
  virtual ~TeoAnyImage();
  
  // libteo $B$H$N8_49@-$N$?$a$K;H$&(B
  operator TEOIMAGE*()const;
  TEOIMAGE *operator->()const;
  TEOIMAGE &operator*()const;

  int Width()const;
  int Height()const;
  int Type()const;
  int Bit()const;
  int Plane()const;
  int Fsize()const;
  
  int Xoffset()const;
  int Yoffset()const;
  int Xstart()const;
  int Xend()const;
  int Ystart()const;
  int Yend()const;
  void *Data()const;
    
  void *Address(int i,int j,int p)const;

  TeoAnyImage &operator=(const TeoAnyImage &image);
  virtual void Write(const char *file_name)const;

protected:
  TEOIMAGE *teoimage;
  int *ref;

  virtual void MakeImage(int width, int height,
			 int xoffset, int yoffset,
			 int type, int bit, int plane);
};
#include <teopp/teoanyimage_inline.h>
#endif
