//-*- Mode: C++ -*-
#ifndef _TEOPP_UTIL_H_
#define _TEOPP_UTIL_H_
// $B2hA|%/%i%9(B
template <class ETYPE>
ETYPE MaxPixel(const TeoImage<ETYPE> &x);
template <class ETYPE>
ETYPE MinPixel(const TeoImage<ETYPE> &x);

template <class ETYPE>
TeoImage<TeoFloat64> Range(const TeoImage<ETYPE> &image,
			   TeoFloat64 smin, TeoFloat64 smax,
			   TeoFloat64 dmin, TeoFloat64 dmax);

template <class ETYPE>
TeoImage<TeoBin> Binarize(const TeoImage<ETYPE> &image,
			  ETYPE threshold);

template <class ETYPE>
TeoImage<TeoFloat64> Convolution(const TeoImage<ETYPE> &image,
				 const TeoImage<TeoFloat64> &mask);

// $B1i;;;R$NDj5A(B
template <class ETYPE>
TeoImage<ETYPE> &operator|=(TeoImage<ETYPE> &x,
			    const TeoImage<ETYPE> &y);
template <class ETYPE>
TeoImage<ETYPE> &operator&=(TeoImage<ETYPE> &x,
			    const TeoImage<ETYPE> &y);

template <class ETYPE>
TeoImage<ETYPE> operator|(const TeoImage<ETYPE> &x,
			  const TeoImage<ETYPE> &y);
template <class ETYPE>
TeoImage<ETYPE> operator&(const TeoImage<ETYPE> &x,
			  const TeoImage<ETYPE> &y);

template <class ETYPE>
TeoAnyImage operator+(const TeoImage<ETYPE> &x,
		      const TeoImage<ETYPE> &y);
template <class ETYPE>
TeoAnyImage operator-(const TeoImage<ETYPE> &x,
		      const TeoImage<ETYPE> &y);
template <class ETYPE>
TeoAnyImage operator+(const TeoImage<ETYPE> &x,
		      ETYPE val);
template <class ETYPE>
TeoAnyImage operator-(const TeoImage<ETYPE> &x,
		      ETYPE val);

template <class ETYPE>
TeoImage<TeoFloat64> operator*(const TeoImage<ETYPE> &image,TeoFloat64 val);
template <class ETYPE>
TeoImage<TeoFloat64> operator/(const TeoImage<ETYPE> &image,TeoFloat64 val);
#endif
