#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include "define.h"
#include "teopp/teoanyimage.h"
#include "teopp/teosequence.h"
#include "teopp/teofile.h"

extern char TEO_ERROR_MESSAGE[];
TeoAnyImage::Error::Error():TeoErr(TEO_ERROR_CODE,TEO_ERROR_MESSAGE,"TeoAnyImage"){}

TeoAnyImage::~TeoAnyImage(){
  if((--(*ref)) == 0){
    if(teoimage != NULL){
      if(TeoFreeImage(teoimage)==0) throw Error();
      teoimage=NULL;
    }
    delete ref;
  }
}

void TeoAnyImage::MakeImage(int w,int h,int x,int y,int t,int b,int p){
  if((--(*ref)) == 0){
    if(teoimage != NULL){
      if(TeoFreeImage(teoimage)==0) throw Error();
      teoimage=NULL;
    }
    delete ref;
  }
  teoimage = TeoAllocImage(w,h,x,y,t,b,p);
  if(teoimage==NULL) throw Error();
  ref = new int;
  *ref = 1;
}

TeoAnyImage &TeoAnyImage::operator=(const TeoAnyImage &img){
  if((--(*ref)) == 0){
    if(teoimage != NULL){
      if(TeoFreeImage(teoimage)==0) throw Error();
      teoimage=NULL;
    }
    delete ref;
  }

  teoimage = img.teoimage;
  ref = img.ref;

  (*ref)++;
  return (*this);
}

TeoAnyImage::TeoAnyImage(const char *fname,int fnum)
  :teoimage(NULL),ref(new int){
  *ref = 1;

  *this = TeoFile(fname).GetImage(fnum);
}

void TeoAnyImage::Write(const char *fname)const{
  TeoFile tf(fname,*this);
  tf << (*this);
}
