//-*- Mode: C++ -*-
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include "define.h"
#include "teopp/teobin.h"
#include "teopp/teoanyimage.h"
#include "teopp/teoimage.h"

#include "teopp/util.h"
template<>
TeoAnyImage operator+(const TeoImage<TeoBin> &x,
		      const TeoImage<TeoBin> &y){
  TeoImage<TeoBin> ret(x);
  char *ptr1=(char*)x.Data();
  char *ptr2=(char*)y.Data();
  char *ptr3=(char*)ret.Data();
  int size=x.Fsize();
  for(int i=0;i<size;i++)
    *(ptr3++) = *(ptr1++) | *(ptr2++);
  return TeoAnyImage(ret);
}

template<>
TeoAnyImage operator-(const TeoImage<TeoBin> &xim,
		      const TeoImage<TeoBin> &yim){
  TeoImage<TeoBin> ret(xim.Width(),xim.Height(),
		       xim.Xoffset(),xim.Yoffset(),xim.Plane());
  for(volatile int y=ret.Ystart();y<=ret.Yend();y++)
    for(volatile int x=ret.Xstart();x<=ret.Xend();x++)
      for(volatile int p=0;p<ret.Plane();p++){
	if( xim(x,y,p) == TeoBin(1) && yim(x,y,p) == TeoBin(0) )
	  ret(x,y,p) = TeoBin(1);
	else xim(x,y,p) = TeoBin(0);
      }
  return TeoAnyImage(ret);
}

template<>
TeoAnyImage operator+(const TeoImage<TeoBin> &x,
		      TeoBin val){
  TeoImage<TeoBin> ret(x.Width(),x.Height(),
		       x.Xoffset(),x.Yoffset(),x.Plane());
  if(val == TeoBin(1)) ret = TeoBin(1);
  else ret = x;
  return TeoAnyImage(ret);
}

template<>
TeoAnyImage operator-(const TeoImage<TeoBin> &x,TeoBin val){
  TeoImage<TeoBin> ret(x.Width(),x.Height(),
		       x.Xoffset(),x.Yoffset(),x.Plane());
  if(val == TeoBin(1)) ret = TeoBin(0);
  else ret = x;
  return TeoAnyImage(ret);
}

template<>
TeoAnyImage operator+(const TeoImage<TeoUint8> &xim,
		      const TeoImage<TeoUint8> &yim){
  TeoImage<TeoUint16> ret(xim.Width(),xim.Height(),
			  xim.Xoffset(),xim.Yoffset(),xim.Plane());
  for(int y=ret.Ystart();y<=ret.Yend();y++)
    for(int x=ret.Xstart();x<=ret.Xend();x++)
      for(int p=0;p<ret.Plane();p++)
	ret(x,y,p) = TeoUint16(xim(x,y,p)) + TeoUint16(yim(x,y,p));
  return TeoAnyImage(ret);
}

template<>
TeoAnyImage operator-(const TeoImage<TeoUint8> &xim,
		      const TeoImage<TeoUint8> &yim){
  TeoImage<TeoSint16> ret(xim.Width(),xim.Height(),
			  xim.Xoffset(),xim.Yoffset(),xim.Plane());
  for(int y=ret.Ystart();y<=ret.Yend();y++)
    for(int x=ret.Xstart();x<=ret.Xend();x++)
      for(int p=0;p<ret.Plane();p++)
	ret(x,y,p) = TeoSint16(xim(x,y,p)) - TeoSint16(yim(x,y,p));
  return TeoAnyImage(ret);
}

template<>
TeoAnyImage operator+(const TeoImage<TeoUint8> &xim,TeoUint8 val){
  TeoImage<TeoUint16> ret(xim.Width(),xim.Height(),
			  xim.Xoffset(),xim.Yoffset(),xim.Plane());
  for(int y=ret.Ystart();y<=ret.Yend();y++)
    for(int x=ret.Xstart();x<=ret.Xend();x++)
      for(int p=0;p<ret.Plane();p++)
	ret(x,y,p) = TeoUint16(xim(x,y,p)) + TeoUint16(val);
  return TeoAnyImage(ret);
}

template<>
TeoAnyImage operator-(const TeoImage<TeoUint8> &xim,TeoUint8 val){
  TeoImage<TeoSint16> ret(xim.Width(),xim.Height(),
			  xim.Xoffset(),xim.Yoffset(),xim.Plane());
  for(int y=ret.Ystart();y<=ret.Yend();y++)
    for(int x=ret.Xstart();x<=ret.Xend();x++)
      for(int p=0;p<ret.Plane();p++)
	ret(x,y,p) = TeoSint16(xim(x,y,p)) - TeoSint16(val);
  return TeoAnyImage(ret);
}
