#ifndef TEO_EXCEPTION_H
#define TEO_EXCEPTION_H
#include <cstring>
#include <exception>
#include <string>
#include <iostream>

extern "C++" {
  class TeoErr : public exception {
    int code;
    string message;
    string name;
  public:
    TeoErr(int c,char *msg,char *n){
      code = c;
      message= string(msg);
      name = string(n);
    }
    ~TeoErr(){}

    virtual void operator()(char *file=NULL,int line=0){
      if(file) TeoErrorBase(file,line);
      else TeoErrorBase((char*)name.c_str(),code);
    }
    int error_code(){return code;}
    const char *what()const throw() {return message.c_str();}
  };
}
#endif
