//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOANYIMAGE_INLINE_H_
#define _TEOPP_TEOANYIMAGE_INLINE_H_
inline TeoAnyImage::TeoAnyImage():teoimage(NULL),ref(new int){
  *ref=1;
}
inline TeoAnyImage::TeoAnyImage(TEOIMAGE *const img)
  :teoimage(img),ref(new int){
  *ref=1;
}
inline TeoAnyImage::TeoAnyImage(const TeoAnyImage &img)
  :teoimage(img.teoimage),ref(img.ref){
  (*ref)++;
}
inline TeoAnyImage::TeoAnyImage(int width, int height,
				int xoffset, int yoffset,
				int type, int bit, int plane)
  :teoimage(NULL),ref(new int){
  (*ref) = 1;
  teoimage = TeoAllocImage(width,height,xoffset,yoffset,
			   type,bit,plane);
  if(teoimage==NULL) throw Error();
}

inline TeoAnyImage::operator TEOIMAGE*()const{return teoimage;}
inline TEOIMAGE *TeoAnyImage::operator->()const{return teoimage;}
inline TEOIMAGE &TeoAnyImage::operator*()const{return *teoimage;}

inline int TeoAnyImage::Width()const{return TeoWidth(teoimage);}
inline int TeoAnyImage::Height()const{return TeoHeight(teoimage);}
inline int TeoAnyImage::Type()const{return TeoType(teoimage);}
inline int TeoAnyImage::Bit()const{return TeoBit(teoimage);}
inline int TeoAnyImage::Plane()const{return TeoPlane(teoimage);}
inline int TeoAnyImage::Fsize()const{return TeoFsize(teoimage);}
  
inline int TeoAnyImage::Xoffset()const{return TeoXoffset(teoimage);}
inline int TeoAnyImage::Yoffset()const{return TeoYoffset(teoimage);}
inline int TeoAnyImage::Xstart()const{return TeoXstart(teoimage);}
inline int TeoAnyImage::Xend()const{return TeoXend(teoimage);}
inline int TeoAnyImage::Ystart()const{return TeoYstart(teoimage);}
inline int TeoAnyImage::Yend()const{return TeoYend(teoimage);}
inline void *TeoAnyImage::Data()const{return TeoData(teoimage);}
    
inline void *TeoAnyImage::Address(int i,int j,int p)const{
  if(Bit() == 1)
    return (void *)
      ((char *)(Data()) +
       (((j - Yoffset())*((Width()-1)/8+1) +
	 ((i - Xoffset())/8))*Plane()) + p);
  else
    return (void *)
      (((char *)(Data()) +
	((((j - Yoffset())*Width() +
	   (i - Xoffset()))*Plane()) + p)*(Bit()/8)));
}
#endif
