//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOFILE_H_
#define _TEOPP_TEOFILE_H_
#include <cstdio>
#include <teopp/error.h>
extern "C++" {
  // TEO $B%U%!%$%k%"%/%;%9%/%i%9(B
  class TeoFile : public TeoSequence {
  public:
    class Error : public TeoErr {
    public:
      Error();
    };

    TeoFile();
    TeoFile(TEOFILE *const file);
    TeoFile(const TeoFile &seq);
    TeoFile(const char *fname);
    TeoFile(const char *fname,
	    int w,int h,int x,int y,
	    int t,int b,int p,int f,
	    int ec=0,const char *const *ev=NULL);
    TeoFile(const char *fname,const TeoFile &seq);
    TeoFile(const char *fname,const TeoAnyImage &img,
	    int fnum=1,int ec=0,const char *const *ev=NULL);
    TeoFile(const char *fname,
	    const TeoAnyImage &img,
	    int ec,
	    const char *const *ev);
    ~TeoFile();

    // libteo $B$H$N8_49@-$N$?$a$K;H$&(B.
    operator TEOFILE*()const;
    TEOFILE *operator->()const;
    TEOFILE &operator*()const;

    TeoFile &operator=(const TeoFile &file);

    TeoAnyImage GetImage(int frame_num=-1);
    void PutImage(const TeoAnyImage &image,int frame_num=-1);

    int Width()const;
    int Height()const;
    int Type()const;
    int Bit()const;
    int Plane()const;
    int Frame()const;
    int Fsize()const;
  
    int Xoffset()const;
    int Yoffset()const;
    int Xstart()const;
    int Xend()const;
    int Ystart()const;
    int Yend()const;
    FILE *Fp()const;

    int Ac_type()const;
    int Current()const;

    int Extc()const;
    char **Extv()const;

    bool CheckFrame()const;
    const char *GetUserExtension(const char *keyword)const;
    bool SetAbsFrame(int fnum=0);
    bool SetRelFrame(int fnum=0);

    void Close();
    void Open(const char *fname);

  protected:
    TEOFILE *teofile;
    int *ref;
  };
} // extern "C++"

#include <teopp/teofile_inline.h>
#endif
