#include <ruby.h>
#include <teo.h>

#include "rbteo.h"

VALUE gFile;

static VALUE file_s_new(int,VALUE*,VALUE);
static VALUE file_s_open(VALUE,VALUE);
static VALUE file_s_create(int,VALUE*,VALUE);
static void  file_free(RBTEOFILE*);


static VALUE file_open(VALUE,VALUE);
static VALUE file_create(int,VALUE*,VALUE);
static VALUE file_close(VALUE);
static VALUE file_closed(VALUE);
static VALUE file_read_ok(VALUE);
static VALUE file_write_ok(VALUE);
static VALUE file_back_ok(VALUE);

static VALUE file_read(VALUE);
static VALUE file_write(VALUE,VALUE);

static VALUE file_width(VALUE);
static VALUE file_height(VALUE);
static VALUE file_xoffset(VALUE);
static VALUE file_yoffset(VALUE);
static VALUE file_xstart(VALUE);
static VALUE file_xend(VALUE);
static VALUE file_ystart(VALUE);
static VALUE file_yend(VALUE);
static VALUE file_type(VALUE);
static VALUE file_bit(VALUE);
static VALUE file_plane(VALUE);
static VALUE file_frame(VALUE);
static VALUE file_fsize(VALUE);
static VALUE file_current(VALUE);
static VALUE file_set_abs_frame(VALUE,VALUE);
static VALUE file_set_rel_frame(VALUE,VALUE);
static VALUE file_check_frame(VALUE);

void
Init_teo_file(){
  gFile = rb_define_class_under(mTEO,"File",rb_cObject);
  rb_define_singleton_method(gFile,"new",file_s_new,-1);
  rb_define_singleton_method(gFile,"open",file_s_open,1);
  rb_define_singleton_method(gFile,"create",file_s_create,-1);

  rb_define_method(gFile,"open",file_open,1);
  rb_define_method(gFile,"create",file_create,-1);
  rb_define_method(gFile,"close",file_close,0);
  rb_define_method(gFile,"closed?",file_closed,0);

  rb_define_method(gFile,"read_frame",file_read,0);
  rb_define_method(gFile,"write_frame",file_write,1);


  rb_define_method(gFile,"width",file_width,0);
  rb_define_method(gFile,"height",file_height,0);
  rb_define_method(gFile,"xoffset",file_xoffset,0);
  rb_define_method(gFile,"yoffset",file_yoffset,0);
  rb_define_method(gFile,"xstart",file_xstart,0);
  rb_define_method(gFile,"xend",file_xend,0);
  rb_define_method(gFile,"ystart",file_ystart,0);
  rb_define_method(gFile,"yend",file_yend,0);
  rb_define_method(gFile,"pixel_type",file_type,0);
  rb_define_method(gFile,"pixel_bit",file_bit,0);
  rb_define_method(gFile,"plane",file_plane,0);
  rb_define_method(gFile,"frame",file_frame,0);
  rb_define_method(gFile,"fsize",file_fsize,0);
  rb_define_method(gFile,"current",file_current,0);
  rb_define_method(gFile,"set_abs_frame",file_set_abs_frame,1);
  rb_define_method(gFile,"current=",file_set_abs_frame,1);
  rb_define_method(gFile,"set_rel_frame",file_set_rel_frame,1);
  rb_define_method(gFile,"add_current",file_set_rel_frame,1);
  rb_define_method(gFile,"check_frame",file_check_frame,0);
}


static VALUE
file_s_new(int argc, VALUE *argv, VALUE file_class){
  if(argc>1) return file_create(argc,argv,file_class);
  else if(argc == 1){
    VALUE filename;
    rb_scan_args(argc,argv,"1",&filename);
    return file_open(file_class,filename);
  } else {
    RBTEOFILE *file;
    VALUE obj;
    obj = Data_Make_Struct(file_class, RBTEOFILE, 0, file_free, file);
    file->teofile = NULL;
    return obj;
  }
}

static VALUE
file_s_open(VALUE file_class, VALUE filename){
  VALUE obj;
  RBTEOFILE *file;

  Check_SafeStr(filename);

  obj = Data_Make_Struct(file_class,RBTEOFILE, 0, file_free, file);
  file->teofile = TeoOpenFile(RSTRING(filename)->ptr);

  if(file->teofile==NULL)
    rb_raise(rb_eIOError,TEO_ERROR_MESSAGE);
  return obj;
}

static VALUE
file_s_create(int argc, VALUE *argv, VALUE file_class){
  VALUE obj;
  VALUE val[9];

  int width=0;
  int height=0;
  int xoffset=0;
  int yoffset=0;
  int type=TEO_UNSIGNED;
  int bit=8;
  int plane=1;
  int frame=1;

  TEOIMAGE *image;
  RBTEOFILE *file;

  rb_secure(4);
  rb_scan_args(argc,argv,"27",
	       &val[0],&val[1],&val[2],&val[3],
	       &val[4],&val[5],&val[6],&val[7],&val[8]);

  Check_SafeStr(val[0]);

  obj = Data_Make_Struct(file_class,RBTEOFILE, 0, file_free, file);
  file->teofile = NULL;

  if(rb_obj_is_kind_of(val[1],gFile)==Qtrue){
    TEOFILE *orig_file;
    GetTEOFILE(val[1], orig_file);
    file->teofile = TeoCreateSimilarFile(RSTRING(val[0])->ptr,orig_file);
  } else if(rb_obj_is_kind_of(val[1],gImage)==Qtrue){
    TEOIMAGE *orig_image;
    if(val[2]!=Qnil) frame = NUM2INT(val[2]);
    Data_Get_Struct(val[1], TEOIMAGE, orig_image);
    file->teofile = TeoCreateFile(RSTRING(val[0])->ptr,
			 TeoWidth(orig_image),  TeoHeight(orig_image),
			 TeoXoffset(orig_image),TeoYoffset(orig_image),
			 TeoType(orig_image),   TeoBit(orig_image),
			 TeoPlane(orig_image),  frame);
  } else  {
    width = NUM2INT(val[1]);
    height = NUM2INT(val[2]);

    if(val[3]!=Qnil) xoffset = NUM2INT(val[3]);
    if(val[4]!=Qnil) yoffset = NUM2INT(val[4]);
    if(val[5]!=Qnil) type = FIX2INT(val[5]);
    if(val[6]!=Qnil) bit = FIX2INT(val[6]);
    if(val[6]!=Qnil) plane = NUM2INT(val[7]);
    if(val[7]!=Qnil) frame = NUM2INT(val[8]);
    file->teofile = TeoCreateFile(RSTRING(val[0])->ptr,
				  width, height, xoffset, yoffset,
				  type, bit,
				  plane, frame);
  }
  if(file->teofile==NULL)
    rb_raise(rb_eIOError,TEO_ERROR_MESSAGE);

  return obj;
}

static VALUE
file_open(VALUE self, VALUE filename){
  RBTEOFILE *file;

  Check_SafeStr(filename);

  Data_Get_Struct(self,RBTEOFILE, file);
  if(file->teofile!=NULL) TeoCloseFile(file->teofile);
  file->teofile = TeoOpenFile(RSTRING(filename)->ptr);
  if(file->teofile==NULL)
    rb_raise(rb_eIOError,TEO_ERROR_MESSAGE);

  return self;
}

static VALUE
file_create(int argc, VALUE *argv, VALUE self){
  VALUE val[9];

  int width=0;
  int height=0;
  int xoffset=0;
  int yoffset=0;
  int type=TEO_UNSIGNED;
  int bit=8;
  int plane=1;
  int frame=1;

  TEOIMAGE *image;
  RBTEOFILE *file;

  rb_secure(4);

  rb_scan_args(argc,argv,"27",
	       &val[0],&val[1],&val[2],&val[3],
	       &val[4],&val[5],&val[6],&val[7],&val[8]);

  Check_SafeStr(val[0]);

  Data_Get_Struct(self,RBTEOFILE, file);
  if(file->teofile!=NULL) TeoCloseFile(file->teofile);
  file->teofile = NULL;
  if(rb_obj_is_kind_of(val[1],gFile)==Qtrue){
    TEOFILE *orig_file;
    GetTEOFILE(val[1], orig_file);
    file->teofile = TeoCreateSimilarFile(RSTRING(val[0])->ptr,orig_file);
  } else if(rb_obj_is_kind_of(val[1],gImage)==Qtrue){
    TEOIMAGE *orig_image;
    if(val[2]!=Qnil) frame = NUM2INT(val[2]);
    Data_Get_Struct(val[1], TEOIMAGE, orig_image);
    file->teofile = TeoCreateFile(RSTRING(val[0])->ptr,
			 TeoWidth(orig_image),  TeoHeight(orig_image),
			 TeoXoffset(orig_image),TeoYoffset(orig_image),
			 TeoType(orig_image),   TeoBit(orig_image),
			 TeoPlane(orig_image),  frame);
  } else  {
    width = NUM2INT(val[1]);
    height = NUM2INT(val[2]);

    if(val[3]!=Qnil) xoffset = NUM2INT(val[3]);
    if(val[4]!=Qnil) yoffset = NUM2INT(val[4]);
    if(val[5]!=Qnil) type = FIX2INT(val[5]);
    if(val[5]!=Qnil) bit = FIX2INT(val[6]);
    if(val[6]!=Qnil) plane = NUM2INT(val[7]);
    if(val[7]!=Qnil) frame = NUM2INT(val[8]);
    file->teofile = TeoCreateFile(RSTRING(val[0])->ptr,
				  width, height, xoffset, yoffset,
				  type, bit,
				  plane, frame);
  }
  if(file->teofile==NULL)
    rb_raise(rb_eIOError,TEO_ERROR_MESSAGE);
  return self;
}

static VALUE
file_close(VALUE self){
  RBTEOFILE *file;
  Data_Get_Struct(self,RBTEOFILE, file);
  if(file->teofile!=NULL) TeoCloseFile(file->teofile);
  file->teofile=NULL;
  return self;
}

static VALUE
file_closed(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self, file);
  if(file!=NULL) return Qtrue;
  else return Qfalse;
}

static VALUE
file_read_ok(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self, file);
  if(file==NULL) return Qfalse;

  switch(file->ac_type){
  case TEO_AC_READ:
  case TEO_AC_STDIN:
  case TEO_AC_TMP_R:
  case TEO_AC_PIPE_SR:
  case TEO_AC_PIPE_R:
    return Qtrue;
    break;
  default:
    return Qfalse;
  }
}

static VALUE
file_write_ok(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self, file);
  if(file==NULL) return Qfalse;

  switch(file->ac_type){
  case TEO_AC_WRITE:
  case TEO_AC_STDOUT:
  case TEO_AC_TMP_W:
  case TEO_AC_TMP_SW:
  case TEO_AC_PIPE_W:
    return Qtrue;
    break;
  default:
    return Qfalse;
  }
}

static VALUE
file_back_ok(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self, file);
  if(file==NULL) return Qfalse;

  switch(file->ac_type){
  case TEO_AC_READ:
  case TEO_AC_WRITE:
  case TEO_AC_TMP_R:
  case TEO_AC_TMP_W:
    return Qtrue;
    break;
  default:
    return Qfalse;
  }
}

static void
file_free(RBTEOFILE *file){
  if(file->teofile!=NULL) TeoCloseFile(file->teofile);
  free(file);
}

static VALUE
file_read(VALUE self){
  TEOFILE *file;
  TEOIMAGE *image;
  VALUE obj;
  ID mid;

  GetTEOFILE(self, file);
  mid = rb_intern("new");
  obj = rb_funcall(gImage,mid,1,self);
  Data_Get_Struct(obj, TEOIMAGE, image);
  if(TeoReadFrame(file,image)==0) rb_raise(rb_eIOError,TEO_ERROR_MESSAGE);

  return obj;
}

static VALUE
file_write(VALUE self, VALUE imobj){
  TEOFILE *file;
  TEOIMAGE *image;
  rb_secure(4);

  if(rb_obj_is_kind_of(imobj,gImage)==Qnil)
    rb_raise(rb_eTypeError,"Type miss match");

  GetTEOFILE(self, file);
  Data_Get_Struct(imobj, TEOIMAGE, image);
  if(TeoWriteFrame(file,image)==0) rb_raise(rb_eIOError,TEO_ERROR_MESSAGE);
  return Qtrue;
}

static VALUE file_width(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoWidth(file));
}
static VALUE file_height(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoHeight(file));
}
static VALUE file_xoffset(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoXoffset(file));
}
static VALUE file_yoffset(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoYoffset(file));
}
static VALUE file_xstart(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoXstart(file));
}
static VALUE file_xend(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoXend(file));
}
static VALUE file_ystart(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoYstart(file));
}
static VALUE file_yend(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoYend(file));
}
static VALUE file_type(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoType(file));
}
static VALUE file_typestring(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  if(TeoBit(file)==1){
    return rb_str_new2("BIT");
  } else if(TeoBit(file)==8) {
    if(TeoType(file)==TEO_UNSIGNED){
      return rb_str_new2("UINT8");
    } else if(TeoType(file)==TEO_SIGNED){
    return rb_str_new2("SINT8");
    }
  } else if(TeoBit(file)==16) {
    if(TeoType(file)==TEO_UNSIGNED){
      return rb_str_new2("UINT16");
    } else if(TeoType(file)==TEO_SIGNED){
      return rb_str_new2("SINT16");
    }
  } else if(TeoBit(file)==32) {
    if(TeoType(file)==TEO_UNSIGNED){
      return rb_str_new2("UINT32");
    } else if(TeoType(file)==TEO_SIGNED){
      return rb_str_new2("SINT32");
    } else if(TeoType(file)==TEO_FLOAT){
      return rb_str_new2("FLOAT32");
    }
  } else if(TeoBit(file)==64) {
    if(TeoType(file)==TEO_UNSIGNED){
      return rb_str_new2("FLOAT64");
    }
  }
  return Qnil;
}
static VALUE file_bit(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
return INT2NUM(TeoBit(file));
}
static VALUE file_plane(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoPlane(file));
}
static VALUE file_frame(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoFrame(file));
}
static VALUE file_fsize(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoFsize(file));
}
static VALUE file_current(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  return INT2NUM(TeoCurrent(file));
}
static VALUE file_set_abs_frame(VALUE self,VALUE val){
  TEOFILE *file;
  GetTEOFILE(self,file);
  if(TeoSetAbsFrame(file,NUM2INT(val))==0)
    rb_raise(rb_eIOError,TEO_ERROR_MESSAGE);
  return val;
}
static VALUE file_set_rel_frame(VALUE self,VALUE val){
  TEOFILE *file;
  GetTEOFILE(self,file);
  if(TeoSetRelFrame(file,NUM2INT(val))==0)
    rb_raise(rb_eIOError,TEO_ERROR_MESSAGE);
  return INT2NUM(TeoCurrent(file));
}
static VALUE file_check_frame(VALUE self){
  TEOFILE *file;
  GetTEOFILE(self,file);
  if(TeoCheckFrame(file)==0) return Qfalse;
  else return Qtrue;
}
