require 'teo.so'

module TEO

  #File class ɲä method 
  class File

    #ΥǽϰϤ֤
    def xrange
      Range.new(xstart,xend)
    end
    def yrange
      Range.new(ystart,yend)
    end
    def prange
      Range.new(0,plane-1)
    end

    #ꤷե졼βФ
    def [](f)
      current=f if(f!=nil)
      read_frame
    end
    def []=(f,im)
      current=f
      write_frame(im)
    end

    #ƥե졼ФƽԤ
    def each
      image = Image.new(self)
      while(check_frame)
	image.read_frame(self)
	yield(image)
      end
    end

    def each_to(last=frame-1)
      image = Image.new(self)
      while(check_frame && current<=last)
	image.read_frame(self)
	yield(image)
      end
    end

    def step(first=0,last=frame-1,st=1)
      current=(first)
      image = Image.new(self)
      while(check_frame && current<=last)
	image.read_frame(self)
	yield(image)
	if(st>1)
	  add_current(st-1)
	end
      end
    end
    include Enumerable
  end




  #Image class ɲämethod 
  class Image
    def alloc(*args)
      type.alloc(*args)
    end
    #ΥǽϰϤ֤
    def xrange
      Range.new(xstart,xend)
    end
    def yrange
      Range.new(ystart,yend)
    end
    def prange
      Range.new(0,plane-1)
    end
    #ƲǤ˥
    def each_pixel!(image=nil)
      if image == nil
      then
	image = self
      end
      xxstart = (xstart > image.xstart)? xstart : image.xstart
      xxend = (xend < image.xend)? xend : image.xend
      yystart = (ystart > image.ystart)? ystart : image.ystart
      yyend = (yend < image.yend)? yend : image.yend
      pplane = (plane < image.plane)? plane-1 : image.plane-1

      for y in yystart..yyend
	for x in xxstart..xxend
	  self[x,y] = yield(self[x,y],image[x,y])
	end
      end
    end

    def each_value!(image=nil)
      if image == nil
      then
	image = self
      end
      xxstart = (xstart > image.xstart)? xstart : image.xstart
      xxend = (xend < image.xend)? xend : image.xend
      yystart = (ystart > image.ystart)? ystart : image.ystart
      yyend = (yend < image.yend)? yend : image.yend
      pplane = (plane < image.plane)? plane-1 : image.plane-1

      for y in yystart..yyend
	for x in xxstart..xxend
	  for p in 0..pplane
	    put_pixel(x,y,p,yield(get_pixel(x,y,p),image.get_pixel(x,y,p)))
	  end
	end
      end
    end


    def each_pixel_with_index!(image=nil)
      if image == nil
      then
	xxstart = xstart
	xxend = xend
	yystart = ystart
	yyend = yend
	pplane = plane-1

	for y in yystart..yyend
	  for x in xxstart..xxend
	    self[x,y]= yield(self[x,y],x,y)
	  end
	end
      else
	xxstart = (xstart > image.xstart)? xstart : image.xstart
	xxend = (xend < image.xend)? xend : image.xend
	yystart = (ystart > image.ystart)? ystart : image.ystart
	yyend = (yend < image.yend)? yend : image.yend
	pplane = (plane < image.plan)? plane-1 : image.plane-1

	for y in yystart..yyend
	  for x in xxstart..xxend
	    self[x,y]= yield(self[x,y],image[x,y],x,y)
	  end
	end
      end
    end

    def each_value_with_index!(image=nil)
      if image == nil
      then
	xxstart = xstart
	xxend = xend
	yystart = ystart
	yyend = yend
	pplane = plane-1
	for y in yystart..yyend
	  for x in xxstart..xxend
	    for p in 0..pplane
	      put_pixel(x,y,p,
			yield(get_pixel(x,y,p),x,y,p))
	    end
	  end
	end
      else
	xxstart = (xstart > image.xstart)? xstart : image.xstart
	xxend = (xend < image.xend)? xend : image.xend
	yystart = (ystart > image.ystart)? ystart : image.ystart
	yyend = (yend < image.yend)? yend : image.yend
	pplane = (plane < image.plan)? plane-1 : image.plane-1
	for y in yystart..yyend
	  for x in xxstart..xxend
	    for p in 0..pplane
	      put_pixel(x,y,p,
			yield(get_pixel(x,y,p),
			      image.get_pixel(x,y,p),x,y,p))
	    end
	  end
	end
      end
    end



    #Ф黻
    def add(image)
      dstimage = copy()
      dstimage.add!(image)
    end
    alias + add

    def sub(image)
      dstimage = copy()
      dstimage.sub!(image)
    end
    alias - sub

    def mult(image)
      dstimage = copy()
      dstimage.mult!(image)
    end
    alias * mult

    def div(image)
      dstimage = copy()
      dstimage.div!(image)
    end
    alias * div

    def exp(image)
      dstimage = copy()
      dstimage.exp!(image)
    end
    alias ** exp

    def abssub(image)
      dstimage = copy()
      dstimage.abssub!(image)
    end

    def abs
      dstimage = copy()
      dstimage.abs!
    end

    def add!(image)
      if image.is_a?(Image)
      then
	each_value!(image){|dst, src|
	  dst + src
	}
      else
	each_value!(image){|dst|
	  dst + image
	}
      end
      self
    end

    def sub!(image=nil)
      if image.is_a?(Image)
      then
	each_value!(image){|dst,src|
	  dst - src
	}
      elsif image == nil
      then
	each_value! {|dst|
	  -dst
	}
      else
	each_value! {|dst|
	  dst - image
	}
      end
      self
    end

    def mult!(image)
      if image.is_a?(Image)
      then
	each_value!(image){|dst,src|
	  dst * src
	}
      else
	each_value! {|dst|
	  dst * image
	}
      end
      self
    end

    def div!(image)
      if image.is_a?(Image)
      then
	each_value!(image){|dst,src|
	  dst / src
	}
      else
	each_value! {|dst|
	  dst / image
	}
      end
      self
    end

    def exp!(image)
      if image.is_a?(Image)
      then
	each_value!(image){|dst,src|
	  dst ** src
	}
      else
	each_value! {|dst|
	  dst ** image
	}
      end
      self
    end

    def abssub!(image)
      if image.is_a?(Image)
      then
	each_value!(image){|dst,src|
	  dst = (dst>src)? (dst - src) : (src - dst)
	}
      else
	each_value! {|dst|
	  dst = (dst>image)? (dst - image) : (image - dst)
	}
      end
      self
    end
    def abs!
      each_value! {|dst|
	(dst>0)? dst : -dst
      }
      self
    end
  end


  #libteo ߴ API
  def TEO.OpenFile(*args)
    File.open(*args)
  end

  def TEO.CreateFile(*args)
    File.create(*args)
  end
  def TEO.CreateSimilarFile(filename,info)
    File.create(filename,info)
  end
  def TEO.CloseFile(teofile)
    teofile.close
  end

  def TEO.ReadFrame(teofile,image)
    image.read_frame(teofile)
  end
  def TEO.WriteFrame(teofile,image)
    image.write_frame(teofile)
  end

  def TEO.SetAbsFrame(teofile, frame=0)
    teofile.current=frame
  end
  def TEO.SetRelFrame(teofile, frame=0)
    teofile.add_current(frame)
  end

  #  def GetUserExtension(TEOFILE *teofp,char *keyword)
  #  end
  def TEO.AllocImage(*args)
    Image.new(*args)
  end
  def TEO.AllocSimilarImage(info)
    Image.new(info)
  end
  def TEO.AllocImageBIT(*args)
    Image::BIT.new(*args)
  end
  def TEO.AllocImageUINT8(*args)
    Image::UINT8.new(*args)
  end
  def TEO.AllocImageSINT8(*args)
    Image::SINT8.new(*args)
  end
  def TEO.AllocImageUINT16(*args)
    Image::UINT16.new(*args)
  end
  def TEO.AllocImageSINT16(*args)
    Image::SINT16.new(*args)
  end
  def TEO.AllocImageUINT32(*args)
    Image::UINT32.new(*args)
  end
  def TEO.AllocImageSINT32(*args)
    Image::SINT32.new(*args)
  end
  def TEO.AllocImageFLOAT32(*args)
    Image::FLOAT32.new(*args)
  end
  def TEO.AllocImageFLOAT64(*args)
    Image::FLOAT64.new(*args)
  end

  #  def TEO.FreeImage(image)
  #    image.free
  #  end

  def TEO.GetPixel(image,index_x,index_y,index_p)
    image.get_pixel(index_x,index_y,index_p)
  end
  def TEO.PutPixel(image,index_x,index_y,index_p,val)
    image.put_pixl(index_x,index_y,index_p,val)
  end

  def TEO.Width(info)
    info.width
  end
  def TEO.Height(info)
    info.height
  end
  def TEO.Type(info)
    info.type
  end
  def TEO.Bit(info)
    info.bit
  end
  def TEO.Plane(info)
    info.plane
  end
  def TEO.Fsize(info)
    info.fsize
  end
  def TEO.Xoffset(info)
    info.xoffset
  end
  def TEO.Yoffset(info)
    info.yoffset
  end

  def TEO.Xstart(info)
    info.xstart
  end
  def TEO.Xend(info)
    info.xend
  end
  def TEO.Ystart(info)
    info.ystart
  end
  def TEO.Yend(info)
    info.yend
  end

  def TEO.Frame(info)
    info.frame
  end
  def TEO.Hsize(info)
    info.hsize
  end
  #  def TEO.Fp(info)
  #  end
  def TEO.Current(info)
    info.current
  end
  #  def TEO.Extc(info)
  #  end
  #  def TEO.Extv(info)
  #  end

  #  def TEO.Data(info)
  #  end

  def TEO.IsBIT(info)
    info.typestring==BIT
  end
  def TEO.IsUINT8(info)
    info.typestring==UINT8
  end
  def TEO.IsSINT8(info)
    info.typestring==SINT8
  end
  def TEO.IsUINT16(info)
    info.typestring==UINT16
  end
  def TEO.IsSINT16(info)
    info.typestring==SINT16
  end
  def TEO.IsUINT32(info)
    info.typestring==UINT32
  end
  def TEO.IsSINT32(info)
    info.typestring==SINT32
  end
  def TEO.IsFLOAT32(info)
    info.typestring==FLOAT32
  end
  def TEO.IsFLOAT64(info)
    info.typestring==FLOAT64
  end
  def TEO.CheckFrame(info)
    info.check_frame
  end
end
