require 'teo'
module TEO
  class Image

    def liner_pixel(index_x,index_y,index_p=nil)
      xmin = index_x.floor.to_i
      xmax = index_x.ceil.to_i
      ymin = index_y.floor.to_i
      ymax = index_y.ceil.to_i
      xp = index_x - xmin
      yp = index_y - ymin
      if(index_p!=nil)
      then
	xp*(yp*get_pixel(xmax,ymax,index_p)+
	    (1.0-yp)*get_pixel(xmax,ymin,index_p))+
	  (1.0-xp)*(yp*get_pixel(xmin,ymax,index_p)+
		    (1.0-yp)*get_pixel(xmin,ymin,index_p))
      else
	ret = Array.new(self.plane)
	prange.each {|p|
	  ret[p] = xp*(yp*get_pixel(xmax,ymax,p)+
		       (1.0-yp)*get_pixel(xmax,ymin,p))+
	    (1.0-xp)*(yp*get_pixel(xmin,ymax,p)+
		      (1.0-yp)*get_pixel(xmin,ymin,p))
	}
	ret
      end
    end

    def affine(trans,image,ys=nil,xe=nil,ye=nil)
      if(image.kind_of?(Numeric))
      then
	xs = image
	image = alloc(xe-xs+1,ye-ys+1,xs,ys,plane)
      end
      image.each_pixel_with_index! {|pixel,x,y|
	xx = trans[0][0]*x + trans[0][1]*y + trans[0][2]
	yy = trans[1][0]*x + trans[1][1]*y + trans[1][2]
	if(xrange === xx && yrange === yy)
	then
	  liner_pixel(xx,yy)
	else
	  0
	end
      }
      image
    end

    def to_gray
      image = alloc(width,height,xoffset,yoffset,1)
      each_pixel_with_index {|p,x,y|
	image[x,y] = (p[0]*38 + p[1]*75 + p[2]*15)>>7
      }
    image
    end
  end
end
