AC_DEFUN(AM_PATH_TEOPP,
[dnl
dnl
dnl
AC_MSG_CHECKING(if teopp library wanted)

AC_ARG_ENABLE(teopp, [ --disable-teopp     Do no use TEOPP library],,
              enable_teopp=yes)

  if test "x$enable_teopp" = "xyes" ; then
    AC_ARG_WITH(teopp-prefix,
      [  --with-teopp-prefix=PREFIX
         Prefix where TEOPP installed [default=/usr/local/lab].],
      teopp_prefix=$withval, teopp_prefix=yes)
    if test ${teopp_prefix} = yes ; then
      if test "x${teo_prefix}" != "x"; then
        teopp_prefix=${teo_prefix}
      else
        teopp_prefix=/usr/local/lab
      fi
    fi
    AC_MSG_RESULT(${teopp_prefix})
    TEOPP_CFLAGS="-I${teopp_prefix}/include"
    TEOPP_LIBS="-L${teopp_prefix}/lib"

    AC_LANG_SAVE
    AC_LANG_CPLUSPLUS
    ac_save_CXXFLAGS="$CXXFLAGS"
    ac_save_LIBS="$LIBS"
    CXXFLAGS="$CXXFLAGS $TEO_CFLAGS $TEOPP_CFLAGS"
    LIBS="$LIBS $TEO_LIBS $TEOPP_LIBS"
    AC_CHECK_LIB(teopp, main, TEOPP_LIBS="${TEOPP_LIBS} -lteopp")
    if test "$ac_cv_lib_teopp_main" != "yes"; then
      echo "Fatal error: no teo library in suggested path ${teopp_prefix}/lib"
      exit 1
    fi
    CXXFLAGS="$ac_save_CXXFLAGS"
    LIBS="$ac_save_LIBS"
    AC_LANG_RESTORE
  fi
  AC_SUBST(teopp_prefix)
  AC_SUBST(TEOPP_CFLAGS)
  AC_SUBST(TEOPP_LIBS)
])
