#include "teo_s.h"
teo_s::teo_s(const char *f,int s,int e,int t):
  start(s),end(e),step(t),current(start){
  format = new char [strlen(f)+1];
  strcpy(format,f);
  TeoAnyImage image=GetImage(start);
  current=start;
  width = image.Width();
  height = image.Height();
  plane = image.Plane();
  bit = image.Bit();
}
teo_s::~teo_s(){
  delete[] format;
}
TeoAnyImage teo_s::GetImage(int frame_num){
  char buf[256];
  if(frame_num>=0) current=frame_num;
  sprintf(buf,format,current);
  current+=step;
  return TeoAnyImage(buf);
}
bool teo_s::SetAbsFrame(int frame_num){
  current = frame_num;
  return CheckFrame();
}
bool teo_s::CheckFrame()const{
  return ( (start <= current) && ( current <= end) );
}
int teo_s::Width()const{return width;}
int teo_s::Height()const{return height;}
int teo_s::Frame()const{return (end-start+1)/step;}
int teo_s::Plane()const{return plane;}
int teo_s::Bit()const{return bit;}
