#include <teo2ipl.h>
#include <cv.h>
int main(int argc,char **argv){
  TEOFILE *input,*output;
  TEOIMAGE *teoimage1,*teoimage2;
  IplImage *iplimage1,*iplimage2;

/* TEO ν */
  input = TeoOpenFile(argv[1]);
  output = TeoCreateFile(argv[2],TeoWidth(input),TeoHeight(input),0,0,
			 TEO_UNSIGNED,8,1,1);
  teoimage1 = TeoAllocSimilarImage(input);
  teoimage2 = TeoAllocSimilarImage(output);
  TeoReadFrame(input,teoimage1);

/* TEOIPLΥإå碌 */
  iplimage1 = cvWrapTEO(teoimage1);
  iplimage2 = cvWrapTEO(teoimage2);

/* OpenCVδؿ */
  cvCanny(iplimage1,iplimage2,10,200,3);

  TeoWriteFrame(output,teoimage2);

  cvReleaseImageHeader(iplimage1);
  cvReleaseImageHeader(iplimage2);

  TeoFreeImage(teoimage1);
  TeoFreeImage(teoimage2);

  TeoCloseFile(input);
  TeoCloseFile(output);
  return 0;
}
