//-*- Mode: C++ -*-
#ifndef _TEOPP_TEOBIN_H_
#define _TEOPP_TEOBIN_H_
// 1bit$B%G!<%?$r07$&$?$a$N%/%i%9(B
class TeoBin {
public:
  // $B%3%s%9%H%i%/%?(B
  TeoBin();
  TeoBin(const TeoBin &value);
  TeoBin(TeoUint8      value);
  TeoBin(TeoSint8      value);
  TeoBin(TeoUint16     value);
  TeoBin(TeoSint16     value);
  TeoBin(TeoUint32     value);
  TeoBin(TeoSint32     value);
  TeoBin(TeoFloat32    value);
  TeoBin(TeoFloat64    value);
  TeoBin(char value, int offset);
  TeoBin(char *pointer, int offset);
  TeoBin(const char *pointer, int offset);

  // $B%G%9%H%i%/%?(B
  ~TeoBin();

  // $B%S%C%H%;%C%H(B
  bool IsSetBit()const;
  TeoBin Set();
  TeoBin Unset();
  TEO_BIT GetBit()const;

  TeoBin &operator()(const TeoBin &value);

  // $B3F<o1i;;;R(B
  // $BBeF~1i;;;R(B
  TeoBin &operator= (const TeoBin &value);
  TeoBin &operator= (TEO_BIT       value);
  TeoBin &operator|=(const TeoBin &value);
  TeoBin &operator+=(const TeoBin &value);
  TeoBin &operator&=(const TeoBin &value);
  TeoBin &operator*=(const TeoBin &value);
  TeoBin &operator-=(const TeoBin &value);
  TeoBin &operator/=(const TeoBin &value);
  // $BC19`1i;;;R(B
  TeoBin operator~()const;
  TeoBin operator-()const;
  // $B;MB'1i;;(B
  TeoBin operator|(const TeoBin &value)const;
  TeoBin operator+(const TeoBin &value)const;
  TeoBin operator&(const TeoBin &value)const;
  TeoBin operator*(const TeoBin &value)const;
  TeoBin operator-(const TeoBin &value)const;
  TeoBin operator/(const TeoBin &value)const;
  // $BHf3S1i;;;R(B
  bool operator==(const TeoBin &value)const;
  bool operator!=(const TeoBin &value)const;
  bool operator< (const TeoBin &value)const;
  bool operator<=(const TeoBin &value)const;
  bool operator> (const TeoBin &value)const;
  bool operator>=(const TeoBin &value)const;
  // $B%-%c%9%H1i;;;R(B
  operator TeoUint8()const;
  operator TeoSint8()const;
  operator TeoUint16()const;
  operator TeoSint16()const;
  operator TeoUint32()const;
  operator TeoSint32()const;
  operator TeoFloat32()const;
  operator TeoFloat64()const;

private:
  char data;
  char mask;
  char *ptr;
};

// $B%$%s%i%$%s4X?t$NDj5A(B
#include <teopp/teobin_inline.h>

#endif
