/* *********************************************************** median.c *** *
 * Teoeyes Plugin Collection (ǥե륿)
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-03 23:41:19 sugaya>
 * ************************************************************************* */
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <gnome.h>
#include "teoeyesplugin.h"

#define	MIN_VAL			1
#define	MAX_VAL			32
#define	STEP_SIZE		1
#define	PAGE_SIZE		5
/* ץ쥹СѤ1ѹƤ */
#define	USE_PROGRESS_BAR	1

/* ************************************************************************* *
   ͤ
 * ************************************************************************* */
guchar
median (guchar	*val,
	int	num) {
  int		n, m, tmp;
  guchar	min;

  for (n = 0; n < num / 2 + 1; n++) {
    min = val[n];
    tmp = n;
    for (m = n+1; m < num; m++) {
      if (val[m] < min) {
	min = val[m];
	tmp = m;
      }
    }
    val[tmp] = val[n];
    val[n]   = min;
  }
  return val[num/2];
}

/* ************************************************************************* *
   ץ饰ؿ
 * ************************************************************************* */
void
exec_median (GdkPixbuf	*src,
	     GdkPixbuf	*dst,
	     double	param1,
	     double	param2,
	     double	param3) {
  int		scope = (int) param1;
  int		row, col;
  int		n, m, p, num;
  int		w, ww;
  guchar	**vals = NULL;

  w  = scope * 2 + 1;  
  ww = w * w;

  vals = (guchar **) malloc (sizeof (guchar *) * 3);
  for (p = 0; p < 3; p++) vals[p] = (guchar *) malloc (sizeof (guchar) * ww);

  for (row = scope; row < gdk_pixbuf_get_height (src) - scope; row++) {
    for (col = scope; col <= gdk_pixbuf_get_width (src) - scope; col++) {
      for (p = 0; p < 3; p++) {
	num = 0;	
	for (n = 0; n < ww; n++) vals[p][n] = 0;
	for (n = -scope; n <= scope; n++) {
	  for (m = -scope; m <= scope; m++) {
	    vals[p][num++] = gdk_pixbuf_get_pixel (src, col+m, row+n, p);
	  }
	}
	gdk_pixbuf_put_pixel (dst, col, row, p, median (vals[p], ww));
      }
      if (gdk_pixbuf_get_has_alpha (src) && gdk_pixbuf_get_has_alpha (dst)) {
	gdk_pixbuf_put_pixel (dst, col, row, 4,
			      gdk_pixbuf_get_pixel (src, col, row, 4));
      }
    }
#if USE_PROGRESS_BAR /* ץ쥹СѤ1ѹƤ */
    plugin_progressbar_update ((double) (row - scope) /
			       (double) (gdk_pixbuf_get_height (src) 
					 - scope + 1));
#endif
  } 
#if USE_PROGRESS_BAR /* ץ쥹СѤ1ѹƤ */
  plugin_progressbar_update (0.0);
#endif
  for (p = 0; p < 3; p++) free (vals[p]);
  free (vals);
}

/* ************************************************************************* *
   ץ饰¹Ѵؿ
 * ************************************************************************* */
void
plugin_median (GdkPixbuf	*src,
	       GdkPixbuf	*dst) {
  /* ץ饰ɽ */
  plugin_dialog_new (_("Median Filter"),	/* ȥ */
		     exec_median,		/* ץ饰ؿ */
		     src,			/* ϲǡ */
		     dst,			/* ϲǡ */
		     _("Scope"),		/* ѥ᡼٥ */
		     MIN_VAL,			/* ѥ᡼Ǿ */
		     MAX_VAL,			/* ѥ᡼ */
		     STEP_SIZE,			/* ѥ᡼1 */	
		     PAGE_SIZE,			/* ѥ᡼2 */	
		     USE_PROGRESSBAR,		/* ץ쥹Сλ */
		     ACTION_NON_INTERACTIVE);	/* ץӥ塼̤ιˡ */

  gtk_main ();
}

/* ************************************************************************* *
   ץ饰
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {N_("/Median Filter"),
   NULL,
   0,
   0,
   "<Item>",
   NULL
  },
  N_("Median Filter Plugin"),
  N_("Yasuyuki Sugaya"),
  "2.0",
  N_("This plugin applies\n the median filter to the image."),
  1,
  plugin_median
};

/* ***************************************************** End of median.c *** */
