/* ************************************************************** edit.c *** *
 * ǥåȥ
 *
 * Copyright (C) 2001-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/05/12 21:50:38 sugaya>
 * ************************************************************************* */
#include <gdk/gdkkeysyms.h>
#include "teoeyes.h"
#include "cripping.h"
#include "edit.h"
#include "draw.h"
#include "grab.h"
#include "image_window.h"
#include "operation.h"
#include "gtkiconbutton.h"

#include "stock_book_open.icon"
#include "stock_book_close.icon"
#include "stock_reset_16.icon"
#include "stock_curve.icon"
#include "stock_brightness.icon"
#include "stock_contrast.icon"
#include "stock_hchain.icon"
#include "stock_hchain_broken.icon"
#include "stock_size_double.icon"
#include "stock_size_half.icon"
#include "stock_size_down.icon"
#include "stock_size_up.icon"
#include "stock_level.icon"
#include "stock_camera.icon"

enum {
  VALUE_ALL,
  VALUE_RED,
  VALUE_GREEN,
  VALUE_BLUE
};

static GdkPixbuf	*book_open;
static GdkPixbuf	*book_close;
static gboolean		keep_aspect;

/* ************************************************************************* */
static void	icon_new		(GtkWidget		*parent);
static void	set_page_image 		(GtkNotebook		*notebook,
					 gint			page_num,
					 GdkPixbuf		*pixbuf);
static void	cb_page_switch 		(GtkWidget		*widget,
					 GtkNotebookPage 	*page,
					 gint			page_num);
static void	cb_destroy		(GtkWidget		*widget,
					 GtkWidget		*parent);

/* ************************************************************************* */
static void color_balance_render_mod 	(GtkWidget		*a,
					 GdkPixbufModifier	*modifier,
					 gint			channel,
					 gint			br);
static void update_graphs		(GtkWidget		*w);
static void color_balance_channel	(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_gamma		(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_bright 	(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_cont		(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_button_gamma	(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_button_bright (GtkWidget		*widget,
					 gpointer		data);
static void color_balance_button_cont 	(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_button_apply 	(GtkWidget		*widget,
					 gpointer		data);
static void color_balance_button_reset	(GtkWidget		*widget,
					 gpointer		data);

/* ************************************************************************* */
static gboolean geometry_enter_width	(GtkWidget		*widget,
					 GdkEventKey		*key, 
					 gpointer		data);
static gboolean geometry_enter_height	(GtkWidget		*widget,
					 GdkEventKey		*key, 
					 gpointer		data);
static void geometry_keep_aspect 	(GtkWidget		*widget,
					 gpointer		data);
static void geometry_button_apply 	(GtkWidget		*widget,
					 gpointer		parent);
static void geometry_button_half 	(GtkWidget		*widget,
					 gpointer		data);
static void geometry_button_down 	(GtkWidget		*widget,
					 gpointer		data);
static void geometry_button_reset 	(GtkWidget		*widget,
					 gpointer		data);
static void geometry_button_up 		(GtkWidget		*widget,
					 gpointer		data);
static void geometry_button_double 	(GtkWidget		*widget,
					 gpointer		data);
static void normal_button_best		(GtkWidget		*widget,
					 gpointer		data);
static void normal_button_apply 	(GtkWidget		*widget,
					 gpointer		parent);

/* ************************************************************************* */
static void crip_change_x 		(GtkWidget		*widget,
					 gpointer		parent);
static void crip_change_y 		(GtkWidget		*widget,
					 gpointer		parent);
static void crip_change_width		(GtkWidget		*widget,
					 gpointer		parent);
static void crip_change_height		(GtkWidget		*widget,
					 gpointer		parent);
static void crip_button_apply		(GtkWidget		*widget,
					 gpointer		parent);
static void grab_start	 		(GtkWidget		*widget,
					 gpointer		parent);

/* ************************************************************************* */
static GtkWidget* tab_label_widget_new	(const gchar		*label,
					 GtkWidget		*parent);
static GtkWidget* color_balance_widget_new (GtkWidget		*parent);
static void notebook_color		(GtkWidget		*parent,
					 GtkWidget		*notebook);
static void notebook_geometry		(GtkWidget		*parent,
					 GtkWidget		*notebook);
static void notebook_crip_grab		(GtkWidget		*parent,
					 GtkWidget		*notebook);

/* ************************************************************************* *
 * ǥåȥɥǻѤؿ
 *    	(ɥѴؿ)
 * ************************************************************************* */

/* Ρȥ֥åѤΥ ******************************************** */
static void
icon_new (GtkWidget	*parent) {
  book_open  = gdk_pixbuf_new_from_inline (-1, stock_book_open,  FALSE, NULL);
  book_close = gdk_pixbuf_new_from_inline (-1, stock_book_close, FALSE, NULL);
}

/* Ρȥ֥åΥڡΥå **************************************** */
static void
set_page_image (GtkNotebook	*notebook,
		gint		page_num,
		GdkPixbuf	*pixbuf) {
  GtkWidget	*page_widget;
  GtkWidget	*pixwid;

  page_widget = gtk_notebook_get_nth_page (notebook, page_num);
#if 0
  pixwid = g_object_get_data (G_OBJECT (page_widget), "tab_icon");
#else
  pixwid = G_GET_WIDGET (page_widget, "tab_icon");
#endif
  gtk_image_set_from_pixbuf (GTK_IMAGE (pixwid), pixbuf);
}

/* ڡڤؤΥڤؤ ************************************ */
static void
cb_page_switch (GtkWidget		*widget,
		GtkNotebookPage 	*page,
		gint			page_num) {
  GtkNotebook	*notebook    = GTK_NOTEBOOK (widget);
  gint		old_page_num = gtk_notebook_get_current_page (notebook);

  if (page_num == old_page_num) return;
  set_page_image (notebook, page_num, book_open);
  if (old_page_num != -1) {
    set_page_image (notebook, old_page_num, book_close);
  }
}

/* ǥåȥɥĤ ******************************************** */
static void
cb_destroy (GtkWidget	*widget,
	    GtkWidget	*parent) {
  gtk_widget_hide (edit_window);
  gtk_widget_destroy (edit_window);
  edit_window = NULL;
}

/* ************************************************************************* *
 * ǥåȥɥǻѤؿ
 *    	(顼ХѥХåؿ)
 * ************************************************************************* */
static void
color_balance_render_mod (GtkWidget		*a,
			  GdkPixbufModifier 	*modifier,
			  gint			channel,
			  gint			br) {
  guchar		modr[256], modg[256], modb[256], mod[256];
  guchar		*ptr;
  gint			i, val, x, y;
  static GdkPixbuf	*curve = NULL;
  GdkPixbuf		*scurve;
  GdkPixmap		*pmap;
  
  if (!curve) {
    ptr = g_new (guchar, 64 * 64 * 3);
    curve = gdk_pixbuf_new_from_data (ptr, GDK_COLORSPACE_RGB, FALSE,
				      8, 64, 64, 64 * 3, 
				      gdk_pixbuf_free_buffer, NULL);
  }
  switch (channel) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_red_curve   (modifier->map, modr);
    gdk_pixbuf_get_image_green_curve (modifier->map, modg);
    gdk_pixbuf_get_image_blue_curve  (modifier->map, modb);
    for (i = 0; i < 256; i++)
      mod[i] = (unsigned char)
	(((int) modr[i] + (int) modg[i] + (int) modb[i]) / 3);
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_red_curve   (modifier->map, mod);
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_green_curve (modifier->map, mod);
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_blue_curve  (modifier->map, mod);
    break;
  }
  ptr = gdk_pixbuf_get_pixels (curve);
  for (y = 0; y < 64; y++) {
    for (x = 0; x < 64; x++) {
      *ptr++ = 0;
      *ptr++ = 0;
      *ptr++ = 0;
    }
  }
  for (i = 0; i < 64; i++) {
    val = mod[i << 2] >> 2;
    ptr = gdk_pixbuf_get_pixels (curve) + (64 * 3 * 63) + (i * 3);
    for (y = 0; y < val; y++) {
      switch (channel) {
      case VALUE_ALL:
	ptr[0] = (i << 1) + (br >> 1);
	ptr[1] = (i << 1) + (br >> 1);
	ptr[2] = (i << 1) + (br >> 1);
	break;
      case VALUE_RED:
	ptr[0] = (i << 1) + (br >> 1);
	ptr[1] = (y * br * i) / (val * 63);
	ptr[2] = (y * br * i) / (val * 63);	
	break;
      case VALUE_GREEN:
	ptr[0] = (y * br * i) / (val * 63);
	ptr[1] = (i << 1) + (br >> 1);
	ptr[2] = (y * br * i) / (val * 63);	
	break;
      case VALUE_BLUE:
	ptr[0] = (y * br * i) / (val * 63);
	ptr[1] = (y * br * i) / (val * 63);
	ptr[2] = (i << 1) + (br >> 1);
	break;
      }
      ptr -= (64 * 3);
    }
  }
  ptr = gdk_pixbuf_get_pixels (curve);
  for (y = 0; y < 64; y++) {
    for (x = 0; x < 64; x++) {
      if ((!(x % 8)) || (!(y % 8))) {
	val = *ptr + 255 - (y << 2);
	if (val > 255) val = 255;
	*ptr++ = val;
	val = *ptr + 255 - (y << 2);
	if (val > 255) val = 255;
	*ptr++ = val;
	val = *ptr + 255 - (y << 2);
	if (val > 255) val = 255;
	*ptr++ = val;
      } else {
	ptr += 3;
      }
    }
  }
  scurve = gdk_pixbuf_scale_simple (curve, 80, 80, GDK_INTERP_TILES);
  gdk_pixbuf_render_pixmap_and_mask (scurve, &pmap, NULL, 255);
  if (pmap) {
    gdk_window_set_back_pixmap (a->window, pmap, FALSE);
    gdk_pixmap_unref (pmap);
    gdk_window_clear (a->window);
    gdk_flush ();
  }
  gdk_pixbuf_unref (scurve);
}

/* 顼㡼ȥܥι ********************************************** */
void
update_graphs (GtkWidget	*w) {
  GtkWidget	*a, *b;
  gint		n;
  gchar		buf[256];
  
  if (!w) return;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "draw_area%d", n);
#if 0
    a = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (w), buf);
#else
    a = G_GET_PARAMETER (w, buf);
#endif
    if (!a) return;
    sprintf (buf, "channel_button%d", n);
#if 0
    b = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (w), buf);
#else
    b = G_GET_PARAMETER (w, buf);
#endif
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (b))) {
      color_balance_render_mod (a, ti_get_mod (image_list), n, 255);
    } else {
      color_balance_render_mod (a, ti_get_mod (image_list), n, 63);
    }
  }
  edit_draw_preview ();
}

/* 顼ͥܥ󤬲줿ν ******************************** */
static void
color_balance_channel (GtkWidget	*widget,
		       gpointer		data) {
  GdkPixbufColorModifier mod;
  GtkObject		*obj_gamma;
  GtkObject		*obj_bright;
  GtkObject		*obj_cont;
  GtkWidget		*b;
  gint			n;
  gchar			buf[256];

#if 0
  obj_gamma = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_gamma");
  obj_bright = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_bright");
  obj_cont = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_cont");
#else
  obj_gamma  = (GtkObject *) G_GET_WIDGET (edit_window, "adj_gamma");
  obj_bright = (GtkObject *) G_GET_WIDGET (edit_window, "adj_bright");
  obj_cont   = (GtkObject *) G_GET_WIDGET (edit_window, "adj_cont");
#endif
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget))) {
    for (n = 0; n < 4; n++) {
      sprintf (buf, "channel_button%d", n);
#if 0
      b = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (data), buf);
#else
      b = G_GET_WIDGET (data, buf);
#endif
      if (b != widget)
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b), 0);
      else {
	switch (n) {
	case VALUE_ALL:
	  gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod),
					 &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	case VALUE_RED:
	  gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->rmod),
					 &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	case VALUE_GREEN:
	  gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->gmod),
					 &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	case VALUE_BLUE:
	  gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->bmod),
					 &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	}
      }
    }
  }
  update_graphs (GTK_WIDGET (data));
}

/* ************************************************************************* */
static void
color_balance_gamma (GtkWidget	*widget,
		     gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  gchar			buf[256];
  gint			n, v;

  v  = GTK_ADJUSTMENT (widget)->value;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
#if 0
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
#else
    w = G_GET_WIDGET (edit_window, buf);
#endif
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }  
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);
}

/* ************************************************************************* */
static void
color_balance_bright (GtkWidget	*widget,
		      gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  gchar			buf[256];
  gint			n, v;
  
  v  = GTK_ADJUSTMENT (widget)->value;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
#if 0
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
#else
    w = G_GET_WIDGET (edit_window, buf);
#endif
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);
}

/* ************************************************************************* */
static void
color_balance_cont (GtkWidget	*widget,
		    gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  gchar			buf[256];
  gint			n, v;
  
  v  = GTK_ADJUSTMENT (widget)->value;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
#if 0
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
#else
    w = G_GET_WIDGET (edit_window, buf);
#endif
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);
}

/* ************************************************************************* */
static void
color_balance_button_gamma (GtkWidget	*widget,
			    gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  GtkObject		*obj_gamma;
  gchar			buf[256];
  gint			n;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
#if 0
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
#else
    w = G_GET_WIDGET (edit_window, buf);
#endif
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
#if 0
  obj_gamma = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_gamma");
#else
  obj_gamma = (GtkObject *) G_GET_WIDGET (edit_window, "adj_gamma");
#endif
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_gamma), 256.0);
}

/* ************************************************************************* */
static void
color_balance_button_bright (GtkWidget	*widget,
			     gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  GtkObject		*obj_bright;
  gchar			buf[256];
  gint			n;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
#if 0
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
#else
    w = G_GET_WIDGET (edit_window, buf);
#endif
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  obj_bright = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_bright");
  
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_bright), 256.0);
}

/* ************************************************************************* */
static void
color_balance_button_cont (GtkWidget	*widget,
			   gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  GtkObject		*obj_cont;
  gchar			buf[256];
  gint			n;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
#if 0
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
#else
    w = G_GET_WIDGET (edit_window, buf);
#endif
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  obj_cont = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_cont");
  
  switch (n) {
  case VALUE_ALL:
    gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod), &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_RED:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->rmod), &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_red_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_GREEN:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->gmod), &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_green_modifier (&mod, ti_get_mod (image_list));
    break;
  case VALUE_BLUE:
    gdk_pixbuf_get_image_modifier(&((ti_get_mod (image_list))->bmod), &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_blue_modifier (&mod, ti_get_mod (image_list));
    break;
  }
  update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_cont), 256.0);
}

/* 顼Х󥹤Υդɸ᤹ͤ ************************************ */
static void
color_balance_clear (void) {
  GdkPixbufColorModifier mod;
  GtkObject		*obj_gamma;
  GtkObject		*obj_bright;
  GtkObject		*obj_cont;
#if 0
  obj_gamma = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_gamma");
  obj_bright = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_bright");
  obj_cont = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_cont");
#else
  obj_gamma  = (GtkObject *) G_GET_WIDGET (edit_window, "adj_gamma");
  obj_bright = (GtkObject *) G_GET_WIDGET (edit_window, "adj_bright");
  obj_cont   = (GtkObject *) G_GET_WIDGET (edit_window, "adj_cont");
#endif
  gdk_pixbuf_get_image_modifier (&((ti_get_mod (image_list))->mod),
				 &mod);
  mod.gamma      = 256.0;
  mod.brightness = 256.0;
  mod.contrast   = 256.0;
  gdk_pixbuf_set_image_modifier (&mod,
				 ti_get_mod (image_list));
  update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_gamma),  256.0);
  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_bright), 256.0);
  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_cont),   256.0);  
}

/* 顼Х󥹤ѹŬѤ ****************************************** */
static void
color_balance_button_apply (GtkWidget	*widget,
			    gpointer	data) {
  GdkPixbuf		*pbuf;
  GdkPixbufModifier	*mod;
  
  pbuf = ti_get_pixbuf (image_list);
  mod  = ti_get_mod (image_list);
  if (pbuf && mod) gdk_pixbuf_apply_modifiers_to_rgb (pbuf, mod, 1);
  draw_image (image_list,
	      ti_get_width (image_list), ti_get_height (image_list));
  color_balance_clear ();
}

/* ꥸʥ᤹ **************************************************** */
static void
color_balance_button_reset (GtkWidget	*widget,
			    gpointer	data) {
  original_image (image_list);
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));
  color_balance_clear ();
}

/* ************************************************************************* *
 * ǥåȥɥǻѤؿ
 *    	(ȥѥХåؿ)
 * ************************************************************************* */

/* ѹ ********************************************************** */
static gboolean
geometry_enter_width (GtkWidget		*widget,
		      GdkEventKey	*key, 
		      gpointer		parent) {
  GtkWidget	*spin_width;
  GtkWidget	*spin_height;
  gint		ow, oh, nw, nh;

  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return FALSE;

  if (keep_aspect) {
    ow = ti_get_width  (image_list);
    oh = ti_get_height (image_list);
#if 0
    spin_width = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (parent), "spin_size_width");
    spin_height = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (parent), "spin_size_height");
#else
    spin_width  = G_GET_WIDGET (parent, "spin_size_width");
    spin_height = G_GET_WIDGET (parent, "spin_size_height");
#endif
    nw = (gint) atoi (gtk_entry_get_text (GTK_ENTRY (widget)));
    nh = oh * nw / ow;
    if (nh != (gint)
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_height))) {
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_height), (gfloat) nh);
    }
  }
  return TRUE;
}

/* ι⤵ѹ ******************************************************** */
static gboolean
geometry_enter_height (GtkWidget	*widget,
		       GdkEventKey	*key, 
		       gpointer		parent) {
  GtkWidget	*spin_width;
  GtkWidget	*spin_height;
  int		ow, oh, nw, nh;

  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return FALSE;

  if (keep_aspect) {
    ow = ti_get_width  (image_list);
    oh = ti_get_height (image_list);
#if 0
    spin_width = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (parent), "spin_size_width");
    spin_height = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (parent), "spin_size_height");
#else
    spin_width  = G_GET_WIDGET (parent, "spin_size_width");
    spin_height = G_GET_WIDGET (parent, "spin_size_height");
#endif
    nh = (gint) atoi (gtk_entry_get_text (GTK_ENTRY (widget)));
    nw = ow * nh / oh;
    if (nw != (gint)
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_width))) {
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_width), (gfloat) nw);
    }
  }
  return TRUE;
}

/* ڥݻ ****************************************************** */
static void
geometry_keep_aspect (GtkWidget	*widget,
		      gpointer	data) {
  keep_aspect = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));
}

/* ѹŬ **************************************************** */
static void
geometry_button_apply (GtkWidget	*widget,
		       gpointer		parent) {
  GtkWidget	*spin_width;
  GtkWidget	*spin_height;
  gint		w, h;
#if 0
  widget_width  = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_size_width");
  widget_height = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_size_height");
#else
  spin_width  = G_GET_WIDGET (parent, "spin_size_width");
  spin_height = G_GET_WIDGET (parent, "spin_size_height");
#endif
  w = (gint) gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (spin_width));
  h = (gint) gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON (spin_height));

  scaling_by_size (image_list, w, h);
}

/* ѹ(ϡե) ****************************************** */
static void
geometry_button_half (GtkWidget	*widget,
		      gpointer	data) {
  scaling_by_scale (image_list, 0.5, 0.5);
}

/* ѹ(-10%) ************************************************** */
static void
geometry_button_down (GtkWidget	*widget,
		      gpointer	data) {
  scaling_by_scale (image_list, 0.9, 0.9);
}

/* ѹ(ꥸʥ륵) ************************************** */
static void
geometry_button_reset (GtkWidget	*widget,
		       gpointer		parent) {
  GtkWidget	*spin_width;
  GtkWidget	*spin_height;
  
  scaling_by_size (image_list,
		   ti_get_width (image_list), ti_get_height(image_list));
#if 0
  spin_width = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_size_width");
  spin_height = (GtkWidget *) 
    gtk_object_get_data (GTK_OBJECT (parent), "spin_size_height");
#else
  spin_width  = G_GET_WIDGET (parent, "spin_size_width");
  spin_height = G_GET_WIDGET (parent, "spin_size_height");
#endif
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_width),
			     (gfloat) ti_get_width (image_list));
  gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_height),
			     (gfloat) ti_get_height (image_list));
}

/* ѹ(+10%) ************************************************** */
static void
geometry_button_up (GtkWidget	*widget,
		    gpointer	data) {
  scaling_by_scale (image_list, 1.1, 1.1);
}

/* ѹ(֥륵) ****************************************** */
static void
geometry_button_double (GtkWidget	*widget,
			gpointer	data) {
  scaling_by_scale (image_list, 2.0, 2.0);
}

/*  (Ŭͤ) ******************************************* */
static void
normal_button_best (GtkWidget	*widget,
		    gpointer	data) {
  do_backup (image_list);    
  normalize_image (image_list, -1, -1);
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));
}

/*  (ꤷϰϤ) ************************************* */
static void
normal_button_apply (GtkWidget	*widget,
		     gpointer	parent) {
  GtkWidget	*widget_min;
  GtkWidget	*widget_max;
  gdouble	min, max;

  /* ͤϰ */  
#if 0
  widget_min = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_norm_min");
  widget_max = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_norm_max");
#else
  widget_min = G_GET_WIDGET (parent, "spin_norm_min");
  widget_max = G_GET_WIDGET (parent, "spin_norm_max");
#endif
  min = (gdouble)
    gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (widget_min));
  max = (gdouble)
    gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (widget_max));
  
  /* ꤷϰϤ */
  do_backup (image_list);  
  normalize_image (image_list, min, max);
  draw_image (image_list,
	      ti_get_current_width  (image_list),
	      ti_get_current_height (image_list));
}

/* ************************************************************************* *
 * ǥåȥɥǻѤؿ
 *    	(åסѥХåؿ)
 * ************************************************************************* */

/* åΰѹ  *************************************************** */
static void
crip_change_x (GtkWidget	*widget,
	       gpointer		parent) {
  GtkWidget	*widget_x;
  GtkWidget	*widget_w;
  gint		x, w;
#if 0
  widget_x = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_x");
  widget_w = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_width");
#else
  widget_x = G_GET_WIDGET (parent, "spin_crip_x");
  widget_w = G_GET_WIDGET (parent, "spin_crip_width");
#endif
  x = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_x));
  w = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_w));  

  if (x + w > ti_get_width (image_list)) {
    x = ti_get_width (image_list) - w;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_x), (gfloat) x);
  }
  crip_clear_area ();
#if 0
  gtk_object_set_data (GTK_OBJECT (image_window), "crip_x", (gpointer) x);
#else
  G_SET_PARAMETER (image_window, "crip_x", x);
#endif
  crip_draw_area ();
}

/* åΰѹ  *************************************************** */
static void
crip_change_y (GtkWidget	*widget,
	       gpointer		parent) {
  GtkWidget	*widget_y;
  GtkWidget	*widget_h;
  gint		y, h;
#if 0
  widget_y = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_y");
  widget_h = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_height");
#else
  widget_y = G_GET_WIDGET (parent, "spin_crip_y");
  widget_h = G_GET_WIDGET (parent, "spin_crip_height");
#endif
  y = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_y));  
  h = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_h));

  if (y + h > ti_get_height (image_list)) {
    y = ti_get_height (image_list) - h;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_y), (gfloat) y);
  }
  crip_clear_area ();
#if 0
  gtk_object_set_data (GTK_OBJECT (image_window), "crip_y", (gpointer) y);
#else
  G_SET_PARAMETER (image_window, "crip_y", y);
#endif
  crip_draw_area ();
}

/* åΰѹ  *************************************************** */
static void
crip_change_width (GtkWidget	*widget,
		   gpointer	parent) {
  GtkWidget	*widget_x;
  GtkWidget	*widget_w;
  gint		w, x;
#if 0
  widget_x = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_x");
  widget_w = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_width");
#else
  widget_x = G_GET_WIDGET (parent, "spin_crip_x");
  widget_w = G_GET_WIDGET (parent, "spin_crip_width");
#endif
  x = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_x));
  w = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_w));  

  if (x + w > ti_get_width (image_list)) {
    w = ti_get_width (image_list) - x;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_w), (gfloat) w);
  }
  crip_clear_area ();
#if 0
  gtk_object_set_data (GTK_OBJECT (image_window), "crip_w", (gpointer) w);
#else
  G_SET_PARAMETER (image_window, "crip_w", w);
#endif
  crip_draw_area ();
}

/* åΰѹ ⤵ ************************************************* */
static void
crip_change_height (GtkWidget	*widget,
		    gpointer	parent) {
  GtkWidget	*widget_y;
  GtkWidget	*widget_h;
  gint		y, h;
#if 0
  widget_y = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_y");
  widget_h = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_height");  
#else
  widget_y = G_GET_WIDGET (parent, "spin_crip_y");
  widget_h = G_GET_WIDGET (parent, "spin_crip_height");  
#endif
  y = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_y));  
  h = (gint) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_h));

  if (y + h > ti_get_height (image_list)) {
    h = ti_get_height (image_list) - y;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_h), (gfloat) h);
  }
  crip_clear_area ();
#if 0
  gtk_object_set_data (GTK_OBJECT (image_window), "crip_h", (gpointer) h);
#else
  G_SET_PARAMETER (image_window, "crip_h", h);
#endif
  crip_draw_area ();
}

/* åפμ¹ ********************************************************** */
static void
crip_button_apply (GtkWidget	*widget,
		   gpointer	parent) {
  crip_do_crip ();
}

/* ֥⡼ɳ ******************************************************** */
static void
grab_start (GtkWidget	*widget,
	    gpointer	parent) {
#if 0 
  if (gtk_toggle_button_get_active
      (GTK_TOGGLE_BUTTON (gtk_object_get_data (GTK_OBJECT (parent),
					       "check_hide_dialog")))) {
#else
    if (gtk_toggle_button_get_active
	(GTK_TOGGLE_BUTTON (G_GET_WIDGET (parent, "check_hide_dialog")))) {
#endif
    gtk_widget_hide (GTK_WIDGET (parent));
  }
  grab_do_grab ();
}

/* ************************************************************************* *
 * ǥåȥɥΥɥؿ
 * ************************************************************************* */

/* ************************************************************************* */
static GtkWidget*
tab_label_widget_new (const gchar	*label,
		      GtkWidget		*parent) {
  GtkWidget	*box;
  GtkWidget	*icon;
  GtkWidget	*widget;
  
  box  = gtk_hbox_new (FALSE, 0);
  icon = gtk_image_new_from_pixbuf (book_close);
  gtk_box_pack_start (GTK_BOX (box), icon, FALSE, TRUE, 0);
  gtk_misc_set_padding (GTK_MISC (icon), 5, 1);
  widget = gtk_label_new (label);
  gtk_box_pack_start (GTK_BOX (box), widget, FALSE, TRUE, 0);  
#if 0
  g_object_set_data (G_OBJECT (parent), "tab_icon", icon);
#else
  G_SET_WIDGET (parent, label, widget);
  G_SET_WIDGET (parent, "tab_icon", icon);
#endif
  return box;
}

/* ************************************************************************* */
static GtkWidget*
color_balance_widget_new (GtkWidget	*parent) {
  GtkWidget	*box;
  GtkWidget	*sbox;
  GtkWidget	*hbox;
  GtkWidget	*frame;
  GtkWidget	*canvas;  
  GtkWidget	*widget;
  GtkWidget	*button;
  GtkObject	*obj;
  gchar		buf[256];
  gint		n;

  /* ܥå */
  box = gtk_hbox_new (FALSE, 5);
  gtk_widget_show (box);
  {
    /* ե졼 */
    frame = gtk_frame_new (NULL);
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    G_SET_WIDGET (parent, "frame1_cb", frame);
    {
      /* Х */
      widget = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
      gtk_container_add (GTK_CONTAINER (frame), widget);
      G_SET_WIDGET (parent, "align1_cb", widget);
      {
	canvas = gtk_drawing_area_new ();
	gtk_widget_set_size_request (canvas, 160, 120);
	gtk_container_add (GTK_CONTAINER (widget), canvas);
	gtk_widget_set_events (canvas, GDK_EXPOSURE_MASK);
	G_SET_WIDGET (parent, "canvas", canvas);
      }
    }
    /* ܥå */
    sbox = gtk_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (box), sbox, FALSE, FALSE, 0);
    G_SET_WIDGET (parent, "vbox1_cb", sbox);    
    {
      /* ʿܥå */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "hbox1_cb", hbox);    
      {
	for (n = 0; n < 4; n++) {

	  /* ܥ */
	  button = gtk_toggle_button_new ();
	  g_signal_connect (G_OBJECT (button), "clicked",
			    G_CALLBACK (color_balance_channel),
			    (gpointer) parent);
	  sprintf (buf, "channel_button%d", n);
	  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
	  G_SET_WIDGET (parent, buf, button);
	  {
	    /* ե졼 */
	    frame = gtk_frame_new (NULL);
	    gtk_container_border_width (GTK_CONTAINER (frame), 2);
	    gtk_container_add (GTK_CONTAINER (button), frame);
	    G_SET_WIDGET (parent, "frame2_cb", frame);
	    {
	      /* Х */
	      widget = gtk_drawing_area_new ();
	      sprintf (buf, "draw_area%d", n);
	      gtk_widget_set_size_request (widget, 77, 77);
	      gtk_container_add (GTK_CONTAINER (frame), widget);
	      G_SET_WIDGET (parent, buf, widget);
	    }
	  }
	}
      }
      /* ѥ졼 */
      widget = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (sbox), widget, FALSE, FALSE, 5);
      G_SET_WIDGET (parent, "separator1_cb", widget);
       
      /* ʿܥå */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "hbox2_cb", hbox);
      {
	/* å */
	obj    = gtk_adjustment_new (256.0, 0.0, 1024.0, 1.0, 4.0, 0.0);      
	widget = gtk_hscale_new (GTK_ADJUSTMENT (obj));
	gtk_scale_set_digits (GTK_SCALE (widget), 0);
	gtk_range_set_update_policy (GTK_RANGE (widget),GTK_UPDATE_CONTINUOUS);
	g_signal_connect (G_OBJECT (obj), "value_changed",
			  G_CALLBACK (color_balance_gamma), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	G_SET_OBJECT (parent, "adj_gamma",   obj);
	G_SET_WIDGET (parent, "scale_gamma", widget);

	widget = gtk_icon_button_new_from_inline (stock_curve);
	g_signal_connect (G_OBJECT (widget), "clicked",
			  G_CALLBACK (color_balance_button_gamma), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	G_SET_WIDGET (parent, "button1_cb", widget);	
      }
      /* ʿܥå */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, TRUE, TRUE, 0);
      G_SET_WIDGET (parent, "hbox3_cb", hbox);
      {
	/* ֥饤ȥͥå */
	obj    = gtk_adjustment_new (256.0, 0.0, 1024.0, 1.0, 4.0, 0.0);
	widget = gtk_hscale_new (GTK_ADJUSTMENT (obj));
	gtk_scale_set_digits (GTK_SCALE (widget), 0);
	gtk_range_set_update_policy (GTK_RANGE (widget),GTK_UPDATE_CONTINUOUS);
	g_signal_connect (G_OBJECT (obj), "value_changed",
			  G_CALLBACK (color_balance_bright), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	G_SET_OBJECT (parent, "adj_bright",   obj);
	G_SET_WIDGET (parent, "scale_bright", widget);


	widget = gtk_icon_button_new_from_inline (stock_brightness);
	g_signal_connect (G_OBJECT (widget), "clicked",
			  G_CALLBACK (color_balance_button_bright), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	G_SET_WIDGET (parent, "button2_cb", widget);	
      }
      /* ʿܥå */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, TRUE, TRUE, 0);
      G_SET_WIDGET (parent, "hbox4_cb", hbox);
      {
	/* ȥ饹å */
	obj    = gtk_adjustment_new (256.0, 0.0, 1024.0, 1.0, 4.0, 0.0);
	widget = gtk_hscale_new (GTK_ADJUSTMENT (obj));
	gtk_scale_set_digits (GTK_SCALE (widget), 0);
	gtk_range_set_update_policy (GTK_RANGE (widget),GTK_UPDATE_CONTINUOUS);
	g_signal_connect (G_OBJECT (obj), "value_changed",
			  G_CALLBACK (color_balance_cont), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	G_SET_OBJECT (parent, "adj_cont",   obj);
	G_SET_WIDGET (parent, "scale_cont", widget);

	widget = gtk_icon_button_new_from_inline (stock_contrast);
	g_signal_connect (G_OBJECT (widget), "clicked",
			  G_CALLBACK (color_balance_button_cont), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	G_SET_WIDGET (parent, "button3_cb", widget);	
      }
    }
  }
  return box;
}
 
/* Ρȥ֥åΥڡ1 (顼Х) **************************** */
static void
notebook_color (GtkWidget	*parent,
		GtkWidget	*notebook) {
  GtkWidget	*label_box;
  GtkWidget	*box;
  GtkWidget	*frame;
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*widget;

  /* ܥå */
  box = gtk_hbox_new (FALSE, 0);
  label_box = tab_label_widget_new  (_("Color Balance"), box);
  gtk_widget_show_all (label_box);
  gtk_notebook_append_page_menu(GTK_NOTEBOOK (notebook), box, label_box, NULL);
  G_SET_WIDGET (parent, "box1_2", box);    
  {
    /* ե졼 */ 
    frame = gtk_frame_new (NULL); 
    gtk_container_add (GTK_CONTAINER (box), frame); 
    gtk_container_border_width (GTK_CONTAINER (frame), 2); 
    G_SET_WIDGET (parent, "frame1_2", frame);    
    {
      /* ľܥå */
      vbox = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), 2);      
      G_SET_WIDGET (parent, "vbox1_2", vbox);
    }
  }
  /* ľܥåؤΥѥå */
  {
    /* ʿܥå */
    widget = color_balance_widget_new (parent);
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
    G_SET_WIDGET (parent, "cb_widget_2", widget);    
    
    /* ѥ졼 */
    widget = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 3);
    G_SET_WIDGET (parent, "separator1_2", widget);    

    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    G_SET_WIDGET (parent, "hbox1_2", hbox);    
  }
  /* ʿܥåؤΥѥå */
  {
    widget =
      gtk_icon_button_new_from_inline_with_label (stock_reset_16,
						  _("Reset"),
						  GTK_ICON_BUTTON_TEXT_RIGHT,
						  5);
    g_signal_connect (G_OBJECT (widget), "clicked",
		      G_CALLBACK (color_balance_button_reset), NULL);
    gtk_widget_set_size_request (widget, 120, -1);
    gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
    G_SET_WIDGET (parent, "button1_2", widget);    
    
    widget = gtk_button_new_from_stock (GTK_STOCK_APPLY);
    g_signal_connect (G_OBJECT (widget), "clicked",
		      G_CALLBACK (color_balance_button_apply), NULL);
    gtk_widget_set_size_request (widget, 120, -1);    
    gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
    G_SET_WIDGET (parent, "button2_2", widget);    
  }
}
  
/* Ρȥ֥åΥڡ2 (ȥ) ******************************** */
static void
notebook_geometry (GtkWidget	*parent,
		   GtkWidget	*notebook) {
  GtkWidget	*label_box;
  GtkWidget	*box;
  GtkWidget	*frame;
  GtkWidget	*vbox1;
  GtkWidget	*vbox2;  
  GtkWidget	*hbox;
  GtkWidget	*widget;
  GtkObject	*obj;

  /* ܥå */
  box = gtk_vbox_new (FALSE, 0);
  label_box = tab_label_widget_new  (_("Geometry"), box);
  gtk_widget_show_all (label_box);
  gtk_notebook_append_page_menu(GTK_NOTEBOOK (notebook), box, label_box, NULL);
  G_SET_WIDGET (parent, "box_2", box);
  G_SET_WIDGET (parent, "label_box_2", label_box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (_("Size"));
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    G_SET_WIDGET (parent, "frame1_2", frame);
    {
      /* ľܥå */
      vbox1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox1);
      gtk_container_set_border_width (GTK_CONTAINER (vbox1), 2);
      G_SET_WIDGET (parent, "vbox1_2", vbox1);
    }
    /* ѥ졼 */
    widget = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box), widget, FALSE, FALSE, 5);
    G_SET_WIDGET (parent, "separator1_2", widget);    

    /* ե졼 */ 
    frame = gtk_frame_new (_("Normalization"));
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    G_SET_WIDGET (parent, "frame2_2", frame);
    {
      /* ľܥå */
      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox2);
      gtk_container_set_border_width (GTK_CONTAINER (vbox2), 2);
      G_SET_WIDGET (parent, "vbox2_2", vbox2);
    }
  }
  /* ľܥå1ؤΥѥå */
  {
    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 3);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    G_SET_WIDGET (parent, "hbox1_2", hbox);
    {
      gint	nw, nh;
      
      /* ߤβĴ٤ */
      nw = ti_get_width  (image_list);
      nh = ti_get_height (image_list);

      /* ٥ (Width) */
      widget = gtk_label_new (_("Width"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_WIDGET (parent, "label1_2", widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (nw, 1, 9999, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      g_signal_connect (G_OBJECT (widget), "key_press_event",
			G_CALLBACK (geometry_enter_width),
			(gpointer) parent);
      G_SET_OBJECT (parent, "adj_size_width", obj);
      G_SET_WIDGET (parent, "spin_size_width", widget);

      /* ٥ (Height) */      
      widget = gtk_label_new (_("Height"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_WIDGET (parent, "label2_2", widget);

      /* ԥܥ */      
      obj = gtk_adjustment_new (nh, 1, 9999, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      g_signal_connect (G_OBJECT (widget), "key_press_event",
			G_CALLBACK (geometry_enter_height),
			(gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_size_height", obj);
      G_SET_WIDGET (parent, "spin_size_height", widget);
    }
    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);    
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
    G_SET_WIDGET (parent, "hbox2_2", hbox);
    {
      /* åܥ */
      widget = gtk_check_button_new_with_label (_("Keep aspect"));
      g_signal_connect (G_OBJECT (widget), "toggled",
			G_CALLBACK (geometry_keep_aspect), NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "check_aspect", widget);

      /* ܥ */
      widget = gtk_button_new_from_stock (GTK_STOCK_APPLY);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_apply),
			(gpointer) parent);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "button1_2", widget);
    }
    /* ʿܥ */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
    G_SET_WIDGET (parent, "hbox3_2", hbox);
    {
      /* ܥ (Reset) */
      widget =
	gtk_icon_button_new_from_inline_with_label (stock_reset_16,
						    _("Reset"),
						    GTK_ICON_BUTTON_TEXT_RIGHT,
						    5);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_reset),
			(gpointer) parent);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "button_size_org", widget);

      /* ܥ (x 2) */
      widget =
	gtk_icon_button_new_from_inline_with_label (stock_size_double,
						    _("x 2"),
						    GTK_ICON_BUTTON_TEXT_RIGHT,
						    5);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_double), NULL);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "button_size_double", widget);

      /* ܥ (+10%) */
      widget =
	gtk_icon_button_new_from_inline_with_label (stock_size_up,
						    _("+10%"),
						    GTK_ICON_BUTTON_TEXT_RIGHT,
						    5);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_up), NULL);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "button_size_up", widget);

      /* ܥ (-10%) */
      widget =
	gtk_icon_button_new_from_inline_with_label (stock_size_down,
						    _("-10%"),
						    GTK_ICON_BUTTON_TEXT_RIGHT,
						    5);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_down), NULL);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "button_size_down", widget);

      /* ܥ (x 1/2)  */
      widget =
	gtk_icon_button_new_from_inline_with_label (stock_size_half,
						    _("x 1/2"),
						    GTK_ICON_BUTTON_TEXT_RIGHT,
						    5);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (geometry_button_half), NULL);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "button_size_half", widget);
    }    
  }
  /* ľܥå2ؤΥѥå */
  {
    /* ʿܥå */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox2), hbox, TRUE, TRUE, 0);
    G_SET_WIDGET (parent, "hbox4_2", hbox);    
    {
      /* ߤβ˹碌ϰϤ */
      gdouble	min = 0, max = 255;
    
      /* ٥ (Min Value) */
      widget = gtk_label_new (_("Min Value"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "label3_2", widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (min, min, max, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_norm_min", obj);
      G_SET_WIDGET (parent, "spin_norm_min", widget);

      /* ٥ (Max Value) */      
      widget = gtk_label_new (_("Max Value"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "label4_2", widget);

      /* ԥܥ */      
      obj = gtk_adjustment_new (max, min, max, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_norm_max", obj);
      G_SET_WIDGET (parent, "spin_norm_max", widget);
    }
    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);
    gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, TRUE, 0);
    G_SET_WIDGET (parent, "hbox5_2", hbox);    
    {
      /* ܥ (Apply) */            
      widget = gtk_button_new_from_stock (GTK_STOCK_APPLY);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (normal_button_apply), parent);
      gtk_widget_set_size_request (widget, 120, -1);      
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "button2_2", widget);    

      /* ܥ (Best) */
      widget =
	gtk_icon_button_new_from_inline_with_label (stock_level,
						    _("Best"), 
						    GTK_ICON_BUTTON_TEXT_RIGHT,
						    5);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (normal_button_best), NULL);
      gtk_widget_set_size_request (widget, 120, -1);      
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "button3_2", widget);    
    }
  }
}

/* Ρȥ֥åΥڡ3 (å&) *************************** */
static void
notebook_crip_grab (GtkWidget	*parent,
		    GtkWidget	*notebook) {
  GtkWidget	*label_box;
  GtkWidget	*box;
  GtkWidget	*frame;
  GtkWidget	*vbox1;
  GtkWidget	*vbox2;
  GtkWidget	*hbox;
  GtkWidget	*widget;
  GtkObject	*obj;
  
  /* ܥå */
  box = gtk_vbox_new (FALSE, 0);
  label_box = tab_label_widget_new  (_("Cripping & Grab"), box);
  gtk_widget_show_all (label_box);
  gtk_notebook_append_page_menu(GTK_NOTEBOOK (notebook), box, label_box, NULL);
  G_SET_WIDGET (parent, "box_3", box);
  G_SET_WIDGET (parent, "label_box_3", label_box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (_("Cripping"));
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    G_SET_WIDGET (parent, "frame_3", frame);
    {
      /* ľܥå */
      vbox1 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox1);
      gtk_container_set_border_width (GTK_CONTAINER (vbox1), 2);
      G_SET_WIDGET (parent, "vbox1_3", vbox1);
    }
    /* ѥ졼 */
    widget = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box), widget, FALSE, FALSE, 5);
    G_SET_WIDGET (parent, "separator_3", widget);
    
    /* ե졼 */ 
    frame = gtk_frame_new (_("Grab"));
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    G_SET_WIDGET (parent, "frame2_3", frame);
    {
      /* ľܥå */
      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_container_add (GTK_CONTAINER (frame), vbox2);
      gtk_container_set_border_width (GTK_CONTAINER (vbox2), 2);
      G_SET_WIDGET (parent, "vbox2_3", vbox2);
    }
  }
  /* ľܥå1ؤΥѥå */
  {
    /* ʿܥå */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    G_SET_WIDGET (parent, "hbox1_3", hbox);
    {
      gint	w, h;
      
      /* γ */
      w = ti_get_width  (image_list);
      h = ti_get_height (image_list);
      
      /* ٥ X */
      widget = gtk_label_new (_("X"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "label1_3", widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (0, 0, w, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      g_signal_connect (G_OBJECT (obj), "value_changed",
			G_CALLBACK (crip_change_x), (gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_crip_x", obj);
      G_SET_WIDGET (parent, "spin_crip_x", widget);

      /* ٥ Y */      
      widget = gtk_label_new (_("Y"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "label2_3", widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (0, 0, h, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      g_signal_connect (G_OBJECT (obj), "value_changed",
			G_CALLBACK (crip_change_y), (gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_crip_y", obj);
      G_SET_WIDGET (parent, "spin_crip_y", widget);
    }
    /* ʿܥå */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    G_SET_WIDGET (parent, "hbox2_3", hbox);
    {
      gint	w, h;
      
      /* γ */
      w = ti_get_width  (image_list);
      h = ti_get_height (image_list);

      /* ٥ Width */            
      widget = gtk_label_new (_("Width"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "label3_3", widget);
      
      /* ԥܥ */
      obj = gtk_adjustment_new (0, 0, w, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      g_signal_connect (G_OBJECT (obj), "value_changed",
			G_CALLBACK (crip_change_width),
			(gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_crip_width", obj);
      G_SET_WIDGET (parent, "spin_crip_width", widget);

      /* ٥ Height */                  
      widget = gtk_label_new (_("Height"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "label4_3", widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (0, 0, h, 1, 10, 10);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      g_signal_connect (G_OBJECT (obj), "value_changed",
			G_CALLBACK (crip_change_height),
			(gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      G_SET_OBJECT (parent, "adj_crip_height", obj);
      G_SET_WIDGET (parent, "spin_crip_height", widget);
    }
    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);        
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
    G_SET_WIDGET (parent, "hbox3_3", hbox);
    {
      /* ܥ Apply */
      widget = gtk_button_new_from_stock (GTK_STOCK_APPLY);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (crip_button_apply),
			(gpointer) parent);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "button1_3", widget);
    }
  }
  /* ľܥå2ؤΥѥå */
  {
    /* ٥ */
    widget = gtk_label_new (_("Left button grabs a rectanguler area,\n"
			      "Middle butotn grabs a window,\n"
			      "Right button cancels."));
    gtk_box_pack_start (GTK_BOX (vbox2), widget, TRUE, TRUE, 3);
    gtk_label_set_line_wrap (GTK_LABEL (widget), TRUE);
    G_SET_WIDGET (parent, "label5_3", widget);

    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);    
    gtk_box_pack_end (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
    G_SET_WIDGET (parent, "hbox5_3", hbox);
    {
      widget = gtk_check_button_new_with_label (_("Hide this dialog"));
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "check_hide_dialog", widget);

      widget =
	gtk_icon_button_new_from_inline_with_label (stock_camera,
						    _("Grab Start"),
						    GTK_ICON_BUTTON_TEXT_RIGHT,
						    5);
      g_signal_connect (G_OBJECT (widget), "clicked",
			G_CALLBACK (grab_start), (gpointer) parent);
      gtk_widget_set_size_request (widget, 120, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      G_SET_WIDGET (parent, "grab_start", widget);
    }
  }
}

/* ǥåȥ ********************************************** */
GtkWidget*
edit_window_new (void) {
  GtkWidget	*window;
  GtkWidget	*notebook;
  GtkWidget	*button;
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*widget;

  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass  (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");
  gtk_window_set_title    (GTK_WINDOW (window), _("Teoeyes Image Editor"));
  gtk_window_set_resizable(GTK_WINDOW (window), FALSE);
  gtk_window_set_icon	  (GTK_WINDOW (window), te_icon);  
  g_signal_connect (G_OBJECT (window),
		    "destroy", G_CALLBACK (cb_destroy), NULL);
  g_signal_connect (G_OBJECT (window),
		    "delete_event", G_CALLBACK (cb_destroy), NULL);

  /* ե졼 */
  widget = gtk_frame_new (NULL);
  gtk_container_set_border_width (GTK_CONTAINER (widget), 2);
  gtk_container_add (GTK_CONTAINER (window), widget);
  G_SET_WIDGET (window, "frame", widget);
  {
    /* ľܥå */
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (widget), vbox);
    G_SET_WIDGET (window, "vbox", vbox);
  }
  /* ʿܥåؤΥѥå */
  {
    /* Ρȥ֥å */
    notebook = gtk_notebook_new ();
    g_signal_connect (G_OBJECT (notebook),
		      "switch_page", G_CALLBACK (cb_page_switch), NULL);
    gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
    gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
    G_SET_WIDGET (window, "notebook", notebook);

    icon_new (window);
    {
      notebook_color    (window, notebook);
      notebook_geometry (window, notebook);
      notebook_crip_grab(window, notebook);
    }
    /* ѥ졼 */
    widget = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, TRUE, 5);
    G_SET_WIDGET (window, "separator", widget);

    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (vbox), 2);      
    G_SET_WIDGET (window, "hbox", hbox);
    {
      button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
      g_signal_connect (G_OBJECT (button),
			"clicked", G_CALLBACK (cb_destroy), window);
      gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
      gtk_widget_set_size_request (button, 120, -1);
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT); 
      gtk_widget_grab_default (button);
      G_SET_WIDGET (window, "button", button);
    }
  }
  return window;
}

/* ************************************************************************* */
void
edit_draw_preview (void) {
  GtkWidget	*canvas;
  GdkWindow	*window;
  GdkPixbuf	*back, *pbuf;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  static gint	pw = 160;	/* ץӥ塼κ */
  static gint	ph = 120;	/* ץӥ塼κ⤵ */
  gint		w, h;
  
  canvas = get_widget (edit_window, "canvas");
  if (!canvas) return;
  window = canvas->window;
  
  if ((w = ti_get_width (image_list)) > pw ||
      (h = ti_get_height(image_list)) > ph) {
    w = pw;
    h = (w * ti_get_height (image_list)) / ti_get_width (image_list);
    if (h == 0) h = 2;
    if (h > ph) {
      h = ph;
      w = (h * ti_get_width (image_list)) / ti_get_height (image_list);
      if (w == 0) w = 2;      
    }
  }
  gtk_widget_set_size_request (canvas, w, h);

  pbuf = gdk_pixbuf_scale_simple (ti_get_pixbuf (image_list), w, h,
				  GDK_INTERP_TILES);
  gdk_pixbuf_apply_modifiers_to_rgb (pbuf, ti_get_mod (image_list), 0);
  gdk_window_set_back_pixmap (window, NULL, FALSE);
  back = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, w, h);
  gdk_pixbuf_composite_color (pbuf, back, 0, 0, w, h, 0, 0, 1.0, 1.0,
			      GDK_INTERP_TILES,
			      255, 0, 0, 8, 0xaaaaaa, 0x555555);
  /* ԥåޥåפ */
  gdk_pixbuf_render_pixmap_and_mask (back, &pixmap, &mask, 255);

  /* ɥؤ */
  gdk_window_set_back_pixmap (window, pixmap, FALSE);
  gdk_window_clear (window);
  gdk_window_shape_combine_mask (window, mask, 0, 0);
  gdk_flush ();
  
  gdk_pixbuf_unref (pbuf);
  gdk_pixbuf_unref (back);
  gdk_pixmap_unref (pixmap);
  if (mask) gdk_bitmap_unref (mask);
}

/* ******************************************************* End of edit.c *** */
