/* ************************************************************** open.c *** *
 * Υץ
 *
 * Copyright (C) 2002-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                    Time-stamp: <03/05/02 23:25:16 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "image_io.h"
#include "image_window.h"
#include "open.h"

#include "gtkcustomiconfilesel.h"

/* ************************************************************************* */
gboolean
teoeyes_open_image_on_same_window (const gchar	*filename) {
  GList	*list;

  /* ȲΥ */

  /* ˥ꥹȤ˴ޤޤƤϤΥǡɽ */
  list = g_list_first (image_list);
  while (list) {
    if (strcmp (ti_get_file_path (list), filename) == 0) {
      /* ɽ */
      image_list = ti_get_list_from_path (image_list, filename);
      if (!ti_get_pixbuf (image_list)) {
	teoeyes_image_load (ti_get_image (image_list), 0, to->min, to->max);
      }
      gtk_widget_set_size_request (G_GET_WIDGET (image_window, "canvas"),
				   ti_get_width  (image_list),
				   ti_get_height (image_list));
      return TRUE;
    } else {
      list = g_list_next (list);
    }
  }
  /* ꥹȤɲ */
  if (!teoeyes_image_add_list (g_list_last (image_list), filename, TRUE)) {
    return FALSE;
  }
  /* ɽ */
  image_list = g_list_last (image_list);
  teoeyes_image_load (ti_get_image (image_list), 0, to->min, to->max);
  gtk_widget_set_size_request (G_GET_WIDGET (image_window, "canvas"),
			       ti_get_width  (image_list),
			       ti_get_height (image_list));
  
  return TRUE;
}

/* ̤Υɥǳ **************************************** */
gboolean
teoeyes_open_image_on_new_window (const gchar	*filename) {
  int	pid;

  if (filename) {
    if ((pid = fork ()) == 0) {
      if (execlp (PACKAGE, PACKAGE, filename, (char *) 0) == -1) {
	perror (PACKAGE);
	return FALSE;
      }
    }
  } else {
    if ((pid = fork ()) == 0) {
      if (execlp (PACKAGE, PACKAGE, (char *) 0) == -1) {
	perror (PACKAGE);
	return FALSE;
      }
    }
  }
  return TRUE;
}

/* OKܥ󤬲줿ν ********************************************** */
static void
cb_dialog_ok (GtkWidget			*widget,
	      GtkCustomIconFileSel	*dialog) {
  gboolean	flag;
  gchar		*filename, *real_path;
  
  /* ɥ򳫤ɤĴ٤ */
  flag =
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON 
				  (gtk_object_get_data (GTK_OBJECT (dialog),
							"checkbutton")));
  /* ե̾ */
  filename = (gchar *) 
    gtk_custom_icon_file_selection_get_filename (GTK_CUSTOM_ICON_FILESEL
						 (dialog));
  real_path = g_filename_from_utf8 (filename, -1, NULL, NULL, NULL);
  if (!real_path || strcmp (real_path, "") == 0 ||
      !g_file_exist (real_path) || g_dir_is (real_path)) return;  

  /* ꤵ줿ե뤬бե뤫ɤĴ٤ */
  if (!check_image_supported (real_path)) return;

  /* 򳫤 */
  if (flag) {
    teoeyes_open_image_on_new_window (real_path);
  } else {
    teoeyes_open_image_on_same_window (real_path);
  }
  g_free (real_path);
}

/* Cancelܥ󤬲줿ν ****************************************** */
static void 
cb_dialog_cancel (GtkWidget	*widget,
		  GtkWidget	*dialog) {
  gtk_widget_hide (dialog);
}

/* ************************************************************************* */
static void
cb_select_item (GtkFileList		*flist,
		GtkFileListItem		*icon,
		GdkEventButton		*ev,
		gpointer		data) {
  if (ev->type == GDK_2BUTTON_PRESS) {
    cb_dialog_ok (NULL, GTK_CUSTOM_ICON_FILESEL (data));
  }
}

/* ************************************************************************* */
static void
open_dialog_destroy (GtkWidget	*widget,
		     gpointer	data) { 
  gtk_widget_hide (widget);
}

/* ץ ******************************************** */
GtkWidget*
open_dialog_new (const gchar	*title) {
  GtkWidget	*dialog;
  GtkWidget	*widget;

  /*  */
  dialog = gtk_custom_icon_file_selection_new (title);
  gtk_window_set_icon (GTK_WINDOW (dialog), te_icon);
  g_signal_connect (G_OBJECT (dialog), "destroy",
		    G_CALLBACK (open_dialog_destroy), NULL);
  g_signal_connect (G_OBJECT (dialog), "delete_event",
		    G_CALLBACK (open_dialog_destroy), NULL);
  
  /* åܥɲ */
  widget = gtk_check_button_new_with_label (_("Open on a new window"));
#if 0
  gtk_object_set_data (GTK_OBJECT (dialog), "checkbutton", widget);
#else
  G_SET_WIDGET (dialog, "checkbutton", widget);
#endif
  gtk_box_pack_start (GTK_BOX
		      (GTK_CUSTOM_ICON_FILESEL (dialog)->custom_box[6]),
		      widget, FALSE, FALSE, 0);
  gtk_widget_show (GTK_CUSTOM_ICON_FILESEL (dialog)->custom_box[6]);
  
  /* ٥Ȥ */
  g_signal_connect (G_OBJECT (GTK_CUSTOM_ICON_FILESEL (dialog)->ok_button),
		    "clicked", G_CALLBACK (cb_dialog_ok), dialog);
  g_signal_connect (G_OBJECT (GTK_CUSTOM_ICON_FILESEL (dialog)->cancel_button),
		    "clicked", G_CALLBACK (cb_dialog_cancel), dialog);
  g_signal_connect (G_OBJECT (GTK_CUSTOM_ICON_FILESEL (dialog)->file_list),
		    "select_icon", G_CALLBACK (cb_select_item), dialog);
  return dialog;
}

/* ******************************************************* End of open.c *** */
