/* ******************************************************** pixel_info.c *** *
 * ɽؿ
 *
 * Copyright (C) 1998-2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/02/03 22:12:51 sugaya>
 * ************************************************************************* */
#include <teo.h>
#include "teoeyes.h"
#include "pixel_info.h"
#include "teo_pixel.h"

/* ꤷβͤɽ ******************************************** */
void
pixel_window_show (gint		x,
		   gint		y,
		   gint		type,
		   Display	*dsp,
		   guint32	time) {
  GtkWidget	*label;
  gchar		info[MAX_STRING_MDL_LINE];  
  static gchar	*buffer = NULL;
  gint		wx, wy, w, h, d, n;
  gdouble	pixel[3];

  /* ͤγ */
  for (n = 0; n < 3; n++) pixel[n] = 0;
  if (type == PIXEL_TYPE_CURRENT || !ti_get_original_data (image_list)) {
    for (n = 0; n < 3; n++) {
      pixel[n] = (gdouble) ti_get_pixel (image_list, x, y, n);
    }
  } else {
    for (n = 0; n < 3; n++) {
      pixel[n] = (gdouble)
	ti_get_pixel_from_original_data (image_list, x, y, n);
    }    
  }
  /* ɽѤΥ٥ */
  if (type == PIXEL_TYPE_CURRENT || !ti_get_original_data (image_list) ||
      ((ti_get_original_data (image_list)) &&
       ti_get_type (image_list) != TI_PIXEL_FLOAT)) {
    sprintf (info, "(%4d, %4d) %ld : %ld : %ld", 
	     x + ti_get_xoffset (image_list),
	     y + ti_get_yoffset (image_list),
	     (glong) pixel[0], (glong) pixel[1], (glong) pixel[2]);
  } else {
    sprintf (info, "(%4d, %4d) %.8e : %.8e : %.8e",
	     x + ti_get_xoffset (image_list),
	     y + ti_get_yoffset (image_list),
	     pixel[0], pixel[1], pixel[2]);
  }
  /* XХåեؤϿ */
  if (buffer) g_free (buffer);
  buffer = g_strconcat (info, "\n", NULL);
  XStoreBytes (dsp, buffer, strlen (buffer));
  gtk_selection_owner_set (GTK_WIDGET (gtk_object_get_data
				       (GTK_OBJECT (image_window), "canvas")),
			   GDK_SELECTION_PRIMARY, time);

  /* ͤɽ */
  label = G_GET_WIDGET (pixel_window, "label");
  gtk_entry_set_text (GTK_ENTRY (label), info);
  gdk_window_get_geometry     (image_window->window, &wx, &wy, &w, &h, &d);
  gdk_window_get_origin       (image_window->window, &wx, &wy);
  gtk_widget_set_size_request (pixel_window, strlen (buffer) * 8, 20);
  gtk_widget_set_uposition    (pixel_window, wx, wy + h + 7);
}

/* ɽɥɽ ******************************************** */
void
pixel_window_hide (GtkWidget		*widget,
		   GdkEventButton	*ev,
		   gpointer		data) {
  /*ޥαܥǥɥ򱣤 */
  if (ev->button == MOUSE_BUTTON_RIGHT) gtk_widget_hide (widget);
}

/* ɽɥ ********************************************** */
GtkWidget*
pixel_window_new (void) {
  GtkWidget	*window;
  GtkWidget	*label;

  /* ɽɥ */
  window = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_set_events (window, GDK_BUTTON_PRESS_MASK);
  g_signal_connect (G_OBJECT (window), "button_press_event",
		    G_CALLBACK (pixel_window_hide), NULL);

  /* ܡ2ԥ  */
  gtk_container_set_border_width (GTK_CONTAINER (window), 2);

  /* ɽѥȥ */
  label= gtk_entry_new ();
  G_SET_WIDGET (window, "label", label);
  gtk_entry_set_editable (GTK_ENTRY (label), FALSE);
  gtk_container_add (GTK_CONTAINER (window), label);

  return window;
}

/* ************************************************* End of pixel_info.c *** */
