/* ***************************************** gnome-file-icon-list-item.h *** *
 * GnomeFileIconListItem إåե
 *
 * Copyright (C) 2003 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/02/18 20:12:53 sugaya>
 * ************************************************************************* */
/*
 * Copyright (C) 1998, 1999, 2000, 2001 Free Software Foundation
 * Copyright (C) 2001 Anders Carlsson
 * All rights reserved.
 *
 * This file is part of the Gnome Library.
 *
 * The Gnome Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The Gnome Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Anders Carlsson <andersca@gnu.org>
 *
 * Based on the GNOME 1.0 icon item by Miguel de Icaza and Federico Mena.
 */

#ifndef _GNOME_FILE_ICON_TEXT_ITEM_H_
#define _GNOME_FILE_ICON_TEXT_ITEM_H_

#include <libgnomecanvas/gnome-canvas.h>
#include <gtk/gtkeditable.h>
#include <gtk/gtkentry.h>

G_BEGIN_DECLS

typedef struct _GnomeFileIconTextItem		GnomeFileIconTextItem;
typedef struct _GnomeFileIconTextItemClass	GnomeFileIconTextItemClass;
typedef struct _GnomeFileIconTextItemPrivate 	GnomeFileIconTextItemPrivate;

#define GNOME_TYPE_FILE_ICON_TEXT_ITEM            (gnome_file_icon_text_item_get_type ())
#define GNOME_FILE_ICON_TEXT_ITEM(obj)            (GTK_CHECK_CAST ((obj), GNOME_TYPE_FILE_ICON_TEXT_ITEM, GnomeFileIconTextItem))
#define GNOME_FILE_ICON_TEXT_ITEM_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GNOME_TYPE_FILE_ICON_TEXT_ITEM, GnomeFileIconTextItemClass))
#define GNOME_IS_FILE_ICON_TEXT_ITEM(obj)         (GTK_CHECK_TYPE ((obj), GNOME_TYPE_FILE_ICON_TEXT_ITEM))
#define GNOME_IS_FILE_ICON_TEXT_ITEM_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_FILE_ICON_TEXT_ITEM))
#define GNOME_FILE_ICON_TEXT_ITEM_GET_CLASS(obj)  (GTK_CHECK_GET_CLASS ((obj), GNOME_TYPE_FILE_ICON_TEXT_ITEM, GnomeFileIconTextItemClass))

struct _GnomeFileIconTextItem {
	GnomeCanvasItem parent_instance;

	/* Size and maximum allowed width */
	int x, y;
	int width;

	/* Font name */
	char *fontname;

	/* Actual text */
	char *text;
        char *actual_text;
  
	/* Whether the text is being edited */
	unsigned int editing : 1;

	/* Whether the text item is selected */
	unsigned int selected : 1;

	/* Whether the text item is focused */
	unsigned int focused : 1;
	
	/* Whether the text is editable */
	unsigned int is_editable : 1;

	/* Whether the text is allocated by us (FALSE if allocated by the client) */
	unsigned int is_text_allocated : 1;

	GnomeFileIconTextItemPrivate *_priv;
};

struct _GnomeFileIconTextItemClass {
	GnomeCanvasItemClass parent_class;

	/* Signals we emit */
	gboolean  (* text_changed) (GnomeFileIconTextItem *iti);
	void (* height_changed)    (GnomeFileIconTextItem *iti);
	void (* width_changed)     (GnomeFileIconTextItem *iti);
	void (* editing_started)   (GnomeFileIconTextItem *iti);
	void (* editing_stopped)   (GnomeFileIconTextItem *iti);
	void (* selection_started) (GnomeFileIconTextItem *iti);
	void (* selection_stopped) (GnomeFileIconTextItem *iti);
	
	/* Virtual functions */
	GtkEntry* (* create_entry)  (GnomeFileIconTextItem *iti);

        /* Padding for possible expansion */
	gpointer padding1;
};

GType        gnome_file_icon_text_item_get_type      (void) G_GNUC_CONST;

void         gnome_file_icon_text_item_configure     (GnomeFileIconTextItem *iti,
						 int                x,
						 int                y,
						 int                width,
						 const char        *fontname,
						 const char        *text,
						 gboolean           is_editable,
						 gboolean           is_static);

void         gnome_file_icon_text_item_setxy         (GnomeFileIconTextItem *iti,
						 int                x,
						 int                y);

void         gnome_file_icon_text_item_select        (GnomeFileIconTextItem *iti,
						 gboolean                sel);

void         gnome_file_icon_text_item_focus         (GnomeFileIconTextItem *iti,
						 gboolean                focused);

const gchar  *gnome_file_icon_text_item_get_text      (GnomeFileIconTextItem *iti);

void         gnome_file_icon_text_item_start_editing (GnomeFileIconTextItem *iti);

void         gnome_file_icon_text_item_stop_editing  (GnomeFileIconTextItem *iti,
						 gboolean           accept);

GtkEditable *gnome_file_icon_text_item_get_editable  (GnomeFileIconTextItem *iti);




G_END_DECLS

#endif /* _GNOME_FILE_ICON_TEXT_ITEM_H_ */

/* ***************************************** gnome-file-icon-list-item.h *** */
