/* ************************************************** libteoeyesplugin.c *** *
 * This library is a auxiliary library for teoeyes-plugin programming.
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-20 23:37:10 sugaya>
 * ************************************************************************* */
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <locale.h>
#include "intl.h"
#include "teoeyesplugin.h"

#define		WINDOW_WIDTH	220
#define		WINDOW_HEIGHT	270
#define		CANVAS_SIZE	200

/* ************************************************************************* */
static void 	draw_dialog_image	(GtkWidget	*canvas,
					 TEOIMAGE	*img);
static void	callback_adj 		(GtkWidget	*widget,
					 GtkSpinButton	*spin);
static void	callback_spin		(GtkWidget	*widget,
					 gpointer	data);
static void	callback_preview 	(void);
static void	callback_apply		(void);
static void	callback_cancel 	(void);

/* ************************************************************************* */
static void 
draw_dialog_image (GtkWidget	*canvas,
		   TEOIMAGE	*img) {
  GdkPixbuf	*back, *pbuf;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  int		w, h, cw, ch;

  gdk_window_set_back_pixmap (canvas->window, NULL, FALSE);
  w = TeoWidth (img);
  h = TeoHeight(img);

  /* $BIA2hMQ%G!<%?$N@8@.(B */
  back = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, w, h);
  pbuf = teo2gdk_pixbuf_new_from_teoimage (img, 0, 0,
					   (TeoPlane (img) == 4) ? 1 : 0);
  /* $BIA2h2hA|$N@8@.(B */
  gdk_pixbuf_composite_color (pbuf, back, 0, 0, w, h, 0, 0, 1.0, 1.0,
			      GDK_INTERP_TILES, 255, 0, 0, 16,
			      0xaaaaaa, 0x555555);
  /* $B%T%C%/%9%^%C%W$N@8@.(B */
  gdk_pixbuf_render_pixmap_and_mask (back, &pixmap, &mask, 255);

  /* $B%&%#%s%I%&$X$NIA2h(B */
  gdk_window_set_back_pixmap (canvas->window, pixmap, FALSE);
  gdk_window_clear (canvas->window);
  gdk_window_shape_combine_mask (canvas->window, mask, 0, 0);
  gdk_flush ();

  gdk_pixbuf_unref (back);
  gdk_pixbuf_unref (pbuf);
  gdk_pixmap_unref (pixmap);
  
  gtk_widget_set_usize (canvas, w, h);
}

/* ************************************************************************* */
static void
callback_adj (GtkWidget		*widget,
	      GtkSpinButton	*spin) {
  int	val;

  val = (int) db->adjuster->value;
  gtk_spin_button_set_value (spin, val);
  if (db->action == ACTION_INTERACTIVE) callback_preview ();
}

/* ************************************************************************* */
static void
callback_spin (GtkWidget	*widget,
	       gpointer		data) {
  int	val;
  char	buf[64];

  val = (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (db->spinbutton));
  
  if (val < (int) db->adjuster->lower) {
    val = (int) db->adjuster->lower;
    sprintf (buf, "%d", val);
    gtk_entry_set_text (GTK_ENTRY (widget), buf);
  }
  if (val > (int) (db->adjuster->upper - db->adjuster->page_increment)) {
    val = (int) (db->adjuster->upper - db->adjuster->page_increment);
    sprintf (buf, "%d", val);
    gtk_entry_set_text (GTK_ENTRY (widget), buf);
  }
  if (db->action == ACTION_INTERACTIVE) {
    plugin_preview_image (db->src_img, db->work_img, (double) val);
    draw_dialog_image (db->canvas, db->work_img);
  }
}

/* ************************************************************************* */
static void
callback_preview (void) {
  plugin_preview_image (db->src_img,
			db->work_img,
			(double) gtk_spin_button_get_value_as_int
			(GTK_SPIN_BUTTON (db->spinbutton)));
  draw_dialog_image (db->canvas, db->work_img);
}

/* ************************************************************************* */
static void
callback_apply (void) {
  plugin_preview_image (db->src_img,
			db->dst_img,
			(double) gtk_spin_button_get_value_as_int
			(GTK_SPIN_BUTTON (db->spinbutton)));
  draw_dialog_image (db->canvas, db->dst_img);

  TeoFreeImage (db->src_img);
  TeoFreeImage (db->work_img);
  
  gtk_grab_remove (db->window);
  gtk_widget_destroy (db->window);
  gtk_main_quit ();
}

/* ************************************************************************* */
static void
callback_cancel (void) {
  gtk_grab_remove (db->window);
  gtk_widget_destroy (db->window);
  gtk_main_quit ();  
}

/* ************************************************************************* */
void
plugin_progressbar_update (double	val) {
  gtk_progress_bar_update (GTK_PROGRESS_BAR (db->progressbar), val);
  while (gtk_events_pending ()) gtk_main_iteration ();
}

/* ************************************************************************* */
void
plugin_dialog_new (char	*title, 
		   void	(*func) (TEOIMAGE	*src,
				 TEOIMAGE	*dst,
				 double		param),
		   TEOIMAGE	*src_img,
		   TEOIMAGE	*dst_img,		    
		   char		*label,
		   double	min,
		   double	max, 
		   double 	step,
		   double 	page,
		   int		use_progressbar,
		   int		action) {
  GtkWidget	*obj;		
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*alignment;
  GtkWidget	*scrolledwindow;
  unsigned char	*src_ptr, *dst_ptr;
  int		n;
  
  plugin_preview_image = func;
  db = (PluginDialog *) malloc (sizeof (PluginDialog));
  db->action = action;

  /* $B%&%#%s%I%&$N@8@.(B */
  db->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (db->window),
			  "teoeyes", "Teo Image Viewer");
  gtk_window_set_title (GTK_WINDOW (db->window), title);
  if (use_progressbar) {
    gtk_widget_set_usize (db->window, WINDOW_WIDTH, WINDOW_HEIGHT+20);
  } else {
    gtk_widget_set_usize (db->window, WINDOW_WIDTH, WINDOW_HEIGHT);
  }
  gtk_window_set_policy (GTK_WINDOW (db->window), FALSE, FALSE, FALSE);
  gtk_widget_show (db->window);
  {
    /* $B%S%e!<%]!<%H$N@8@.(B */
    obj = gtk_viewport_new (NULL, NULL);
    gtk_widget_show (obj);
    gtk_container_add (GTK_CONTAINER (db->window), obj);
    gtk_container_set_border_width (GTK_CONTAINER (obj), 2);
    {
      vbox = gtk_vbox_new (FALSE, 0);
      gtk_widget_show (vbox);
      gtk_container_add (GTK_CONTAINER (obj), vbox);
      {
	/* $B%9%/%m!<%k%&%#%s%I%&(B */
	scrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow),
					GTK_POLICY_AUTOMATIC,
					GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrolledwindow);
	gtk_box_pack_start (GTK_BOX (vbox), scrolledwindow, TRUE, TRUE, 0);
	{
	  /* $B%"%i%$%s%a%s%H$N@8@.(B */
	  alignment = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
	  gtk_widget_show (alignment);
	  gtk_scrolled_window_add_with_viewport
	    (GTK_SCROLLED_WINDOW (scrolledwindow), alignment);

	  /* $B%-%c%s%P%9$N@8@.(B */
	  db->canvas = gtk_drawing_area_new ();
	  gtk_widget_show (db->canvas);
	  gtk_container_add (GTK_CONTAINER (alignment), db->canvas);
	  gtk_widget_set_usize (GTK_WIDGET (db->canvas),
				CANVAS_SIZE, CANVAS_SIZE);
	}
	hbox = gtk_hbox_new (FALSE, 3);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	{
	  /* $B%i%Y%k(B */
	  obj = gtk_label_new (label);
	  gtk_widget_show (obj);
	  gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);

	  /* $B%9%T%s%\%?%s$N@8@.(B */
	  db->adjuster
	    = GTK_ADJUSTMENT (gtk_adjustment_new (min, min,
						  max, step, page, page));
	  db->spinbutton =
	    gtk_spin_button_new (db->adjuster, 1, 0);
	  gtk_signal_connect (GTK_OBJECT (db->spinbutton), "activate",
			      GTK_SIGNAL_FUNC (callback_spin), NULL);
	  gtk_signal_connect (GTK_OBJECT (db->adjuster), "value_changed",
			      GTK_SIGNAL_FUNC (callback_adj),
			      (gpointer) db->spinbutton);
	  gtk_box_pack_start (GTK_BOX (hbox), db->spinbutton, TRUE, TRUE, 0);
	  gtk_widget_show (db->spinbutton);
	}
	/* $B%+%9%?%^%$%:MQ$N?bD>(BBOX$B$NDI2C(B */
	db->box = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), db->box, FALSE, FALSE, 0);
      
	/* $B%;%Q%l!<%?$N@8@.(B */
	obj = gtk_hseparator_new ();
	gtk_widget_show (obj);
	gtk_box_pack_start (GTK_BOX (vbox), obj, FALSE, FALSE, 5);

	hbox = gtk_hbox_new (FALSE, 3);
	gtk_widget_show (hbox);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	{
	  /* $B%W%l%S%e!<%\%?%s$N@8@.(B */
	  if (action == ACTION_NON_INTERACTIVE) {
	    obj = gtk_button_new_with_label (_("Preview"));
	    gtk_signal_connect_object (GTK_OBJECT (obj), "clicked",
				       GTK_SIGNAL_FUNC (callback_preview),
				       NULL);
	    gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);
	    gtk_widget_show (obj);
	  }
	  /* $BE,MQ%\%?%s$N@8@.(B */
	  obj = gtk_button_new_with_label (_("Apply"));
	  gtk_signal_connect_object (GTK_OBJECT (obj), "clicked",
				     GTK_SIGNAL_FUNC (callback_apply), NULL);
	  gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);
	  gtk_widget_show (obj);

	  /* $B%-%c%s%;%k%\%?%s$N@8@.(B */
	  obj = gtk_button_new_with_label (_("Cancel"));	  
	  gtk_signal_connect_object (GTK_OBJECT (obj), "clicked",
				     GTK_SIGNAL_FUNC (callback_cancel), NULL);
	  gtk_box_pack_start (GTK_BOX (hbox), obj, TRUE, TRUE, 0);
	  gtk_widget_show (obj);
	}
	/* $B%W%m%0%l%9%P!<$N@8@.(B */
	if (use_progressbar) {
	  obj = gtk_hseparator_new ();
	  gtk_widget_show (obj);
	  gtk_box_pack_start (GTK_BOX (vbox), obj, FALSE, FALSE, 5);

	  db->progressbar = gtk_progress_bar_new ();

	  gtk_box_pack_start (GTK_BOX (vbox),
			      db->progressbar, FALSE, FALSE, 0);
	  gtk_widget_show (db->progressbar);
	}
      }
    }
  }
  /* $B2hA|$NI=<((B */
  db->src_img  = src_img;
  db->dst_img  = dst_img;
  db->work_img = TeoAllocSimilarImage (db->src_img);

  src_ptr = (unsigned char *) src_img->data;
  dst_ptr = (unsigned char *) dst_img->data;
  for (n = 0; n < TeoFsize (db->src_img); n++) *dst_ptr++ = *src_ptr++;
  
  plugin_preview_image (db->src_img, db->work_img, min);
  draw_dialog_image (db->canvas, db->work_img);

  gtk_grab_add (db->window);
}

/* ******************************************* End of libteoeyesplugin.c *** */
