/* ************************************************** libteoeyesplugin.h *** *
 * This library is a auxiliary library for teoeyes-plugin programming.
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-20 23:21:24 sugaya>
 * ************************************************************************* */
#ifndef _LIB_TEOEYES_PLUGIN_H_
#define _LIB_TEOEYES_PLUGIN_H_

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <teo.h>
#include <teo2gdk-pixbuf.h>
#include "plugin_info.h"

enum {
  ACTION_NON_INTERACTIVE,
  ACTION_INTERACTIVE
};

enum {
  NON_USE_PROGRESSBAR,	
  USE_PROGRESSBAR	
};

typedef struct {
  GtkWidget		*window;
  GtkWidget		*canvas;
  GtkWidget		*spinbutton;
  GtkWidget		*progressbar;
  GtkWidget		*box;
  GtkAdjustment		*adjuster;
  TEOIMAGE		*src_img;
  TEOIMAGE		*dst_img;
  TEOIMAGE		*work_img;
  int			action;
} PluginDialog;
			     
/* Functions *************************************************************** */
void	plugin_progressbar_update(double			val);

void	plugin_dialog_new	(char			*title,
				 void			(*func) 
				 (TEOIMAGE		*src,
				  TEOIMAGE		*dst,
				  double		param),
				 TEOIMAGE		*src_img,
				 TEOIMAGE		*dst_img,
				 char 			*label,
				 double			min, 
				 double			max,
				 double			step,
				 double			page,
				 int			use_progressbar,
				 int			action);

/* Arguments *************************************************************** */
void	(*plugin_preview_image)	(TEOIMAGE		*src,
				 TEOIMAGE		*dst,
				 double			param);

PluginDialog	*db;

#endif	/* _LIB_TEOEYES_PLUGIN_H_ */

/* ********************************************** End of teoeyesplugin.h *** */
