/* ************************************************************ binary.c *** *
 * Teoeyes Plugin Collection (Ͳ)
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-09 12:38:09 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <locale.h>
#include <teo.h>
#include "intl.h"
#include "teoeyesplugin.h"

#define	MIN_VAL			0
#define	MAX_VAL			255
#define	STEP_SIZE		1
#define	PAGE_SIZE		5
/* ץ쥹СѤ1ѹƤ */
#define	USE_PROGRESS_BAR	0

/* ************************************************************************* *
   ץ饰ؿ
 * ************************************************************************* */
void
exec_binary (TEOIMAGE	*src,
	     TEOIMAGE	*dst,
	     double	param) {
  int		row, col, p;
  TEO_UINT8	val;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      if ((TeoGetPixel (src, col, row, 0, TEO_UINT8)) > (TEO_UINT8) param) 
	val = 255;
      else
	val = 0;
      for (p = 0; p < TeoPlane (dst); p++) 
	TeoPutPixel (dst, col, row, p, TEO_UINT8, val);	
    }
#if USE_PROGRESS_BAR /* ץ쥹СѤ1ѹƤ */
    plugin_progressbar_update ((double) (row - TeoYstart (src)) /
			       (TeoYend (src) - TeoYstart (src)));
#endif
  }
#if USE_PROGRESS_BAR 
  plugin_progressbar_update (0.0);
#endif
}

/* ************************************************************************* *
   ץ饰¹Ѵؿ
 * ************************************************************************* */
void
plugin_binary (TEOIMAGE	*src,
	       TEOIMAGE	*dst) {
  /* ץ饰ɽ */
  plugin_dialog_new ("Ͳץ饰",	/* ȥ */
		     exec_binary,		/* ץ饰ؿ */
		     src,			/* ϲǡ */
		     dst,			/* ϲǡ */
		     "",			/* ѥ᡼٥ */
		     MIN_VAL,			/* ѥ᡼Ǿ */
		     MAX_VAL,			/* ѥ᡼ */
		     STEP_SIZE,			/* ѥ᡼1 */	
		     PAGE_SIZE,			/* ѥ᡼2 */	
		     NON_USE_PROGRESSBAR,	/* ץ쥹Сλ */
		     ACTION_INTERACTIVE);	/* ץӥ塼̤ιˡ */

  gtk_main ();
}

/* ************************************************************************* *
   ץ饰
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {"/Ͳץ饰",
   NULL,
   NULL,
   NULL,
   0,
   "<Item>"
  },
  "Ͳץ饰",
  "ë Ƿ",
  "1.0",
  "ͤǣͲ",
  1,
  plugin_binary
};

/* ***************************************************** End of binary.c *** */
