/* ****************************************************** edge_detect.c *** *
 * Teoeyes Plugin Collection (å)
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-03 23:59:48 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <teo.h>
#include "teoeyesplugin.h"

/* ************************************************************************* *
   ץ饰ؿ
 * ************************************************************************* */
void
plugin_edge_detect (TEOIMAGE	*src,
		    TEOIMAGE	*dst) {
  int		col, row, p;
  TEO_UINT8	val;
  
  for (row = TeoYstart (src) + 1; row <= TeoYend (src) - 1; row++) {
    for (col = TeoXstart (src) + 1; col <= TeoXend (src) - 1; col++) {
      val = 255 - (TeoGetPixel (src, col, row, 0, TEO_UINT8) -
		   (TeoGetPixel (src, col  , row-1, 0, TEO_UINT8) +
		    TeoGetPixel (src, col-1, row  , 0, TEO_UINT8) +
		    TeoGetPixel (src, col+1, row  , 0, TEO_UINT8) +
		    TeoGetPixel (src, col  , row+1, 0, TEO_UINT8)) / 4);
      for (p = 0; p < 3; p++) TeoPutPixel (dst, col, row, p, TEO_UINT8, val);
      if (TeoPlane (src) > 3) {
	for (p = 3; p < TeoPlane (src); p++) {
	  TeoPutPixel (dst, col, row, p, TEO_UINT8,
		       TeoGetPixel (src, col, row, p, TEO_UINT8));
	}
      }
    }
  }
}

/* ************************************************************************* *
   ץ饰
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {"/åХץ饰",
   NULL,
   NULL,
   NULL,
   0,
   "<Item>"
  },
  "åХץ饰",
  "ë Ƿ",
  "1.0",
  "åХץ饰Ǥ",
  1,
  plugin_edge_detect
};

/* ************************************************ End of edge_detect.c *** */
