/* ************ ********************************************* gaussian.c *** *
 * Teoeyes Plugin Collection (ե륿)
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-03 23:14:28 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <teo.h>
#include "teoeyesplugin.h"

#define		MIN_VAL		1
#define		MAX_VAL		32
#define		STEP_SIZE	1
#define		PAGE_SIZE	5
/* ץ쥹СѤ1ѹƤ */
#define	USE_PROGRESS_BAR	1

/* ************************************************************************* *
   ؿ
 * ************************************************************************* */
float
func_gaussian (float sigma, int x, int y) {
  return (float) exp ((double) -0.5 * (x * x + y * y) / (sigma * sigma));
}

/* ************************************************************************* *
   ץ饰ؿ
 * ************************************************************************* */
void
exec_gaussian (TEOIMAGE	*src,
	       TEOIMAGE	*dst,
	       double	param) {
  int		row, col, p, n, m;
  int		rs, re, cs, ce, col_sft, row_sft;
  int		scope, fw, fw2;
  float		sigma, **filter;
  float		cof, base = 0.0;
  TEO_FLOAT64	*val;

  scope = (int) param;
  fw	= scope * 2 + 1;
  fw2	= fw  * fw;
  sigma	= (float) fw / 2.0;
  cs	= TeoXstart (src);
  ce 	= TeoXend   (src);
  rs	= TeoYstart (src);
  re 	= TeoYend   (src);

  val   = (TEO_FLOAT64 *) malloc (sizeof (TEO_FLOAT64) * TeoPlane (src));
  
  filter = (float **) malloc (sizeof (float * ) * fw) + scope;
  for (n = -scope; n <= scope; n++) {
    filter[n] = (float *) malloc (sizeof (float) * fw) + scope;
    for (m = -scope; m <= scope; m++) {
      filter[n][m] = cof = func_gaussian (sigma, m, n);
      base += cof;
    }
  }
  for (n = -scope; n <= scope; n++) {
    for (m = -scope; m <= scope; m++) {
      filter[n][m] /= base;
    }
  }
  for (row = rs; row <= re; row++) {
    for (col = cs; col <= ce; col++) {
      for (p = 0; p < TeoPlane (src); p++) val[p] = 0.0;
      for (n = -scope; n <= scope; n++) {
	for (m = -scope; m <= scope; m++) {
	  col_sft = col + m;	
	  row_sft = row + n;
	  if ((col_sft < cs) || (col_sft > ce) || 
	      (row_sft < rs) || (row_sft > re)) continue;
	  for (p = 0; p < TeoPlane (src); p++) {
	    val[p] += filter[n][m] 
	      * TeoGetPixel (src, col_sft, row_sft, p, TEO_UINT8);
	    if (val[p] > 255) val[p] = 255;
	  }
	}
      }
      for (p = 0; p < TeoPlane (dst); p++)
	TeoPutPixel (dst, col, row, p, TEO_UINT8, (TEO_UINT8) val[p]);
    }
#if USE_PROGRESS_BAR /* ץ쥹СѤ1ѹƤ */
    plugin_progressbar_update ((float) (row - rs) / (re - rs + 1));
#endif
  }
#if USE_PROGRESS_BAR /* ץ쥹СѤ1ѹƤ */
  plugin_progressbar_update (0.0);
#endif
  for (n = -scope; n <= scope; n++) {
    filter[n] -= scope;
    free (filter[n]);
  }
  filter -= scope;
  free (filter);
  free (val);
}

/* ************************************************************************* *
   ץ饰¹Ѵؿ
 * ************************************************************************* */
void
plugin_gaussian (TEOIMAGE	*src,
		 TEOIMAGE	*dst) {
  /* ץ饰ɽ */
  plugin_dialog_new ("ե륿",	/* ȥ */
		     exec_gaussian,		/* ץ饰ؿ */
		     src,			/* ϲ */
		     dst,			/* ϲ */		      
		     "ϰ", 			/* ѥ᡼٥ */
		     MIN_VAL,			/* ѥ᡼Ǿ */
		     MAX_VAL,			/* ѥ᡼ */
		     STEP_SIZE,			/* ѥ᡼1 */
		     PAGE_SIZE,			/* ѥ᡼2 */
		     USE_PROGRESSBAR,		/* ץ쥹Сλ */
		     ACTION_NON_INTERACTIVE); 	/* ץӥ塼̤ιˡ */

  gtk_main ();
}

/* ************************************************************************* *
   ץ饰
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {"/ե륿",
   NULL,
   NULL,
   NULL,
   0,
   "<Item>"
  },
  "ե륿",
  "ë Ƿ",
  "1.0",
  "ե륿\n"
  "򤫤ץ饰Ǥ",
  1,
  plugin_gaussian
};

/* *************************************************** End of gaussian.c *** */

