/* ******************************************************** laplacian.c *** *
 * Teoeyes Plugin Collection (ץ饷ե륿)
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-04 00:03:57 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <teo.h>
#include "teoeyesplugin.h"

/* ************************************************************************* *
   ץ饰ؿ
 * ************************************************************************* */
void
plugin_laplacian (TEOIMAGE	*src,
		  TEOIMAGE	*dst) {
  int		n, m, p, col, row;
  int		scope = 1;
  int		*val, filter[] = {-1, -1, -1, -1, 8, -1, -1, -1, -1};

  /* ϲѥγ */
  val = (int *) malloc (sizeof (int) * TeoPlane (src));
  for (row = TeoYstart (src) + 1; row <= TeoYend (src) - 1; row++) {
    for (col = TeoXstart (src) + 1; col <= TeoXend (src) - 1; col++) {
      for (p = 0; p < TeoPlane (src); p++) val[p] = 0;
      for (n = -scope; n <= scope; n++) {
	for (m = -scope; m <= scope; m++) {
	  for (p = 0; p < 3; p++) {
	    val[p] += TeoGetPixel (src, col+m, row+n, p, TEO_UINT8) * 
	      filter[(n+scope)*3+(m+scope)];
	  }
	}
      }
      for (p = 0; p < 3; p++) {
	if (val[p] < 0)   val[p] = 0;
	if (val[p] > 255) val[p] = 255;
	TeoPutPixel (dst, col, row, p, TEO_UINT8, val[p]);	
      }
      if (TeoPlane (src) > 3) {
	for (p = 3; p < TeoPlane (src); p++) {
	  TeoPutPixel (dst, col, row, p, TEO_UINT8,
		       TeoGetPixel (src, col, row, p, TEO_UINT8));
	}
      }
    }
  }
}

/* ************************************************************************* *
   ץ饰
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {"/ץ饷ե륿",
   NULL,
   NULL,
   NULL,
   0,
   "<Item>"
  },
  "ץ饷ե륿",
  "ë Ƿ",
  "1.0",
  "ץ饷ե륿\n"
  "򤫤ץ饰Ǥ",
  1,
  plugin_laplacian
};

/* ************************************************** End of laplacian.c *** */
