/* *********************************************************** median.c *** *
 * Teoeyes Plugin Collection (ǥե륿)
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-03 23:41:19 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <teo.h>
#include "teoeyesplugin.h"

#define	MIN_VAL			3
#define	MAX_VAL			31
#define	STEP_SIZE		2
#define	PAGE_SIZE		5
/* ץ쥹СѤ1ѹƤ */
#define	USE_PROGRESS_BAR	1

/* ************************************************************************* *
   ͤ
 * ************************************************************************* */
TEO_UINT8
median (TEO_UINT8	*val,
	int		num) {
  int		n, m, tmp;
  TEO_UINT8	min;

  for (n = 0; n < num / 2 + 1; n++) {
    min = val[n];
    tmp = n;
    for (m = n+1; m < num; m++) {
      if (val[m] < min) {
	min = val[m];
	tmp = m;
      }
    }
    val[tmp] = val[n];
    val[n]   = min;
  }
  return val[num/2];
}

/* ************************************************************************* *
   ץ饰ؿ
 * ************************************************************************* */
void
exec_median (TEOIMAGE		*src,
	     TEOIMAGE		*dst,
	     double		param) {
  int		scope = (int) param;
  int		row, col;
  int		n, m, p, num;
  int		half  = scope / 2;
  TEO_UINT8	**vals = NULL;

  vals = (TEO_UINT8 **) malloc (sizeof (TEO_UINT8 *) * TeoPlane (src));
  for (p = 0; p < TeoPlane (src); p++) {
    vals[p] = (TEO_UINT8 *) malloc (sizeof (TEO_UINT8) * scope * scope);
  }
  for (row = TeoYstart (src) + half; row <= TeoYend (src) - half; row++) {
    for (col = TeoXstart (src) + half; col <= TeoXend (src) - half; col++) {
      for (p = 0; p < TeoPlane (src); p++) {
	num = 0;	
	for (n = 0; n < scope * scope; n++) vals[p][n] = 0;
	for (n = -half; n <= half; n++) {
	  for (m = -half; m <= half; m++) {
	    vals[p][num++] = TeoGetPixel (src, col+m, row+n, p, TEO_UINT8);
	  }
	}
	TeoPutPixel (dst, col, row, p, TEO_UINT8,
		     median (vals[p], scope * scope));
      }
    }
#if USE_PROGRESS_BAR /* ץ쥹СѤ1ѹƤ */
    plugin_progressbar_update ((double) (row - (TeoYstart (src) + half)) /
			       (double) (TeoYend (src) - half + 1));
#endif
  } 
#if USE_PROGRESS_BAR /* ץ쥹СѤ1ѹƤ */
  plugin_progressbar_update (0.0);
#endif
  for (p = 0; p < TeoPlane (src); p++) free (vals[p]);
  free (vals);
}

/* ************************************************************************* *
   ץ饰¹Ѵؿ
 * ************************************************************************* */
void
plugin_median (TEOIMAGE	*src,
	       TEOIMAGE	*dst) {
  /* ץ饰ɽ */
  plugin_dialog_new ("ǥե륿",	/* ȥ */
		     exec_median,		/* ץ饰ؿ */
		     src,			/* ϲǡ */
		     dst,			/* ϲǡ */
		     "",			/* ѥ᡼٥ */
		     MIN_VAL,			/* ѥ᡼Ǿ */
		     MAX_VAL,			/* ѥ᡼ */
		     STEP_SIZE,			/* ѥ᡼1 */	
		     PAGE_SIZE,			/* ѥ᡼2 */	
		     USE_PROGRESSBAR,		/* ץ쥹Сλ */
		     ACTION_NON_INTERACTIVE);	/* ץӥ塼̤ιˡ */

  gtk_main ();
}

/* ************************************************************************* *
   ץ饰
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {"/ǥե륿",
   NULL,
   NULL,
   NULL,
   0,
   "<Item>"
  },
  "ǥե륿",
  "ë Ƿ",
  "1.0",
  "ǥե륿\n"
  "򤫤ץ饰Ǥ",
  1,
  plugin_median
};

/* ***************************************************** End of median.c *** */
