/* ****************************************************** pseudo_color.c *** *
 * Teoeyes Plugin Collection (顼)
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-03 23:46:39 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <teo.h>
#include "teoeyesplugin.h"

#define	MIN_VAL			0
#define	MAX_VAL			255
#define	STEP_SIZE		1
#define	PAGE_SIZE		5
/* ץ쥹СѤ1ѹƤ */
#define	USE_PROGRESS_BAR	0

/* ************************************************************************* */
static TEO_UINT8
gray_to_pseudo_color (TEO_UINT8	src,
		      int	plane) {
  switch (plane) {
  case 0:
    if (src < 128) {
      return 0;
    } else if (src > 192) {
      return 255;
    } else {
      return (TEO_UINT8) ((src - 128) * 255 / 64);
    }
    break;
  case 1:
    if (src <= 64) {
      return (TEO_UINT8) src * 255 / 64;
    } else if (src >= 192) {
      return (TEO_UINT8) (255 - (TEO_UINT8) (src - 192) * 255 / 63);
    } else {
      return (TEO_UINT8) 255;
    }
    break;
  case 2:
    if (src < 64) {
      return (TEO_UINT8) 255;
    } else if (src > 128) {
      return 0;
    } else {
      return (TEO_UINT8) (255 - (TEO_UINT8) (src - 64) * 255 / 64);
    }
    break;
  default:
    return (TEO_UINT8) 0;
  }
}

/* ************************************************************************* *
   ץ饰¹Ѵؿ
 * ************************************************************************* */
void
plugin_pseudo (TEOIMAGE	*src,
	       TEOIMAGE	*dst) {
  TEO_UINT8	val;
  int		row, col, p;
  
  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      val = TeoGetPixel (src, col, row, 0, TEO_UINT8);
      TeoPutPixel (dst, col, row, 0, TEO_UINT8, gray_to_pseudo_color (val, 0));
      TeoPutPixel (dst, col, row, 1, TEO_UINT8, gray_to_pseudo_color (val, 1));
      TeoPutPixel (dst, col, row, 2, TEO_UINT8, gray_to_pseudo_color (val, 2));
      if (TeoPlane (src) > 3) {
	for (p = 3; p < TeoPlane (src); p++) {
	  TeoPutPixel (dst, col, row, p, TEO_UINT8,
		       TeoGetPixel (src, col, row, p, TEO_UINT8));
	}
      }
    }
  }
}

/* ************************************************************************* *
   ץ饰
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {"/顼ץ饰",
   NULL,
   NULL,
   NULL,
   0,
   "<Item>"
  },
  "顼ץ饰",
  "ë Ƿ",
  "1.0",
  "ǻø򵿻顼\n"
  "Ѵ",
  1,
  plugin_pseudo
};

/* *********************************************** End of pseudo_color.c *** */
