/* ********************************************************* quantize.c *** *
 * Teoeyes Plugin Collection (̻Ҳ)
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-03 23:51:56 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <teo.h>
#include "teoeyesplugin.h"

#define	MIN_VAL			1
#define	MAX_VAL			7
#define	STEP_SIZE		1
#define	PAGE_SIZE		5
/* ץ쥹СѤ1ѹƤ */
#define	USE_PROGRESS_BAR	1

/* ************************************************************************* *
   ץ饰ؿ
 * ************************************************************************* */
void
exec_quantize (TEOIMAGE		*src,
	       TEOIMAGE		*dst,
	       double		param) {
  int			qsize = 8 - (int) param;
  int			row, col, p;

  for (row = TeoYstart (src); row <= TeoYend (src); row++) {
    for (col = TeoXstart (src); col <= TeoXend (src); col++) {
      for (p = 0; p < TeoPlane (src); p++) {
	TeoPutPixel (dst, col, row, p, TEO_UINT8,
		     (TEO_UINT8) ((TeoGetPixel (src, col, row, p, TEO_UINT8)
				   >> qsize) << qsize));
      }
    }
#if USE_PROGRESS_BAR /* ץ쥹СѤ1ѹƤ */
    plugin_progressbar_update ((double) (row - (TeoYstart (src))) /
			       (double) TeoHeight (src));
#endif
  } 
#if USE_PROGRESS_BAR /* ץ쥹СѤ1ѹƤ */
  plugin_progressbar_update (0.0);
#endif
}

/* ************************************************************************* *
   ץ饰¹Ѵؿ
 * ************************************************************************* */
void
plugin_quantize (TEOIMAGE	*src,
		 TEOIMAGE	*dst) {
  /* ץ饰ɽ */
  plugin_dialog_new ("̻Ҳץ饰",	/* ȥ */
		     exec_quantize,		/* ץ饰ؿ */
		     src,			/* ϲǡ */
		     dst,			/* ϲǡ */
		     "̻Ҳ٥",		/* ѥ᡼٥ */
		     MIN_VAL,			/* ѥ᡼Ǿ */
		     MAX_VAL,			/* ѥ᡼ */
		     STEP_SIZE,			/* ѥ᡼1 */	
		     PAGE_SIZE,			/* ѥ᡼2 */	
		     USE_PROGRESSBAR,		/* ץ쥹Сλ */
		     ACTION_NON_INTERACTIVE);	/* ץӥ塼̤ιˡ */

  gtk_main ();
}

/* ************************************************************************* *
   ץ饰
 * ************************************************************************* */
PluginInfo plugin_info = {  
  {"/̻Ҳץ饰",
   NULL,
   NULL,
   NULL,
   0,
   "<Item>"
  },
  "̻Ҳץ饰",
  "ë Ƿ",
  "1.0",
  "̻Ҳ\n"
  "ץ饰Ǥ",
  1,
  plugin_quantize
};

/* ***************************************************** End of median.c *** */
