/* ********************************************************* assistant.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/07/01 10:39:23 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include <gdk/gdkkeysyms.h>
#include "assistant.h"

/* ************************************************************************* *
 * ᥤ󥦥ɥΥХåؿ
 * ************************************************************************* */

/* ************************************************************************* */
static void
te_assistant_cb_close (GtkWidget	*widget,
		       gpointer		data) {
  gtk_widget_hide (GTK_WIDGET (data));
  gtk_widget_hide (widget);
}

/* ************************************************************************* */
static void
te_assistant_cb_mouse_press (GtkWidget		*widget,
			     GdkEventButton	*ev) {
  AssistantSkinData	*skin;
  GtkWidget		*msgbox;
  int			wx, wy;

  if (ev->type == GDK_2BUTTON_PRESS) {
    skin = (AssistantSkinData *)
      gtk_object_get_data (GTK_OBJECT (widget), "skin");
    msgbox = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (widget), "msg_box");
    gdk_window_get_root_origin (widget->window, &wx, &wy);    
    gtk_widget_show (msgbox);
    gtk_widget_set_uposition (msgbox, wx + skin->xoffset, wy + skin->yoffset);
  } else if (ev->button == 1) {
    gtk_object_set_data (GTK_OBJECT (widget), "move_x_pos",
			 (gpointer) (gint) ev->x);
    gtk_object_set_data (GTK_OBJECT (widget), "move_y_pos",
			 (gpointer) (gint) ev->y);
  } else {
#if 1
    msgbox = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (widget), "msg_box");
    gtk_widget_hide (msgbox);
    gtk_widget_hide (widget);
#else
    te_assistant_cb_close (widget, (gpointer) msgbox);
#endif
  }
}

/* ************************************************************************* */
static void
te_assistant_cb_mouse_motion (GtkWidget		*widget,
			      GdkEventMotion	*ev) {
  AssistantSkinData	*skin;
  GtkWidget		*msgbox;
  GdkModifierType	state;
  gint			x, y, ox, oy;

  gdk_window_get_pointer (NULL, &x, &y, &state);

  if ((state & GDK_BUTTON1_MASK) != 0) {
    skin = (AssistantSkinData *)
      gtk_object_get_data (GTK_OBJECT (widget), "skin");
    msgbox = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (widget),"msg_box");
    ox = (gint) gtk_object_get_data (GTK_OBJECT (widget), "move_x_pos");
    oy = (gint) gtk_object_get_data (GTK_OBJECT (widget), "move_y_pos");  
    gdk_window_move (widget->window, x - ox, y - oy);
    gdk_window_move (msgbox->window,
		     x - ox + skin->xoffset, y - oy + skin->yoffset);
  }
}

/* ************************************************************************* *
 * åɥΥХåؿ
 * ************************************************************************* */

/* ************************************************************************* */
static void
te_assistant_cb_msg_query (GtkWidget	*widget,
			   gpointer	*data) {
  GtkEntry	*entry;
  gchar		*keyword, *file;
  char		*cmd;
  int		pid, n, l;
  
  file = (gchar *)
    malloc (sizeof (gchar) * (strlen (y_dir_homedir ()) +
			      strlen (CONFIG_FILE_DIR) + 19 + 2 + 1));
  sprintf (file, "%s/%s/search_result.html",y_dir_homedir (), CONFIG_FILE_DIR);

  if (y_file_exist_file (file)) y_file_remove_file (file);
  
  entry = GTK_ENTRY (gtk_object_get_data (GTK_OBJECT (data), "entry"));
  keyword = (gchar *) gtk_entry_get_text (entry);
  for (n = 0, l = 0; n < tc->assistant_help_paths; n++) {
    l += strlen (tc->assistant_help_path[n]) + 1;
  }
  l += strlen (file) + 1;
  l += strlen (keyword) + 1;
  l += 14;
  cmd = (char *) malloc (sizeof (char) * l);
  sprintf (cmd, "namazu -h -o %s %s", file, keyword);
  for (n = 0, l = strlen (cmd); n < tc->assistant_help_paths; n++) {
    strcat (cmd+l, " ");
    strcat (cmd+l+1, tc->assistant_help_path[n]);
    l += strlen (tc->assistant_help_path[n]) + 1;
  }
  system (cmd);
  free (cmd);
  
  if (y_file_exist_file (file)) {
    if (!tc->help_browser) {
      fprintf (stderr, _("Not set help browser.\n"));
      return;
    }
    if ((pid = fork ()) == 0) {
      if (execlp (tc->help_browser, tc->help_browser, file, (char *) 0) == -1){
	perror (tc->help_browser);
	return;
      }
    }
  }
}

/* ************************************************************************* */
static void
te_assistant_cb_none (GtkWidget	*widget,
		      gpointer	data) {
  return;
}

/* ************************************************************************* */
static void
te_assistant_cb_msg_cancel (GtkWidget	*widget,
			    gpointer	data) {
  gtk_widget_hide (GTK_WIDGET (data));
}

/* ************************************************************************* */
static void
te_assistant_cb_msg_entry (GtkWidget	*widget,
			   GdkEventKey	*key,
			   gpointer	data) {
  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return;
  te_assistant_cb_msg_query (widget, data);
}

/* ************************************************************************* *
 * ؿ
 * ************************************************************************* */

/* ************************************************************************* */
static AssistantSkinData*
te_assistant_skin_new (char	*skin_data) {
  AssistantSkinData	*skin;
  FILE			*fp;
  GdkPixbuf		*pbuf;
  GdkPixmap		*pixmap;
  GdkBitmap		*mask;
  char			*skin_path, *file;
  char			name[1024], data_file[1024];
  int			n;
  
  /* ǡեΥץ */
  fp = fopen (skin_data, "r");
  if (!fp) {
    fprintf (stderr, "Can not open assistant skin data.\n");
    return NULL;
  }
  /* ǡѥγ */
  y_separate_dir_and_file (skin_data, &skin_path, &file);
  free (file);
  
  /* ¤Τΰ */
  skin = (AssistantSkinData *) malloc (sizeof (AssistantSkinData));

  /* ΤΥǡ */
  fscanf (fp, "%s", name);
  sprintf (data_file, "%s/%s", skin_path, name);
  pbuf = gdk_pixbuf_new_from_file (data_file);
  gdk_pixbuf_render_pixmap_and_mask (pbuf,
				     &(skin->body), &(skin->body_mask), 255);
  gdk_pixbuf_unref (pbuf);

  /* åܥå(塦) */
  for (n = 0; n < 4; n++) {
    fscanf (fp, "%s", name);
    sprintf (data_file, "%s/%s", skin_path, name);
    pbuf = gdk_pixbuf_new_from_file (data_file);
    gdk_pixbuf_render_pixmap_and_mask (pbuf, &(skin->msg_box[n]), &mask, 255);
    if (mask) gdk_bitmap_unref (mask);
  }
  /* åܥåޥ */
  fscanf (fp, "%s", name);
  sprintf (data_file, "%s/%s", skin_path, name);
  pbuf = gdk_pixbuf_new_from_file (data_file);
  gdk_pixbuf_render_pixmap_and_mask(pbuf, &pixmap, &(skin->msg_box_mask), 255);
  gdk_pixmap_unref (pixmap);

  /* ΤȥåܥåȤΥեå */
  fscanf (fp, "%d %d", &(skin->xoffset), &(skin->yoffset));
  
  fclose (fp);
  
  return skin;
}

/* ************************************************************************* */
static void
te_assistant_attach_skin (GtkWidget	*canvas,
			  GdkPixmap	*pixmap) {
  int	w, h;
  
  gdk_window_get_size (pixmap, &w, &h);
  gtk_widget_set_usize (canvas, w, h);
  gdk_window_set_back_pixmap (canvas->window, pixmap, FALSE);
  gdk_window_clear (canvas->window);
}

/* ************************************************************************* */
GtkWidget*
te_assistant_msgbox_new (GtkWidget		*parent,
			 AssistantSkinData	*skin) {
  GtkWidget	*msgbox;
  GtkWidget	*table;
  GtkWidget	*canvas;
  GtkWidget	*vbox, *hbox;
  GtkWidget	*widget;
  int		w, h;

  /* ɥ */
  msgbox = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_ref (msgbox);
  gtk_window_set_policy (GTK_WINDOW (msgbox), FALSE, FALSE, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (msgbox), 0);
  gtk_widget_realize (msgbox);
  gdk_window_set_decorations (msgbox->window, FALSE);
  gtk_signal_connect (GTK_OBJECT (msgbox), "destroy",
		      GTK_SIGNAL_FUNC (te_assistant_cb_none), NULL);
  gtk_signal_connect (GTK_OBJECT (msgbox), "delete_event",
		      GTK_SIGNAL_FUNC (te_assistant_cb_none), NULL);
  
  /* ơ֥ */
  table = gtk_table_new (3, 3, FALSE);
  gtk_widget_ref (table);
  gtk_widget_show (table);
  gtk_container_add (GTK_CONTAINER (msgbox), table);

  /* Х */
  canvas = gtk_drawing_area_new ();
  gtk_widget_ref (canvas);
  gtk_widget_show (canvas);
  gtk_object_set_data (GTK_OBJECT (msgbox), "canvas_left", (gpointer) canvas);
  gtk_table_attach (GTK_TABLE (table), canvas, 0, 1, 0, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  te_assistant_attach_skin (canvas, skin->msg_box[0]);
			    
  canvas = gtk_drawing_area_new ();
  gtk_widget_ref (canvas);
  gtk_widget_show (canvas);
  gtk_object_set_data (GTK_OBJECT (msgbox), "canvas_right", (gpointer) canvas);
  gtk_table_attach (GTK_TABLE (table), canvas, 2, 3, 0, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  te_assistant_attach_skin (canvas, skin->msg_box[1]);  
  
  canvas = gtk_drawing_area_new ();
  gtk_widget_ref (canvas);
  gtk_widget_show (canvas);
  gtk_object_set_data (GTK_OBJECT (msgbox), "canvas_top", (gpointer) canvas);
  gtk_table_attach (GTK_TABLE (table), canvas, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  te_assistant_attach_skin (canvas, skin->msg_box[2]);    
  
  canvas = gtk_drawing_area_new ();
  gtk_widget_ref (canvas);
  gtk_widget_show (canvas);
  gtk_object_set_data (GTK_OBJECT (msgbox), "canvas_bottom",(gpointer) canvas);
  gtk_table_attach (GTK_TABLE (table), canvas, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  te_assistant_attach_skin (canvas, skin->msg_box[3]);

  /* ȥꥦåȤ */
  vbox = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox);
  gtk_widget_show (vbox);
  gtk_table_attach (GTK_TABLE (table), vbox, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL), 0, 0);
  {
    widget = gtk_label_new (_("What keyword do you want to know about ?"));
    gtk_widget_ref (widget);    
    gtk_widget_show (widget);
    gtk_misc_set_alignment (GTK_MISC (widget), 0.0, 0.5);
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
    gtk_widget_set_usize (widget, -1, 30);

    widget = gtk_entry_new ();
    gtk_widget_ref (widget);
    gtk_widget_show (widget);
    gtk_box_pack_start (GTK_BOX (vbox), widget, TRUE, TRUE, 0);    
    gtk_widget_set_usize (widget, -1, 32);
    gtk_object_set_data (GTK_OBJECT (msgbox), "entry", widget);
    gtk_signal_connect (GTK_OBJECT (widget), "key_press_event",
			GTK_SIGNAL_FUNC (te_assistant_cb_msg_entry),
			(gpointer) msgbox);
    
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (hbox);        
    gtk_widget_show (hbox);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);
    {
      widget = gtk_button_new_with_label (_("Cancel"));
      gtk_widget_ref (widget);          
      gtk_widget_show (widget);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_set_usize (widget, 100, 28);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_assistant_cb_msg_cancel),
			  (gpointer) msgbox);
      
      widget = gtk_button_new_with_label (_("Query"));
      gtk_widget_ref (widget);          
      gtk_widget_show (widget);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_set_usize (widget, 100, 28);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_assistant_cb_msg_query),
			  (gpointer) msgbox);
    }
  }
  gdk_window_get_size (skin->msg_box_mask, &w, &h);
  gtk_widget_set_usize (msgbox, w, h);
  gtk_widget_shape_combine_mask (msgbox, skin->msg_box_mask, 0, 0);
  gdk_window_clear (msgbox->window);
  
  return msgbox;
}

/* ************************************************************************* */
void
te_assistant_sync_to_skin (GtkWidget	*window) {
  
}

/* ************************************************************************* */
GtkWidget*
te_assistant_new (char	*skin_data) {
  GtkWidget		*window;
  GtkWidget		*canvas;
  GtkWidget		*msgbox;
  AssistantSkinData	*skin;
  int			w, h;
  
  /* ɤ߹ */
  skin = te_assistant_skin_new (skin_data);

  /* Ȥ礭 */
  gdk_window_get_size (skin->body, &(skin->width), &(skin->height));  
  
  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_POPUP);
  gtk_widget_ref (window);
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  gtk_container_set_border_width (GTK_CONTAINER (window), 0);

  gtk_widget_set_events (window,
			 GDK_ENTER_NOTIFY_MASK | 
			 GDK_LEAVE_NOTIFY_MASK |
			 GDK_POINTER_MOTION_MASK |
			 GDK_BUTTON_PRESS_MASK |
			 GDK_BUTTON_RELEASE_MASK);

  gtk_signal_connect (GTK_OBJECT (window), "motion_notify_event",
		      (GtkSignalFunc) te_assistant_cb_mouse_motion, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "button_press_event",
		      (GtkSignalFunc) te_assistant_cb_mouse_press, NULL);
  gtk_widget_realize (window);
  gdk_window_set_decorations (window->window, FALSE);
  
  /* Х */
  canvas = gtk_drawing_area_new ();
  gtk_widget_ref  (canvas);
  gtk_widget_show (canvas);
  gtk_object_set_data (GTK_OBJECT (window), "canvas", (gpointer) canvas);
  gtk_container_add (GTK_CONTAINER (window), canvas);

  gdk_window_get_size (skin->body, &w, &h);
  gtk_widget_set_usize (window, w, h);
  gtk_drawing_area_size (GTK_DRAWING_AREA (canvas), w, h);  
  gtk_widget_shape_combine_mask (window, skin->body_mask, 0, 0);
  gdk_window_set_back_pixmap (canvas->window, skin->body, FALSE);
  gdk_window_clear (canvas->window);

  /* åܥå */
  msgbox = te_assistant_msgbox_new (window, skin);
  gtk_object_set_data (GTK_OBJECT (window), "msg_box", (gpointer) msgbox);  

  gtk_object_set_data (GTK_OBJECT (window), "skin", (gpointer) skin);

  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      (GtkSignalFunc) te_assistant_cb_close,
		      (gpointer) msgbox);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      (GtkSignalFunc) te_assistant_cb_close,
		      (gpointer) msgbox);

  
  return window;  
}

/* ************************************************** End of assistant.c *** */
