/* *********************************************************** browser.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/11/14 11:32:36 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <gdk/gdkkeysyms.h>
#include "gtkdirtree.h"
#include "gtkiconitemfactory.h"
#include "gtkicon.h"
#include "gtkiconlist.h"

#define	COMBO_LIST_LIMIT	20

/* ************************************************************************* */
static void
te_browser_cb_go_home 			(GtkWidget		*widget,
					 gpointer		data);
static void
te_browser_cb_show_hidden		(GtkWidget		*widget,
					 gpointer		data);
static void
te_browser_refresh_list	 		(GtkWidget		*widget,
					 gpointer		data);
static void
te_browser_switch_view_mode 		(GtkWidget		*widget,
					 gpointer		data);
static void
te_browser_window_hide 			(GtkWidget		*widget,
					 gpointer		data);
static void
te_browser_cb_open_image	 	(GtkWidget		*widget,
					 gpointer		data);
static void
te_browser_cb_new_window 		(GtkWidget		*widget,
					 gpointer		data);
static void
te_browser_cb_remove_tmp_icon		(GtkWidget		*widget,
					 gpointer		data);
  
static void	
te_browser_dtree_select 		(GtkDirTree		*dtree,
					 GList			*list,
					 gint			column,
					 gpointer		data);
static gchar*
te_browser_iconlist_create_icon		(gchar			*name);
static void	
te_browser_iconlist_add_icon 		(GtkIconList		*ilist,
					 char			*name);
static void
te_browser_iconlist_select		(GtkIconList		*ilist,
					 GtkIconListItem	*icon,
					 GdkEventButton		*ev,
					 gpointer		data);
static void
te_browser_icon_unselect 		(GtkIconList		*list,
					 GtkIconListItem	*icon,
					 GdkEventButton		*ev,
					 gpointer		data);

static void
te_browser_filelist_add_file 		(GtkCList		*clist,
					 char			*name,
					 int			row);
static void
te_browser_filelist_select		(GtkWidget		*clist,
					 gint			row,
					 gint			column,
					 GdkEventButton		*ev,
					 gpointer		data);
static gint
te_browser_filelist_compare_default 	(GtkCList		*clist,
					 gconstpointer		ptr1,
					 gconstpointer		ptr2);
static gint
te_browser_filelist_compare_fsize	(GtkCList		*clist,
					 gconstpointer		ptr1,
					 gconstpointer		ptr2);
static gint
te_browser_filelist_compare_isize	(GtkCList		*clist,
					 gconstpointer		ptr1,
					 gconstpointer		ptr2);
static void
te_browser_filelist_select_title	(GtkWidget		*clist,
					 gint			column,
					 gpointer		data);

static void
te_browser_combo_list_add 		(TEBrowser		*browser,
					 GtkWidget		*combo,
					 gchar			*folder);
static void
te_browser_combo_select_item 		(GtkWidget		*widget,
					 GdkEvent		*ev,
					 gpointer		data);
static void
te_browser_combo_set_popdown_strings	(TEBrowser		*browser,
					 GtkCombo		*combo,
					 GList			*strings);
  
static GtkWidget*
te_browser_component_menu_new 		(TEBrowser		*parent);

static GtkWidget*	
te_browser_component_combo_new 		(TEBrowser		*parent);

static GtkWidget*
te_browser_component_toolbar_new	(TEBrowser		*parent);

#include "browser_menu.h"

/* ǥ쥯ȥΥ ************************************************** */
void
te_browser_scan_dir (TEBrowser	*browser,
		     gchar	*path) {
  DIR		*dir;
  struct dirent *dirent;
  struct stat 	fileinfo;
  GList		*files = NULL;
  GList		*list;
  gint		n, file_num;
  gchar		*label;
  gchar		*full_name = NULL;
  gchar		*file = NULL;

  /* ǥ쥯ȥγ */
  if ((dir = opendir (path)) == NULL) return;

  /* ɽ */
  gtk_icon_list_freeze (GTK_ICON_LIST (browser->iconlist));
  gtk_clist_freeze (GTK_CLIST (browser->filelist));
  
  /* ꥹ&եꥹȤΥꥢ */
  gtk_icon_list_clear (GTK_ICON_LIST (browser->iconlist));
  gtk_clist_clear (GTK_CLIST (browser->filelist));
  
  /* ǥ쥯ȥΥ */
  while ((dirent = readdir (dir)) != NULL) {
    /* եμĴ٤ */
    full_name = g_strconcat (path, dirent->d_name, NULL);    
    file      = g_strdup (dirent->d_name);
    stat (full_name, &fileinfo);
    {
      /* ǥ쥯ȥ? */
      if (S_ISDIR (fileinfo.st_mode)) {
	g_free (full_name);
	g_free (file);
	continue;
      }
      /* ȥǥ쥯ȥ? ƥǥ쥯ȥ */
      if (y_dir_is_current_dir (file) || y_dir_is_parent_dir (file)) {
	g_free (full_name);
	g_free (file);
	continue;
      }
      /* ե? */
      if (what_format_is_this (full_name) >= FORMAT_UNKNOWN) {
	g_free (full_name);
	g_free (file);
	continue;
      }
    }
    /* ꥹȤؤɲ */
    files = g_list_append (files, file);
    g_free (full_name);
  }
  /* ǥ쥯ȥΥ */
  closedir (dir);

  /* ͥɲ */  
  if (files) {
  
    list     = files;
    n	     = 1;
    file_num = g_list_length (list);
    
    while (list) {
      /* ٥ */
      label = (char *)
	malloc (sizeof (char) * (strlen ("Now Loading ")
				 + strlen ((char *) list->data) + 1));

      /* ɤ߹Υե̾ɽ */
      sprintf (label, "Now Loading %s", (char *) list->data);
      gtk_label_set (GTK_LABEL (browser->state_label), label);

      /* ץ쥹Сι */
      gtk_progress_bar_update (GTK_PROGRESS_BAR (browser->progressbar),
			       (1.0 * n) / file_num);
      while (gtk_events_pending ()) gtk_main_iteration();

      /* եѥ */
      full_name = g_strconcat (path, (gchar *) list->data, NULL);

      /* ɲ */
      te_browser_iconlist_add_icon (GTK_ICON_LIST (browser->iconlist),
				   full_name);

      /* եɲ */
      te_browser_filelist_add_file (GTK_CLIST (browser->filelist),
				   full_name, n-1);
      n++;

      /* ΰ */
      g_free (full_name);
      g_free (label);

      /* ΥꥹȤ */
      list = list->next;
    }
    /* ץ쥹Сȥ٥θ */
    gtk_progress_bar_update (GTK_PROGRESS_BAR (browser->progressbar), 0.0);
    while (gtk_events_pending()) gtk_main_iteration();
    gtk_label_set (GTK_LABEL (browser->state_label), "");
  }
  /* ɽ */
  gtk_icon_list_thaw (GTK_ICON_LIST (browser->iconlist));
  gtk_clist_thaw (GTK_CLIST (browser->filelist));

  /* ꥹΰβ */
  g_list_free (files);
}

/* ǥ쥯ȥΥեå ********************************************** */
static void
te_browser_refresh_list (GtkWidget	*widget,
			gpointer	data) {
  te_browser_scan_dir ((TEBrowser *) data,
		       gtk_dir_tree_get_dir(GTK_DIR_TREE (browser->dir_tree)));
}

/* եɽڤؤ ************************************************** */
static void
te_browser_switch_view_mode (GtkWidget	*widget,
			    gpointer	data) {

  if ((int) data == 0) {
    if (!browser->iconlist_window) return;
    if (browser->filelist_window) gtk_widget_hide (browser->filelist_window);
    gtk_widget_show (browser->iconlist_window);
  } else {
    if (!browser->filelist_window) return;
    if (browser->iconlist_window) gtk_widget_hide (browser->iconlist_window);
    gtk_widget_show (browser->filelist_window);
  }
  browser->display_mode = (int) data;
}

/* ֥饦ɥĤ ********************************************** */
static void
te_browser_window_hide (GtkWidget	*widget,
			gpointer	data) {
  gtk_widget_hide (browser->window);
}

/* 򳫤 ******************************************************** */
static void
te_browser_cb_open_image (GtkWidget	*widget,
			 gpointer	data) {
  if (selected_icon_name) {
    te_open_file_with_same_window (selected_icon_name);
  } else {
    te_open_file_with_same_window (NULL);
  }
}

/* TEOEYES򿷤ɥǳ ***************************************** */
static void
te_browser_cb_new_window (GtkWidget	*widget,
			 gpointer	data) {
  if (selected_icon_name) {
    te_open_file_with_new_window (selected_icon_name);
  } else {
    te_open_file_with_new_window (NULL);
  }
}

/* ѥƥݥǥ쥯ȥ ****************************** */
static void
te_browser_cb_remove_tmp_icon (GtkWidget	*widget,
			      gpointer	data) {
  char	buf[1024];

  /* ǧ */
  sprintf (buf, "%s %s",
	   _("Are you sure you want to remove"), tc->thumb_dir);
  if (te_confirm_box_show (image_window, _("Confirm"), buf) == FALSE) return;

  /* ֥饦ѥκ */
  y_dir_remove_dir (tc->thumb_dir);
}

/* ꤵ줿ǥ쥯ȥ˰ư **************************************** */
static void
te_browser_open_dir (GtkWidget	*widget,
		    GdkEventKey	*key,
		    gpointer	data) {
  TEBrowser	*browser;
  gchar		*path;

  if(key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return;
  
  browser = (TEBrowser *) data;
  path = g_strdup (gtk_entry_get_text (GTK_ENTRY (widget)));

  if ((!path) || (!*path)) return;
  if (!y_dir_is_dir (path)) {
    free (path);
    return;
  }
  if (path[strlen (path)-1] != '/') {
    path = (gchar *)
      g_realloc (path, sizeof (gchar) * (strlen (path) + 2));
    sprintf (path, "%s/", path);
  }
  te_browser_combo_list_add (browser, browser->dir_combo, path);
  gtk_dir_tree_open_dir (GTK_DIR_TREE (browser->dir_tree), path);
}

/* ************************************************************************* */
static void
te_browser_combo_changed (GtkWidget	*widget,
			  GtkWidget	*child,
			  gpointer	data) {
  TEBrowser	*browser;
  GtkCombo	*combo;
  GtkEntry	*entry;
  gchar		*folder;
  
  browser = (TEBrowser *) data;
  combo = GTK_COMBO (browser->dir_combo);
  entry = GTK_ENTRY (combo->entry);

  folder = gtk_entry_get_text (entry);
  if (folder) {
    gtk_signal_handler_block (GTK_OBJECT (combo->list), combo->list_change_id);
    gtk_dir_tree_open_dir (GTK_DIR_TREE (browser->dir_tree), folder);
    gtk_signal_handler_unblock(GTK_OBJECT (combo->list),combo->list_change_id);
  }
}

/* ۡǥ쥯ȥ **************************************************** */
static void
te_browser_cb_go_home (GtkWidget	*widget,
		      gpointer	data) {
  TEBrowser	*browser;
  gchar		home[1024];

  browser = (TEBrowser *) data;

  sprintf (home, "%s/", getenv ("HOME"));
  gtk_dir_tree_open_dir (GTK_DIR_TREE (browser->dir_tree), home);
}

/* ǥ쥯ȥɽ ************************************************** */
static void
te_browser_cb_show_hidden (GtkWidget	*widget,
			  gpointer	data) {
#if 0
  if (GTK_DIR_TREE (browser->dir_tree)->show_hidden == FALSE) {
    gtk_dir_tree_show_hidden (GTK_DIR_TREE (browser->dir_tree), TRUE);
  } else {
    gtk_dir_tree_show_hidden (GTK_DIR_TREE (browser->dir_tree), FALSE);
  }
#endif
}

/* ************************************************************************* *
 * ǥ쥯ȥĥ꡼åȤΥХåؿ
 * ************************************************************************* */

/* ĥ꡼Ρɤ򤵤줿ν **************************************** */
static void
te_browser_dtree_select (GtkDirTree	*dtree,
			GList		*list,
			gint		column,
			gpointer	data) {
  TEBrowser	*browser;
  GtkWidget	*entry;

  browser = (TEBrowser *) data;
  entry = GTK_COMBO (browser->dir_combo)->entry;
  gtk_entry_set_text (GTK_ENTRY (entry), gtk_dir_tree_get_dir (dtree));
  te_browser_combo_list_add (browser,
			    browser->dir_combo,
			    g_strdup (gtk_entry_get_text (GTK_ENTRY (entry))));
  te_browser_scan_dir (browser, gtk_dir_tree_get_dir (dtree));
}

/* ************************************************************************* *
 * ꥹȥåȤΥХåؿ
 * ************************************************************************* */

/* ͥκ ******************************************************** */
static gchar*
te_browser_iconlist_create_icon (gchar	*name) {
  GdkPixbuf	*pbuf1, *pbuf2;
  gchar		*thumb_name = NULL;
  gint		w, h, row, col;
  gint		thumb_width  = tc->thumb_width;
  gint		thumb_height = tc->thumb_height;
  unsigned long	date1, date2;
  unsigned char	*src_ptr, *dst_ptr;
  unsigned char	*png_name;
  unsigned char	*ptr, *ext, *src_data, *dst_data;

  ptr = png_name = g_strdup (name);
  ext = strrchr (png_name, '.');

  while (ptr < ext) *ptr++;
  *ptr++ = '.';
  *ptr++ = 'p';
  *ptr++ = 'n';
  *ptr++ = 'g';  
  *ptr++ = '\0';

  /* ͥΥե̾ */
  thumb_name = y_concat_dir_and_file (tc->thumb_dir, png_name);
  g_free (png_name);

  /* ˥ͥ뤬¸ߤ... */
  if (y_file_exist_file (thumb_name)) {
    date1 = y_file_moddate (name);
    date2 = y_file_moddate (thumb_name);
    if (date1 < date2) {
      pbuf1 = gdk_pixbuf_new_from_file (thumb_name);
      if (gdk_pixbuf_get_width (pbuf1) == thumb_width ||
	  gdk_pixbuf_get_height(pbuf1) == thumb_height) {
	gdk_pixbuf_unref (pbuf1);
	return thumb_name;
      } else {
	gdk_pixbuf_unref (pbuf1);
      }
    }  }
  if (what_format_is_this (name) == FORMAT_TEO) {
    pbuf1 = teo2gdk_pixbuf_new_from_file (name, 0, opt->min, opt->max, 1);
#if 0
  } else if (what_format_is_this (name) == FORMAT_EPS) {
#else
  } else {
#endif
#if 0
    GdkPixbuf	**tmp;
    int		i, pages;
    
    tmp = load_ps_image (name, &pages);
    pbuf1 = gdk_pixbuf_copy (tmp[0]);
    for (i = 0; i < pages; i++) gdk_pixbuf_unref (tmp[i]);
    free (tmp);
  } else if (what_format_is_this (name) == FORMAT_WMF) {
    pbuf1 = load_wmf_image (name);
  } else {
    pbuf1 = gdk_pixbuf_new_from_file (name);
#else
    pbuf1 = gdk_pixbuf_new_from_file_extension (name);
  }
#endif
  if (!pbuf1) {
    g_free (thumb_name);
    return NULL;
  }
  /* ͥ礭η */
  if ((w = gdk_pixbuf_get_width (pbuf1)) > thumb_width ||
      (h = gdk_pixbuf_get_height(pbuf1)) > thumb_height) {
    w = thumb_width;
    h = (w * gdk_pixbuf_get_height (pbuf1)) / gdk_pixbuf_get_width (pbuf1);
    if (h == 0) h = 2;
    if (h > thumb_height) {
      h = thumb_height;
      w = (h * gdk_pixbuf_get_width (pbuf1))/ gdk_pixbuf_get_height(pbuf1);
      if (w == 0) w = 2;      
    }
  }
#if 0 /* ֥饦礭ƻꤵ줿礭ˤ1 */
  else {
    if (im2->rgb_width > im2->rgb_height) {
      w = thumb_width;
      h = (w * im2->rgb_height) / im2->rgb_width;
    } else {
      h = thumb_height;
      w = (h * im2->rgb_width) / im2->rgb_height;
    }
  }
#endif
  if (w == 0 || h == 0) {
    g_free (thumb_name);
    gdk_pixbuf_unref (pbuf1);
    return NULL;
  }
  src_data = (unsigned char *) malloc (sizeof (unsigned char) * (w * h * 3));
  if (!src_data) {
    g_free (thumb_name);
    gdk_pixbuf_unref (pbuf1);
    return NULL;
  }
  pbuf2 = gdk_pixbuf_new_from_data (src_data, GDK_COLORSPACE_RGB, FALSE, 8,
				    w, h, w * 3, free_buffer, NULL);
  if (!pbuf2) {
    g_free (thumb_name);
    gdk_pixbuf_unref (pbuf1);    
    return NULL;
  }
  gdk_pixbuf_composite_color (pbuf1, pbuf2,
			      0, 0, w, h, 0, 0,
			      (double) w / gdk_pixbuf_get_width (pbuf1),
			      (double) h / gdk_pixbuf_get_height(pbuf1),
			      GDK_INTERP_TILES,
			      255, 0, 0, 16, 0xaaaaaa, 0x555555);
  gdk_pixbuf_unref (pbuf1);
  
  dst_data = (unsigned char *)
    malloc (sizeof (unsigned char) * (thumb_width * thumb_height * 3));
  if (!dst_data) {
    g_free (thumb_name);
    gdk_pixbuf_unref (pbuf2);
    return NULL;
  }
  src_ptr = gdk_pixbuf_get_pixels (pbuf2);
  dst_ptr = dst_data;

  for (row = 0; row < thumb_height; row++) {
    for (col = 0; col < thumb_width; col++) {
      if (row >= (thumb_height / 2 - gdk_pixbuf_get_height (pbuf2) / 2) &&
	  row < (thumb_height / 2 - gdk_pixbuf_get_height (pbuf2) / 2
		 + gdk_pixbuf_get_height (pbuf2)) &&
	  col >= (thumb_width / 2 - gdk_pixbuf_get_width (pbuf2) / 2) &&
	  col < (thumb_width / 2 - gdk_pixbuf_get_width (pbuf2) / 2
		 + gdk_pixbuf_get_width (pbuf2))) {
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
	*dst_ptr++ = *src_ptr++;
      } else {
	*dst_ptr++ = 255;
	*dst_ptr++ = 255;
	*dst_ptr++ = 255;
      }
    }
  }
  pbuf1 = gdk_pixbuf_new_from_data (dst_data,
				    GDK_COLORSPACE_RGB,
				    FALSE, 8, thumb_width, thumb_height,
				    thumb_width * 3, free_buffer, NULL);
  if (!pbuf1) {
    g_free (dst_data);    
    g_free (thumb_name);    
    gdk_pixbuf_unref (pbuf2);
    return NULL;
  }
  y_dir_make_dirs (thumb_name);
  gdk_pixbuf_save_to_file (pbuf1, thumb_name);

  gdk_pixbuf_unref (pbuf1);
  gdk_pixbuf_unref (pbuf2);

  return thumb_name;
}

/* ͥɲ ******************************************************** */
static void
te_browser_iconlist_add_icon (GtkIconList	*ilist,
			     char		*name) {
  GtkIconListItem	*item;
  gchar			*thumb_name;
  gchar			*lastname;
  int			pos;

  thumb_name = te_browser_iconlist_create_icon (name);
  lastname   = (strrchr (name, '/')) ? strrchr (name, '/') + 1 : name;

  item = gtk_icon_list_add (ilist, thumb_name, lastname, g_strdup (name));
  if (item) {
#if 1
    te_dnd_drag_on_widget (item->entry, name);
#else
    te_dnd_drag_on_widget (item->pixmap, name);
#endif
  }
  g_free (thumb_name);
}

/*  ********************************************************** */
static void
te_browser_iconlist_select (GtkIconList		*ilist,
			    GtkIconListItem	*icon,
			    GdkEventButton	*ev,
			    gpointer		data) {
  int			pid;
  int			pos;

  /* 򤵤줿̾γ */
  selected_icon_name = (gchar *) gtk_icon_list_get_link (icon);

  if (!selected_icon_name) return;

  if (ev->type == GDK_2BUTTON_PRESS) {
    if (ev->state == 0) {
      te_open_file_with_same_window (selected_icon_name);
    } else if (ev->state == 4) {
      te_open_file_with_new_window  (selected_icon_name);      
    }
  }
}

/*  ****************************************************** */
static void
te_browser_iconlist_unselect (GtkIconList	*list,
			     GtkIconListItem	*icon,
			     GdkEventButton	*ev,
			     gpointer		data) {
  /* 줿̾Ͽ */
  selected_icon_name = NULL;
}

/* ************************************************************************* *
 * եꥹȥåȤΥХåؿ
 * ************************************************************************* */

/* եɲ ****************************************************** */
static void
te_browser_filelist_add_file (GtkCList	*clist,
			     char	*name,
			     int	row) {
  GdkPixbuf	*pbuf;
  char		*info[] = {"", "", "", ""};
  char		buf[256];
  int		fmt, w, h;

  gtk_clist_append (clist, info);

  /* ե̾ */
  gtk_clist_set_text (clist,
		      row, 0,
		      (!strrchr (name, '/')) ? name : strrchr (name, '/') + 1);
  /* ե륵 */
  sprintf (buf, "%d", y_file_filesize (name));
  gtk_clist_set_text (clist, row, 1, buf);

  /*  */
  fmt = what_format_is_this (name);
  if (fmt == FORMAT_TEO) {
    pbuf = teo2gdk_pixbuf_new_from_file (name, 0, opt->min, opt->max, 1);
#if 0
  } else if (fmt == FORMAT_EPS) {
#else
  } else {
#endif
#if 0
    GdkPixbuf	**tmp;
    int		i, pages;
    
    tmp = load_ps_image (name, &pages);
    pbuf = gdk_pixbuf_copy (tmp[0]);
    for (i = 0; i < pages; i++) gdk_pixbuf_unref (tmp[i]);
    free (tmp);
  } else if (fmt == FORMAT_WMF) {
    pbuf = load_wmf_image (name);
  } else {
    pbuf = gdk_pixbuf_new_from_file (name);
#else
    pbuf = gdk_pixbuf_new_from_file_extension (name);
#endif
  }
  w = gdk_pixbuf_get_width (pbuf);
  h = gdk_pixbuf_get_height(pbuf);
  gdk_pixbuf_unref (pbuf);
  sprintf (buf, "%dx%d", w, h);
  gtk_clist_set_text (clist, row, 2, buf);    
  /*  */
  gtk_clist_set_text (clist, row, 3, y_file_moddate_string (name));
  /* ǡղ */
  gtk_clist_set_row_data (clist, row, (gpointer) g_strdup (name));
}

/* եꥹȤ **************************************************** */
static void
te_browser_filelist_select (GtkWidget		*clist,
			   gint			row,
			   gint			column,
			   GdkEventButton	*ev,
			   gpointer		data) {
  int	pid;

  selected_icon_name = (gchar *)
    gtk_clist_get_row_data (GTK_CLIST (clist), row);

  if (!selected_icon_name) return;

  if (ev->type == GDK_2BUTTON_PRESS) {
    if (ev->state == 0) {
      te_open_file_with_same_window (selected_icon_name);
    } else if (ev->state == 4) {
      te_open_file_with_new_window  (selected_icon_name);
    }
  }
}

/* Ӵؿ (ǥե) *************************************************** */
static gint
te_browser_filelist_compare_default (GtkCList		*clist,
				    gconstpointer	ptr1,
				    gconstpointer	ptr2) {
  char	*text1 = NULL;
  char	*text2 = NULL;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  switch (row1->cell[clist->sort_column].type) {
  case GTK_CELL_TEXT:
    text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
    break;
  case GTK_CELL_PIXTEXT:
    text1 = GTK_CELL_PIXTEXT (row1->cell[clist->sort_column])->text;
    break;
  default:
    break;
  }
  switch (row2->cell[clist->sort_column].type) {
  case GTK_CELL_TEXT:
    text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;
    break;
  case GTK_CELL_PIXTEXT:
    text2 = GTK_CELL_PIXTEXT (row2->cell[clist->sort_column])->text;
    break;
  default:
    break;
  }
  if (!text2) return (text1 != NULL);
  if (!text1) return -1;

  return strcmp (text1, text2);
}

/* Ӵؿ (ե륵ˤ) ************************************* */
static gint
te_browser_filelist_compare_fsize (GtkCList	*clist,
				  gconstpointer	ptr1,
				  gconstpointer	ptr2) {
  char	*text1 = NULL;
  char	*text2 = NULL;
  int	fsize1;
  int	fsize2;

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  switch (row1->cell[clist->sort_column].type) {
  case GTK_CELL_TEXT:
    text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
    break;
  case GTK_CELL_PIXTEXT:
    text1 = GTK_CELL_PIXTEXT (row1->cell[clist->sort_column])->text;
    break;
  default:
    break;
  }
  switch (row2->cell[clist->sort_column].type) {
  case GTK_CELL_TEXT:
    text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;
    break;
  case GTK_CELL_PIXTEXT:
    text2 = GTK_CELL_PIXTEXT (row2->cell[clist->sort_column])->text;
    break;
  default:
    break;
  }
  if (!text2) return (text1 != NULL);
  if (!text1) return -1;

  fsize1 = atoi (text1);
  fsize2 = atoi (text2);
  
  return (fsize1 > fsize2) ? 1 : -1;
}

/* Ӵؿ (ˤ) ***************************************** */
static gint
te_browser_filelist_compare_isize (GtkCList	*clist,
				  gconstpointer	ptr1,
				  gconstpointer	ptr2) {
  char	*text1 = NULL;
  char	*text2 = NULL;
  int	n, w, h;
  int	isize1;
  int	isize2;
  char	buf[32];

  GtkCListRow *row1 = (GtkCListRow *) ptr1;
  GtkCListRow *row2 = (GtkCListRow *) ptr2;

  switch (row1->cell[clist->sort_column].type) {
  case GTK_CELL_TEXT:
    text1 = GTK_CELL_TEXT (row1->cell[clist->sort_column])->text;
    break;
  case GTK_CELL_PIXTEXT:
    text1 = GTK_CELL_PIXTEXT (row1->cell[clist->sort_column])->text;
    break;
  default:
    break;
  }
  switch (row2->cell[clist->sort_column].type) {
  case GTK_CELL_TEXT:
    text2 = GTK_CELL_TEXT (row2->cell[clist->sort_column])->text;
    break;
  case GTK_CELL_PIXTEXT:
    text2 = GTK_CELL_PIXTEXT (row2->cell[clist->sort_column])->text;
    break;
  default:
    break;
  }
  if (!text2) return (text1 != NULL);
  if (!text1) return -1;

  n = 0;
  while (*text1 != 'x') buf[n++] = *text1++;
  buf[n] = '\0';
  w = atoi (buf);
  text1++;
  n = 0;
  while (*text1 != '\0') buf[n++] = *text1++;
  buf[n] = '\0';
  h = atoi (buf);  
  isize1 = w * h;

  n = 0;
  while (*text2 != 'x') buf[n++] = *text2++;
  buf[n] = '\0';
  w = atoi (buf);
  text2++;
  n = 0;
  while (*text2 != '\0') buf[n++] = *text2++;
  buf[n] = '\0';
  h = atoi (buf);  
  isize2 = w * h;

  return (isize1 > isize2) ? 1 : -1;
}

/* եꥹȤΥȥܥ󤬲줿ν ************************ */
static void
te_browser_filelist_select_title (GtkWidget	*clist,
				 gint		column,
				 gpointer	data) {
  TEBrowser	*browser;

  browser = (TEBrowser *) data;
  switch (column) {
  case 0:
    gtk_clist_set_sort_type (GTK_CLIST (clist),
			     (browser->sort_type_name == 0) ?
			     GTK_SORT_ASCENDING : GTK_SORT_DESCENDING);
    browser->sort_type_name = (browser->sort_type_name == 0) ? 1 : 0;
    gtk_clist_set_compare_func (GTK_CLIST (clist),
				(GtkCListCompareFunc)
				te_browser_filelist_compare_default);
    break;
  case 1:
    gtk_clist_set_sort_type (GTK_CLIST (clist),
			     (browser->sort_type_fsize == 0) ?
			     GTK_SORT_ASCENDING : GTK_SORT_DESCENDING);
    browser->sort_type_fsize = (browser->sort_type_fsize == 0) ? 1 : 0;
    gtk_clist_set_compare_func (GTK_CLIST (clist),
				(GtkCListCompareFunc)
				te_browser_filelist_compare_fsize);
    break;
  case 2:
    gtk_clist_set_sort_type (GTK_CLIST (clist),
			     (browser->sort_type_isize == 0) ?
			     GTK_SORT_ASCENDING : GTK_SORT_DESCENDING);
    browser->sort_type_isize = (browser->sort_type_isize == 0) ? 1 : 0;
    gtk_clist_set_compare_func (GTK_CLIST (clist),
				(GtkCListCompareFunc)
				te_browser_filelist_compare_isize);
    break;
  case 3:
    gtk_clist_set_sort_type (GTK_CLIST (clist),
			     (browser->sort_type_update == 0) ?
			     GTK_SORT_ASCENDING : GTK_SORT_DESCENDING);
    browser->sort_type_update = (browser->sort_type_update == 0) ? 1 : 0;
    gtk_clist_set_compare_func (GTK_CLIST (clist),
				(GtkCListCompareFunc)
				te_browser_filelist_compare_default);
    break;
  }
  gtk_clist_set_sort_column (GTK_CLIST (clist), column);
  gtk_clist_sort (GTK_CLIST (clist));
}

/* ************************************************************************* *
 * ܥåȤΥХåؿ
 * ************************************************************************* */

/* ************************************************************************* */
static void
te_browser_combo_list_add (TEBrowser	*browser,
			  GtkWidget	*combo,
			  gchar		*folder) {
  GList	*list;
  int	flg = 1;

  list = g_list_first (browser->combo_list);

  while (list) {
    if (strcmp (folder, (char *) list->data) == 0) {
      flg = 0;
      break;
    }
    list = g_list_next (list);
  }
  
  if (flg) {
    browser->combo_list
      = g_list_prepend (browser->combo_list, folder);
    if (g_list_length (g_list_first (browser->combo_list))
	> COMBO_LIST_LIMIT) {
      browser->combo_list =
	g_list_remove (browser->combo_list,
		       g_list_last (browser->combo_list)->data);
    }
    te_browser_combo_set_popdown_strings (browser,
					 GTK_COMBO (combo),
					 browser->combo_list);
  }
}

/* ************************************************************************* */
static void
te_browser_combo_select_item (GtkWidget	*widget,
			     GdkEvent	*ev,
			     gpointer	data) {
  GtkWidget		*label;

  label = GTK_BIN (widget)->child;
  gtk_dir_tree_open_dir (GTK_DIR_TREE (data), GTK_LABEL (label)->label);
}

/* ************************************************************************* */
static void
te_browser_combo_set_popdown_strings (TEBrowser	*browser,
				      GtkCombo	*combo,
				      GList	*strings) {
  GList 	*list;
  GtkWidget	*li;

  g_return_if_fail (combo != NULL);
  g_return_if_fail (GTK_IS_COMBO (combo));
  g_return_if_fail (strings != NULL);

  gtk_list_clear_items (GTK_LIST (combo->list), 0, -1);
  list = strings;
  while (list) {
    li = gtk_list_item_new_with_label ((gchar *) list->data);
#if 0
    gtk_signal_connect (GTK_OBJECT (li), "focus_in_event",
			GTK_SIGNAL_FUNC (te_browser_combo_select_item),
			browser->dir_tree);
#endif
    gtk_widget_show (li);
    gtk_container_add (GTK_CONTAINER (combo->list), li);
    list = list->next;
  }
}

/* ************************************************************************* *
 * ֥饦ɥγƥݡͥؿ
 * ************************************************************************* */

/* ˥塼 ********************************************************** */
static GtkWidget*
te_browser_component_menu_new (TEBrowser	*parent) {
  GtkIconItemFactory	*item_factory;
  GtkAccelGroup		*accel_group;
  GtkWidget		*handlebox;
  GtkWidget		*frame;
  int			items = sizeof (menu_items) / sizeof (menu_items[0]);

  /* ϥɥܥå */
  handlebox = gtk_handle_box_new ();
  gtk_widget_show (handlebox);
  {
    /* ե졼 */
    frame = gtk_frame_new (NULL);
    gtk_widget_show (frame);
    gtk_container_add (GTK_CONTAINER (handlebox), frame);
    
    /* ˥塼 */
    accel_group = gtk_accel_group_new ();
    item_factory
      = gtk_icon_item_factory_new (GTK_TYPE_MENU_BAR, "<main>", accel_group);
    gtk_icon_item_factory_create_items (item_factory, items, menu_items, NULL);
    gtk_accel_group_attach (accel_group, GTK_OBJECT (parent->window));
    parent->menu = gtk_icon_item_factory_get_widget (item_factory, "<main>");
    gtk_widget_show (parent->menu);
    gtk_container_add (GTK_CONTAINER (frame), parent->menu);
  }
  return handlebox;
}

/* ȥ ********************************************************** */
static GtkWidget*
te_browser_component_combo_new (TEBrowser	*parent) {
  GtkWidget	*handlebox;
  GtkWidget	*box;
  GtkWidget	*label;
  GtkWidget	*combo;

  /* ϥɥܥå */
  handlebox = gtk_handle_box_new ();
  gtk_container_border_width (GTK_CONTAINER (handlebox), 3);
  gtk_widget_show (handlebox);
  {
    /* ʿBOX */
    box = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (handlebox), box);    
    gtk_widget_show (box);
    {
      /* ٥ */
      label = gtk_label_new (_("Current Dir:"));
      gtk_box_pack_start (GTK_BOX (box), label, FALSE, FALSE, 1);
      gtk_widget_show (label);
      /* ǥ쥯ȥꥳ */
      parent->dir_combo = gtk_combo_new ();
      gtk_box_pack_start (GTK_BOX (box), parent->dir_combo, TRUE, TRUE, 1);
      gtk_combo_disable_activate (GTK_COMBO (parent->dir_combo));
      gtk_widget_show (parent->dir_combo);

      gtk_signal_handler_block(GTK_OBJECT (GTK_COMBO
					   (parent->dir_combo)->entry),
			       GTK_COMBO (parent->dir_combo)->entry_change_id);
    
      gtk_signal_connect (GTK_OBJECT (GTK_COMBO (parent->dir_combo)->entry),
			  "key_press_event",
			  GTK_SIGNAL_FUNC (te_browser_open_dir), parent);

      gtk_signal_connect (GTK_OBJECT (GTK_COMBO (parent->dir_combo)->list), 
			  "select_child",
			  GTK_SIGNAL_FUNC (te_browser_combo_changed), parent);
    }
  }
  return handlebox;
}

/* ġС ******************************************************** */
static GtkWidget*
te_browser_component_toolbar_new (TEBrowser	*parent) {
  GtkWidget	*handlebox;
  GtkWidget	*toolbar;
  GtkWidget	*icon;
  GtkWidget	*button;

  /* ϥɥܥå */
  handlebox = gtk_handle_box_new ();
  gtk_widget_show (handlebox);
  {
    /* ġС */
    toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_ICONS);
    gtk_toolbar_set_space_style (GTK_TOOLBAR (toolbar),GTK_TOOLBAR_SPACE_LINE);
    gtk_toolbar_set_space_size (GTK_TOOLBAR (toolbar), 10);
    gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_NONE);    
    gtk_container_add (GTK_CONTAINER (handlebox), toolbar);
    gtk_widget_show (toolbar);
    {
      /* ֥饦Ĥܥ */
      icon = gtk_icon_new_with_label (_("Close"), stock_close,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_set_usize (icon, 48, -1);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Close"),
			       _("Close Image Explorer"),
			       _("Close Image Explorer"),
			       icon,
			       te_browser_window_hide,
			       NULL);

      /* ֽλץܥ */
      icon = gtk_icon_new_with_label (_("Exit"), stock_exit,
					GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Exit"), 
			       _("Exit TeoEyes"),
			       _("Exit TeoEyes"),
			       icon,
			       te_menu_cb_quit,
			       NULL);

      /* ѥ졼 */
      gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

      /* ۡذưܥ */
      icon = gtk_icon_new_with_label (_("Home"), stock_home2,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Home"), 
			       _("Go home directory"),
			       _("Go home directory"),
			       icon,
			       te_browser_cb_go_home,
			       (gpointer) parent);
      
      /* ѥ졼 */
      gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
      
      /* TeoEyesεưܥ */
      icon = gtk_icon_new_with_label (_("Run"), teoeyes_icon_small,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Teoeyes"), 
			       _("Run TeoEyes"),
			       _("Run TeoEyes"),
			       icon,
			       te_menu_cb_file_run_teoeyes,
			       NULL);

      /* ֳץܥ */
      icon = gtk_icon_new_with_label (_("Open"), stock_open,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Open"), 
			       _("Open a new file"),
			       _("Open a new file"),
			       icon,
			       te_menu_cb_file_open,
			       NULL);
      /* ¸ץܥ */
      icon = gtk_icon_new_with_label (_("Save"), stock_save,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Save"), 
			       _("Save as original filename"),
			       _("Save as original filename"),
			       icon,
			       te_menu_cb_file_save,
			       NULL);
      /* ̾¸ץܥ */
      icon = gtk_icon_new_with_label (_("SaveAs"), stock_save_as,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("SaveAs"), 
			       _("Save as new filename"),
			       _("Save as new filename"),
			       icon,
			       te_menu_cb_file_saveas,
			       NULL);

      /* ѥ졼 */
      gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));
      
      /* ץܥ */
      icon = gtk_icon_new_with_label (_("Preference"), stock_properties,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Property"), 
			       _("Configure teoeyes properety"),
			       _("Configure teoeyes properety"),
			       icon,
			       te_menu_cb_preference,
			       NULL);

      /* ѥ졼 */
      gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

      /* ǥ쥯ȥΥեå */
      icon = gtk_icon_new_with_label (_("Refresh"), stock_reload,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Refresh"),
			       _("Refresh current list"),
			       _("Refresh current list"),
			       icon,
			       te_browser_refresh_list,
			       parent);
      
      /* ֥ꥢץܥ */
      icon = gtk_icon_new_with_label (_("Clear Thumb."), stock_clear,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Clear Icon"), 
			       _("Remove thumbnail files"),
			       _("Remove thumbnail files"),
			       icon,
			       te_browser_cb_remove_tmp_icon,
			       NULL);

      /* ѥ졼 */
      gtk_toolbar_append_space (GTK_TOOLBAR (toolbar));

      /* ɽڤؤܥ (ɽ) */
      icon = gtk_icon_new_with_label (_("Display Icon"), listing_iconic,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			       _("Display Icon"), 
			       _("Switch view to an icon display"),
			       _("Switch view to an icon display"),
			       icon,
			       te_browser_switch_view_mode,
			       (gpointer) 0);
      
      /* ɽڤؤܥ (ꥹɽ) */
      icon = gtk_icon_new_with_label (_("Display List"), listing_list,
				      GTK_ICON_TEXT_BOTTOM, 0);
      gtk_widget_show (icon);
      gtk_toolbar_append_item (GTK_TOOLBAR (toolbar), 
			     _("Display List"), 
			     _("Switch view to show detailed file statistics"),
			     _("Switch view to show detailed file statistics"),
			       icon,
			       te_browser_switch_view_mode,
			       (gpointer) 1);
    }
  }
  return handlebox;
}

/* ֥饦ɥ ************************************************ */
TEBrowser*
te_browser_window_new (void) {
  TEBrowser	*browser;
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*widget;
  GtkWidget	*paned_window;
  GtkWidget	*scrolled_window;
  GtkWidget	*tree;
  GtkWidget	*iconlist;
  GtkWidget	*filelist;	
  GtkWidget	*progress;
  GtkWidget	*process;
  GtkWidget	*status;
  gchar		*title = _("TeoEyes Image Explorer");

  /* TEBrowser¤Τΰ */
  browser = (TEBrowser *) malloc (sizeof (TEBrowser));
  browser->combo_list = NULL;
  /* ɥ */
  browser->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (browser->window),
			  "teoeyes", "Teo Image Viewer");  
  gtk_widget_realize (browser->window);

  gtk_signal_connect (GTK_OBJECT (browser->window), "destroy",
		      (GtkSignalFunc) te_browser_window_hide, NULL);
  gtk_signal_connect (GTK_OBJECT (browser->window), "delete_event",
		      (GtkSignalFunc) te_browser_window_hide, NULL);
  
  /* ȥ */
  gtk_window_set_title (GTK_WINDOW (browser->window), title);
  /* ܡ */
  gtk_container_set_border_width (GTK_CONTAINER (browser->window), 0);
  /* ɥ ꥵ */
  gtk_window_set_policy (GTK_WINDOW (browser->window), FALSE, TRUE, TRUE);
  {
    vbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (vbox);
    gtk_container_add (GTK_CONTAINER (browser->window), vbox);
    {
      /* ˥塼 */
      widget = te_browser_component_menu_new (browser);
      gtk_widget_show (widget);
      gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, TRUE, 0);

      /* ʿBOX */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_widget_show (hbox);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);      
      {
	/* ġС */
	browser->toolbar = te_browser_component_toolbar_new (browser);
	gtk_box_pack_start (GTK_BOX (hbox), browser->toolbar, FALSE, FALSE, 0);
	gtk_widget_show (browser->toolbar);
      }

      /* ǥ쥯ȥꥳܤ */
      widget = te_browser_component_combo_new (browser);
      gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ѥ󥦥ɥ */
      paned_window = gtk_hpaned_new ();
      gtk_widget_show (paned_window);
      gtk_box_pack_start (GTK_BOX (vbox), paned_window, TRUE, TRUE, 0);
      {
	/* 륦ɥ */
	scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (scrolled_window);
	gtk_container_add (GTK_CONTAINER (paned_window), scrolled_window);
	{
	  /* ǥ쥯ȥĥ꡼ */
	  browser->dir_tree = gtk_dir_tree_new ();
	  gtk_signal_connect (GTK_OBJECT (browser->dir_tree),
			      "tree_select_row",
			      GTK_SIGNAL_FUNC (te_browser_dtree_select),
			      (gpointer) browser);
	  gtk_widget_show (browser->dir_tree);
	  gtk_widget_set_usize (browser->dir_tree, 180, 300);
	  gtk_container_add (GTK_CONTAINER (scrolled_window),
			     browser->dir_tree);
	}
	/* ľܥå */
	widget = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (widget);
	gtk_container_add (GTK_CONTAINER (paned_window), widget);
	{
	  browser->display_mode     = 0;
	  browser->sort_type_name   = 0;
	  browser->sort_type_fsize  = 0;
	  browser->sort_type_isize  = 0;
	  browser->sort_type_update = 0;

	  /* 륦ɥ */
	  browser->iconlist_window = gtk_scrolled_window_new (NULL, NULL);
	  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW
					  (browser->iconlist_window),
					  GTK_POLICY_AUTOMATIC,
					  GTK_POLICY_AUTOMATIC); 
	  gtk_widget_set_usize (browser->iconlist_window, 420, 300);
	  gtk_box_pack_start (GTK_BOX(widget),
			      browser->iconlist_window, TRUE, TRUE, 0);
	  gtk_widget_show (browser->iconlist_window);
	  {
	    /* ꥹȤ */
	    browser->iconlist = gtk_icon_list_new (tc->thumb_width,
						   GTK_ICON_LIST_TEXT_BELOW);
	    gtk_icon_list_set_editable (GTK_ICON_LIST (browser->iconlist),
					FALSE);
	    gtk_signal_connect (GTK_OBJECT (browser->iconlist),
				"select_icon",
				GTK_SIGNAL_FUNC (te_browser_iconlist_select),
				NULL);
	    gtk_signal_connect (GTK_OBJECT (browser->iconlist),
				"unselect_icon",
				GTK_SIGNAL_FUNC (te_browser_iconlist_unselect),
				NULL);
	    gtk_scrolled_window_add_with_viewport (GTK_SCROLLED_WINDOW
						   (browser->iconlist_window),
						   browser->iconlist);
	    gtk_widget_realize (browser->iconlist);
	    gtk_widget_show (browser->iconlist);
	  }
	  /* 륦ɥ */
	  browser->filelist_window = gtk_scrolled_window_new (NULL, NULL);
	  gtk_widget_set_usize (browser->filelist_window, 420, 300);
	  gtk_box_pack_start (GTK_BOX (widget),
			      browser->filelist_window, TRUE, TRUE, 0);
	  gtk_widget_realize (browser->filelist_window);
	  {
	    /* եꥹȤ */
	    gchar	*fl_titles[]	= {_("File Name"),
					   _("File Size"),
					   _("Image Size"),
					   _("Update")};
	    gchar	*buf[]		= {"", "", "", ""};
	
	    browser->filelist = gtk_clist_new_with_titles (4, fl_titles);
	    gtk_signal_connect (GTK_OBJECT (browser->filelist), "select_row",
				GTK_SIGNAL_FUNC (te_browser_filelist_select),
				NULL);
	    gtk_signal_connect (GTK_OBJECT (browser->filelist), "click-column",
				GTK_SIGNAL_FUNC 
				(te_browser_filelist_select_title),
				(gpointer) browser);
	    gtk_clist_set_column_justification (GTK_CLIST (browser->filelist),
						1, GTK_JUSTIFY_RIGHT);
	    gtk_clist_set_column_justification (GTK_CLIST (browser->filelist),
						2, GTK_JUSTIFY_RIGHT);
	    gtk_clist_set_column_justification (GTK_CLIST (browser->filelist),
						3, GTK_JUSTIFY_RIGHT);
	    gtk_clist_set_column_width (GTK_CLIST (browser->filelist), 0, 100);
	    gtk_clist_set_column_width (GTK_CLIST (browser->filelist), 1, 70);
	    gtk_clist_set_column_width (GTK_CLIST (browser->filelist), 2, 70);
	    gtk_clist_set_column_width (GTK_CLIST (browser->filelist), 3, 100);
	    gtk_clist_set_selection_mode (GTK_CLIST (browser->filelist),
					  GTK_SELECTION_BROWSE);
	    gtk_container_add (GTK_CONTAINER (browser->filelist_window),
			       browser->filelist);
	    gtk_widget_show (browser->filelist);
	  }
	}
      }

      hbox = gtk_hbox_new (FALSE, 0);
      gtk_widget_show (hbox);
      gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
      {
	/* ץ쥹С */
        browser->progressbar = gtk_progress_bar_new ();
        gtk_widget_set_usize (browser->progressbar, 100, -1);
        gtk_box_pack_start (GTK_BOX (hbox),
			    browser->progressbar, FALSE, FALSE, 0);
        gtk_widget_show (browser->progressbar);

	widget = gtk_frame_new (NULL);
        gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	gtk_frame_set_shadow_type (GTK_FRAME (widget), GTK_SHADOW_IN);
	gtk_widget_show (widget);
	{
	  /* ٥ */
	  browser->state_label = gtk_label_new ("");
	  gtk_misc_set_alignment (GTK_MISC (browser->state_label), 0.0, 0.5);
	  gtk_container_add (GTK_CONTAINER (widget), browser->state_label);
	  gtk_widget_show (browser->state_label);
	}
      }
    }
  }
  return browser;
}

/* **************************************************** End of browser.c *** */
