/* ****************************************************** browser_menu.h *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-18 14:04:32 sugaya>
 * ************************************************************************* */
#ifndef	_TE_BROWSER_MENU_H_
#define	_TE_BROWSER_MENU_H_

#include "intl.h"

#include "icon_small.xpm"
#include "stock_new.xpm"
#include "stock_open.xpm"
#include "stock_save.xpm"
#include "stock_save_as.xpm"
#include "stock_close.xpm"
#include "stock_exit.xpm"
#include "stock_listing_iconic.xpm"
#include "stock_listing_list.xpm"
#include "stock_reload.xpm"
#include "stock_clear.xpm"
#include "stock_properties.xpm"
#include "stock_help2.xpm"
#include "stock_menu_about.xpm"
#include "stock_home2.xpm"
#include "stock_hidden.xpm"

/* ˥塼ƥ ******************************************************** */
static GtkIconItemFactoryEntry
menu_items[] =
{
  /* <File>˥塼 */
  {N_("/_File"),		
   NULL,		NULL,		NULL,		0, "<Branch>"},
  {N_("/_File/tearoff"),
   NULL,		NULL,		NULL,		0, "<Tearoff>"},
  {N_("/_File/TeoEyes _New Window"),
   stock_new,
   NULL,		te_browser_cb_new_window,	0, NULL},
  {N_("/_File/TeoEyes Same Window"),
   stock_new,
   NULL,		te_browser_cb_open_image,	0, NULL},
  
  {N_("/_File/separator"),	
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  {N_("/_File/_Open"),
   stock_open,
   "<Control>O",	te_menu_cb_file_open,		0, NULL},
  {N_("/_File/_Save"),
   stock_save,
   "<control>S",	te_menu_cb_file_save,		0, NULL},
  {N_("/_File/Save _as"),
   stock_save_as,
   "<control><mod1>S",	te_menu_cb_file_saveas,	0, NULL},

  {N_("/_File/separator"),	
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  {N_("/_File/_Close"),
   stock_close,
   "<control>W",	te_browser_window_hide,		0, NULL},
  
  {N_("/_File/separator"),	
   NULL,		NULL, 		NULL, 		0, "<Separator>"},

  {N_("/_File/_Quit"),
   stock_exit,
   "<control>Q",	te_menu_cb_quit,		0, NULL},


  /* <View>˥塼 */
  {N_("/_View"),		
   NULL,		NULL,		NULL,		0, "<Branch>"},
  {N_("/_View/tearoff"),
   NULL,		NULL,		NULL,		0, "<Tearoff>"},
  {N_("/_View/Show _Icon List"),
   listing_iconic,
   NULL,		te_browser_switch_view_mode,	0, NULL},
  {N_("/_View/Show _File List"),
   listing_list,
   NULL,		te_browser_switch_view_mode,	1, NULL},

  {N_("/_View/separator"),	
   NULL,		NULL, 		NULL, 		0, "<Separator>"},
#if 0
  {N_("/_View/Show _Hidden Directories"),
   stock_hidden,
   NULL, 		te_browser_cb_show_hidden,	0, "<ToggleItem>"},

  {N_("/_View/separator"),	
   NULL,		NULL, 		NULL, 		0, "<Separator>"},
#endif  
  {N_("/_View/_Refresh List"),
   stock_reload,
   "<control>R",	te_browser_refresh_list,		0, NULL},
  {N_("/_View/Remove _Tmp Icon"),
   stock_clear,
   "<control>C",	te_browser_cb_remove_tmp_icon,	0, NULL},

  /* <Preferences>˥塼 */
  {N_("/_Preferences"),
   NULL,		NULL, 		NULL,		0, "<Branch>"},
  {N_("/_Preferences/tearoff"),
   NULL,		NULL,		NULL,		0, "<Tearoff>"},
  {N_("/_Preferences/_Preferences"),
   stock_properties,
   "<control>P",	te_menu_cb_preference,		0, NULL},


  /* <Help>˥塼 */
  {N_("/_Help"),		
   NULL,		NULL,		NULL,		0, "<LastBranch>"},
  {N_("/_Help/tearoff"),
   NULL,		NULL,		NULL,		0, "<Tearoff>"},
  {N_("/_Help/_Help"),		
   stock_help2,
   "<control>H",	te_menu_cb_help,		0, NULL},
  {N_("/_Help/_About"),
   stock_menu_about,
   "<control>A",	te_menu_cb_about,		0, NULL}
};

#endif	/* _TE_BROWSER_MENU_H_ */

/* *********************************************** End of browser_menu.h *** */
