/* ********************************************************** cripping.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-05 13:53:32 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"

/* åԥΰ ************************************************** */
void
te_crip_draw_crip (void) {
  GdkWindow	*window;
  GdkGC		*gc;
  GdkColor	c1, c2;
  GdkColormap	*cmap;
  GtkWidget	*canvas;
  gint		r, g, b;
  gint		x, y, w, h;
  
  /* åȤγ */
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT(image_window), "canvas");
  window = canvas->window;

  /* åԥ󥰺ɸγ */
  x = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_x");
  y = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_y");
  w = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_w");
  h = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_h");

  /* ǥåȥɥؤȿ */
  if (edit_window) {
    GtkWidget	*widget_x;
    GtkWidget	*widget_y;
    GtkWidget	*widget_w;
    GtkWidget	*widget_h;

    widget_x = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), "spin_crip_x");
    widget_y = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), "spin_crip_y");
    widget_w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), "spin_crip_width");
    widget_h = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), "spin_crip_height");

    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_x), (gfloat) x);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_y), (gfloat) y);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_w), (gfloat) w);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_h), (gfloat) h);
  }
  /* åԥΰΥꥢ */
  if (w > 0 && h > 0) gdk_window_clear_area (window, x, y, w, h);

  /* 顼ޥåפγ */
  cmap = gdk_colormap_get_system ();
  
  /* ǣ1 */
  gc = gdk_gc_new (window);
  c1.pixel = 0;
  c1.red   = 160 << 8;
  c1.green = 200 << 8;
  c1.blue  = 220 << 8;
  gdk_color_alloc (cmap, &c1);
  
  /* ǣ2 */
  c2.pixel = 0;  
  c2.red   = 0;
  c2.green = 0;
  c2.blue  = 0;
  gdk_color_alloc (cmap, &c2);
  
  /* ǣäΥå */
  gdk_gc_set_foreground (gc, &c1);

  /* åԥΰ */
  if (w >= 10 && h >= 10) {
    gdk_gc_set_foreground (gc, &c2);
    gdk_draw_rectangle (window, gc, FALSE, 
			x - 1 + (w >> 1) - 4, y - 1 + (h >> 1) - 4, 7, 7);
    gdk_gc_set_foreground (gc, &c1);
    gdk_draw_rectangle (window, gc, TRUE, 
			x - 1 + (w >> 1) - 3, y - 1 + (h >> 1) - 3, 6, 6);
  }
  gdk_gc_set_foreground (gc, &c2);
  gdk_draw_rectangle (window, gc, FALSE,
		      x - 7 - 1, y - 7 - 1, 7, 7);
  gdk_gc_set_foreground (gc, &c1);
  gdk_draw_rectangle (window, gc, TRUE,
		      x - 6 - 1, y - 6 - 1, 6, 6);
  gdk_gc_set_foreground (gc, &c2);
  gdk_draw_rectangle (window, gc, FALSE,
		      x + w - 1 + 0 + 1, y - 7 - 1, 7, 7);
  gdk_gc_set_foreground (gc, &c1);
  gdk_draw_rectangle (window, gc, TRUE,
		      x + w - 1 + 1 + 1, y - 6 - 1, 6, 6);
  gdk_gc_set_foreground (gc, &c2);
  gdk_draw_rectangle (window, gc, FALSE,
		      x + w - 1 + 0 + 1, y + h + 1 - 1 + 0, 7, 7);
  gdk_gc_set_foreground (gc, &c1);
  gdk_draw_rectangle (window, gc, TRUE,
		      x + w - 1 + 1 + 1, y + h + 1 - 1 + 1, 6, 6);
  gdk_gc_set_foreground (gc, &c2);
  gdk_draw_rectangle (window, gc, FALSE,
		      x - 7 - 1, y + h + 1 - 1 + 0, 7, 7);
  gdk_gc_set_foreground (gc, &c1);
  gdk_draw_rectangle (window, gc, TRUE,
		      x - 6 - 1, y + h + 1 + 1 - 1 + 1 - 1, 6, 6);
  gdk_gc_set_foreground (gc, &c2);
  gdk_draw_rectangle (window, gc, FALSE, 
		     x - 2 - 1, y - 2 - 1, w + 2 - 1 + 4, h + 2 - 1 + 4);
  gdk_draw_rectangle (window, gc, FALSE, 
		     x - 1, y - 1, w + 2 - 1, h + 2 - 1);
  gdk_gc_set_foreground (gc, &c1);
  gdk_draw_rectangle (window, gc, FALSE, 
		     x - 1 - 1, y - 1 - 1, w + 2 - 1 + 2, h + 2 - 1 + 2);
  gdk_flush ();
  gdk_gc_destroy (gc);
}

/* åԥΰΥꥢ ************************************************ */
void
te_crip_clear_crip (void) {
  GdkWindow	*window;
  GtkWidget	*canvas;
  gint		x, y, w, h;

  /* åȤγ */
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (image_window), "canvas");
  window = canvas->window;

  /* åΰγ */
  x = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_x");
  y = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_y");
  w = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_w");
  h = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_h");

  /* ΰΥꥢ */
  if (w >= 10 && h >= 10)
    gdk_window_clear_area (window,
			   x - 1 + (w >> 1) - 4, y - 1 + (h >> 1) - 4, 8, 8);
  gdk_window_clear_area (window, x - 8, y - 8, 8,      h + 16);
  gdk_window_clear_area (window, x - 8, y - 8, w + 16, 8);
  gdk_window_clear_area (window, x + w, y - 8, 8,      h + 16);
  gdk_window_clear_area (window, x - 8, y + h, w + 16, 8);
}

/* åԥ󥰥⡼ɤβ ************************************************ */
static void
te_crip_remove_crip (void) {

  gtk_object_set_data (GTK_OBJECT (image_window), "crip_x", (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (image_window), "crip_y", (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (image_window), "crip_w", (gpointer) 0);
  gtk_object_set_data (GTK_OBJECT (image_window), "crip_h", (gpointer) 0);

  /* ǥåȥɥؤȿ */
  if (edit_window) {
    GtkWidget	*widget_x;
    GtkWidget	*widget_y;
    GtkWidget	*widget_w;
    GtkWidget	*widget_h;

    widget_x = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), "spin_crip_x");
    widget_y = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), "spin_crip_y");
    widget_w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), "spin_crip_width");
    widget_h = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), "spin_crip_height");

    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_x), (gfloat) 0);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_y), (gfloat) 0);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_w), (gfloat) 0);
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_h), (gfloat) 0);
  }
}

/* åԥ󥰤μ¹ ****************************************************** */
void
te_crip_cb_do_crip (void) {
  GtkWidget	*canvas;
  TEImage	*te;
  GdkPixbuf	*pbuf, *tmp;
  unsigned char	*data;
  char		buf[256];
  int		x, y, w, h, ow, oh, nw, nh;

  /* åȤγ */
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (image_window), "canvas");

  /* ǡγ */
  pbuf = te_image_get_pbuf (image_list);

  /* åΰγ */
  x  = (int) gtk_object_get_data (GTK_OBJECT (image_window), "crip_x");
  y  = (int) gtk_object_get_data (GTK_OBJECT (image_window), "crip_y");
  w  = (int) gtk_object_get_data (GTK_OBJECT (image_window), "crip_w");
  h  = (int) gtk_object_get_data (GTK_OBJECT (image_window), "crip_h");
  ow = te_image_get_orig_width  (image_list);
  oh = te_image_get_orig_height (image_list);
  nw = te_image_get_curr_width  (image_list);
  nh = te_image_get_curr_height (image_list);

  /* åԥ󥰤μ¹ */
  if (pbuf) {
    if (w > 0 && h > 0) {
      x = x * ow / nw;
      y = y * oh / nh;
      w = w * ow / nw;
      h = h * oh / nh;

      /* åԥ */
      if (gdk_pixbuf_get_has_alpha (pbuf)) {
	data = (unsigned char *) malloc (sizeof (unsigned char) * w * h * 4);
	tmp = gdk_pixbuf_new_from_data (data, GDK_COLORSPACE_RGB, TRUE, 8,
					w, h, w * 4, free_buffer, NULL);
      } else {
	data = (unsigned char *) malloc (sizeof (unsigned char) * w * h * 3);
	tmp = gdk_pixbuf_new_from_data (data, GDK_COLORSPACE_RGB, FALSE, 8,
					w, h, w * 3, free_buffer, NULL);
      }
      gdk_pixbuf_copy_area (pbuf, x, y, w, h, tmp, 0, 0);

      sprintf (buf, "./_crip%d.ppm",
	       te_image_get_id (g_list_last (image_list)) + 1);
      te_image_add_image_list (g_list_last (image_list), buf,
			       te_image_get_id (g_list_last (image_list))+1,1);
      
      /* ȲΥ */
      if (opt->clear_data && !opt->display_mode) {
	te_image_clear_image (image_list);
      }
      /* åԥ󥰤ꥹȤɲ */
      image_list	= g_list_last (image_list);
      te		= te_image_get_image (image_list);
      te->pbuf		= tmp;

      if (!opt->display_mode) {
	te_image_load_image (image_list, 0, opt->min, opt->max);
      }
      /* 礭 */      
      w = (int) gtk_object_get_data (GTK_OBJECT (image_window), "crip_w");
      h = (int) gtk_object_get_data (GTK_OBJECT (image_window), "crip_h");
      gtk_widget_set_usize (canvas, w, h);
      te_image_set_image_size (image_window, w, h);
      te_crip_remove_crip ();

      /* ꥹȥɥƤϥͥ򹹿 */
      if (list_window && GTK_WIDGET_VISIBLE (list_window)) {
	te_image_list_refresh_list ();
      }
    }
  }
}

/* ޥܥ󤬲줿ν ****************************************** */
void
te_crip_cb_mouse_press (int	x,
			int	y) {
  gint		cx, cy, cw, ch;

  cx = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_x");
  cy = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_y");
  cw = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_w");
  ch = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_h");
  if (x >= cx && x < (cx + cw) && y >= cy && y < (cy + ch)) {
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_do", (gpointer) 3);
    gtk_object_set_data (GTK_OBJECT (image_window), "prev_x",  (gpointer) x);
    gtk_object_set_data (GTK_OBJECT (image_window), "prev_y",  (gpointer) y);
  } else if (x <= (cx + (cw / 2)) && y <= (cy + (ch / 2)) &&
	     x >= (cx - 8) && y >= (cy - 8)) {
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_do",    (gpointer)2);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_dir_x", (gpointer)1);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_dir_y", (gpointer)1);
  } else if (x <= (cx + (cw / 2)) && y >= (cy + (ch / 2)) &&
	     x >= (cx - 8) && y <= (cy + ch + 8)) {
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_do",    (gpointer)2);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_dir_x", (gpointer)1);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_dir_y", (gpointer)2);
  } else if (x >= (cx + (cw / 2)) && y <= (cy + (ch / 2)) &&
	     x <= (cx + cw + 8) && y >= (cy - 8)) {
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_do",    (gpointer)2);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_dir_x", (gpointer)2);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_dir_y", (gpointer)1);
  } else if (x >= (cx + (cw / 2)) && y >= (cy + (ch / 2)) &&
	     x <= (cx + cw + 8) && y <= (cy + ch + 8)) {
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_do",    (gpointer)2);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_dir_x", (gpointer)2);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_dir_y", (gpointer)2);
  } else {
    te_crip_clear_crip ();
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_do",    (gpointer)1);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_x",	  (gpointer)x);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_y",     (gpointer)y);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_w",     (gpointer)0);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_h",     (gpointer)0);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_dir_x", (gpointer)0);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_dir_y", (gpointer)0);
  }
}

/* ޥɥå줿ν ****************************************** */
void
te_crip_cb_mouse_move (int	x,
		       int	y) {
  GtkWidget	*canvas;
  gint		w, h;
  gint          px, py, pw, ph, cx, cy, cw, ch, dirx, diry;
  gint          cripping;

  /* åȤγ */
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (image_window), "canvas");
  cripping = (gint)
    gtk_object_get_data (GTK_OBJECT (image_window), "crip_do");

  w = canvas->allocation.width;
  h = canvas->allocation.height;
  
  if (cripping == 1) { /* åԥΰ */
    te_crip_clear_crip ();
    cx = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_x");
    cy = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_y");
    pw = cw = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_w");
    ph = ch = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_h");
    dirx = (gint) gtk_object_get_data (GTK_OBJECT (image_window),"crip_dir_x");
    diry = (gint) gtk_object_get_data (GTK_OBJECT (image_window),"crip_dir_y");
    
    if (!dirx) {
      if (x < cx) {
	dirx = 1;
      } else if (x > cx) {
	dirx = 2;
      }
      if (dirx) gtk_object_set_data (GTK_OBJECT (image_window),
				     "crip_dir_x", (gpointer) (dirx));
    }
    if (!diry) {
      if (y < cy) {
	diry = 1;
      } else if (y > cy) {
	diry = 2;
      }
      if (diry) gtk_object_set_data (GTK_OBJECT (image_window),
				     "crip_dir_y", (gpointer) (diry));
    }
    if (x < 0) x = 0;
    if (x > w) x = w;
    if (dirx == 1) {
      cw = cw + cx - x;
    } else if (dirx == 2) {
      cw = x - cx;
      x = cx;
    }
    if (cw < 1) {
      cw = 1;
      if (x > (cx + pw - 1))	x = cx + pw - 1;
      if (pw == cw)		x = cx;
    } else if (pw == cw) {
      x = cx;
    }
    if ((x + cw) > w) cw = w - x;
    
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_x", (gpointer) x);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_w", (gpointer) cw);

    if (y < 0) y = 0;
    if (y > h) y = h;
    if (diry == 1) {
      ch = ch + cy - y;
    } else if (diry == 2) {
      ch = y - cy;
      y = cy;
    }
    if (ch < 1) {
      ch = 1;
      if (y > (cy + ph - 1))	y = cy + ph - 1;
      if (ph == ch)		y = cy;
    } else if (ph == ch) {
      y = cy;
    }
    if ((y + ch) > h) ch = h - y;

    gtk_object_set_data (GTK_OBJECT (image_window), "crip_y", (gpointer) y);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_h", (gpointer) ch);

    te_crip_draw_crip ();

  } else if (cripping == 2) { /* åԥΰΰư */

    te_crip_clear_crip ();
    cx = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_x");
    cy = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_y");
    pw = cw = (gint)
      gtk_object_get_data (GTK_OBJECT (image_window), "crip_w");
    ph = ch = (gint)
      gtk_object_get_data (GTK_OBJECT (image_window), "crip_h");
    dirx = (gint)
      gtk_object_get_data (GTK_OBJECT (image_window), "crip_dir_x");
    diry = (gint)
      gtk_object_get_data (GTK_OBJECT (image_window), "crip_dir_y");

    if (x < 0) x = 0;
    if (x > w) x = w;
    if (dirx == 1) {
      cw = cw + cx - x;
    } else if (dirx == 2) {
      cw = x - cx;
      x  = cx;
    }
    if (cw < 1) {
      cw = 1;
      if (x > (cx + pw - 1))	x = cx + pw - 1;
      if (pw == cw)		x = cx;
    } else if (pw == cw) {
      x = cx;
    }
    if ((x + cw) > w) cw = w - x;

    gtk_object_set_data (GTK_OBJECT (image_window), "crip_x", (gpointer) x);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_w", (gpointer) cw);

    if (y < 0) y = 0;
    if (y > h) y = h;
    if (diry == 1) {
      ch = ch + cy - y;
    } else if (diry == 2) {
      ch = y - cy;
      y  = cy;
    }
    if (ch < 1) {
      ch = 1;
      if (y > (cy + ph - 1))	y = cy + ph - 1;
      if (ph == ch)		y = cy;
    } else if (ph == ch) {
      y = cy;
    }
    if ((y + ch) > h) ch = h - y;

    gtk_object_set_data (GTK_OBJECT (image_window), "crip_y", (gpointer) y);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_h", (gpointer) ch);
    
    te_crip_draw_crip ();

  } else if (cripping == 3) {

    te_crip_clear_crip ();
    cx = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_x");
    cy = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_y");
    px = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "prev_x");
    py = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "prev_y");
    cw = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_w");
    ch = (gint) gtk_object_get_data (GTK_OBJECT (image_window), "crip_h");

    cx += x - px;
    cy += y - py;
      
    if (cx < 0) cx = 0;
    if (cy < 0) cy = 0;
    if ((cx + cw) > w) cx = w - cw;
    if ((cy + ch) > h) cy = h - ch;

    gtk_object_set_data (GTK_OBJECT (image_window), "prev_x", (gpointer) x);
    gtk_object_set_data (GTK_OBJECT (image_window), "prev_y", (gpointer) y);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_x", (gpointer) cx);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_y", (gpointer) cy);

    te_crip_draw_crip ();
  }
}

/* ޥ ܥΥ줿ν ***************************************** */
void
te_crip_mouse_release (void) {
  int	dirx, diry;

  gtk_object_set_data (GTK_OBJECT (image_window), "crip_do", (gpointer) 0);
  dirx = (int) gtk_object_get_data (GTK_OBJECT (image_window), "crip_dir_x");
  diry = (int) gtk_object_get_data (GTK_OBJECT (image_window), "crip_dir_y");
  if (!dirx || !diry) {
    te_crip_clear_crip ();
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_x", (gpointer) 0);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_y", (gpointer) 0);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_w", (gpointer) 0);
    gtk_object_set_data (GTK_OBJECT (image_window), "crip_h", (gpointer) 0);
    gtk_object_set_data (GTK_OBJECT (image_window),
			 "crip_dir_x", (gpointer) 0);
    gtk_object_set_data (GTK_OBJECT (image_window),
			 "crip_dir_y", (gpointer) 0);
  }
}

/* *************************************************** End of cripping.c *** */
