/* *************************************************************** dnd.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-11-07 22:37:03 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include "stock-dnd-file.xpm"

/* ************************************************************************* */
enum {
  TARGET_URI_LIST,
  TARGET_URL,
  TARGET_STRING,
  TARGET_ROOTWIN  
};

static GtkTargetEntry target_table[] = {
  { "STRING",     0, TARGET_STRING },
  { "text/plain", 0, TARGET_STRING },
  { "text/uri-list", 0, TARGET_URL },
  { "application/x-rootwin-drop", 0, TARGET_ROOTWIN }
};

static guint n_targets = sizeof (target_table) / sizeof (target_table[0]);

/* ɥå׻Υ٥ **************************************************** */
static void
drop_event (GtkWidget		*widget,
	    GdkDragContext	*context,
	    gint		x,
	    gint		y,
	    GtkSelectionData	*selection_data,
	    guint		info,
	    guint		time) {
  gchar	*filename;
  int	n;

  if (!selection_data->data) return;

  if (strncmp (selection_data->data, "file:", 5) == 0) {
    filename = selection_data->data + 5;
  } else {
    filename = selection_data->data;
  }
  
  filename[strlen (filename) - 2] = '\0';

  /* ե뤬¸ߤ뤫ɤĴ٤ */
  if (!filename || !y_file_exist_file (filename)) return;

  /* ꤵ줿ե뤬бե뤫ɤĴ٤ */
  if (what_format_is_this (filename) == FORMAT_UNKNOWN) return;

  /* 򳫤 */
  if (!te_open_file_with_same_window (filename)) exit (1);
}

/* ɥå¦ ******************************************************** */
void
te_dnd_drop_on_widget (GtkWidget	*widget) {
  static GtkTargetEntry drag_types[] =
  {
    {"text/uri-list", 0, TARGET_URI_LIST},
    {"_NETSCAPE_URL", 0, TARGET_URL}
  };

  static gint		n_drag_types;

  n_drag_types = sizeof (drag_types) / sizeof (drag_types[0]);

  gtk_drag_dest_set (widget,
		     GTK_DEST_DEFAULT_MOTION |
		     GTK_DEST_DEFAULT_HIGHLIGHT |
		     GTK_DEST_DEFAULT_DROP,
		     drag_types,
		     n_drag_types,
		     GDK_ACTION_COPY);
  gtk_signal_connect (GTK_OBJECT (widget), "drag_data_received",
		      GTK_SIGNAL_FUNC (drop_event), NULL);
}

/* ɥå¦ ******************************************************** */

/* ************************************************************************* */
static void
te_dnd_drag_data_get (GtkWidget		*widget,
		      GdkDragContext	*context,
		      GtkSelectionData	*selection_data,
		      guint		info,
		      guint		time,
		      gpointer		data) {
  gchar	*src_ptr;
  gchar	*dst_ptr;  
  gchar	*name;
  int	n;

  name = (gchar *) malloc (sizeof (gchar)
			   * (strlen ((gchar *) data) + 8));
  src_ptr = (gchar *) data;
  dst_ptr = name;
  *dst_ptr++ = 'f';
  *dst_ptr++ = 'i';
  *dst_ptr++ = 'l';
  *dst_ptr++ = 'e';
  *dst_ptr++ = ':';
  for (n = 0; n < strlen ((gchar *) data); n++) {
    *dst_ptr++ = *src_ptr++;
  }
  *dst_ptr++ = '\r';
  *dst_ptr++ = '\n';
  *dst_ptr++ = '\0';  
  
  gtk_selection_data_set (selection_data,
			  selection_data->target,
			  8,
			  (gchar *) name,
			  strlen (name) + 1);

  free (name);
}

/* ************************************************************************* */
void
te_dnd_drag_on_widget (GtkWidget	*widget,
		       gchar		*name) {
  GdkPixmap	*drag_icon;
  GdkPixmap	*drag_mask;

  drag_icon = gdk_pixmap_create_from_xpm_d ((GdkWindow *) &gdk_root_parent,
					    &drag_mask, NULL, stock_dnd_file);
  gtk_drag_source_set (widget,
		       GDK_BUTTON1_MASK,
                       target_table,
		       n_targets, 
                       GDK_ACTION_COPY | GDK_ACTION_MOVE);
  gtk_drag_source_set_icon (widget, 
                            gtk_widget_get_colormap (image_window),	
                            drag_icon,
			    drag_mask);
  gtk_signal_connect (GTK_OBJECT (widget), "drag_data_get",
		      GTK_SIGNAL_FUNC (te_dnd_drag_data_get),
		      g_strdup (name));

  gdk_pixmap_unref (drag_icon);
  gdk_pixmap_unref (drag_mask);  
}

/* ******************************************************** End of dnd.c *** */
