/* ************************************************************** draw.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/01/25 10:50:04 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"

/*  ************************************************************** */
void
te_draw_image (GList		*list,
	       gint		width,
	       gint		height) {
  GtkWidget	*canvas;
  GdkWindow	*window;
  GdkPixbuf	*back;
  GdkPixbuf	*tmp;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  TEImage	*ti;
  
  /* Хγ */
  canvas = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (image_window), "canvas");
  window = canvas->window;

  if (opt->display_mode) {	/* ɽ⡼ */
    /* ɥؤ */
    gdk_window_set_back_pixmap (window, te_image_get_pixmap (list), FALSE);
    gdk_window_clear (window);
    gdk_window_shape_combine_mask (window, te_image_get_mask (list), 0, 0);
    gdk_flush ();
  } else {
    if (opt->quick_draw) {	/* ®⡼ */
      /*  */
      back = gdk_pixbuf_scale_simple (te_image_get_pbuf (list),
				      width, height, GDK_INTERP_TILES);
      /* ԥåޥåפ */
      gdk_pixbuf_render_pixmap_and_mask (back, &pixmap, &mask, 255);

      /* ɥؤ */
      gdk_window_set_back_pixmap (window, pixmap, FALSE);
      gdk_window_clear (window);
      gdk_window_shape_combine_mask (window, mask, 0, 0);
      gdk_flush ();
      gdk_pixbuf_unref (back);
      gdk_pixmap_unref (pixmap);
      if (mask) gdk_bitmap_unref (mask);
    } else {			/* ɸ⡼ */
      /* ץ졼ɽ⡼ɤξ... */
      if (te_image_get_plane (list) != -1) {
	tmp = gdk_pixbuf_copy (te_image_get_pbuf (list));
	te_image_create_plane_data (list, te_image_get_plane (list));
      }
      /* Хå */
      gdk_window_set_back_pixmap (window, NULL, FALSE);
      back = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, width, height);
      /*  */
      gdk_pixbuf_composite_color (te_image_get_pbuf (list), back,
				  0, 0,
				  width, height,
				  0, 0,
				  (double) width  /
				  gdk_pixbuf_get_width
				  (te_image_get_pbuf (list)),
				  (double) height /
				  gdk_pixbuf_get_height
				  (te_image_get_pbuf(list)),
				  GDK_INTERP_TILES,
				  255,
				  0, 0,
				  16, 0xaaaaaa, 0x555555);
      /* ɥؤ */

      /* ԥåޥåפ */
      gdk_pixbuf_render_pixmap_and_mask (back, &pixmap, &mask, 255);

      /* ɥؤ */
      gdk_window_set_back_pixmap (window, pixmap, FALSE);
      gdk_window_clear (window);
      gdk_window_shape_combine_mask (window, mask, 0, 0);
      gdk_flush ();

      gdk_pixbuf_unref (back);
      gdk_pixmap_unref (pixmap);
      if (mask) gdk_bitmap_unref (mask);
      
      /* ץ졼ɽ⡼ɤξ... */
      if (te_image_get_plane (list) != -1) {
	ti = te_image_get_image (list);
	gdk_pixbuf_unref (ti->pbuf);
	ti->pbuf = gdk_pixbuf_copy (tmp);
	ti->curr_data->data = (void *) gdk_pixbuf_get_pixels (ti->pbuf);
	gdk_pixbuf_unref (tmp);
      }
    }
  }
}

/* طʤؤ ************************************************************ */
void
te_draw_on_desktop (GList	*list,
		    int		mode) {
  GdkWindow		*window;
  GdkVisual		*visual;
  GdkWindowPrivate 	*window_private;
  GdkImagePrivate	*gimage_private;
  GdkGC			*gc;
  GdkPixmap		*pixmap;
  GdkPixmap		*pbuf_data;
  GdkBitmap		*mask;
  
  int			w, h;
  
  /* 롼ȥɥγ */
  window = GDK_ROOT_PARENT ();
  visual = gdk_window_get_visual (window);

  /*  */
  w = te_image_get_curr_width (list);
  h = te_image_get_curr_height(list);

  switch (mode) {
  case (DRAW_TILE):
    /* 褵Υԥåޥåפ */    
    gdk_pixbuf_render_pixmap_and_mask (te_image_get_pbuf (list),
				       &pbuf_data, &mask, 255);
    gdk_window_set_back_pixmap (window, pbuf_data, 0);
    if (pbuf_data) gdk_pixmap_unref (pbuf_data);
    if (mask)      gdk_bitmap_unref (mask);

    break;

  case (DRAW_CENTER):
    window_private = (GdkWindowPrivate *) window;
    gc = gdk_gc_new (window);
    /* طѤΥԥåޥåפ */
    pixmap = gdk_pixmap_new (window,
			     window_private->width,
			     window_private->height,
			     visual->depth);

    /* ǥꥢ */
    gdk_draw_rectangle ((GdkDrawable *) pixmap, gc, 1, 0, 0,
			window_private->width, window_private->height);
    
    /* 褵Υԥåޥåפ */
    gdk_pixbuf_render_pixmap_and_mask (te_image_get_pbuf (list),
				       &pbuf_data, &mask, 255);
    
    /*  */
    gdk_draw_pixmap ((GdkDrawable *) pixmap,
		     gc,
		     (GdkDrawable *) pbuf_data,
		     0, 0,
		     window_private->width / 2 - w / 2,
		     window_private->height/ 2 - h / 2,
		     w, h);
     gdk_window_set_back_pixmap (window, pixmap, 0);

     if (pixmap)    gdk_pixmap_unref (pixmap);
     if (pbuf_data) gdk_pixmap_unref (pbuf_data);
     if (mask)      gdk_bitmap_unref (mask);
     if (gc)        gdk_gc_unref (gc);

     break;
   }
  gdk_window_clear (window);
  gdk_flush ();    
}

/* ************************************************************************* */
void
te_draw_loope_image (GtkWidget	*widget,
		     GList	*list,
		     int	x,
		     int	y,
		     int	rx,
		     int	ry,
		     int	scale) {
  GdkWindow	*window;
  GdkPixbuf	*pbuf, *back;
  unsigned char	*data, *src_ptr, *dst_ptr;
  static int	pre_x, pre_y;
  int		pos, row, col, ox, oy, w, h, ow, oh, p;
  
  /* ΰ֡礭γ */
  if (x == -1) x = pre_x;
  if (y == -1) y = pre_y;
  pre_x = x;
  pre_y = y;
  w	= SW_WIDTH / scale;
  h	= SW_HEIGHT/ scale;
  ox	= x + 1 - w / 2;
  oy	= y + 1 - h / 2;
  ow	= te_image_get_orig_width (list);
  oh	= te_image_get_orig_height(list);

  /* ǡؤΥݥ */
  src_ptr = gdk_pixbuf_get_pixels (te_image_get_pbuf (list));

  /* ץ졼γ */
  p = te_image_get_has_alpha (list) + 3;

  /* ǡΰ */
  dst_ptr = data =
    (unsigned char *) malloc (sizeof (unsigned char) * w * h * 3);
  
  /* ǡ */
  for (row = oy; row < oy + h; row++) {
    for (col = ox; col < ox + w; col++) {
      if (row < 0 || row >= oh || col < 0 || col >= ow) {
	*dst_ptr++ = 0;
	*dst_ptr++ = 0;
	*dst_ptr++ = 0;
      } else {
	pos = (row * ow + col) * p;
	*dst_ptr++ = *(src_ptr + pos);
	*dst_ptr++ = *(src_ptr + pos + 1);
	*dst_ptr++ = *(src_ptr + pos + 2);
      }
    }
  }

  /*  */
  pbuf = gdk_pixbuf_new_from_data (data, GDK_COLORSPACE_RGB,
				   FALSE, 8, w, h, w * 3, free_buffer, NULL);
  back = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, SW_WIDTH, SW_HEIGHT);

  /* Хγ */
  window = widget->window;
  gdk_window_set_back_pixmap (window, NULL, FALSE);
  gdk_pixbuf_composite_color (pbuf, back,
			      0, 0,
			      SW_WIDTH, SW_HEIGHT,
			      0, 0,
			      (double) SW_WIDTH / w,
			      (double) SW_HEIGHT/ h,
			      GDK_INTERP_TILES,
			      255,
			      0, 0,
			      8, 0xaaaaaa, 0x555555);
  gdk_pixbuf_render_to_drawable (back,
				 window,
				 widget->style->fg_gc[GTK_STATE_NORMAL],
				 0, 0,
				 0, 0,
				 SW_WIDTH, SW_HEIGHT,
				 GDK_RGB_DITHER_NORMAL,
				 0, 0);
  gdk_draw_rectangle (window,
		      widget->style->white_gc, FALSE, rx, ry, scale, scale);
  gdk_draw_rectangle (window, widget->style->black_gc,
		      FALSE, rx + 1, ry + 1, scale - 2, scale - 2);
  
  gdk_pixbuf_unref (pbuf);
  gdk_pixbuf_unref (back);  
}

/* ******************************************************* End of draw.c *** */
