/* ************************************************************** edit.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <03/09/30 21:04:39 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"
#include <gdk/gdkkeysyms.h>
#include "gtkiconbutton.h"
#include "stock_button_close.xpm"
#include "stock_button_apply.xpm"
#include "stock_button_cancel.xpm"
#include "stock_menu_about.xpm"
#include "icon_gamma.xpm"
#include "icon_contrast.xpm"
#include "icon_brightness.xpm"
#include "book_open.xpm"
#include "book_closed.xpm"

static GdkPixmap	*book_open;
static GdkPixmap	*book_closed;
static GdkBitmap	*book_open_mask;
static GdkBitmap	*book_closed_mask;

static int		keep_aspect;

/* ************************************************************************* */
static void
te_edit_icon_new		(void);
static void
te_edit_notebook_page_switch 	(GtkWidget		*widget,
				 GtkNotebookPage 	*page,
				 gint			page_num);


static void
te_edit_close 			(GtkWidget		*widget,
				 GtkWidget		*parent);

/* ************************************************************************* */
static void
te_edit_color_balance_render_mod (GtkWidget		*a,
				  GdkPixbufModifier 	*modifier,
				  int			channel,
				  gint			br);
void
te_edit_update_graphs		(GtkWidget		*w);
static void
te_edit_color_balance_channel	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_color_balance_gamma 	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_color_balance_bright 	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_color_balance_cont	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_color_balance_button_gamma (GtkWidget		*widget,
				    gpointer		data);
static void
te_edit_color_balance_button_bright (GtkWidget		*widget,
				     gpointer		data);
static void
te_edit_color_balance_button_cont (GtkWidget		*widget,
				   gpointer		data);
static void
te_edit_color_balance_button_apply (GtkWidget		*widget,
				    gpointer		data);
static void
te_edit_color_balance_button_cancel (GtkWidget		*widget,
				     gpointer		data);

/* ************************************************************************* */
static void
te_edit_geometry_enter_width	(GtkWidget		*widget,
				 GdkEventKey		*key, 
				 gpointer		data);
static void
te_edit_geometry_enter_height	(GtkWidget		*widget,
				 GdkEventKey		*key, 
				 gpointer		data);
static void
te_edit_geometry_keep_aspect 	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_geometry_button_apply 	(GtkWidget		*widget,
				 gpointer		parent);
static void
te_edit_geometry_button_half 	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_geometry_button_down 	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_geometry_button_reset 	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_geometry_button_up 	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_geometry_button_double 	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_normal_button_best 	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_normal_button_apply 	(GtkWidget		*widget,
				 gpointer		parent);

/* ************************************************************************* */
static void
te_edit_crip_change_x 		(GtkWidget		*widget,
				 gpointer		parent);
static void
te_edit_crip_change_y 		(GtkWidget		*widget,
				 gpointer		parent);
static void
te_edit_crip_change_width 	(GtkWidget		*widget,
				 gpointer		parent);
static void
te_edit_crip_change_height 	(GtkWidget		*widget,
				 gpointer		parent);
static void
te_edit_crip_button_apply 	(GtkWidget		*widget,
				 gpointer		parent);
static void
te_edit_crip_button_cancel 	(GtkWidget		*widget,
				 gpointer		data);
static void
te_edit_grab_start 		(GtkWidget		*widget,
				 gpointer		parent);

/* ************************************************************************* */
static GtkWidget*
te_edit_color_balance_widget_new(GtkWidget		*parent);
static void
te_edit_notebook_color		(GtkWidget		*parent,
				 GtkWidget		*notebook);
static void
te_edit_notebook_geometry	(GtkWidget		*parent,
				 GtkWidget		*notebook);
static void
te_edit_notebook_crip_and_grab	(GtkWidget		*parent,
				 GtkWidget		*notebook);

/* ************************************************************************* *
 * ǥåȥɥǻѤؿ
 *    	(ɥѴؿ)
 * ************************************************************************* */

/* Ρȥ֥åѤΥ ******************************************** */
static void
te_edit_icon_new (void) {
  book_open
    = gdk_pixmap_create_from_xpm_d ((GdkWindow *) &gdk_root_parent,
				    &book_open_mask, NULL, book_open_xpm);
  book_closed 
    = gdk_pixmap_create_from_xpm_d ((GdkWindow *) &gdk_root_parent,
				    &book_closed_mask,
				    NULL, book_closed_xpm);
}

/* ڡڤؤΥڤؤ ************************************ */
static void
te_edit_notebook_page_switch (GtkWidget		*widget,
			      GtkNotebookPage 	*page,
			      gint		page_num) {
  GtkNotebookPage	*oldpage;
  GtkWidget		*pix;

  oldpage = GTK_NOTEBOOK (widget)->cur_page;
  if (page == oldpage) return;

  pix = ((GtkBoxChild*)
	 (GTK_BOX (page->tab_label)->children->data))->widget;
  gtk_pixmap_set (GTK_PIXMAP (pix), book_open, book_open_mask);

  if (oldpage) {
    pix = ((GtkBoxChild*)
	   (GTK_BOX (oldpage->tab_label)->children->data))->widget;
    gtk_pixmap_set (GTK_PIXMAP (pix), book_closed, book_closed_mask);
  }
}

/* ǥåȥɥĤ ******************************************** */
static void
te_edit_close (GtkWidget	*widget,
	       GtkWidget	*parent) {
  gtk_widget_hide (edit_window);
  gtk_widget_destroy (edit_window);
  edit_window = NULL;
}

/* ************************************************************************* *
 * ǥåȥɥǻѤؿ
 *    	(顼ХѥХåؿ)
 * ************************************************************************* */
static void
te_edit_color_balance_render_mod (GtkWidget		*a,
				  GdkPixbufModifier 	*modifier,
				  int			channel,
				  gint			br) {
  unsigned char		modr[256], modg[256], modb[256], mod[256];
  unsigned char		*ptr;
  int			i, val, x, y;
  static GdkPixbuf	*curve = NULL;
  GdkPixbuf		*scurve;
  GdkPixmap		*pmap;
  GdkBitmap		*mask;
  
  if (!curve) {
    ptr = g_malloc (64 * 64 * 3);
    curve = gdk_pixbuf_new_from_data (ptr, GDK_COLORSPACE_RGB, FALSE,
				      8, 64, 64, 64 * 3, free_buffer, NULL);
  }
  switch (channel) {
  case 0:
    gdk_pixbuf_get_image_red_curve   (modifier->map, modr);
    gdk_pixbuf_get_image_green_curve (modifier->map, modg);
    gdk_pixbuf_get_image_blue_curve  (modifier->map, modb);
    for (i = 0; i < 256; i++)
      mod[i] = (unsigned char)
	(((int) modr[i] + (int) modg[i] + (int) modb[i]) / 3);
    break;
  case 1:
    gdk_pixbuf_get_image_red_curve   (modifier->map, mod);
    break;
  case 2:
    gdk_pixbuf_get_image_green_curve (modifier->map, mod);
    break;
  case 3:
    gdk_pixbuf_get_image_blue_curve  (modifier->map, mod);
    break;
  }
  ptr = gdk_pixbuf_get_pixels (curve);
  for (y = 0; y < 64; y++) {
    for (x = 0; x < 64; x++) {
      *ptr++ = 0;
      *ptr++ = 0;
      *ptr++ = 0;
    }
  }
  for (i = 0; i < 64; i++) {
    val = mod[i << 2] >> 2;
    ptr = gdk_pixbuf_get_pixels (curve) + (64 * 3 * 63) + (i * 3);
    for (y = 0; y < val; y++) {
      switch (channel) {
      case 0:
	ptr[0] = (i << 1) + (br >> 1);
	ptr[1] = (i << 1) + (br >> 1);
	ptr[2] = (i << 1) + (br >> 1);
	break;
      case 1:
	ptr[0] = (i << 1) + (br >> 1);
	ptr[1] = (y * br * i) / (val * 63);
	ptr[2] = (y * br * i) / (val * 63);	
	break;
      case 2:
	ptr[0] = (y * br * i) / (val * 63);
	ptr[1] = (i << 1) + (br >> 1);
	ptr[2] = (y * br * i) / (val * 63);	
	break;
      case 3:
	ptr[0] = (y * br * i) / (val * 63);
	ptr[1] = (y * br * i) / (val * 63);
	ptr[2] = (i << 1) + (br >> 1);
	break;
      }
      ptr -= (64 * 3);
    }
  }
  ptr = gdk_pixbuf_get_pixels (curve);
  for (y = 0; y < 64; y++) {
    for (x = 0; x < 64; x++) {
      if ((!(x % 8)) || (!(y % 8))) {
	val = *ptr + 255 - (y << 2);
	if (val > 255) val = 255;
	*ptr++ = val;
	val = *ptr + 255 - (y << 2);
	if (val > 255) val = 255;
	*ptr++ = val;
	val = *ptr + 255 - (y << 2);
	if (val > 255) val = 255;
	*ptr++ = val;
      } else {
	ptr += 3;
      }
    }
  }
  scurve = gdk_pixbuf_scale_simple (curve, 80, 80, GDK_INTERP_TILES);
  gdk_pixbuf_render_pixmap_and_mask (scurve, &pmap, &mask, 255);
  if (pmap) {
    gdk_window_set_back_pixmap (a->window, pmap, FALSE);
    gdk_pixmap_unref (pmap);
    if (mask) gdk_bitmap_unref (mask);
    gdk_window_clear (a->window);
    gdk_flush ();
  }
  gdk_pixbuf_unref (scurve);
}

/* 顼㡼ȥܥι ********************************************** */
void
te_edit_update_graphs (GtkWidget	*w) {
  GtkWidget	*a, *b;
  GdkPixbuf	*pbuf;
  int		n;
  char		buf[256];
  
  if (!w) return;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "draw_area%d", n);
    a = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (w), buf);
    if (!a) return;
    sprintf (buf, "channel_button%d", n);    
    b = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (w), buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (b))) {
      te_edit_color_balance_render_mod (a, te_image_get_modifier (image_list),
					n, 255);
    } else {
      te_edit_color_balance_render_mod (a, te_image_get_modifier (image_list),
					n, 63);
    }
  }
  te_edit_draw_preview ();
}

/* 顼ͥܥ󤬲줿ν ******************************** */
static void
te_edit_color_balance_channel (GtkWidget	*widget,
			       gpointer		data) {
  GdkPixbufColorModifier mod;
  GtkObject		*obj_gamma;
  GtkObject		*obj_bright;
  GtkObject		*obj_cont;
  GtkWidget		*b;
  int			n;
  char			buf[256];

  obj_gamma = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_gamma");
  obj_bright = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_bright");
  obj_cont = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_cont");
  
  if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget))) {
    for (n = 0; n < 4; n++) {
      sprintf (buf, "channel_button%d", n);
      b = (GtkWidget *) gtk_object_get_data (GTK_OBJECT (data), buf);
      if (b != widget)
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON (b), 0);
      else {
	switch (n) {
	case 0:
	  gdk_pixbuf_get_image_modifier (&((te_image_get_modifier
					    (image_list))->mod), &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	case 1:
	  gdk_pixbuf_get_image_modifier (&((te_image_get_modifier
					    (image_list))->rmod), &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	case 2:
	  gdk_pixbuf_get_image_modifier (&((te_image_get_modifier
					    (image_list))->gmod), &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	case 3:
	  gdk_pixbuf_get_image_modifier (&((te_image_get_modifier
					    (image_list))->bmod), &mod);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_gamma), mod.gamma);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_bright),mod.brightness);
	  gtk_adjustment_set_value(GTK_ADJUSTMENT (obj_cont), mod.contrast);
	  break;
	}
      }
    }
  }
  te_edit_update_graphs (GTK_WIDGET (data));
}

/* ************************************************************************* */
static void
te_edit_color_balance_gamma (GtkWidget	*widget,
			     gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  char			buf[256];
  int			n;
  gint			v;

  v  = GTK_ADJUSTMENT (widget)->value;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  
  switch (n) {
  case 0:
    gdk_pixbuf_get_image_modifier (&((te_image_get_modifier(image_list))->mod),
				   &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_modifier (&mod, te_image_get_modifier (image_list));
    break;
  case 1:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->rmod),
				  &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_red_modifier (&mod,te_image_get_modifier(image_list));
    break;
  case 2:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->gmod),
				  &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_green_modifier (&mod,
					 te_image_get_modifier (image_list));
    break;
  case 3:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->bmod),
				  &mod);
    mod.gamma = v;
    gdk_pixbuf_set_image_blue_modifier (&mod,
					te_image_get_modifier (image_list));
    break;
  }
  te_edit_update_graphs (edit_window);
}

/* ************************************************************************* */
static void
te_edit_color_balance_bright (GtkWidget	*widget,
			      gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  char			buf[256];
  int			n;
  gint			v;
  
  v  = GTK_ADJUSTMENT (widget)->value;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  
  switch (n) {
  case 0:
    gdk_pixbuf_get_image_modifier (&((te_image_get_modifier(image_list))->mod),
				   &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_modifier (&mod, te_image_get_modifier (image_list));
    break;
  case 1:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->rmod),
				  &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_red_modifier (&mod,
				       te_image_get_modifier (image_list));
    break;
  case 2:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->gmod),
				  &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_green_modifier (&mod,
					 te_image_get_modifier (image_list));
    break;
  case 3:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->bmod),
				  &mod);
    mod.brightness = v;
    gdk_pixbuf_set_image_blue_modifier (&mod,
					te_image_get_modifier (image_list));
    break;
  }
  te_edit_update_graphs (edit_window);
}

/* ************************************************************************* */
static void
te_edit_color_balance_cont (GtkWidget	*widget,
			    gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  char			buf[256];
  int			n;
  gint			v;
  
  v  = GTK_ADJUSTMENT (widget)->value;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }
  
  switch (n) {
  case 0:
    gdk_pixbuf_get_image_modifier (&((te_image_get_modifier(image_list))->mod),
				   &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_modifier (&mod,
				   te_image_get_modifier (image_list));
    break;
  case 1:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->rmod),
				  &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_red_modifier (&mod,
				       te_image_get_modifier (image_list));
    break;
  case 2:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->gmod),
				  &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_green_modifier (&mod,
					 te_image_get_modifier (image_list));
    break;
  case 3:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->bmod),
				  &mod);
    mod.contrast = v;
    gdk_pixbuf_set_image_blue_modifier (&mod,
					te_image_get_modifier (image_list));
    break;
  }
  te_edit_update_graphs (edit_window);
}

/* ************************************************************************* */
static void
te_edit_color_balance_button_gamma (GtkWidget	*widget,
				    gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  GtkObject		*obj_gamma;
  char			buf[256];
  int			n;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }

  obj_gamma = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_gamma");
  
  switch (n) {
  case 0:
    gdk_pixbuf_get_image_modifier (&((te_image_get_modifier(image_list))->mod),
				   &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_modifier (&mod,
				   te_image_get_modifier (image_list));
    break;
  case 1:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->rmod),
				  &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_red_modifier (&mod,
				       te_image_get_modifier (image_list));
    break;
  case 2:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->gmod),
				  &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_green_modifier (&mod,
					 te_image_get_modifier (image_list));
    break;
  case 3:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->bmod),
				  &mod);
    mod.gamma = 256.0;
    gdk_pixbuf_set_image_blue_modifier (&mod,
					te_image_get_modifier (image_list));
    break;
  }
  te_edit_update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_gamma), 256.0);
}

/* ************************************************************************* */
static void
te_edit_color_balance_button_bright (GtkWidget	*widget,
				     gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  GtkObject		*obj_bright;
  char			buf[256];
  int			n;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }

  obj_bright = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_bright");
  
  switch (n) {
  case 0:
    gdk_pixbuf_get_image_modifier (&((te_image_get_modifier(image_list))->mod),
				   &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_modifier (&mod,
				   te_image_get_modifier (image_list));
    break;
  case 1:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->rmod),
				  &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_red_modifier (&mod,
				       te_image_get_modifier (image_list));
    break;
  case 2:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->gmod),
				   &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_green_modifier (&mod,
					 te_image_get_modifier (image_list));
    break;
  case 3:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->bmod),
				  &mod);
    mod.brightness = 256.0;
    gdk_pixbuf_set_image_blue_modifier (&mod,
					te_image_get_modifier (image_list));
    break;
  }
  te_edit_update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_bright), 256.0);
}

/* ************************************************************************* */
static void
te_edit_color_balance_button_cont (GtkWidget	*widget,
				   gpointer	data) {
  GtkWidget		*w;
  GdkPixbufColorModifier mod;
  GtkObject		*obj_cont;
  char			buf[256];
  int			n;

  for (n = 0; n < 4; n++) {
    sprintf (buf, "channel_button%d", n);
    w = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (edit_window), buf);
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) break;
  }

  obj_cont = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_cont");
  
  switch (n) {
  case 0:
    gdk_pixbuf_get_image_modifier (&((te_image_get_modifier(image_list))->mod),
				   &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_modifier (&mod,
				   te_image_get_modifier (image_list));
    break;
  case 1:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->rmod),
				  &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_red_modifier (&mod,
				       te_image_get_modifier (image_list));
    break;
  case 2:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->gmod),
				  &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_green_modifier (&mod,
					 te_image_get_modifier (image_list));
    break;
  case 3:
    gdk_pixbuf_get_image_modifier(&((te_image_get_modifier(image_list))->bmod),
				  &mod);
    mod.contrast   = 256.0;    
    gdk_pixbuf_set_image_blue_modifier (&mod,
					te_image_get_modifier (image_list));
    break;
  }
  te_edit_update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_cont), 256.0);
}

/* ************************************************************************* */
static void
te_edit_color_balance_button_apply (GtkWidget	*widget,
				    gpointer	data) {
  GdkPixbuf		*pbuf;
  GdkPixbufModifier	*mod;
  
  pbuf = te_image_get_pbuf (image_list);
  mod  = te_image_get_modifier (image_list);
  if (pbuf && mod) gdk_pixbuf_apply_modifiers_to_rgb (pbuf, mod, 1);
  te_draw_image (image_list,
		 te_image_get_curr_width (image_list),
		 te_image_get_curr_height(image_list));
  te_edit_color_balance_button_cancel (widget, data);
}

/* ************************************************************************* */
static void
te_edit_color_balance_button_cancel (GtkWidget	*widget,
				     gpointer	data) {
  GdkPixbufColorModifier mod;
  GtkObject		*obj_gamma;
  GtkObject		*obj_bright;
  GtkObject		*obj_cont;

  obj_gamma = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_gamma");
  obj_bright = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_bright");
  obj_cont = (GtkObject *)
    gtk_object_get_data (GTK_OBJECT (edit_window), "adj_cont");
  
  gdk_pixbuf_get_image_modifier (&((te_image_get_modifier (image_list))->mod),
				 &mod);
  mod.gamma      = 256.0;
  mod.brightness = 256.0;
  mod.contrast   = 256.0;
  gdk_pixbuf_set_image_modifier (&mod,
				 te_image_get_modifier (image_list));

  te_edit_update_graphs (edit_window);

  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_gamma),  256.0);
  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_bright), 256.0);
  gtk_adjustment_set_value (GTK_ADJUSTMENT (obj_cont),   256.0);  
}

/* ************************************************************************* *
 * ǥåȥɥǻѤؿ
 *    	(ȥѥХåؿ)
 * ************************************************************************* */

/* ѹ ********************************************************** */
static void
te_edit_geometry_enter_width	(GtkWidget		*widget,
				 GdkEventKey		*key, 
				 gpointer		parent) {
  GtkWidget	*spin_width;
  GtkWidget	*spin_height;
  int		width;
  int		ow, oh;
  int		nw, nh;

  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return;

  if (keep_aspect) {
    ow = te_image_get_curr_width  (image_list);
    oh = te_image_get_curr_height (image_list);
    spin_width = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (parent), "spin_size_width");
    spin_height = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (parent), "spin_size_height");
    width = (int) atoi (gtk_entry_get_text (GTK_ENTRY (widget)));
    nw = (int)
      gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_width));
    if (nw != width) {
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget), (gfloat) width);
      nw = (int)
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_width));
    }
    nh = oh * nw / ow;
    if (nh != (int)
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_height))) {
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_height), (gfloat) nh);
    }
  }
}

/* ι⤵ѹ ******************************************************** */
static void
te_edit_geometry_enter_height	(GtkWidget		*widget,
				 GdkEventKey		*key, 
				 gpointer		parent) {
  GtkWidget	*spin_width;
  GtkWidget	*spin_height;
  int		height;
  int		ow, oh;
  int		nw, nh;

  if (key->keyval != GDK_Return && key->keyval != GDK_KP_Enter) return;

  if (keep_aspect) {
    ow = te_image_get_curr_width  (image_list);
    oh = te_image_get_curr_height (image_list);
    spin_width = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (parent), "spin_size_width");
    spin_height = (GtkWidget *)
      gtk_object_get_data (GTK_OBJECT (parent), "spin_size_height");
    height = (int) atoi (gtk_entry_get_text (GTK_ENTRY (widget)));
    nh = (int)
      gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_height));
    if (nh != height) {
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget), (gfloat) height);
      nh = (int)
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_height));
    }
    nw = ow * nh / oh;
    if (nw != (int)
	gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin_width))) {
      gtk_spin_button_set_value (GTK_SPIN_BUTTON (spin_width), (gfloat) nw);
    }
  }
}

/* ڥݻ ****************************************************** */
static void
te_edit_geometry_keep_aspect (GtkWidget	*widget,
			      gpointer	data) {
  keep_aspect = (int)
    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (widget));
}

/* ѹŬ **************************************************** */
static void
te_edit_geometry_button_apply (GtkWidget	*widget,
			       gpointer		parent) {
  GtkWidget	*widget_width;
  GtkWidget	*widget_height;
  int		w, h;

  widget_width  = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_size_width");
  widget_height = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_size_height");

  w = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_width));
  h = (int) gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_height));

  te_operation_scaling_by_size (image_list, w, h);
}

/* ѹ(ϡե) ****************************************** */
static void
te_edit_geometry_button_half (GtkWidget	*widget,
			      gpointer	data) {
  te_operation_scaling_by_scale (image_list, 0.5, 0.5);
}

/* ѹ(-10%) ************************************************** */
static void
te_edit_geometry_button_down (GtkWidget	*widget,
			      gpointer	data) {
  te_operation_scaling_by_scale (image_list, 0.9, 0.9);
}

/* ѹ(ꥸʥ륵) ************************************** */
static void
te_edit_geometry_button_reset (GtkWidget	*widget,
			       gpointer		data) {
  te_operation_scaling_by_size (image_list,
				te_image_get_orig_width (image_list),
				te_image_get_orig_height(image_list));
}

/* ѹ(+10%) ************************************************** */
static void
te_edit_geometry_button_up (GtkWidget	*widget,
			    gpointer	data) {
  te_operation_scaling_by_scale (image_list, 1.1, 1.1);
}

/* ѹ(֥륵) ****************************************** */
static void
te_edit_geometry_button_double (GtkWidget	*widget,
				gpointer	data) {
  te_operation_scaling_by_scale (image_list, 2.0, 2.0);
}

/* ϰϤѹ (Ǿ) ***************************************** */
static void
te_edit_normal_change_min (GtkWidget	*widget,
			   gpointer	data) {

}

/* ϰϤѹ () ***************************************** */
static void
te_edit_normal_change_max (GtkWidget	*widget,
			   gpointer	data) {

}

/*  (Ŭͤ) ******************************************* */
static void
te_edit_normal_button_best (GtkWidget	*widget,
			    gpointer	data) {
  double	min, max;
  TEOIMAGE	*tmp;
  
  /* ͤκǾ&ͤĴ٤ */  
  TeoGetPixelRange (te_image_get_orig_data (image_list), &min, &max);

  /* Хåå*/
  if (backup) gdk_pixbuf_unref (backup);
  backup = gdk_pixbuf_copy (te_image_get_pbuf (image_list));
  
  /*  */
  tmp = TeoCreateNormalImage (te_image_get_orig_data (image_list), min, max);
  if (TeoPlane (tmp) != 3) {
    Teo1PlaneTo3Plane (tmp, te_image_get_curr_data (image_list));
  } else {
    TeoCopyImage (tmp, te_image_get_curr_data (image_list));
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/*  (ꤷϰϤ) ************************************* */
static void
te_edit_normal_button_apply (GtkWidget	*widget,
			     gpointer	parent) {
  GtkWidget	*widget_min;
  GtkWidget	*widget_max;
  double	min, max;
  TEOIMAGE	*tmp;

  /* Ǿ&ͤĴ٤ */  
  widget_min = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_norm_min");
  widget_max = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_norm_max");

  min = (double)
    gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (widget_min));
  max = (double)
    gtk_spin_button_get_value_as_float (GTK_SPIN_BUTTON (widget_max));
  
  /* Хåå*/
  if (!backup) gdk_pixbuf_unref (backup);
  backup = gdk_pixbuf_copy (te_image_get_pbuf (image_list));
  
  /*  */
  tmp = TeoCreateNormalImage (te_image_get_orig_data (image_list), min, max);
  if (TeoPlane (tmp) != 3) {
    Teo1PlaneTo3Plane (tmp, te_image_get_curr_data (image_list));
  } else {
    TeoCopyImage (tmp, te_image_get_curr_data (image_list));
  }
  /*  */
  te_draw_image (image_list,
		 te_image_get_curr_width  (image_list),
		 te_image_get_curr_height (image_list));
}

/* ************************************************************************* *
 * ǥåȥɥǻѤؿ
 *    	(åסѥХåؿ)
 * ************************************************************************* */

/* åΰѹ  *************************************************** */
static void
te_edit_crip_change_x (GtkWidget	*widget,
		       gpointer		parent) {
  GtkWidget	*widget_x;
  GtkWidget	*widget_w;
  int		x, w;

  widget_x = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_x");
  widget_w = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_width");
  
  x = (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_x));
  w = (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_w));  

  if (x + w > te_image_get_curr_width (image_list)) {
    x = te_image_get_curr_width (image_list) - w;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_x), (gfloat) x);
  }
  
  te_crip_clear_crip ();
  
  gtk_object_set_data (GTK_OBJECT (image_window), "crip_x", (gpointer) x);
  
  te_crip_draw_crip ();
}

/* åΰѹ  *************************************************** */
static void
te_edit_crip_change_y (GtkWidget	*widget,
		       gpointer		parent) {
  GtkWidget	*widget_y;
  GtkWidget	*widget_h;
  int		y, h;

  widget_y = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_y");
  widget_h = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_height");
  
  y = (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_y));  
  h = (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_h));

  if (y + h > te_image_get_curr_height (image_list)) {
    y = te_image_get_curr_height (image_list) - h;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_y), (gfloat) y);
  }
  
  te_crip_clear_crip ();

  gtk_object_set_data (GTK_OBJECT (image_window), "crip_y", (gpointer) y);

  te_crip_draw_crip ();
}

/* åΰѹ  *************************************************** */
static void
te_edit_crip_change_width (GtkWidget	*widget,
			   gpointer	parent) {
  GtkWidget	*widget_x;
  GtkWidget	*widget_w;
  int		w, x;

  widget_x = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_x");
  widget_w = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_width");
  
  x = (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_x));
  w = (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_w));  

  if (x + w > te_image_get_curr_width (image_list)) {
    w = te_image_get_curr_width (image_list) - x;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_w), (gfloat) w);
  }
  
  te_crip_clear_crip ();

  gtk_object_set_data (GTK_OBJECT (image_window), "crip_w", (gpointer) w);

  te_crip_draw_crip ();
}

/* åΰѹ ⤵ ************************************************* */
static void
te_edit_crip_change_height (GtkWidget	*widget,
			    gpointer	parent) {
  GtkWidget	*widget_y;
  GtkWidget	*widget_h;
  int		y, h;

  widget_y = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_y");
  widget_h = (GtkWidget *)
    gtk_object_get_data (GTK_OBJECT (parent), "spin_crip_height");  

  y = (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_y));  
  h = (int)
    gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (widget_h));

  if (y + h > te_image_get_curr_height (image_list)) {
    h = te_image_get_curr_height (image_list) - y;
    gtk_spin_button_set_value (GTK_SPIN_BUTTON (widget_h), (gfloat) h);
  }
  
  te_crip_clear_crip ();

  gtk_object_set_data (GTK_OBJECT (image_window), "crip_h", (gpointer) h);

  te_crip_draw_crip ();
}

/* åפμ¹ ********************************************************** */
static void
te_edit_crip_button_apply (GtkWidget	*widget,
			   gpointer	parent) {
  te_crip_cb_do_crip ();
}

/* ************************************************************************* */
static void
te_edit_crip_button_cancel (GtkWidget	*widget,
			    gpointer	data) {

}

/* ֥⡼ɳ ******************************************************** */
static void
te_edit_grab_start (GtkWidget	*widget,
		    gpointer	parent) {
  if (gtk_toggle_button_get_active
      (GTK_TOGGLE_BUTTON (gtk_object_get_data (GTK_OBJECT (parent),
					       "check_hide_dialog")))) {
    gtk_widget_hide (GTK_WIDGET (parent));
  }
  te_grab_do ();
}

/* ************************************************************************* *
 * ǥåȥɥΥɥؿ
 * ************************************************************************* */

/* 襤٥ ********************************************************** */
static void
te_edit_canvas_expose (GtkWidget	*widget,
		       GdkEventExpose	*ev) {
  te_edit_draw_preview ();
}

/* 顼Х󥹥åȤ **************************************** */
static GtkWidget*
te_edit_color_balance_widget_new (GtkWidget	*parent) {
  GtkWidget	*box;
  GtkWidget	*sbox;
  GtkWidget	*hbox;
  GtkWidget	*frame;
  GtkWidget	*canvas;  
  GtkWidget	*widget;
  GtkWidget	*button;
  GtkObject	*obj;
  char		buf[256];
  int		n;

  /* ܥå */
  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (box);
  {
    /* ե졼 */
    frame = gtk_frame_new (NULL);
    gtk_widget_set_usize (frame, 160, 120);
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_widget_show (frame);
    {
      /* Х */
      widget = gtk_alignment_new (0.5, 0.5, 0.0, 0.0);
      gtk_widget_show (widget);
      gtk_container_add (GTK_CONTAINER (frame), widget);
      {
	canvas = gtk_drawing_area_new ();
	gtk_widget_set_usize (canvas, 160, 120);
	gtk_widget_show (canvas);
	gtk_container_add (GTK_CONTAINER (widget), canvas);
	gtk_object_set_data (GTK_OBJECT (parent), "canvas", canvas);
	gtk_widget_set_events (canvas, GDK_EXPOSURE_MASK);
      }
    }
    /* ܥå */
    sbox = gtk_vbox_new (FALSE, 0);
    gtk_widget_show (sbox);
    gtk_box_pack_start (GTK_BOX (box), sbox, FALSE, FALSE, 0);
    {
      /* ʿܥå */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, FALSE, FALSE, 0);
      gtk_widget_show (hbox);
      {
	for (n = 0; n < 4; n++) {

	  /* ܥ */
	  button = gtk_toggle_button_new ();
	  gtk_signal_connect (GTK_OBJECT (button), "clicked",
			      GTK_SIGNAL_FUNC (te_edit_color_balance_channel),
			      (gpointer) parent);
	  sprintf (buf, "channel_button%d", n);
	  gtk_object_set_data (GTK_OBJECT (parent), buf, button);
	  gtk_box_pack_start (GTK_BOX (hbox), button, FALSE, FALSE, 0);
	  gtk_widget_show (button);
	  {
	    /* ե졼 */
	    frame = gtk_frame_new (NULL);
	    gtk_container_border_width (GTK_CONTAINER (frame), 2);
	    gtk_container_add (GTK_CONTAINER (button), frame);	
	    gtk_widget_show (frame);
	    {
	      /* Х */
	      widget = gtk_drawing_area_new ();
	      gtk_widget_show (widget);
	      sprintf (buf, "draw_area%d", n);
	      gtk_widget_set_usize (widget, 80, 80);
	      gtk_object_set_data (GTK_OBJECT (parent), buf, widget);
	      gtk_container_add (GTK_CONTAINER (frame), widget);
	    }
	  }
	}
      }
      /* ѥ졼 */
      widget = gtk_hseparator_new ();
      gtk_box_pack_start (GTK_BOX (sbox), widget, FALSE, FALSE, 5);
      gtk_widget_show (widget);
       
      /* ʿܥå */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, FALSE, FALSE, 0);
      gtk_widget_show (hbox);
      {
	/* å */
	obj = gtk_adjustment_new (256.0, 0.0, 1024.0, 1.0, 4.0, 0.0);      
	gtk_object_set_data (GTK_OBJECT (parent), "adj_gamma", obj);
	widget = gtk_hscale_new (GTK_ADJUSTMENT (obj));
	gtk_scale_set_digits (GTK_SCALE (widget), 0);
	gtk_range_set_update_policy (GTK_RANGE (widget),GTK_UPDATE_CONTINUOUS);
	gtk_object_set_data (GTK_OBJECT (parent), "scale_gamma", widget);
	gtk_signal_connect (GTK_OBJECT (obj), "value_changed",
			    GTK_SIGNAL_FUNC(te_edit_color_balance_gamma),NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	gtk_widget_show (widget);

	widget = gtk_icon_button_new (icon_gamma);
	gtk_signal_connect(GTK_OBJECT (widget), "clicked",
			   GTK_SIGNAL_FUNC(te_edit_color_balance_button_gamma),
			   NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	gtk_widget_show (widget);
      }

      /* ʿܥå */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, TRUE, TRUE, 0);
      gtk_widget_show (hbox);
      {
	/* ֥饤ȥͥå */
	obj = gtk_adjustment_new (256.0, 0.0, 1024.0, 1.0, 4.0, 0.0);
	
	gtk_object_set_data (GTK_OBJECT (parent), "adj_bright", obj);
	widget = gtk_hscale_new (GTK_ADJUSTMENT (obj));
	gtk_scale_set_digits (GTK_SCALE (widget), 0);
	gtk_range_set_update_policy (GTK_RANGE (widget),GTK_UPDATE_CONTINUOUS);
	gtk_object_set_data (GTK_OBJECT (parent), "scale_bright", widget);
	gtk_signal_connect (GTK_OBJECT (obj), "value_changed",
			    GTK_SIGNAL_FUNC (te_edit_color_balance_bright),
			    NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	gtk_widget_show (widget);

	widget = gtk_icon_button_new (icon_brightness);
	gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			    GTK_SIGNAL_FUNC
			    (te_edit_color_balance_button_bright), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	gtk_widget_show (widget);
      }

      /* ʿܥå */
      hbox = gtk_hbox_new (FALSE, 0);
      gtk_box_pack_start (GTK_BOX (sbox), hbox, TRUE, TRUE, 0);
      gtk_widget_show (hbox);
      {
	/* ȥ饹å */
	obj = gtk_adjustment_new (256.0, 0.0, 1024.0, 1.0, 4.0, 0.0);
	
	gtk_object_set_data (GTK_OBJECT (parent), "adj_cont", obj);
	widget = gtk_hscale_new (GTK_ADJUSTMENT (obj));
	gtk_scale_set_digits (GTK_SCALE (widget), 0);
	gtk_range_set_update_policy (GTK_RANGE (widget),GTK_UPDATE_CONTINUOUS);
	gtk_object_set_data (GTK_OBJECT (parent), "scale_cont", widget);
	gtk_signal_connect (GTK_OBJECT (obj), "value_changed",
			    GTK_SIGNAL_FUNC(te_edit_color_balance_cont), NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
	gtk_widget_show (widget);

	widget = gtk_icon_button_new (icon_contrast);
	gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			    GTK_SIGNAL_FUNC(te_edit_color_balance_button_cont),
			    NULL);
	gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
	gtk_widget_show (widget);
      }
    }
  }
  return box;
}
 
/* Ρȥ֥åΥڡ1 (顼Х) **************************** */
static void
te_edit_notebook_color (GtkWidget	*parent,
			GtkWidget	*notebook) {
  GtkWidget	*label_box;
  GtkWidget	*box;
  GtkWidget	*frame;
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*widget;

  /* ٥ */ 
  label_box = te_notebook_label_new (_("Color Balance"),
				     book_closed, book_closed_mask); 

  /* ܥå */
  box = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (box);
  gtk_widget_show (box);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box, label_box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (NULL); 
    gtk_widget_ref (frame);
    gtk_container_add (GTK_CONTAINER (box), frame); 
    gtk_container_border_width (GTK_CONTAINER (frame), 2); 
    gtk_widget_show (frame); 
    {
      /* ľܥå */
      vbox = gtk_vbox_new (FALSE, 0);
      gtk_widget_ref (vbox);
      gtk_container_add (GTK_CONTAINER (frame), vbox);
      gtk_container_set_border_width (GTK_CONTAINER (vbox), 5);      
      gtk_widget_show (vbox);
    }
  }

  /* ľܥåؤΥѥå */
  {
    /* ʿܥå */
    widget = te_edit_color_balance_widget_new (parent);
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 0);
    gtk_widget_show (widget);
    
    /* ѥ졼 */
    widget = gtk_hseparator_new ();
    gtk_widget_ref (widget);
    gtk_widget_show (widget);
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, FALSE, 3);

    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 3);
    gtk_widget_ref (hbox);    
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);
  }

  /* ʿܥåؤΥѥå */
  {
    widget = gtk_icon_button_new_with_label (_("Cancel"), 
					     stock_button_cancel,
					     GTK_ICON_BUTTON_TEXT_RIGHT, 5);
    gtk_widget_ref (widget);
    gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			GTK_SIGNAL_FUNC (te_edit_color_balance_button_cancel),
			NULL);
    gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
    gtk_widget_show (widget);
    
    widget = gtk_icon_button_new_with_label (_("Apply"), 
					     stock_button_apply,
					     GTK_ICON_BUTTON_TEXT_RIGHT, 5);
    gtk_widget_ref (widget);
    gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			GTK_SIGNAL_FUNC (te_edit_color_balance_button_apply),
			NULL);
    gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
    gtk_widget_show (widget);
  }
  
}
  
/* Ρȥ֥åΥڡ2 (ȥ) ******************************** */
static void
te_edit_notebook_geometry (GtkWidget	*parent,
			   GtkWidget	*notebook) {
  GtkWidget	*label_box;
  GtkWidget	*box;
  GtkWidget	*frame;
  GtkWidget	*vbox1;
  GtkWidget	*vbox2;  
  GtkWidget	*hbox;
  GtkWidget	*widget;
  GtkObject	*obj;

  /* ٥ */ 
  label_box = te_notebook_label_new (_("Geometry"),
				     book_closed, book_closed_mask); 

  /* ܥå */
  box = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (box);
  gtk_widget_show (box);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box, label_box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (_("Size"));
    gtk_widget_ref (frame);
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    gtk_widget_show (frame);
    {
      /* ľܥå */
      vbox1 = gtk_vbox_new (FALSE, 0);
      gtk_widget_ref (vbox1);
      gtk_container_add (GTK_CONTAINER (frame), vbox1);
      gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);
      gtk_widget_show (vbox1);
    }

    /* ѥ졼 */
    widget = gtk_hseparator_new ();
    gtk_widget_ref (widget);
    gtk_box_pack_start (GTK_BOX (box), widget, FALSE, FALSE, 5);
    gtk_widget_show (widget);
    
    /* ե졼 */ 
    frame = gtk_frame_new (_("Normalization"));
    gtk_widget_ref (frame);
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    gtk_widget_show (frame);
    {
      /* ľܥå */
      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_widget_ref (vbox1);
      gtk_container_add (GTK_CONTAINER (frame), vbox2);
      gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);
      gtk_widget_show (vbox2);
    }
  }

  /* ľܥå1ؤΥѥå */
  {
    /* ʿܥå */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_widget_ref (hbox);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);
    {
      int	nw, nh;
      
      /* ߤβĴ٤ */
      nw = te_image_get_curr_width  (image_list);
      nh = te_image_get_curr_height (image_list);

      /* ٥ (Width) */
      widget = gtk_label_new (_("Width"));
      gtk_widget_ref (widget);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (nw, 1, 9999, 1, 10, 10);
      gtk_object_set_data (GTK_OBJECT (parent), "adj_size_width", obj);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_widget_ref (widget);
      gtk_object_set_data (GTK_OBJECT (parent), "spin_size_width", widget);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_signal_connect (GTK_OBJECT (widget), "key_press_event",
			  GTK_SIGNAL_FUNC (te_edit_geometry_enter_width),
			  (gpointer) parent);
      gtk_widget_show (widget);
      
      /* ٥ (Height) */      
      widget = gtk_label_new (_("Height"));
      gtk_widget_ref (widget);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ԥܥ */      
      obj = gtk_adjustment_new (nh, 1, 9999, 1, 10, 10);
      gtk_object_set_data (GTK_OBJECT (parent), "adj_size_height", obj);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_widget_ref (widget);
      gtk_object_set_data (GTK_OBJECT (parent), "spin_size_height", widget);
      gtk_signal_connect (GTK_OBJECT (widget), "key_press_event",
			  GTK_SIGNAL_FUNC (te_edit_geometry_enter_height),
			  (gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);
    }

    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (hbox);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);    
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);
    {
      /* åܥ */
      widget = gtk_check_button_new_with_label (_("Keep aspect"));
      gtk_widget_ref (widget);
      gtk_object_set_data (GTK_OBJECT (parent), "check_aspect", widget);
      gtk_signal_connect (GTK_OBJECT (widget), "toggled",
			  GTK_SIGNAL_FUNC (te_edit_geometry_keep_aspect),
			  NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ܥ */
      widget = gtk_icon_button_new_with_label (_("Apply"),
					       stock_button_apply,
					       GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      gtk_widget_ref (widget);
      gtk_widget_set_usize (widget, 100, -1);      
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_geometry_button_apply),
			  (gpointer) parent);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);
    }
    
    /* ʿܥ */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_widget_ref (hbox);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);
    {
      /* ܥ (x 1/2)  */
      widget = gtk_button_new_with_label (_("x 1/2"));
      gtk_widget_ref (widget);
      gtk_widget_set_usize (widget, -1, 28);      
      gtk_object_set_data (GTK_OBJECT (parent), "button_size_half", widget);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_geometry_button_half),
			  NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);

      /* ܥ (-10%) */
      widget = gtk_button_new_with_label (_("-10%"));
      gtk_widget_ref (widget);
      gtk_widget_set_usize (widget, -1, 28);
      gtk_object_set_data (GTK_OBJECT (parent), "button_size_down", widget);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_geometry_button_down),
			  NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);

      /* ܥ (+10%) */      
      widget = gtk_button_new_with_label (_("+10%"));
      gtk_widget_ref (widget);
      gtk_widget_set_usize (widget, -1, 28);      
      gtk_object_set_data (GTK_OBJECT (parent), "button_size_up", widget);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_geometry_button_up),
			  NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);

      /* ܥ (x 2) */      
      widget = gtk_button_new_with_label (_("x 2"));
      gtk_widget_ref (widget);
      gtk_widget_set_usize (widget, -1, 28);      
      gtk_object_set_data (GTK_OBJECT (parent), "button_size_double", widget);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_geometry_button_double),
			  NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);

      /* ܥ (Reset) */      
      widget = gtk_button_new_with_label (_("Reset"));
      gtk_widget_ref (widget);
      gtk_widget_set_usize (widget, -1, 28);      
      gtk_object_set_data (GTK_OBJECT (parent), "button_size_org", widget);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_geometry_button_reset),
			  NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);
    }    
  }

  /* ľܥå2ؤΥѥå */
  {
    /* ʿܥå */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_widget_ref (hbox);
    gtk_box_pack_start (GTK_BOX (vbox2), hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);
    {
      /* ߤβ˹碌ϰϤ */
      double	min, max;
    
      /* ͤκǾ&ͤĴ٤ */
      TeoGetPixelRange (te_image_get_orig_data (image_list), &min, &max);

      /* ٥ (Min Value) */
      widget = gtk_label_new (_("Min Value"));
      gtk_widget_ref (widget);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (min, min, max, 1, 10, 10);
      gtk_object_set_data (GTK_OBJECT (parent), "adj_norm_min", obj);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_widget_ref (widget);
      gtk_object_set_data (GTK_OBJECT (parent), "spin_norm_min", widget);
      gtk_signal_connect (GTK_OBJECT (obj), "value_changed",
			  GTK_SIGNAL_FUNC (te_edit_normal_change_min),
			  NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);

      /* ٥ (Max Value) */      
      widget = gtk_label_new (_("Max Value"));
      gtk_widget_ref (widget);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ԥܥ */      
      obj = gtk_adjustment_new (max, min, max, 1, 10, 10);
      gtk_object_set_data (GTK_OBJECT (parent), "adj_norm_max", obj);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_widget_ref (widget);
      gtk_object_set_data (GTK_OBJECT (parent), "spin_norm_max", widget);
      gtk_signal_connect (GTK_OBJECT (obj), "value_changed",
			  GTK_SIGNAL_FUNC (te_edit_normal_change_max),
			  NULL);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);
    }

    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (hbox);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
    gtk_box_pack_start (GTK_BOX (vbox2), hbox, FALSE, TRUE, 0);
    gtk_widget_show (hbox);
    {
      /* ܥ (Apply) */            
      widget = gtk_icon_button_new_with_label (_("Apply"), 
					       stock_button_apply,
					       GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      gtk_widget_ref (widget);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_normal_button_apply),
			  parent);
      gtk_widget_set_usize (widget, 100, -1);      
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ܥ (Best) */            
      widget = gtk_icon_button_new_with_label (_("Best"), 
					       stock_menu_about,
					       GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      gtk_widget_ref (widget);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_normal_button_best),
			  NULL);
      gtk_widget_set_usize (widget, 100, -1);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);
    }
  }
}

/* Ρȥ֥åΥڡ3 (å&) *************************** */
static void
te_edit_notebook_crip_grab (GtkWidget	*parent,
			    GtkWidget	*notebook) {
  GtkWidget	*label_box;
  GtkWidget	*box;
  GtkWidget	*frame;
  GtkWidget	*vbox1;
  GtkWidget	*vbox2;
  GtkWidget	*hbox;
  GtkWidget	*widget;
  GtkObject	*obj;
  
  /* ٥ */ 
  label_box = te_notebook_label_new (_("Cripping & Grab"),
				     book_closed, book_closed_mask); 

  /* ܥå */
  box = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (box);
  gtk_widget_show (box);
  gtk_notebook_append_page (GTK_NOTEBOOK (notebook), box, label_box);
  {
    /* ե졼 */ 
    frame = gtk_frame_new (_("Cripping"));
    gtk_widget_ref (frame);
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    gtk_widget_show (frame);
    {
      /* ľܥå */
      vbox1 = gtk_vbox_new (FALSE, 0);
      gtk_widget_ref (vbox1);
      gtk_container_add (GTK_CONTAINER (frame), vbox1);
      gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);
      gtk_widget_show (vbox1);
    }

    /* ѥ졼 */
    widget = gtk_hseparator_new ();
    gtk_widget_ref (widget);
    gtk_box_pack_start (GTK_BOX (box), widget, FALSE, FALSE, 5);
    gtk_widget_show (widget);
    
    /* ե졼 */ 
    frame = gtk_frame_new (_("Grab"));
    gtk_widget_ref (frame);
    gtk_box_pack_start (GTK_BOX (box), frame, TRUE, TRUE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (frame), 2);
    gtk_frame_set_label_align (GTK_FRAME (frame), 0.03, 0.5);
    gtk_widget_show (frame);
    {
      /* ľܥå */
      vbox2 = gtk_vbox_new (FALSE, 0);
      gtk_widget_ref (vbox2);
      gtk_container_add (GTK_CONTAINER (frame), vbox2);
      gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);
      gtk_widget_show (vbox2);
    }
  }

  /* ľܥå1ؤΥѥå */
  {
    /* ʿܥå */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_widget_ref (hbox);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);
    {
      int	w, h;
      
      /* γ */
      w = te_image_get_curr_width  (image_list);
      h = te_image_get_curr_height (image_list);
      
      /* ٥ X */
      widget = gtk_label_new (_("X"));
      gtk_widget_ref (widget);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (0, 0, w, 1, 10, 10);
      gtk_object_set_data (GTK_OBJECT (parent), "adj_crip_x", obj);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_widget_ref (widget);
      gtk_object_set_data (GTK_OBJECT (parent), "spin_crip_x", widget);
      gtk_signal_connect (GTK_OBJECT (obj), "value_changed",
			  GTK_SIGNAL_FUNC (te_edit_crip_change_x),
			  (gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);

      /* ٥ Y */      
      widget = gtk_label_new (_("Y"));
      gtk_widget_ref (widget);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (0, 0, h, 1, 10, 10);
      gtk_object_set_data (GTK_OBJECT (parent), "adj_crip_y", obj);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_widget_ref (widget);
      gtk_object_set_data (GTK_OBJECT (parent), "spin_crip_y", widget);
      gtk_signal_connect (GTK_OBJECT (obj), "value_changed",
			  GTK_SIGNAL_FUNC (te_edit_crip_change_y),
			  (gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);
    }

    /* ʿܥå */
    hbox = gtk_hbox_new (TRUE, 0);
    gtk_widget_ref (hbox);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);
    {
      int	w, h;
      
      /* γ */
      w = te_image_get_curr_width  (image_list);
      h = te_image_get_curr_height (image_list);

      /* ٥ Width */            
      widget = gtk_label_new (_("Width"));
      gtk_widget_ref (widget);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (0, 0, w, 1, 10, 10);
      gtk_object_set_data (GTK_OBJECT (parent), "adj_crip_width", obj);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_widget_ref (widget);
      gtk_object_set_data (GTK_OBJECT (parent), "spin_crip_width", widget);
      gtk_signal_connect (GTK_OBJECT (obj), "value_changed",
			  GTK_SIGNAL_FUNC (te_edit_crip_change_width),
			  (gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);

      /* ٥ Height */                  
      widget = gtk_label_new (_("Height"));
      gtk_widget_ref (widget);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      /* ԥܥ */
      obj = gtk_adjustment_new (0, 0, h, 1, 10, 10);
      gtk_object_set_data (GTK_OBJECT (parent), "adj_crip_heigth", obj);
      widget = gtk_spin_button_new (GTK_ADJUSTMENT (obj), 1, 0);
      gtk_widget_ref (widget);
      gtk_object_set_data (GTK_OBJECT (parent), "spin_crip_height", widget);
      gtk_signal_connect (GTK_OBJECT (obj), "value_changed",
			  GTK_SIGNAL_FUNC (te_edit_crip_change_height),
			  (gpointer) parent);
      gtk_box_pack_start (GTK_BOX (hbox), widget, TRUE, TRUE, 0);
      gtk_widget_show (widget);
    }

    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 3);
    gtk_widget_ref (hbox);
    gtk_box_pack_start (GTK_BOX (vbox1), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);
    {
      /* ܥ Apply */
      widget = gtk_icon_button_new_with_label (_("Apply"), 
					       stock_button_apply,
					       GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      gtk_widget_ref (widget);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_crip_button_apply),
			  (gpointer) parent);
      gtk_widget_set_usize (widget, 100, -1);      
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);
    }
  }

  /* ľܥå2ؤΥѥå */
  {
    /* ٥ */
    widget = gtk_label_new (_("Left button grabs a recrtanguler area,\n"
			      "Middle butotn grabs a window,\n"
			      "Right button cancels."));
    gtk_widget_ref (widget);
    gtk_box_pack_start (GTK_BOX (vbox2), widget, TRUE, TRUE, 3);
    gtk_label_set_line_wrap (GTK_LABEL (widget), TRUE);
    gtk_widget_show (widget);

    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 3);
    gtk_widget_ref (hbox);
    gtk_box_pack_end (GTK_BOX (vbox2), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);
    {
      widget = gtk_check_button_new_with_label (_("Hide this dialog"));
      gtk_widget_ref (widget);
      gtk_object_set_data (GTK_OBJECT (parent), "check_hide_dialog", widget);
      gtk_box_pack_start (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);

      widget = gtk_icon_button_new_with_label (_("Grab Start"), 
					       stock_menu_about,
					       GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      gtk_widget_ref (widget);
      gtk_signal_connect (GTK_OBJECT (widget), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_grab_start),
			  (gpointer) parent);
      gtk_box_pack_end (GTK_BOX (hbox), widget, FALSE, FALSE, 0);
      gtk_widget_show (widget);
    }
  }
}

/* ǥåȥ ********************************************** */
GtkWidget*
te_edit_window_new (void) {
  GtkWidget	*window;
  GtkWidget	*notebook;
  GtkWidget	*button;
  GtkWidget	*vbox;
  GtkWidget	*hbox;
  GtkWidget	*widget;
  gchar		*title = _("Teoeyes Image Editor");

  /* ɥ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_wmclass (GTK_WINDOW (window), "teoeyes", "Teo Image Viewer");
  gtk_window_set_policy (GTK_WINDOW (window), FALSE, FALSE, FALSE);
  gtk_window_set_title (GTK_WINDOW (window), title);
  gtk_signal_connect (GTK_OBJECT (window), "destroy",
		      (GtkSignalFunc) te_edit_close, NULL);
  gtk_signal_connect (GTK_OBJECT (window), "delete_event",
		      (GtkSignalFunc) te_edit_close, NULL);
  {
    /* ե졼 */
    widget = gtk_frame_new (NULL);
    gtk_widget_ref (widget);
    gtk_container_set_border_width (GTK_CONTAINER (widget), 3);
    gtk_container_add (GTK_CONTAINER (window), widget);
    gtk_widget_show (widget);
    {
      /* ľܥå */
      vbox = gtk_vbox_new (FALSE, 0);
      gtk_widget_ref (vbox);
      gtk_container_add (GTK_CONTAINER (widget), vbox);
      gtk_widget_show (vbox);
    }
  }

  /* ʿܥåؤΥѥå */
  {
    /* Ρȥ֥å */
    notebook = gtk_notebook_new ();
    gtk_widget_ref (notebook);
    gtk_object_set_data (GTK_OBJECT (window), "notebook", notebook);
    gtk_signal_connect (GTK_OBJECT (notebook), "switch_page",
			GTK_SIGNAL_FUNC (te_edit_notebook_page_switch), NULL);
    gtk_notebook_set_scrollable (GTK_NOTEBOOK (notebook), TRUE);
    gtk_box_pack_start (GTK_BOX (vbox), notebook, TRUE, TRUE, 0);
    gtk_widget_show (notebook);  

    te_edit_icon_new ();
    {
      te_edit_notebook_color	(window, notebook);
      te_edit_notebook_geometry (window, notebook);
      te_edit_notebook_crip_grab(window, notebook);
    }
    
    /* ѥ졼 */
    widget = gtk_hseparator_new ();
    gtk_widget_ref (widget);
    gtk_box_pack_start (GTK_BOX (vbox), widget, FALSE, TRUE, 5);
    gtk_widget_show (widget);

    /* ʿܥå */
    hbox = gtk_hbox_new (FALSE, 0);
    gtk_widget_ref (hbox);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
    gtk_widget_show (hbox);
    {
      button = gtk_icon_button_new_with_label (_("Close"), 
					       stock_button_close,
					       GTK_ICON_BUTTON_TEXT_RIGHT, 5);
      gtk_widget_ref (button);
      gtk_signal_connect (GTK_OBJECT (button), "clicked",
			  GTK_SIGNAL_FUNC (te_edit_close), window);
      gtk_widget_set_usize (button, 100, -1);
      gtk_box_pack_end (GTK_BOX (hbox), button, FALSE, FALSE, 0);
      gtk_widget_show (button);
      GTK_WIDGET_SET_FLAGS (button, GTK_CAN_DEFAULT); 
      gtk_widget_grab_default (button);   
    }
  }
  
  return window;
}

/* ************************************************************************* */
void
te_edit_draw_preview (void) {
  GtkWidget	*canvas;
  GdkWindow	*window;
  GdkPixbuf	*back, *pbuf;
  GdkPixmap	*pixmap;
  GdkBitmap	*mask;
  static int	image_id = -1; 	
  static int	pw = 160;	/* ץӥ塼κ */
  static int	ph = 120;	/* ץӥ塼κ⤵ */
  int		w, h;
  
  canvas = gtk_object_get_data (GTK_OBJECT (edit_window), "canvas");
  if (!canvas) return;
  window = canvas->window;
  
  if ((w = te_image_get_orig_width (image_list)) > pw ||
      (h = te_image_get_orig_height(image_list)) > ph) {
    w = pw;
    h = (w * te_image_get_orig_height (image_list)) /
      te_image_get_orig_width (image_list);
    if (h == 0) h = 2;
    if (h > ph) {
      h = ph;
      w = (h * te_image_get_orig_width (image_list)) /
	te_image_get_orig_height (image_list);
      if (w == 0) w = 2;      
    }
  }
  if (te_image_get_id (image_list) != image_id) {
    image_id = te_image_get_id (image_list);
    gtk_widget_set_usize (canvas, w, h);
  }
  pbuf = gdk_pixbuf_scale_simple (te_image_get_pbuf (image_list),
				  w, h, GDK_INTERP_TILES);
  gdk_pixbuf_apply_modifiers_to_rgb (pbuf,
				     te_image_get_modifier (image_list), 0);
  gdk_window_set_back_pixmap (window, NULL, FALSE);
  back = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, w, h);
  gdk_pixbuf_composite_color (pbuf, back, 0, 0, w, h, 0, 0, 1.0, 1.0,
			      GDK_INTERP_TILES,
			      255, 0, 0, 8, 0xaaaaaa, 0x555555);
  /* ԥåޥåפ */
  gdk_pixbuf_render_pixmap_and_mask (back, &pixmap, &mask, 255);

  /* ɥؤ */
  gdk_window_set_back_pixmap (window, pixmap, FALSE);
  gdk_window_clear (window);
  gdk_window_shape_combine_mask (window, mask, 0, 0);
  gdk_flush ();
  
  gdk_pixbuf_unref (pbuf);
  gdk_pixbuf_unref (back);
  gdk_pixmap_unref (pixmap);
  if (mask) gdk_bitmap_unref (mask);
}

/* ******************************************************* End of edit.c *** */
