/* ************************************************************ fileop.c *** *
 * ǥ쥯ȥꡦեؿ
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <2001-12-11 00:11:26 sugaya>
 * ************************************************************************* */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <glib.h>

#define	PATH_CURRENT_STR	"."
#define	PATH_PARENT_STR		".."
#ifndef TRUE
#define	TRUE	1
#endif
#ifndef FALSE
#define	FALSE	0
#endif

#define	DEFAULT_DIRECTORY_MODE	(0755)

/* ************************************************************************* *
 * ǥ쥯ȥꡦե̴ؿ
 * ************************************************************************* */

/* ǥ쥯ȥ̾ȥե̾򤯤äĤ ********************************** */
char*
y_concat_dir_and_file (char	*dir,
		       char	*file) {
  char	*path;

  if (!dir || !file) return NULL;
  path = (char *) malloc (sizeof (char) * (strlen (dir) + strlen (file) + 2));
  sprintf (path, "%s/%s", dir, file);

  return path;
}

/* եѥե̾ƥǥ쥯ȥȥե̾ʬ䤹 **************** */
void
y_separate_dir_and_file (char	*fullname,
			 char	**path,
			 char	**file) {
  char	*ptr = fullname;
  char	*folder;
  char	*name;
  char	*last;
  int	nlen     = 0;
  int	file_len = 0;

  folder = NULL;
  name   = NULL;
  last   = NULL;
  
  while (*ptr != '\0' && *ptr != '\n' && ptr != NULL) {
    nlen++;
    file_len++;

    folder = (char *) g_realloc (folder, sizeof (char) * (nlen + 1));
    folder[nlen - 1] = *ptr;
    folder[nlen]	   = '\0';

    name = (char *) g_realloc (name, sizeof (char) * (file_len + 1));
    name[file_len - 1] = *ptr;
    name[file_len]     = '\0';

    if(*ptr == '/') {
      g_free (name);
      g_free (last);
      last	= strdup (folder);
      file_len	= 0;
      name	= NULL;
    }
    ptr++;
  }
  *path = strdup (last);
  *file = strdup (name);  
  g_free (folder);
  g_free (last);
  g_free (name);  
}

/* եꥹΰβ ************************************************ */
void
y_free_strings (char	**files,
		int	num) {
  if (!files) return;
  while (num--) if (files[num]) free (files[num]);
  free (files);
}

/* 桼͡ϡ ****************************************************** */
char*
y_username (int	uid) {
 struct passwd	*pass;
 char 		*result; 

 pass = getpwuid (uid);
 if (pass && pass->pw_name) {
   endpwent ();    
   return pass->pw_name;
 } else {
   return NULL;
 }
}

/* ϡ ************************************************************** */
char*
y_file_usershell (int	uid) {       
  struct passwd	*pass;
  char 		*result;
   
  pass = getpwuid (uid);
  if (pass && pass->pw_shell) {
    endpwent ();
    return pass->pw_shell;
  } else {
    return NULL;
  }
}

/* ************************************************************************* *
 * ǥ쥯ȥؿ
 * ************************************************************************* */

/* ȥǥ쥯ȥѹ ********************************************** */
void
y_dir_cd (char	*dir) {
  if ((!dir) || (!*dir)) return;
  chdir (dir);
}

/* ȥǥ쥯ȥγ ********************************************** */
char*
y_dir_get_current_dir (void) {
  char s[4096];
   
  getcwd (s, sizeof (s));
#if 0
  if (s[strlen (s) - 1] != '/') {
    s[strlen (s)    ] = '/';
    s[strlen (s) + 1] = '\0';    
  }
#endif  
  return strdup (s);
}

/* ǥ쥯ȥ ************************************************** */
int
y_dir_make_dir (char	*dir) {
  if ((!dir) || (!*dir)) return 0;
  mkdir (dir, DEFAULT_DIRECTORY_MODE);
  
  return 1;
}

/* ǥ쥯ȥ ************************************************** */
int
y_dir_make_dirs (char	*dir) {
  char  s[1024];
  int   n = 0;
  int	m = 0;
   
  while (dir[n]) {
    s[m++] = dir[n];
    s[m] = 0;
    if (dir[n] == '/') {
      if (!y_file_exist_file (s)) y_dir_make_dir (s);
      else if (!y_dir_is_dir (s)) return;
    }
    n++;
  }
  return 1;
}

/* ǥ쥯ȥ ************************************************** */
void
y_dir_remove_dir (char	*dir) {
  char	cmd[1024];

  sprintf (cmd, "rm -rf %s", dir);
  system (cmd);
}

/* ۡǥ쥯ȥĴ٤ ********************************************** */
char*
y_dir_homedir (void) {
  char	*home;

  home = getenv ("HOME");
  return (home) ? home : NULL;
}

/* ȥǥ쥯ȥꡩ ************************************************** */
int
y_dir_is_current_dir (char	*dir) {
  if ((!dir) || (!*dir)) return FALSE;
  if (strcmp (dir, PATH_CURRENT_STR) == 0)
    return TRUE;
  else
    return FALSE;
}

/* ƥǥ쥯ȥꡩ ******************************************************** */
int
y_dir_is_parent_dir (char	*dir) {
  if ((!dir) || (!*dir)) return FALSE;
  if (strcmp (dir, PATH_PARENT_STR) == 0)
    return TRUE;
  else
    return FALSE;
}

/* ǥ쥯ȥꡩ ********************************************************** */
int
y_dir_is_dir (char	*dir) {
  struct stat	st;

  if ((!dir) || (!*dir))	return FALSE;
  if (stat (dir, &st) < 0)	return FALSE;
  if (S_ISDIR (st.st_mode))
    return TRUE;
  else
    return FALSE;
}

/* ֥ǥ쥯ȥ꤬뤫ɤĴ٤ ************************************ */
int
y_dir_exist_subdir (char	*dir) {
  DIR		*dp;
  struct dirent	*entry;
  struct stat	st;
  char		*path;

  if ((!dir) || (!*dir))	return 0;
  if (!(dp = opendir (dir)))	return 0;
  
  while ((entry = readdir (dp))) {
    if (y_dir_is_current_dir (entry->d_name) ||
	y_dir_is_parent_dir  (entry->d_name)) 
      continue;
    path = y_concat_dir_and_file (dir, entry->d_name);
    if (y_dir_is_dir (path)) {
      free (path);
      closedir (dp);
      return TRUE;
    }
    free (path);
  }
  closedir (dp);

  return FALSE;
}

/* ǥ쥯ȥls ********************************************************** */
char**
y_dir_ls_dir (char	*dir,
	      int	*dir_nums) {
  DIR		*dp;
  struct dirent	*entry;
  char		*path;
  char		**dir_names;
  int		nums = 0;
  int		n = 0;
  
  if ((!dir) || (!*dir))	return NULL;
  if (!(dp = opendir (dir)))	return NULL;

  while ((entry = readdir (dp))) {
    if (y_dir_is_current_dir (entry->d_name) ||
	y_dir_is_parent_dir  (entry->d_name)) 
      continue;
    path = y_concat_dir_and_file (dir, entry->d_name);
    if (y_dir_is_dir (path)) nums++;
    free (path);
  }

  if (nums == 0) {
    closedir (dp);
    *dir_nums = 0;
    return NULL;
  }
  rewinddir (dp);
  
  dir_names = (char **) malloc (sizeof (char *) * nums);
  if (!dir_names) {
    closedir (dp);
    *dir_nums = 0;
    return NULL;
  }

  while ((entry = readdir (dp))) {
    if (y_dir_is_current_dir (entry->d_name) ||
	y_dir_is_parent_dir  (entry->d_name)) 
      continue;
    path = y_concat_dir_and_file (dir, entry->d_name);
    if (y_dir_is_dir (path)) {
      dir_names[n] = (char *)
	malloc (sizeof (char) * (strlen (entry->d_name) + 1));
      strcpy (dir_names[n], entry->d_name);
      n++;
    }
  }
  closedir (dp);

  *dir_nums = nums;
  return dir_names;
}

/* ls ********************************************************************** */
char**
y_dir_ls (char	*dir,
	   int	*file_nums) {
  DIR		*dp;
  struct dirent	*entry;
  char		**file_names;
  int		n = 0;

  if ((!dir) || (!*dir))	return 0;
  if (!(dp = opendir (dir)))	return 0;

  while ((entry = readdir (dp))) {
    if (y_dir_is_current_dir (entry->d_name) || 
	y_dir_is_parent_dir  (entry->d_name)) 
      continue;
    *file_nums++;
  }
  if (*file_nums == 0) {
    closedir (dp);
    return NULL;
  }
  rewinddir (dp);

  
  file_names = (char **) malloc (sizeof (char) * *file_nums);
  if (!file_names) {
    closedir (dp);
    return NULL;
  }

  while ((entry = readdir (dp))) {
    if (y_dir_is_current_dir (entry->d_name) || 
	y_dir_is_parent_dir  (entry->d_name)) 
      continue;
    file_names[n] = (char *) 
      malloc (sizeof (char) * (strlen (entry->d_name) + 1));
    strcpy (file_names[n], entry->d_name);
    n++;
  }
  closedir (dp);

  return file_names;
}

/* ************************************************************************* *
 * եؿ
 * ************************************************************************* */

/* ե¸ߤ뤫 ************************************************** */
int
y_file_exist_file (char	*s) {
  struct stat st;

  if ((!s) || (!*s)) return 0;
  if (stat (s, &st) < 0) return 0;

  return 1;
}

/* ե뤫 ************************************************************ */
int
y_file_is_file (char	*s) {
  struct stat st;

  if ((!s) || (!*s)) return 0;
  if (stat (s, &st) < 0) return 0;
  if (S_ISREG (st.st_mode)) return 1;

  return 0;
}

/* եκ ********************************************************** */
void
y_file_remove_file (char	*s) {
  if ((!s) || (!*s)) return;
  unlink (s);
}

/* ե̾ѹ ****************************************************** */
void
y_file_rename_file (char	*old, 
		    char	*new) {
  if ((!old) || (!new) || (!*old) || (!*new)) return;
  rename (old, new);
}

/* եΥԡ ******************************************************** */
void
y_file_cp_file (char	*from,
		char	*to) {
  FILE		*from_fp, *to_fp;
  unsigned char buf[1];
   
  if ((!from) || (!to) || (!*from) || (!*to)) return;
  if (!y_file_exist_file (from)) return;

  from_fp = fopen (from, "r");
  if (!from_fp) return;
  to_fp = fopen (to, "w");
  if (!to_fp) {
    fclose (from_fp);
    return;
  }
  while (fread (buf, 1, 1, from_fp)) fwrite (buf, 1, 1, to_fp);

  fclose (from_fp);
  fclose (to_fp);
}

/* եιγ ************************************************ */
unsigned long
y_file_moddate (char	*s) {
  struct stat st;
   
  if ((!s) || (!*s)) return 0;
  if (!stat (s, &st) < 0) return 0;
  if (st.st_mtime > st.st_ctime) return st.st_mtime;
  else return st.st_ctime;
}

/* եιγ (ʸȤ֤) ***************************** */
char*
y_file_moddate_string (char	*s) {
  char		*tmp;
  char		buf[1024];
  struct stat 	st;
  struct tm	*update;
  int		n;
  
  if ((!s) || (!*s))		return 0;
  if (!stat (s, &st) < 0)	return 0;

  update = (st.st_mtime > st.st_ctime) ?
    localtime ((time_t *) &st.st_mtime) : localtime ((time_t *) &st.st_ctime);
  tmp = asctime (update) + 4;
  for (n = 0; n < 12; n++) buf[n] = *tmp++;
  tmp += 3;
  for (; n < 17; n++) buf[n] = *tmp++;
  buf[n] = '\0';

  return strdup (buf);
}

/* ե륵γ **************************************************** */
int
y_file_filesize (char	*s) {
  struct stat st;
   
  if ((!s) || (!*s)) return 0;
  if (stat (s, &st) < 0) return 0;
  return (int) st.st_size;
}

/* ѡߥåϡ ****************************************************** */
int
y_file_permissions (char	*s) {
  struct stat st;
   
  if ((!s) || (!*s)) return 0;
  if (!stat (s, &st) < 0) return 0;
  return st.st_mode;
}

/* ͭԤï ************************************************************ */
int
y_file_owner (char	*s) {
  struct stat st;
   
  if ((!s) || (!*s)) return 0;
  if (!stat (s, &st) < 0) return 0;
  return st.st_uid;
}

/* 롼פϡ ************************************************************ */
int
y_file_group (char	*s) {
  struct stat st;
   
  if ((!s) || (!*s)) return 0;
  if (!stat (s, &st) < 0) return 0;
  return st.st_gid;
}

/* ɤ߹߲ǽ ********************************************************** */
int
y_file_canread (char	*s) {
  if ((!s) || (!*s)) return -1;
  return access (s, R_OK);
}

/* 񤭹߲ǽ ********************************************************** */
int
y_file_canwrite (char	*s) {
  if ((!s) || (!*s)) return -1;
  return access (s, W_OK);
}

/* ¹Բǽ ************************************************************** */
int
y_file_canexec (char	*s) {
  if ((!s) || (!*s)) return -1;
  return access (s, X_OK);
}

/* ************************************************************************* *
 * ѥޥå󥰴ؿ
 * ************************************************************************* */
int
y_strcmp (const char	*pattern,
	  const char	*text) {
  int	p_length;
  int	t_length;

  p_length = strlen (pattern);
  t_length = strlen (text);

  if (p_length < t_length) {
    return strcmp (pattern, (text + t_length - p_length));
  } else {
    return strcmp (pattern, text);
  }
}

/* ***************************************************** End of fileop.c *** */
