/* ************************************************************ format.c *** *
 * TeoEyes - Teo Image Viewer
 *
 * Copyright (C) 1998-2001 Yasuyuki SUGAYA <sugaya@suri.it.okayama-u.ac.jp>
 * Okayama University
 *                                  Time-stamp: <02/11/14 11:27:12 sugaya>
 * ************************************************************************* */
#include "teoeyes.h"

/* TEOեޥåȤɤĴ٤ ******************************************* */
static int
is_teo (FILE 	*fp) {
  int	magic;

  magic = getc (fp);

  if ((magic == '\037') || (magic == 'T'))
    return 1;
  else
    return 0;	
}

/* PNMեޥåȤɤĴ٤ ******************************************* */
static int
is_pnm (FILE	*fp) {
  char	buf[8];

  if (!fp) return 0;
  fgets (buf, 8, fp);
  rewind (fp);
  if (!strcmp ("P6\n", buf)) return 1;
  if (!strcmp ("P5\n", buf)) return 1;
  if (!strcmp ("P4\n", buf)) return 1;
  if (!strcmp ("P3\n", buf)) return 1;
  if (!strcmp ("P2\n", buf)) return 1;
  if (!strcmp ("P1\n", buf)) return 1;
  return 0;
}

/* JPEGեޥåȤɤĴ٤ ****************************************** */
static int
is_jpeg (FILE	*fp) {
  unsigned char	buf[8];

  if (!fp) return 0;
  fread (buf, 1, 2, fp);
  rewind (fp);
  if ((buf[0] == 0xff) && (buf[1] == 0xd8)) return 1;
  return 0;
}

/* PNGեޥåȤɤĴ٤ ******************************************* */
static int
is_png (FILE	*fp) {
  unsigned char       buf[8];
	
  if (!fp) return 0;
  fread (buf, 1, 8, fp);
  rewind (fp);
  if (buf [0] != 0x89 ||
      buf [1] != 'P'  ||
      buf [2] != 'N'  ||
      buf [3] != 'G'  ||
      buf [4] != 0x0d ||
      buf [5] != 0x0a ||
      buf [6] != 0x1a ||
      buf [7] != 0x0a)
    return 0;
  return 1;
}

/* TIFFեޥåȤɤĴ٤ ****************************************** */
static int
is_tiff (FILE	*fp) {
  char	buf[8];

  if (!fp) return 0;
  fgets (buf, 5, fp);
  rewind (fp);
  if ((buf[0] == 'M') && (buf[1] == 'M') &&
      (buf[2] == 0x00) && (buf[3] == 0x2a)) return 1;
  if ((buf[0] == 'I') && (buf[1] == 'I') &&
      (buf[2] == 0x2a) && (buf[3] == 0x00)) return 1;
  return 0;
}

/* GIFեޥåȤɤĴ٤ ******************************************* */
static int
is_gif (FILE	*fp) {
  char	buf[8];

  if (!fp) return 0;
  fread (buf, 1, 4, fp);
  rewind (fp);
  buf[4] = 0;
  if (!strcmp ("GIF8", buf)) return 1;
  return 0;
}

/* XPMեޥåȤɤĴ٤ ******************************************* */
static int
is_xpm (FILE	*fp) {
  char	buf[11];

  if (!fp) return 0;
  fread (buf, 1, 9, fp);
  rewind (fp);
  buf[9] = 0;
  if (!strcmp ("/* XPM */", buf)) return 1;
  return 0;
}

/* BMPեޥåȤɤĴ٤ ******************************************* */
static int
is_bmp (FILE	*fp) {
  char	buf[3];

  if (!fp) return 0;
  fread (buf, 1, 2, fp);
  rewind (fp);
  buf[2] = 0;
  if (!strcmp ("BM", buf)) return 1;
  return 0;
}

/* եޥåȤĴ٤ ************************************************ */
int
what_format_is_this (char	*filename) {
  FILE	*fp;
  int	fmt;
  char	*ext;

  /* ĥҤγ */
  ext = (char *) strrchr (filename, '.');
  if (!ext) return FORMAT_UNKNOWN;

  /* եΥץ */
  fp  = fopen (filename, "r");
  if (!fp) return FORMAT_UNKNOWN;

  /* եޥåȤΥå */
  if (strcmp (ext, ".teo") == 0 && is_teo (fp)) {
    fmt = FORMAT_TEO;
  } else if (is_pnm (fp)) {
    fmt = FORMAT_PPM;	
  } else if (is_jpeg (fp)) {
    fmt = FORMAT_JPEG;
  } else if (is_png (fp)) {
    fmt = FORMAT_PNG;
  } else if (is_gif (fp)) {
    fmt = FORMAT_GIF;
  } else if (is_tiff (fp)) {
    fmt = FORMAT_TIFF;
  } else if (is_xpm (fp)) {
    fmt = FORMAT_XPM;
  } else if (strcmp (ext, ".xbm") == 0) {
    fmt = FORMAT_XBM;
  } else if (is_bmp (fp)) {
    fmt = FORMAT_BMP;
  } else if (strcmp (ext, ".eps") == 0) {
    fmt = FORMAT_EPS;
  } else if (strcmp (ext, ".wmf") == 0) {
    fmt = FORMAT_WMF;
  } else {
    fmt = FORMAT_UNKNOWN;
  }
  fclose (fp);

  return fmt;
}

/* ***************************************************** End of format.c *** */
